/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.thread;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.core.UnaryCoreMethodNode;
import org.jruby.truffle.core.thread.ThreadBacktraceLocationNodes;
import org.jruby.truffle.language.RubyNode;

@GeneratedBy(value=ThreadBacktraceLocationNodes.class)
public final class ThreadBacktraceLocationNodesFactory {
    public static List<NodeFactory<? extends UnaryCoreMethodNode>> getFactories() {
        return Arrays.asList(AbsolutePathNodeFactory.getInstance(), LinenoNodeFactory.getInstance(), ToSNodeFactory.getInstance());
    }

    @GeneratedBy(value=ThreadBacktraceLocationNodes.ToSNode.class)
    public static final class ToSNodeFactory
    extends NodeFactoryBase<ThreadBacktraceLocationNodes.ToSNode> {
        private static ToSNodeFactory toSNodeFactoryInstance;

        private ToSNodeFactory() {
            super(ThreadBacktraceLocationNodes.ToSNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode.class}});
        }

        @Override
        public ThreadBacktraceLocationNodes.ToSNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode)) {
                return ToSNodeFactory.create((RubyNode)arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadBacktraceLocationNodes.ToSNode> getInstance() {
            if (toSNodeFactoryInstance == null) {
                toSNodeFactoryInstance = new ToSNodeFactory();
            }
            return toSNodeFactoryInstance;
        }

        public static ThreadBacktraceLocationNodes.ToSNode create(RubyNode operand) {
            return new ToSNodeGen(operand);
        }

        @GeneratedBy(value=ThreadBacktraceLocationNodes.ToSNode.class)
        public static final class ToSNodeGen
        extends ThreadBacktraceLocationNodes.ToSNode {
            @Node.Child
            private RubyNode operand_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ToSNodeGen(RubyNode operand) {
                this.operand_ = operand;
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject operandValue_;
                try {
                    operandValue_ = this.operand_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.toS(operandValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object operandValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.operand_}, operandValue);
            }
        }
    }

    @GeneratedBy(value=ThreadBacktraceLocationNodes.LinenoNode.class)
    public static final class LinenoNodeFactory
    extends NodeFactoryBase<ThreadBacktraceLocationNodes.LinenoNode> {
        private static LinenoNodeFactory linenoNodeFactoryInstance;

        private LinenoNodeFactory() {
            super(ThreadBacktraceLocationNodes.LinenoNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode.class}});
        }

        @Override
        public ThreadBacktraceLocationNodes.LinenoNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode)) {
                return LinenoNodeFactory.create((RubyNode)arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadBacktraceLocationNodes.LinenoNode> getInstance() {
            if (linenoNodeFactoryInstance == null) {
                linenoNodeFactoryInstance = new LinenoNodeFactory();
            }
            return linenoNodeFactoryInstance;
        }

        public static ThreadBacktraceLocationNodes.LinenoNode create(RubyNode operand) {
            return new LinenoNodeGen(operand);
        }

        @GeneratedBy(value=ThreadBacktraceLocationNodes.LinenoNode.class)
        public static final class LinenoNodeGen
        extends ThreadBacktraceLocationNodes.LinenoNode {
            @Node.Child
            private RubyNode operand_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private LinenoNodeGen(RubyNode operand) {
                this.operand_ = operand;
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeInteger(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeInteger(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                DynamicObject operandValue_;
                try {
                    operandValue_ = this.operand_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.lineno(operandValue_);
            }

            private UnsupportedSpecializationException unsupported(Object operandValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.operand_}, operandValue);
            }
        }
    }

    @GeneratedBy(value=ThreadBacktraceLocationNodes.AbsolutePathNode.class)
    public static final class AbsolutePathNodeFactory
    extends NodeFactoryBase<ThreadBacktraceLocationNodes.AbsolutePathNode> {
        private static AbsolutePathNodeFactory absolutePathNodeFactoryInstance;

        private AbsolutePathNodeFactory() {
            super(ThreadBacktraceLocationNodes.AbsolutePathNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode.class}});
        }

        @Override
        public ThreadBacktraceLocationNodes.AbsolutePathNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode)) {
                return AbsolutePathNodeFactory.create((RubyNode)arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ThreadBacktraceLocationNodes.AbsolutePathNode> getInstance() {
            if (absolutePathNodeFactoryInstance == null) {
                absolutePathNodeFactoryInstance = new AbsolutePathNodeFactory();
            }
            return absolutePathNodeFactoryInstance;
        }

        public static ThreadBacktraceLocationNodes.AbsolutePathNode create(RubyNode operand) {
            return new AbsolutePathNodeGen(operand);
        }

        @GeneratedBy(value=ThreadBacktraceLocationNodes.AbsolutePathNode.class)
        public static final class AbsolutePathNodeGen
        extends ThreadBacktraceLocationNodes.AbsolutePathNode {
            @Node.Child
            private RubyNode operand_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private AbsolutePathNodeGen(RubyNode operand) {
                this.operand_ = operand;
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject operandValue_;
                try {
                    operandValue_ = this.operand_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.absolutePath(operandValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object operandValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.operand_}, operandValue);
            }
        }
    }
}

