/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.dsl.internal.SuppressFBWarnings;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.string.StringCachingGuards;
import org.jruby.truffle.interop.ForeignReadStringCachedHelperNode;
import org.jruby.truffle.interop.ForeignReadStringCachingHelperNode;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyTypesGen;

@GeneratedBy(value=ForeignReadStringCachingHelperNode.class)
@SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
final class ForeignReadStringCachingHelperNodeGen
extends ForeignReadStringCachingHelperNode
implements SpecializedNode {
    @Node.Child
    private RubyNode receiver_;
    @Node.Child
    private RubyNode name_;
    @CompilerDirectives.CompilationFinal
    private Class<?> nameType_;
    @CompilerDirectives.CompilationFinal
    private boolean excludeCacheStringAndForward_;
    @CompilerDirectives.CompilationFinal
    private boolean excludeCacheSymbolAndForward_;
    @CompilerDirectives.CompilationFinal
    private boolean excludeCacheJavaStringAndForward_;
    @Node.Child
    private BaseNode_ specialization_;

    private ForeignReadStringCachingHelperNodeGen(RubyContext context, RubyNode receiver, RubyNode name) {
        super(context);
        this.receiver_ = receiver;
        this.name_ = name;
        this.specialization_ = UninitializedNode_.create(this);
    }

    @Override
    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public Object executeStringCachingHelper(VirtualFrame frameValue, DynamicObject receiverValue, Object nameValue) {
        return this.specialization_.execute1(frameValue, receiverValue, nameValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute0(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    @Override
    public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
        return this.specialization_.executeInt(frameValue);
    }

    @Override
    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    @Override
    public Node deepCopy() {
        return SpecializationNode.updateRoot(super.deepCopy());
    }

    private static int expectInteger(Object value) throws UnexpectedResultException {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        throw new UnexpectedResultException(value);
    }

    public static ForeignReadStringCachingHelperNode create(RubyContext context, RubyNode receiver, RubyNode name) {
        return new ForeignReadStringCachingHelperNodeGen(context, receiver, name);
    }

    @GeneratedBy(methodName="indexString(DynamicObject, int)", value=ForeignReadStringCachingHelperNode.class)
    private static final class IndexStringNode_
    extends BaseNode_ {
        private final Class<?> nameImplicitType;

        IndexStringNode_(ForeignReadStringCachingHelperNodeGen root, Object nameValue) {
            super(root, 9);
            this.nameImplicitType = RubyTypesGen.getImplicitIntegerClass(nameValue);
        }

        @Override
        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.nameImplicitType == ((IndexStringNode_)other).nameImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            try {
                return this.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
            int nameValue_;
            DynamicObject receiverValue_;
            try {
                receiverValue_ = this.root.receiver_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object nameValue = this.executeName_(frameValue);
                return ForeignReadStringCachingHelperNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult(), nameValue));
            }
            try {
                if (this.nameImplicitType == Integer.TYPE) {
                    nameValue_ = this.root.name_.executeInteger(frameValue);
                } else {
                    Object nameValue__ = this.executeName_(frameValue);
                    nameValue_ = RubyTypesGen.expectImplicitInteger(nameValue__, this.nameImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return ForeignReadStringCachingHelperNodeGen.expectInteger(this.getNext().execute_(frameValue, receiverValue_, ex.getResult()));
            }
            if (RubyGuards.isRubyString(receiverValue_) && nameValue_ >= 0 && this.root.inRange(receiverValue_, nameValue_)) {
                return this.root.indexString(receiverValue_, nameValue_);
            }
            return ForeignReadStringCachingHelperNodeGen.expectInteger(this.getNext().execute_(frameValue, receiverValue_, nameValue_));
        }

        @Override
        public Object execute1(VirtualFrame frameValue, DynamicObject receiverValue, Object nameValue) {
            if (RubyTypesGen.isImplicitInteger(nameValue, this.nameImplicitType)) {
                int nameValue_ = RubyTypesGen.asImplicitInteger(nameValue, this.nameImplicitType);
                if (RubyGuards.isRubyString(receiverValue) && nameValue_ >= 0 && this.root.inRange(receiverValue, nameValue_)) {
                    return this.root.indexString(receiverValue, nameValue_);
                }
            }
            return this.getNext().execute1(frameValue, receiverValue, nameValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object receiverValue, Object nameValue) {
            if (receiverValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(nameValue, this.nameImplicitType)) {
                DynamicObject receiverValue_ = (DynamicObject)receiverValue;
                int nameValue_ = RubyTypesGen.asImplicitInteger(nameValue, this.nameImplicitType);
                if (RubyGuards.isRubyString(receiverValue_) && nameValue_ >= 0 && this.root.inRange(receiverValue_, nameValue_)) {
                    return this.root.indexString(receiverValue_, nameValue_);
                }
            }
            return this.getNext().execute_(frameValue, receiverValue, nameValue);
        }

        static BaseNode_ create(ForeignReadStringCachingHelperNodeGen root, Object nameValue) {
            return new IndexStringNode_(root, nameValue);
        }
    }

    @GeneratedBy(methodName="indexStringOutOfRange(DynamicObject, int)", value=ForeignReadStringCachingHelperNode.class)
    private static final class IndexStringOutOfRangeNode_
    extends BaseNode_ {
        private final Class<?> nameImplicitType;

        IndexStringOutOfRangeNode_(ForeignReadStringCachingHelperNodeGen root, Object nameValue) {
            super(root, 8);
            this.nameImplicitType = RubyTypesGen.getImplicitIntegerClass(nameValue);
        }

        @Override
        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.nameImplicitType == ((IndexStringOutOfRangeNode_)other).nameImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            try {
                return this.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
            int nameValue_;
            DynamicObject receiverValue_;
            try {
                receiverValue_ = this.root.receiver_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object nameValue = this.executeName_(frameValue);
                return ForeignReadStringCachingHelperNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult(), nameValue));
            }
            try {
                if (this.nameImplicitType == Integer.TYPE) {
                    nameValue_ = this.root.name_.executeInteger(frameValue);
                } else {
                    Object nameValue__ = this.executeName_(frameValue);
                    nameValue_ = RubyTypesGen.expectImplicitInteger(nameValue__, this.nameImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return ForeignReadStringCachingHelperNodeGen.expectInteger(this.getNext().execute_(frameValue, receiverValue_, ex.getResult()));
            }
            if (RubyGuards.isRubyString(receiverValue_) && nameValue_ >= 0 && !this.root.inRange(receiverValue_, nameValue_)) {
                return this.root.indexStringOutOfRange(receiverValue_, nameValue_);
            }
            return ForeignReadStringCachingHelperNodeGen.expectInteger(this.getNext().execute_(frameValue, receiverValue_, nameValue_));
        }

        @Override
        public Object execute1(VirtualFrame frameValue, DynamicObject receiverValue, Object nameValue) {
            if (RubyTypesGen.isImplicitInteger(nameValue, this.nameImplicitType)) {
                int nameValue_ = RubyTypesGen.asImplicitInteger(nameValue, this.nameImplicitType);
                if (RubyGuards.isRubyString(receiverValue) && nameValue_ >= 0 && !this.root.inRange(receiverValue, nameValue_)) {
                    return this.root.indexStringOutOfRange(receiverValue, nameValue_);
                }
            }
            return this.getNext().execute1(frameValue, receiverValue, nameValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object receiverValue, Object nameValue) {
            if (receiverValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(nameValue, this.nameImplicitType)) {
                DynamicObject receiverValue_ = (DynamicObject)receiverValue;
                int nameValue_ = RubyTypesGen.asImplicitInteger(nameValue, this.nameImplicitType);
                if (RubyGuards.isRubyString(receiverValue_) && nameValue_ >= 0 && !this.root.inRange(receiverValue_, nameValue_)) {
                    return this.root.indexStringOutOfRange(receiverValue_, nameValue_);
                }
            }
            return this.getNext().execute_(frameValue, receiverValue, nameValue);
        }

        static BaseNode_ create(ForeignReadStringCachingHelperNodeGen root, Object nameValue) {
            return new IndexStringOutOfRangeNode_(root, nameValue);
        }
    }

    @GeneratedBy(methodName="indexStringNegative(DynamicObject, int)", value=ForeignReadStringCachingHelperNode.class)
    private static final class IndexStringNegativeNode_
    extends BaseNode_ {
        private final Class<?> nameImplicitType;

        IndexStringNegativeNode_(ForeignReadStringCachingHelperNodeGen root, Object nameValue) {
            super(root, 7);
            this.nameImplicitType = RubyTypesGen.getImplicitIntegerClass(nameValue);
        }

        @Override
        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.nameImplicitType == ((IndexStringNegativeNode_)other).nameImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            try {
                return this.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
            int nameValue_;
            DynamicObject receiverValue_;
            try {
                receiverValue_ = this.root.receiver_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object nameValue = this.executeName_(frameValue);
                return ForeignReadStringCachingHelperNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult(), nameValue));
            }
            try {
                if (this.nameImplicitType == Integer.TYPE) {
                    nameValue_ = this.root.name_.executeInteger(frameValue);
                } else {
                    Object nameValue__ = this.executeName_(frameValue);
                    nameValue_ = RubyTypesGen.expectImplicitInteger(nameValue__, this.nameImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return ForeignReadStringCachingHelperNodeGen.expectInteger(this.getNext().execute_(frameValue, receiverValue_, ex.getResult()));
            }
            if (RubyGuards.isRubyString(receiverValue_) && nameValue_ < 0) {
                return this.root.indexStringNegative(receiverValue_, nameValue_);
            }
            return ForeignReadStringCachingHelperNodeGen.expectInteger(this.getNext().execute_(frameValue, receiverValue_, nameValue_));
        }

        @Override
        public Object execute1(VirtualFrame frameValue, DynamicObject receiverValue, Object nameValue) {
            if (RubyTypesGen.isImplicitInteger(nameValue, this.nameImplicitType)) {
                int nameValue_ = RubyTypesGen.asImplicitInteger(nameValue, this.nameImplicitType);
                if (RubyGuards.isRubyString(receiverValue) && nameValue_ < 0) {
                    return this.root.indexStringNegative(receiverValue, nameValue_);
                }
            }
            return this.getNext().execute1(frameValue, receiverValue, nameValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object receiverValue, Object nameValue) {
            if (receiverValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(nameValue, this.nameImplicitType)) {
                DynamicObject receiverValue_ = (DynamicObject)receiverValue;
                int nameValue_ = RubyTypesGen.asImplicitInteger(nameValue, this.nameImplicitType);
                if (RubyGuards.isRubyString(receiverValue_) && nameValue_ < 0) {
                    return this.root.indexStringNegative(receiverValue_, nameValue_);
                }
            }
            return this.getNext().execute_(frameValue, receiverValue, nameValue);
        }

        static BaseNode_ create(ForeignReadStringCachingHelperNodeGen root, Object nameValue) {
            return new IndexStringNegativeNode_(root, nameValue);
        }
    }

    @GeneratedBy(methodName="uncachedJavaStringAndForward(VirtualFrame, DynamicObject, String, ForeignReadStringCachedHelperNode)", value=ForeignReadStringCachingHelperNode.class)
    private static final class UncachedJavaStringAndForwardNode_
    extends BaseNode_ {
        @Node.Child
        private ForeignReadStringCachedHelperNode nextHelper;

        UncachedJavaStringAndForwardNode_(ForeignReadStringCachingHelperNodeGen root, ForeignReadStringCachedHelperNode nextHelper) {
            super(root, 6);
            this.nextHelper = nextHelper;
        }

        @Override
        public Object execute1(VirtualFrame frameValue, DynamicObject receiverValue, Object nameValue) {
            if (nameValue instanceof String) {
                String nameValue_ = (String)nameValue;
                return this.root.uncachedJavaStringAndForward(frameValue, receiverValue, nameValue_, this.nextHelper);
            }
            return this.getNext().execute1(frameValue, receiverValue, nameValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object receiverValue, Object nameValue) {
            if (receiverValue instanceof DynamicObject && nameValue instanceof String) {
                DynamicObject receiverValue_ = (DynamicObject)receiverValue;
                String nameValue_ = (String)nameValue;
                return this.root.uncachedJavaStringAndForward(frameValue, receiverValue_, nameValue_, this.nextHelper);
            }
            return this.getNext().execute_(frameValue, receiverValue, nameValue);
        }

        static BaseNode_ create(ForeignReadStringCachingHelperNodeGen root, ForeignReadStringCachedHelperNode nextHelper) {
            return new UncachedJavaStringAndForwardNode_(root, nextHelper);
        }
    }

    @GeneratedBy(methodName="cacheJavaStringAndForward(VirtualFrame, DynamicObject, String, String, boolean, ForeignReadStringCachedHelperNode)", value=ForeignReadStringCachingHelperNode.class)
    private static final class CacheJavaStringAndForwardNode_
    extends BaseNode_ {
        private final String cachedName;
        private final boolean cachedStartsWithAt;
        @Node.Child
        private ForeignReadStringCachedHelperNode nextHelper;

        CacheJavaStringAndForwardNode_(ForeignReadStringCachingHelperNodeGen root, String cachedName, boolean cachedStartsWithAt, ForeignReadStringCachedHelperNode nextHelper) {
            super(root, 5);
            this.cachedName = cachedName;
            this.cachedStartsWithAt = cachedStartsWithAt;
            this.nextHelper = nextHelper;
        }

        @Override
        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object receiverValue, Object nameValue) {
            if (newNode.getClass() == UncachedJavaStringAndForwardNode_.class) {
                this.removeSame("Contained by uncachedJavaStringAndForward(VirtualFrame, DynamicObject, String, ForeignReadStringCachedHelperNode)");
            }
            return super.merge(newNode, frameValue, receiverValue, nameValue);
        }

        @Override
        public boolean isIdentical(SpecializationNode other, Frame frameValue, Object receiverValue, Object nameValue) {
            String nameValue_;
            return receiverValue instanceof DynamicObject && nameValue instanceof String && (nameValue_ = (String)nameValue) == this.cachedName;
        }

        @Override
        public Object execute1(VirtualFrame frameValue, DynamicObject receiverValue, Object nameValue) {
            String nameValue_;
            if (nameValue instanceof String && (nameValue_ = (String)nameValue) == this.cachedName) {
                return this.root.cacheJavaStringAndForward(frameValue, receiverValue, nameValue_, this.cachedName, this.cachedStartsWithAt, this.nextHelper);
            }
            return this.getNext().execute1(frameValue, receiverValue, nameValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object receiverValue, Object nameValue) {
            if (receiverValue instanceof DynamicObject && nameValue instanceof String) {
                DynamicObject receiverValue_ = (DynamicObject)receiverValue;
                String nameValue_ = (String)nameValue;
                if (nameValue_ == this.cachedName) {
                    return this.root.cacheJavaStringAndForward(frameValue, receiverValue_, nameValue_, this.cachedName, this.cachedStartsWithAt, this.nextHelper);
                }
            }
            return this.getNext().execute_(frameValue, receiverValue, nameValue);
        }

        static BaseNode_ create(ForeignReadStringCachingHelperNodeGen root, String cachedName, boolean cachedStartsWithAt, ForeignReadStringCachedHelperNode nextHelper) {
            return new CacheJavaStringAndForwardNode_(root, cachedName, cachedStartsWithAt, nextHelper);
        }
    }

    @GeneratedBy(methodName="uncachedSymbolAndForward(VirtualFrame, DynamicObject, DynamicObject, ForeignReadStringCachedHelperNode)", value=ForeignReadStringCachingHelperNode.class)
    private static final class UncachedSymbolAndForwardNode_
    extends BaseNode_ {
        @Node.Child
        private ForeignReadStringCachedHelperNode nextHelper;

        UncachedSymbolAndForwardNode_(ForeignReadStringCachingHelperNodeGen root, ForeignReadStringCachedHelperNode nextHelper) {
            super(root, 4);
            this.nextHelper = nextHelper;
        }

        @Override
        public Object execute1(VirtualFrame frameValue, DynamicObject receiverValue, Object nameValue) {
            DynamicObject nameValue_;
            if (nameValue instanceof DynamicObject && RubyGuards.isRubySymbol(nameValue_ = (DynamicObject)nameValue)) {
                return this.root.uncachedSymbolAndForward(frameValue, receiverValue, nameValue_, this.nextHelper);
            }
            return this.getNext().execute1(frameValue, receiverValue, nameValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object receiverValue, Object nameValue) {
            if (receiverValue instanceof DynamicObject && nameValue instanceof DynamicObject) {
                DynamicObject receiverValue_ = (DynamicObject)receiverValue;
                DynamicObject nameValue_ = (DynamicObject)nameValue;
                if (RubyGuards.isRubySymbol(nameValue_)) {
                    return this.root.uncachedSymbolAndForward(frameValue, receiverValue_, nameValue_, this.nextHelper);
                }
            }
            return this.getNext().execute_(frameValue, receiverValue, nameValue);
        }

        static BaseNode_ create(ForeignReadStringCachingHelperNodeGen root, ForeignReadStringCachedHelperNode nextHelper) {
            return new UncachedSymbolAndForwardNode_(root, nextHelper);
        }
    }

    @GeneratedBy(methodName="cacheSymbolAndForward(VirtualFrame, DynamicObject, DynamicObject, DynamicObject, String, boolean, ForeignReadStringCachedHelperNode)", value=ForeignReadStringCachingHelperNode.class)
    private static final class CacheSymbolAndForwardNode_
    extends BaseNode_ {
        private final DynamicObject cachedName;
        private final String cachedString;
        private final boolean cachedStartsWithAt;
        @Node.Child
        private ForeignReadStringCachedHelperNode nextHelper;

        CacheSymbolAndForwardNode_(ForeignReadStringCachingHelperNodeGen root, DynamicObject cachedName, String cachedString, boolean cachedStartsWithAt, ForeignReadStringCachedHelperNode nextHelper) {
            super(root, 3);
            this.cachedName = cachedName;
            this.cachedString = cachedString;
            this.cachedStartsWithAt = cachedStartsWithAt;
            this.nextHelper = nextHelper;
        }

        @Override
        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object receiverValue, Object nameValue) {
            if (newNode.getClass() == UncachedSymbolAndForwardNode_.class) {
                this.removeSame("Contained by uncachedSymbolAndForward(VirtualFrame, DynamicObject, DynamicObject, ForeignReadStringCachedHelperNode)");
            }
            return super.merge(newNode, frameValue, receiverValue, nameValue);
        }

        @Override
        public boolean isIdentical(SpecializationNode other, Frame frameValue, Object receiverValue, Object nameValue) {
            DynamicObject nameValue_;
            return receiverValue instanceof DynamicObject && nameValue instanceof DynamicObject && RubyGuards.isRubySymbol(nameValue_ = (DynamicObject)nameValue) && nameValue_ == this.cachedName;
        }

        @Override
        public Object execute1(VirtualFrame frameValue, DynamicObject receiverValue, Object nameValue) {
            DynamicObject nameValue_;
            if (nameValue instanceof DynamicObject && RubyGuards.isRubySymbol(nameValue_ = (DynamicObject)nameValue) && nameValue_ == this.cachedName) {
                return this.root.cacheSymbolAndForward(frameValue, receiverValue, nameValue_, this.cachedName, this.cachedString, this.cachedStartsWithAt, this.nextHelper);
            }
            return this.getNext().execute1(frameValue, receiverValue, nameValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object receiverValue, Object nameValue) {
            if (receiverValue instanceof DynamicObject && nameValue instanceof DynamicObject) {
                DynamicObject receiverValue_ = (DynamicObject)receiverValue;
                DynamicObject nameValue_ = (DynamicObject)nameValue;
                if (RubyGuards.isRubySymbol(nameValue_) && nameValue_ == this.cachedName) {
                    return this.root.cacheSymbolAndForward(frameValue, receiverValue_, nameValue_, this.cachedName, this.cachedString, this.cachedStartsWithAt, this.nextHelper);
                }
            }
            return this.getNext().execute_(frameValue, receiverValue, nameValue);
        }

        static BaseNode_ create(ForeignReadStringCachingHelperNodeGen root, DynamicObject cachedName, String cachedString, boolean cachedStartsWithAt, ForeignReadStringCachedHelperNode nextHelper) {
            return new CacheSymbolAndForwardNode_(root, cachedName, cachedString, cachedStartsWithAt, nextHelper);
        }
    }

    @GeneratedBy(methodName="uncachedStringAndForward(VirtualFrame, DynamicObject, DynamicObject, ForeignReadStringCachedHelperNode)", value=ForeignReadStringCachingHelperNode.class)
    private static final class UncachedStringAndForwardNode_
    extends BaseNode_ {
        @Node.Child
        private ForeignReadStringCachedHelperNode nextHelper;

        UncachedStringAndForwardNode_(ForeignReadStringCachingHelperNodeGen root, ForeignReadStringCachedHelperNode nextHelper) {
            super(root, 2);
            this.nextHelper = nextHelper;
        }

        @Override
        public Object execute1(VirtualFrame frameValue, DynamicObject receiverValue, Object nameValue) {
            DynamicObject nameValue_;
            if (nameValue instanceof DynamicObject && RubyGuards.isRubyString(nameValue_ = (DynamicObject)nameValue)) {
                return this.root.uncachedStringAndForward(frameValue, receiverValue, nameValue_, this.nextHelper);
            }
            return this.getNext().execute1(frameValue, receiverValue, nameValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object receiverValue, Object nameValue) {
            if (receiverValue instanceof DynamicObject && nameValue instanceof DynamicObject) {
                DynamicObject receiverValue_ = (DynamicObject)receiverValue;
                DynamicObject nameValue_ = (DynamicObject)nameValue;
                if (RubyGuards.isRubyString(nameValue_)) {
                    return this.root.uncachedStringAndForward(frameValue, receiverValue_, nameValue_, this.nextHelper);
                }
            }
            return this.getNext().execute_(frameValue, receiverValue, nameValue);
        }

        static BaseNode_ create(ForeignReadStringCachingHelperNodeGen root, ForeignReadStringCachedHelperNode nextHelper) {
            return new UncachedStringAndForwardNode_(root, nextHelper);
        }
    }

    @GeneratedBy(methodName="cacheStringAndForward(VirtualFrame, DynamicObject, DynamicObject, Rope, String, boolean, ForeignReadStringCachedHelperNode)", value=ForeignReadStringCachingHelperNode.class)
    private static final class CacheStringAndForwardNode_
    extends BaseNode_ {
        private final Rope cachedRope;
        private final String cachedString;
        private final boolean cachedStartsWithAt;
        @Node.Child
        private ForeignReadStringCachedHelperNode nextHelper;

        CacheStringAndForwardNode_(ForeignReadStringCachingHelperNodeGen root, Rope cachedRope, String cachedString, boolean cachedStartsWithAt, ForeignReadStringCachedHelperNode nextHelper) {
            super(root, 1);
            this.cachedRope = cachedRope;
            this.cachedString = cachedString;
            this.cachedStartsWithAt = cachedStartsWithAt;
            this.nextHelper = nextHelper;
        }

        @Override
        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object receiverValue, Object nameValue) {
            if (newNode.getClass() == UncachedStringAndForwardNode_.class) {
                this.removeSame("Contained by uncachedStringAndForward(VirtualFrame, DynamicObject, DynamicObject, ForeignReadStringCachedHelperNode)");
            }
            return super.merge(newNode, frameValue, receiverValue, nameValue);
        }

        @Override
        public boolean isIdentical(SpecializationNode other, Frame frameValue, Object receiverValue, Object nameValue) {
            DynamicObject nameValue_;
            return receiverValue instanceof DynamicObject && nameValue instanceof DynamicObject && RubyGuards.isRubyString(nameValue_ = (DynamicObject)nameValue) && StringCachingGuards.ropesEqual(nameValue_, this.cachedRope);
        }

        @Override
        public Object execute1(VirtualFrame frameValue, DynamicObject receiverValue, Object nameValue) {
            DynamicObject nameValue_;
            if (nameValue instanceof DynamicObject && RubyGuards.isRubyString(nameValue_ = (DynamicObject)nameValue) && StringCachingGuards.ropesEqual(nameValue_, this.cachedRope)) {
                return this.root.cacheStringAndForward(frameValue, receiverValue, nameValue_, this.cachedRope, this.cachedString, this.cachedStartsWithAt, this.nextHelper);
            }
            return this.getNext().execute1(frameValue, receiverValue, nameValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object receiverValue, Object nameValue) {
            if (receiverValue instanceof DynamicObject && nameValue instanceof DynamicObject) {
                DynamicObject receiverValue_ = (DynamicObject)receiverValue;
                DynamicObject nameValue_ = (DynamicObject)nameValue;
                if (RubyGuards.isRubyString(nameValue_) && StringCachingGuards.ropesEqual(nameValue_, this.cachedRope)) {
                    return this.root.cacheStringAndForward(frameValue, receiverValue_, nameValue_, this.cachedRope, this.cachedString, this.cachedStartsWithAt, this.nextHelper);
                }
            }
            return this.getNext().execute_(frameValue, receiverValue, nameValue);
        }

        static BaseNode_ create(ForeignReadStringCachingHelperNodeGen root, Rope cachedRope, String cachedString, boolean cachedStartsWithAt, ForeignReadStringCachedHelperNode nextHelper) {
            return new CacheStringAndForwardNode_(root, cachedRope, cachedString, cachedStartsWithAt, nextHelper);
        }
    }

    @GeneratedBy(value=ForeignReadStringCachingHelperNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(ForeignReadStringCachingHelperNodeGen root) {
            super(root, 0);
        }

        @Override
        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object receiverValue, Object nameValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, receiverValue, nameValue));
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object receiverValue, Object nameValue) {
            return this.getNext().execute_(frameValue, receiverValue, nameValue);
        }

        static BaseNode_ create(ForeignReadStringCachingHelperNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=ForeignReadStringCachingHelperNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(ForeignReadStringCachingHelperNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object receiverValue, Object nameValue) {
            return this.uninitialized((Frame)frameValue, receiverValue, nameValue);
        }

        static BaseNode_ create(ForeignReadStringCachingHelperNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=ForeignReadStringCachingHelperNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected ForeignReadStringCachingHelperNodeGen root;

        BaseNode_(ForeignReadStringCachingHelperNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        @Override
        protected final void setRoot(Node root) {
            this.root = (ForeignReadStringCachingHelperNodeGen)root;
        }

        @Override
        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.receiver_, this.root.name_};
        }

        @Override
        public final Object acceptAndExecute(Frame frameValue, Object receiverValue, Object nameValue) {
            return this.execute_((VirtualFrame)frameValue, receiverValue, nameValue);
        }

        public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

        public Object execute1(VirtualFrame frameValue, DynamicObject receiverValue, Object nameValue) {
            return this.execute_(frameValue, receiverValue, nameValue);
        }

        public Object execute0(VirtualFrame frameValue) {
            Object receiverValue_ = this.root.receiver_.execute(frameValue);
            Object nameValue_ = this.executeName_(frameValue);
            return this.execute_(frameValue, receiverValue_, nameValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute0(frameValue);
        }

        public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
            return ForeignReadStringCachingHelperNodeGen.expectInteger(this.execute0(frameValue));
        }

        @Override
        protected final SpecializationNode createNext(Frame frameValue, Object receiverValue, Object nameValue) {
            if (receiverValue instanceof DynamicObject) {
                Object nameValue_;
                DynamicObject receiverValue_ = (DynamicObject)receiverValue;
                if (nameValue instanceof DynamicObject) {
                    ForeignReadStringCachedHelperNode nextHelper3;
                    boolean cachedStartsWithAt3;
                    String cachedString3;
                    BaseNode_ s;
                    ForeignReadStringCachedHelperNode nextHelper1;
                    boolean cachedStartsWithAt1;
                    String cachedString1;
                    BaseNode_ s2;
                    nameValue_ = (DynamicObject)nameValue;
                    Rope cachedRope1 = StringCachingGuards.privatizeRope((DynamicObject)nameValue_);
                    if (RubyGuards.isRubyString((DynamicObject)nameValue_) && StringCachingGuards.ropesEqual((DynamicObject)nameValue_, cachedRope1) && !this.root.excludeCacheStringAndForward_ && this.countSame(s2 = CacheStringAndForwardNode_.create(this.root, cachedRope1, cachedString1 = this.root.ropeToString(cachedRope1), cachedStartsWithAt1 = this.root.startsWithAt(cachedString1), nextHelper1 = this.root.createNextHelper())) < this.root.getCacheLimit()) {
                        return s2;
                    }
                    if (RubyGuards.isRubyString((DynamicObject)nameValue_)) {
                        ForeignReadStringCachedHelperNode nextHelper2 = this.root.createNextHelper();
                        this.root.excludeCacheStringAndForward_ = true;
                        return UncachedStringAndForwardNode_.create(this.root, nextHelper2);
                    }
                    Object cachedName3 = nameValue_;
                    if (RubyGuards.isRubySymbol((DynamicObject)nameValue_) && nameValue_ == cachedName3 && !this.root.excludeCacheSymbolAndForward_ && this.countSame(s = CacheSymbolAndForwardNode_.create(this.root, (DynamicObject)cachedName3, cachedString3 = this.root.objectToString((DynamicObject)cachedName3), cachedStartsWithAt3 = this.root.startsWithAt(cachedString3), nextHelper3 = this.root.createNextHelper())) < this.root.getCacheLimit()) {
                        return s;
                    }
                    if (RubyGuards.isRubySymbol((DynamicObject)nameValue_)) {
                        ForeignReadStringCachedHelperNode nextHelper4 = this.root.createNextHelper();
                        this.root.excludeCacheSymbolAndForward_ = true;
                        return UncachedSymbolAndForwardNode_.create(this.root, nextHelper4);
                    }
                }
                if (nameValue instanceof String) {
                    ForeignReadStringCachedHelperNode nextHelper5;
                    boolean cachedStartsWithAt5;
                    BaseNode_ s;
                    Object cachedName5 = nameValue_ = (String)nameValue;
                    if (nameValue_ == cachedName5 && !this.root.excludeCacheJavaStringAndForward_ && this.countSame(s = CacheJavaStringAndForwardNode_.create(this.root, (String)cachedName5, cachedStartsWithAt5 = this.root.startsWithAt((String)cachedName5), nextHelper5 = this.root.createNextHelper())) < this.root.getCacheLimit()) {
                        return s;
                    }
                    ForeignReadStringCachedHelperNode nextHelper6 = this.root.createNextHelper();
                    this.root.excludeCacheJavaStringAndForward_ = true;
                    return UncachedJavaStringAndForwardNode_.create(this.root, nextHelper6);
                }
                if (RubyTypesGen.isImplicitInteger(nameValue)) {
                    int nameValue_2 = RubyTypesGen.asImplicitInteger(nameValue);
                    if (RubyGuards.isRubyString(receiverValue_) && nameValue_2 < 0) {
                        return IndexStringNegativeNode_.create(this.root, nameValue);
                    }
                    if (RubyGuards.isRubyString(receiverValue_) && nameValue_2 >= 0 && !this.root.inRange(receiverValue_, nameValue_2)) {
                        return IndexStringOutOfRangeNode_.create(this.root, nameValue);
                    }
                    if (RubyGuards.isRubyString(receiverValue_) && nameValue_2 >= 0 && this.root.inRange(receiverValue_, nameValue_2)) {
                        return IndexStringNode_.create(this.root, nameValue);
                    }
                }
            }
            return null;
        }

        @Override
        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final Object executeName_(Frame frameValue) {
            Object object;
            Class nameType_ = this.root.nameType_;
            if (nameType_ == Integer.TYPE) {
                return this.root.name_.executeInteger((VirtualFrame)frameValue);
            }
            if (nameType_ != null) return this.root.name_.execute((VirtualFrame)frameValue);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Class<Object> _type = Object.class;
            try {
                Object _value = this.root.name_.execute((VirtualFrame)frameValue);
                _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                object = _value;
            }
            catch (Throwable throwable) {
                try {
                    this.root.nameType_ = _type;
                    throw throwable;
                }
                catch (UnexpectedResultException ex) {
                    this.root.nameType_ = Object.class;
                    return ex.getResult();
                }
            }
            this.root.nameType_ = _type;
            return object;
        }
    }
}

