/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.rope.RopeOperations;
import org.jruby.truffle.core.string.StringCachingGuards;
import org.jruby.truffle.interop.ForeignWriteStringCachedHelperNode;
import org.jruby.truffle.interop.ForeignWriteStringCachedHelperNodeGen;
import org.jruby.truffle.language.RubyNode;

@ImportStatic(value={StringCachingGuards.class})
@NodeChildren(value={@NodeChild(value="receiver"), @NodeChild(value="name"), @NodeChild(value="value")})
abstract class ForeignWriteStringCachingHelperNode
extends RubyNode {
    public ForeignWriteStringCachingHelperNode(RubyContext context) {
        super(context, null);
    }

    public abstract Object executeStringCachingHelper(VirtualFrame var1, DynamicObject var2, Object var3, Object var4);

    @Specialization(guards={"isRubyString(name)", "ropesEqual(name, cachedRope)"}, limit="getCacheLimit()")
    public Object cacheStringAndForward(VirtualFrame frame, DynamicObject receiver, DynamicObject name, Object value, @Cached(value="privatizeRope(name)") Rope cachedRope, @Cached(value="ropeToString(cachedRope)") String cachedString, @Cached(value="startsWithAt(cachedString)") boolean cachedStartsWithAt, @Cached(value="createNextHelper()") ForeignWriteStringCachedHelperNode nextHelper) {
        return nextHelper.executeStringCachedHelper(frame, receiver, name, cachedString, cachedStartsWithAt, value);
    }

    @Specialization(guards={"isRubyString(name)"}, contains={"cacheStringAndForward"})
    public Object uncachedStringAndForward(VirtualFrame frame, DynamicObject receiver, DynamicObject name, Object value, @Cached(value="createNextHelper()") ForeignWriteStringCachedHelperNode nextHelper) {
        String nameString = this.objectToString(name);
        return nextHelper.executeStringCachedHelper(frame, receiver, name, nameString, this.startsWithAt(nameString), value);
    }

    @Specialization(guards={"isRubySymbol(name)", "name == cachedName"}, limit="getCacheLimit()")
    public Object cacheSymbolAndForward(VirtualFrame frame, DynamicObject receiver, DynamicObject name, Object value, @Cached(value="name") DynamicObject cachedName, @Cached(value="objectToString(cachedName)") String cachedString, @Cached(value="startsWithAt(cachedString)") boolean cachedStartsWithAt, @Cached(value="createNextHelper()") ForeignWriteStringCachedHelperNode nextHelper) {
        return nextHelper.executeStringCachedHelper(frame, receiver, cachedName, cachedString, cachedStartsWithAt, value);
    }

    @Specialization(guards={"isRubySymbol(name)"}, contains={"cacheSymbolAndForward"})
    public Object uncachedSymbolAndForward(VirtualFrame frame, DynamicObject receiver, DynamicObject name, Object value, @Cached(value="createNextHelper()") ForeignWriteStringCachedHelperNode nextHelper) {
        String nameString = this.objectToString(name);
        return nextHelper.executeStringCachedHelper(frame, receiver, name, nameString, this.startsWithAt(nameString), value);
    }

    @Specialization(guards={"name == cachedName"}, limit="getCacheLimit()")
    public Object cacheJavaStringAndForward(VirtualFrame frame, DynamicObject receiver, String name, Object value, @Cached(value="name") String cachedName, @Cached(value="startsWithAt(cachedName)") boolean cachedStartsWithAt, @Cached(value="createNextHelper()") ForeignWriteStringCachedHelperNode nextHelper) {
        return nextHelper.executeStringCachedHelper(frame, receiver, cachedName, cachedName, cachedStartsWithAt, value);
    }

    @Specialization(contains={"cacheJavaStringAndForward"})
    public Object uncachedJavaStringAndForward(VirtualFrame frame, DynamicObject receiver, String name, Object value, @Cached(value="createNextHelper()") ForeignWriteStringCachedHelperNode nextHelper) {
        return nextHelper.executeStringCachedHelper(frame, receiver, name, name, this.startsWithAt(name), value);
    }

    protected ForeignWriteStringCachedHelperNode createNextHelper() {
        return ForeignWriteStringCachedHelperNodeGen.create(null, null, null, null, null);
    }

    @CompilerDirectives.TruffleBoundary
    protected String objectToString(DynamicObject string) {
        return string.toString();
    }

    protected String ropeToString(Rope rope) {
        return RopeOperations.decodeRope(this.getContext().getJRubyRuntime(), rope);
    }

    @CompilerDirectives.TruffleBoundary
    protected boolean startsWithAt(String name) {
        return !name.isEmpty() && name.charAt(0) == '@';
    }

    protected int getCacheLimit() {
        return this.getContext().getOptions().INTEROP_WRITE_CACHE;
    }
}

