/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.language.RubyGuards;

public class LexicalScope {
    public static final LexicalScope NONE = null;
    private final LexicalScope parent;
    @CompilerDirectives.CompilationFinal
    private DynamicObject liveModule;

    public LexicalScope(LexicalScope parent, DynamicObject liveModule) {
        assert (liveModule == null || RubyGuards.isRubyModule(liveModule));
        this.parent = parent;
        this.liveModule = liveModule;
    }

    public LexicalScope(LexicalScope parent) {
        this(parent, null);
    }

    public LexicalScope getParent() {
        return this.parent;
    }

    public DynamicObject getLiveModule() {
        return this.liveModule;
    }

    public void unsafeSetLiveModule(DynamicObject liveModule) {
        this.liveModule = liveModule;
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject resolveTargetModuleForClassVariables() {
        LexicalScope scope = this;
        while (RubyGuards.isRubyClass(scope.liveModule) && Layouts.CLASS.getIsSingleton(scope.liveModule)) {
            scope = scope.parent;
        }
        return scope.liveModule;
    }

    public String toString() {
        return " :: " + this.liveModule + (this.parent == null ? "" : this.parent.toString());
    }
}

