/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.arguments;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import java.util.Map;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.hash.BucketsStrategy;
import org.jruby.truffle.core.hash.HashOperations;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.arguments.ReadUserKeywordsHashNode;

public class ReadKeywordRestArgumentNode
extends RubyNode {
    private final String[] excludedKeywords;
    @Node.Child
    private ReadUserKeywordsHashNode readUserKeywordsHashNode;
    private final ConditionProfile noHash = ConditionProfile.createBinaryProfile();

    public ReadKeywordRestArgumentNode(RubyContext context, SourceSection sourceSection, int minimum, String[] excludedKeywords) {
        super(context, sourceSection);
        this.excludedKeywords = excludedKeywords;
        this.readUserKeywordsHashNode = new ReadUserKeywordsHashNode(minimum);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        return this.lookupRestKeywordArgumentHash(frame);
    }

    private Object lookupRestKeywordArgumentHash(VirtualFrame frame) {
        Object hash = this.readUserKeywordsHashNode.execute(frame);
        if (this.noHash.profile(hash == null)) {
            return Layouts.HASH.createHash(this.coreLibrary().getHashFactory(), null, 0, null, null, null, null, false);
        }
        CompilerDirectives.bailout("Ruby keyword arguments aren't optimized");
        DynamicObject hashObject = (DynamicObject)hash;
        ArrayList<Map.Entry<Object, Object>> entries = new ArrayList<Map.Entry<Object, Object>>();
        block0: for (Map.Entry<Object, Object> keyValue : HashOperations.iterableKeyValues(hashObject)) {
            if (!RubyGuards.isRubySymbol(keyValue.getKey())) continue;
            for (String excludedKeyword : this.excludedKeywords) {
                if (excludedKeyword.equals(keyValue.getKey().toString())) continue block0;
            }
            entries.add(keyValue);
        }
        return BucketsStrategy.create(this.getContext(), entries, Layouts.HASH.getCompareByIdentity(hashObject));
    }
}

