/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.facet;

import com.baselet.control.basics.XValues;
import com.baselet.control.basics.geom.Dimension;
import com.baselet.control.enums.ElementStyle;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.element.facet.Alignment;
import com.baselet.element.facet.Buffer;
import com.baselet.element.facet.Facet;
import com.baselet.element.facet.Settings;
import com.baselet.element.sticking.polygon.SimpleStickingPolygonGenerator;
import com.baselet.element.sticking.polygon.StickingPolygonGenerator;
import java.util.HashMap;
import java.util.Map;

public class PropertiesParserState {
    private final Settings settings;
    private final DrawHandler drawer;
    private Alignment alignment;
    private double textPrintPosition;
    private double minimumWidth;
    private Buffer buffer;
    private Dimension gridElementSize;
    private ElementStyle elementStyle;
    private StickingPolygonGenerator stickingPolygonGenerator = SimpleStickingPolygonGenerator.INSTANCE;
    private double totalTextBlockHeight;
    private final Map<Class<? extends Facet>, Object> facetResponse = new HashMap<Class<? extends Facet>, Object>();

    public PropertiesParserState(Settings settings, DrawHandler drawer) {
        this.settings = settings;
        this.drawer = drawer;
    }

    public void resetValues(Dimension gridElementSize, double totalTextBlockHeight, boolean enableDrawing) {
        this.alignment = new Alignment(this.settings);
        this.textPrintPosition = 0.0;
        this.minimumWidth = 0.0;
        this.buffer = new Buffer();
        this.gridElementSize = gridElementSize;
        this.elementStyle = this.settings.getElementStyle();
        this.stickingPolygonGenerator = SimpleStickingPolygonGenerator.INSTANCE;
        this.totalTextBlockHeight = totalTextBlockHeight;
        this.facetResponse.clear();
        this.drawer.setEnableDrawing(enableDrawing);
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public double getTextPrintPosition() {
        return this.textPrintPosition + this.buffer.getTop();
    }

    public void increaseTextPrintPosition(double inc) {
        this.textPrintPosition += inc;
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public Dimension getGridElementSize() {
        return this.gridElementSize;
    }

    public XValues getXLimits(double linePos) {
        XValues xLimits = this.settings.getXValues(linePos, this.getGridElementSize().height, this.getGridElementSize().width);
        xLimits.addLeft(this.buffer.getLeft());
        xLimits.subRight(this.buffer.getRight());
        return xLimits;
    }

    public XValues getXLimitsForArea(double bottomYPos, double areaHeight, boolean nanPriority) {
        XValues xLimitsTop = this.getXLimits(bottomYPos - areaHeight);
        XValues xLimitsBottom = this.getXLimits(bottomYPos);
        XValues xLimits = xLimitsTop.intersect(xLimitsBottom, nanPriority);
        return xLimits;
    }

    public void updateMinimumWidth(double width) {
        this.minimumWidth = Math.max(this.minimumWidth, width);
    }

    public void updateMinimumSize(double width, double height) {
        this.updateMinimumWidth(width);
        this.getBuffer().setTopMin(height);
    }

    public double getCalculatedElementWidth() {
        return this.minimumWidth;
    }

    public ElementStyle getElementStyle() {
        return this.elementStyle;
    }

    public void setElementStyle(ElementStyle elementStyle) {
        this.elementStyle = elementStyle;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public DrawHandler getDrawer() {
        return this.drawer;
    }

    public <T> T getFacetResponse(Class<? extends Facet> facetClass, T defaultValue) {
        Object mapValue = this.facetResponse.get(facetClass);
        if (mapValue == null) {
            return defaultValue;
        }
        return (T)mapValue;
    }

    public <T> T getOrInitFacetResponse(Class<? extends Facet> facetClass, T defaultValue) {
        T mapValue = this.getFacetResponse(facetClass, defaultValue);
        this.setFacetResponse(facetClass, mapValue);
        return mapValue;
    }

    public void setFacetResponse(Class<? extends Facet> facetClass, Object value) {
        this.facetResponse.put(facetClass, value);
    }

    public StickingPolygonGenerator getStickingPolygonGenerator() {
        return this.stickingPolygonGenerator;
    }

    public void setStickingPolygonGenerator(StickingPolygonGenerator stickingPolygonGenerator) {
        this.stickingPolygonGenerator = stickingPolygonGenerator;
    }

    public double getTotalTextBlockHeight() {
        return this.totalTextBlockHeight;
    }
}

