/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmediaimpl;

import com.sun.media.jfxmedia.AudioClip;
import com.sun.media.jfxmedia.MediaException;
import com.sun.media.jfxmedia.locator.Locator;
import com.sun.media.jfxmediaimpl.MediaDisposer;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

public class NativeAudioClip
extends AudioClip {
    private final Locator mediaSource;
    private long nativeHandle = 0L;
    private static NativeAudioClipDisposer clipDisposer = new NativeAudioClipDisposer();

    private static native boolean nacInit();

    private static native long nacLoad(Locator var0);

    private static native long nacCreate(byte[] var0, int var1, int var2, int var3, int var4, int var5);

    private static native void nacUnload(long var0);

    private static native void nacStopAll();

    public static synchronized boolean init() {
        return NativeAudioClip.nacInit();
    }

    public static AudioClip load(URI source) {
        NativeAudioClip newClip = null;
        try {
            Locator locator = new Locator(source);
            locator.init();
            newClip = new NativeAudioClip(locator);
        }
        catch (URISyntaxException ex) {
            throw new MediaException("Non-compliant URI", ex);
        }
        catch (IOException ex) {
            throw new MediaException("Cannot connect to media", ex);
        }
        if (null == newClip || 0L == newClip.getNativeHandle()) {
            newClip = null;
            throw new MediaException("Cannot create audio clip");
        }
        MediaDisposer.addResourceDisposer(newClip, new Long(newClip.getNativeHandle()), clipDisposer);
        return newClip;
    }

    public static AudioClip create(byte[] data, int dataOffset, int sampleCount, int sampleFormat, int channels, int sampleRate) {
        NativeAudioClip newClip = new NativeAudioClip(data, dataOffset, sampleCount, sampleFormat, channels, sampleRate);
        if (null == newClip || 0L == newClip.getNativeHandle()) {
            newClip = null;
            throw new MediaException("Cannot create audio clip");
        }
        MediaDisposer.addResourceDisposer(newClip, new Long(newClip.getNativeHandle()), clipDisposer);
        return newClip;
    }

    private native NativeAudioClip nacCreateSegment(long var1, double var3, double var5);

    private native NativeAudioClip nacCreateSegment(long var1, int var3, int var4);

    private native NativeAudioClip nacResample(long var1, int var3, int var4, int var5);

    private native NativeAudioClip nacAppend(long var1, long var3);

    private native boolean nacIsPlaying(long var1);

    private native void nacPlay(long var1, double var3, double var5, double var7, double var9, int var11, int var12);

    private native void nacStop(long var1);

    private NativeAudioClip(Locator source) {
        this.mediaSource = source;
        this.nativeHandle = NativeAudioClip.nacLoad(this.mediaSource);
    }

    private NativeAudioClip(byte[] data, int dataOffset, int sampleCount, int sampleFormat, int channels, int sampleRate) {
        this.mediaSource = null;
        this.nativeHandle = NativeAudioClip.nacCreate(data, dataOffset, sampleCount, sampleFormat, channels, sampleRate);
    }

    long getNativeHandle() {
        return this.nativeHandle;
    }

    public AudioClip createSegment(double startTime, double stopTime) {
        return this.nacCreateSegment(this.nativeHandle, startTime, stopTime);
    }

    public AudioClip createSegment(int startSample, int endSample) {
        return this.nacCreateSegment(this.nativeHandle, startSample, endSample);
    }

    public AudioClip resample(int startSample, int endSample, int newSampleRate) {
        return this.nacResample(this.nativeHandle, startSample, endSample, newSampleRate);
    }

    public AudioClip append(AudioClip clip) {
        if (!(clip instanceof NativeAudioClip)) {
            throw new IllegalArgumentException("AudioClip type mismatch, cannot append");
        }
        return this.nacAppend(this.nativeHandle, ((NativeAudioClip)clip).getNativeHandle());
    }

    public AudioClip flatten() {
        return this;
    }

    public boolean isPlaying() {
        return this.nacIsPlaying(this.nativeHandle);
    }

    public void play() {
        this.nacPlay(this.nativeHandle, this.clipVolume, this.clipBalance, this.clipPan, this.clipRate, this.loopCount, this.clipPriority);
    }

    public void play(double volume) {
        this.nacPlay(this.nativeHandle, volume, this.clipBalance, this.clipPan, this.clipRate, this.loopCount, this.clipPriority);
    }

    public void play(double volume, double balance, double rate, double pan, int loopCount, int priority) {
        this.nacPlay(this.nativeHandle, volume, balance, pan, rate, loopCount, priority);
    }

    public void stop() {
        this.nacStop(this.nativeHandle);
    }

    public static void stopAllClips() {
        NativeAudioClip.nacStopAll();
    }

    private static class NativeAudioClipDisposer
    implements MediaDisposer.ResourceDisposer {
        private NativeAudioClipDisposer() {
        }

        public void disposeResource(Object resource) {
            long nativeHandle = (Long)resource;
            if (0L != nativeHandle) {
                NativeAudioClip.nacUnload(nativeHandle);
            }
        }
    }
}

