/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl.packrect;

import com.sun.prism.impl.packrect.Level;
import com.sun.prism.impl.packrect.Rect;
import java.util.ArrayList;
import java.util.List;

public class LevelSet {
    private List<Level> levels = new ArrayList<Level>(150);
    private static final int MIN_HEIGHT = 8;
    private static final int ROUND_UP = 4;
    private int recentUsedLevelIndex = 0;
    private int nextAddY;
    private int w;
    private int h;

    public LevelSet(int n, int n2) {
        this.w = n;
        this.h = n2;
    }

    public int w() {
        return this.w;
    }

    public int h() {
        return this.h;
    }

    public boolean add(Rect rect) {
        Level level;
        if (rect.w() > this.w) {
            return false;
        }
        int n = 8 > rect.h() ? 8 : rect.h();
        n = n + 4 - 1 - (n - 1) % 4;
        int n2 = this.recentUsedLevelIndex < this.levels.size() && this.levels.get(this.recentUsedLevelIndex).h() != n ? LevelSet.binarySearch(this.levels, n) : this.recentUsedLevelIndex;
        boolean bl = this.nextAddY + n <= this.h;
        for (int i = n2; !(i >= this.levels.size() || (level = this.levels.get(i)).h() > n + 8 && bl); ++i) {
            if (!level.add(rect)) continue;
            this.recentUsedLevelIndex = i;
            return true;
        }
        if (!bl) {
            return false;
        }
        Level level2 = new Level(this.w, n, this.nextAddY, this);
        this.nextAddY += n;
        if (n2 < this.levels.size() && this.levels.get(n2).h() <= n) {
            this.levels.add(n2 + 1, level2);
            this.recentUsedLevelIndex = n2 + 1;
        } else {
            this.levels.add(n2, level2);
            this.recentUsedLevelIndex = n2;
        }
        return level2.add(rect);
    }

    public int getUsedHeight() {
        return this.nextAddY;
    }

    public void clear() {
        this.levels.clear();
        this.nextAddY = 0;
        this.recentUsedLevelIndex = 0;
    }

    private static int binarySearch(List<Level> list, int n) {
        int n2 = n + 1;
        int n3 = 0;
        int n4 = list.size() - 1;
        int n5 = 0;
        int n6 = 0;
        if (n4 < 0) {
            return 0;
        }
        while (n3 <= n4) {
            n5 = (n3 + n4) / 2;
            n6 = list.get(n5).h();
            if (n2 < n6) {
                n4 = n5 - 1;
                continue;
            }
            n3 = n5 + 1;
        }
        if (n6 < n) {
            return n5 + 1;
        }
        if (n6 > n) {
            return n5 > 0 ? n5 - 1 : 0;
        }
        return n5;
    }
}

