/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.db.Database;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.DatabaseUnsupportedException;
import org.parosproxy.paros.extension.Extension;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.ExtensionHookMenu;
import org.parosproxy.paros.extension.ExtensionHookView;
import org.parosproxy.paros.extension.ExtensionLoader;
import org.parosproxy.paros.extension.ViewDelegate;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.model.Session;
import org.zaproxy.zap.Version;
import org.zaproxy.zap.control.AddOn;

public abstract class ExtensionAdaptor
implements Extension {
    private String name = this.getClass().getName();
    private String description;
    private Model model = null;
    private ViewDelegate view = null;
    private int order = 0;
    private boolean enabled = true;
    private ResourceBundle messages = null;
    private String i18nPrefix = null;
    private ExtensionHook hook = null;
    private AddOn addOn;
    private Version version;

    public ExtensionAdaptor() {
    }

    public ExtensionAdaptor(String string) {
        this(string, null);
    }

    private static void validateNotNull(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException("Parameter \"" + string + "\" must not be null.");
        }
    }

    protected ExtensionAdaptor(String string, Version version) {
        ExtensionAdaptor.validateNotNull(string, "name");
        this.name = string;
        this.version = version;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        ExtensionAdaptor.validateNotNull(string, "name");
        this.name = string;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public String getUIName() {
        return this.getName();
    }

    @Override
    public void init() {
    }

    @Override
    public void initModel(Model model) {
        this.model = model;
    }

    @Override
    public void initView(ViewDelegate viewDelegate) {
        this.view = viewDelegate;
    }

    @Override
    public void initXML(Session session, OptionsParam optionsParam) {
    }

    public ExtensionHookView getExtensionView() {
        return null;
    }

    public ExtensionHookMenu getExtensionMenu() {
        return null;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public ViewDelegate getView() {
        return this.view;
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        this.hook = extensionHook;
    }

    @Override
    public boolean isDepreciated() {
        return false;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(int n) {
        this.order = n;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Override
    public String getDescription() {
        if (this.description == null || this.description.length() == 0) {
            return this.getUIName();
        }
        return this.description;
    }

    protected void setDescription(String string) {
        this.description = string;
    }

    @Override
    public List<Class<?>> getDependencies() {
        return Collections.emptyList();
    }

    @Override
    public boolean isCore() {
        return false;
    }

    @Override
    public URL getURL() {
        return null;
    }

    @Override
    public ResourceBundle getMessages() {
        return this.messages;
    }

    @Override
    public void setMessages(ResourceBundle resourceBundle) {
        this.messages = resourceBundle;
    }

    @Override
    public String getI18nPrefix() {
        if (this.i18nPrefix == null) {
            String string = this.getClass().getPackage().getName();
            this.i18nPrefix = string.substring(string.lastIndexOf(".") + 1);
        }
        return this.i18nPrefix;
    }

    @Override
    public void setI18nPrefix(String string) {
        this.i18nPrefix = string;
    }

    @Override
    public void optionsLoaded() {
    }

    @Override
    public boolean canUnload() {
        return false;
    }

    @Override
    public void unload() {
        Control control = Control.getSingleton();
        ExtensionLoader extensionLoader = control.getExtensionLoader();
        extensionLoader.removeExtension(this, this.hook);
    }

    @Override
    public List<String> getUnsavedResources() {
        return null;
    }

    @Override
    public List<String> getActiveActions() {
        return null;
    }

    @Override
    public void postInstall() {
    }

    @Override
    public void postInit() {
    }

    @Override
    public void databaseOpen(Database database) throws DatabaseException, DatabaseUnsupportedException {
    }

    @Override
    public AddOn getAddOn() {
        return this.addOn;
    }

    @Override
    public void setAddOn(AddOn addOn) {
        if (this.addOn != addOn) {
            this.addOn = addOn;
            if (this.addOn != null) {
                this.addOn.addLoadedExtension(this);
            }
        }
    }

    @Override
    public boolean supportsDb(String string) {
        return "hsqldb".equals(string);
    }

    @Override
    public boolean supportsLowMemory() {
        return false;
    }
}

