/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.autoupdate;

import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.control.AddOnCollection;
import org.zaproxy.zap.extension.autoupdate.AddOnWrapper;
import org.zaproxy.zap.extension.autoupdate.AddOnsTableModel;

public class UninstalledAddOnsTableModel
extends AddOnsTableModel {
    private static final long serialVersionUID = 1L;
    private static final String[] COLUMN_NAMES = new String[]{"", Constant.messages.getString("cfu.table.header.status"), Constant.messages.getString("cfu.table.header.name"), Constant.messages.getString("cfu.table.header.desc"), Constant.messages.getString("cfu.table.header.update"), ""};
    private static final int COLUMN_COUNT = COLUMN_NAMES.length;
    private static final Comparator<AddOnWrapper> COMPARATOR = new Comparator<AddOnWrapper>(){

        @Override
        public int compare(AddOnWrapper addOnWrapper, AddOnWrapper addOnWrapper2) {
            if (!addOnWrapper.getAddOn().getStatus().equals((Object)addOnWrapper2.getAddOn().getStatus())) {
                return addOnWrapper2.getAddOn().getStatus().compareTo(addOnWrapper.getAddOn().getStatus());
            }
            return addOnWrapper.getAddOn().getName().toLowerCase().compareTo(addOnWrapper2.getAddOn().getName().toLowerCase());
        }
    };

    public UninstalledAddOnsTableModel(AddOnCollection addOnCollection) {
        super(COMPARATOR, addOnCollection, 4);
    }

    @Override
    public int getColumnCount() {
        return COLUMN_COUNT;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES[n];
    }

    @Override
    public int getRowCount() {
        return this.getAddOnWrappers().size();
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n == 0) {
            return Icon.class;
        }
        if (n == 5) {
            return Boolean.class;
        }
        return String.class;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case -1: {
                return this.getAddOnWrapper(n);
            }
            case 0: {
                return this.getAddOnWrapper(n).hasRunningIssues();
            }
            case 1: {
                return Constant.messages.getString("cfu.status." + this.getAddOnWrapper(n).getAddOn().getStatus().toString());
            }
            case 2: {
                return this.getAddOnWrapper(n).getAddOn().getName();
            }
            case 3: {
                return this.getAddOnWrapper(n).getAddOn().getDescription();
            }
            case 4: {
                int n3 = this.getAddOnWrapper(n).getProgress();
                if (this.getAddOnWrapper(n).isFailed()) {
                    return Constant.messages.getString("cfu.download.failed");
                }
                if (n3 > 0) {
                    return n3 + "%";
                }
                if (AddOnWrapper.Status.newAddon == this.getAddOnWrapper(n).getStatus()) {
                    return Constant.messages.getString("cfu.table.label.new");
                }
                return this.getAddOnWrapper(n).getAddOn().getFileVersion();
            }
            case 5: {
                return this.getAddOnWrapper(n).isEnabled();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 5 && this.getAddOnWrapper(n).getInstallationStatus() != AddOn.InstallationStatus.DOWNLOADING && object instanceof Boolean) {
            this.getAddOnWrapper(n).setEnabled((Boolean)object);
            this.fireTableCellUpdated(n, n2);
        }
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 5 && this.getAddOnWrapper(n).getInstallationStatus() != AddOn.InstallationStatus.DOWNLOADING;
    }

    public boolean canIinstallSelected() {
        boolean bl = false;
        for (AddOnWrapper addOnWrapper : this.getAddOnWrappers()) {
            if (!addOnWrapper.isEnabled()) continue;
            return true;
        }
        return bl;
    }

    public void addAddOn(AddOn addOn) {
        this.addAddOnWrapper(addOn, null);
    }

    public void setAddOns(List<AddOn> list, AddOnCollection addOnCollection) {
        for (AddOn addOn : list) {
            AddOnWrapper.Status status = null;
            if (addOnCollection != null && addOnCollection.getAddOn(addOn.getId()) == null) {
                status = AddOnWrapper.Status.newAddon;
            }
            this.addAddOnWrapper(addOn, status);
        }
    }

    @Override
    protected void restoreInstallationStatusFailedDownload(AddOnWrapper addOnWrapper) {
        addOnWrapper.setInstallationStatus(AddOn.InstallationStatus.AVAILABLE);
    }
}

