/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.fuzz;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.owasp.jbrofuzz.fuzz.ConnectionException;
import org.owasp.jbrofuzz.fuzz.FullyTrustingManager;
import org.owasp.jbrofuzz.fuzz.SocketConnection;

public class Connection {
    private final SocketConnection mainConnection;

    public Connection(String urlString, String message) throws ConnectionException {
        URL url;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e1) {
            throw new ConnectionException("Malformed URL : " + e1.getMessage() + "\n");
        }
        String protocol = url.getProtocol();
        String host = url.getHost();
        int port = url.getPort();
        if (!protocol.equalsIgnoreCase("http") && !protocol.equalsIgnoreCase("https")) {
            throw new ConnectionException("Protocol is not http://, nor is it https://\n");
        }
        if (protocol.equalsIgnoreCase("https") && port == -1) {
            port = 443;
        }
        if (protocol.equalsIgnoreCase("http") && port == -1) {
            port = 80;
        }
        this.mainConnection = new SocketConnection(protocol, host, port, message);
    }

    public String getMessage() {
        return this.mainConnection.getMessage();
    }

    public String getPort() {
        return this.mainConnection.getPort();
    }

    public String getReply() {
        return this.mainConnection.getReply();
    }

    public String getStatus() {
        return this.mainConnection.getStatus();
    }

    protected static final SSLSocketFactory getSocketFactory() throws ConnectionException {
        try {
            TrustManager[] tManager = new TrustManager[]{new FullyTrustingManager()};
            SSLContext context = SSLContext.getInstance("SSL");
            context.init(new KeyManager[0], tManager, new SecureRandom());
            return context.getSocketFactory();
        }
        catch (KeyManagementException e) {
            throw new ConnectionException("No SSL algorithm support.");
        }
        catch (NoSuchAlgorithmException e) {
            throw new ConnectionException("Exception when setting up the Naive key management.");
        }
    }
}

