#ifndef EFL_GENERATED_ELM_ENTRY_HH
#define EFL_GENERATED_ELM_ENTRY_HH

extern "C"
{
#include <Efl.h>
}
#include <Eo.hh>

#include <eo_cxx_interop.hh>

extern "C"
{
#include "elm_entry.eo.h"
}

#include "elm_layout.eo.hh"
#include "elm_interface_scrollable.eo.hh"
#include "evas_clickable_interface.eo.hh"
#include "elm_interface_atspi_text.eo.hh"
#include "elm_interface_atspi_editable_text.eo.hh"
#include "efl_file.eo.hh"
#include "evas_selectable_interface.eo.hh"
#include "evas_scrollable_interface.eo.hh"
#include <evas_object.eo.hh>
#include <string>

namespace elm {

struct entry;

}

/// @cond EO_CXX_ABSTRACT
namespace eo_cxx {

namespace elm {

struct entry
{
   bool cursor_prev() const;

   void text_style_user_pop() const;

   /// @param func 
   /// @param data 
   ///
   void item_provider_prepend(Elm_Entry_Item_Provider_Cb func_, void * data_) const;

   void input_panel_show() const;

   void imf_context_reset() const;

   void calc_force() const;

   void anchor_hover_end() const;

   void cursor_selection_begin() const;

   bool cursor_down() const;

   void file_save() const;

   void selection_copy() const;

   /// @param style 
   ///
   void text_style_user_push(::efl::eina::string_view style_) const;

   /// @param func 
   /// @param data 
   ///
   void item_provider_remove(Elm_Entry_Item_Provider_Cb func_, void * data_) const;

   ::efl::eina::string_view text_style_user_peek() const;

   void context_menu_clear() const;

   bool cursor_up() const;

   /// @param entry 
   ///
   void entry_insert(::efl::eina::string_view entry_) const;

   /// @param data 
   /// @param len 
   ///
   void input_panel_imdata_set(const void * data_, int len_) const;

   /// @param[out] data 
   /// @param[out] len 
   ///
   void input_panel_imdata_get(void* data_, int* len_) const;

   void selection_paste() const;

   bool cursor_next() const;

   void select_none() const;

   void input_panel_hide() const;

   void select_all() const;

   void cursor_selection_end() const;

   void selection_cut() const;

   bool is_empty() const;

   /// @param func 
   /// @param data 
   ///
   void markup_filter_remove(Elm_Entry_Filter_Cb func_, void * data_) const;

   /// @param func 
   /// @param data 
   ///
   void item_provider_append(Elm_Entry_Item_Provider_Cb func_, void * data_) const;

   /// @param func 
   /// @param data 
   ///
   void markup_filter_append(Elm_Entry_Filter_Cb func_, void * data_) const;

   /// @param str 
   ///
   void entry_append(::efl::eina::string_view str_) const;

   /// @param label 
   /// @param icon_file 
   /// @param icon_type 
   /// @param func 
   /// @param data 
   ///
   void context_menu_item_add(::efl::eina::optional< ::efl::eina::string_view > label_, ::efl::eina::optional< ::efl::eina::string_view > icon_file_, Elm_Icon_Type icon_type_, Evas_Smart_Cb func_, const void * data_) const;

   /// @param func 
   /// @param data 
   ///
   void markup_filter_prepend(Elm_Entry_Filter_Cb func_, void * data_) const;

   bool scrollable_get() const;

   void scrollable_set(bool scroll_) const;

   bool input_panel_show_on_demand_get() const;

   void input_panel_show_on_demand_set(bool ondemand_) const;

   bool context_menu_disabled_get() const;

   void context_menu_disabled_set(bool disabled_) const;

   Elm_Cnp_Mode cnp_mode_get() const;

   void cnp_mode_set(Elm_Cnp_Mode cnp_mode_) const;

   void file_text_format_set(Elm_Text_Format format_) const;

   Elm_Input_Panel_Lang input_panel_language_get() const;

   void input_panel_language_set(Elm_Input_Panel_Lang lang_) const;

   bool selection_handler_disabled_get() const;

   void selection_handler_disabled_set(bool disabled_) const;

   int input_panel_layout_variation_get() const;

   void input_panel_layout_variation_set(int variation_) const;

   Elm_Autocapital_Type autocapital_type_get() const;

   void autocapital_type_set(Elm_Autocapital_Type autocapital_type_) const;

   bool editable_get() const;

   void editable_set(bool editable_) const;

   ::efl::eina::optional< ::efl::eina::string_view > anchor_hover_style_get() const;

   void anchor_hover_style_set(::efl::eina::optional< ::efl::eina::string_view > style_) const;

   bool single_line_get() const;

   void single_line_set(bool single_line_) const;

   bool password_get() const;

   void password_set(bool password_) const;

   bool input_panel_return_key_disabled_get() const;

   void input_panel_return_key_disabled_set(bool disabled_) const;

   bool autosave_get() const;

   void autosave_set(bool auto_save_) const;

   ::evas::object anchor_hover_parent_get() const;

   void anchor_hover_parent_set(::evas::object parent_) const;

   bool prediction_allow_get() const;

   void prediction_allow_set(bool prediction_) const;

   Elm_Input_Hints input_hint_get() const;

   void input_hint_set(Elm_Input_Hints hints_) const;

   Elm_Input_Panel_Layout input_panel_layout_get() const;

   void input_panel_layout_set(Elm_Input_Panel_Layout layout_) const;

   Elm_Input_Panel_Return_Key_Type input_panel_return_key_type_get() const;

   void input_panel_return_key_type_set(Elm_Input_Panel_Return_Key_Type return_key_type_) const;

   bool input_panel_enabled_get() const;

   void input_panel_enabled_set(bool enabled_) const;

   Elm_Wrap_Type line_wrap_get() const;

   void line_wrap_set(Elm_Wrap_Type wrap_) const;

   int cursor_pos_get() const;

   void cursor_pos_set(int pos_) const;

   void icon_visible_set(bool setting_) const;

   void cursor_line_end_set() const;

   void select_region_set(int start_, int end_) const;

   void input_panel_return_key_autoenabled_set(bool enabled_) const;

   void end_visible_set(bool setting_) const;

   void cursor_begin_set() const;

   void cursor_line_begin_set() const;

   void cursor_end_set() const;

   ::evas::object textblock_get() const;

   bool cursor_geometry_get(Evas_Coord* x_, Evas_Coord* y_, Evas_Coord* w_, Evas_Coord* h_) const;

   void * imf_context_get() const;

   bool cursor_is_format_get() const;

   char * cursor_content_get() const;

   ::efl::eina::string_view selection_get() const;

   bool cursor_is_visible_format_get() const;

   template <typename F>
   ::efl::eo::signal_connection
   callback_activated_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ENTRY_EVENT_ACTIVATED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_ENTRY_EVENT_ACTIVATED );
   }

   template <typename T>
   void
   callback_activated_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ENTRY_EVENT_ACTIVATED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ENTRY_EVENT_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_ENTRY_EVENT_CHANGED );
   }

   template <typename T>
   void
   callback_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ENTRY_EVENT_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_changed_user_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ENTRY_EVENT_CHANGED_USER, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_ENTRY_EVENT_CHANGED_USER );
   }

   template <typename T>
   void
   callback_changed_user_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ENTRY_EVENT_CHANGED_USER, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_validate_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ENTRY_EVENT_VALIDATE, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_ENTRY_EVENT_VALIDATE );
   }

   template <typename T>
   void
   callback_validate_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ENTRY_EVENT_VALIDATE, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_context_open_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ENTRY_EVENT_CONTEXT_OPEN, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_ENTRY_EVENT_CONTEXT_OPEN );
   }

   template <typename T>
   void
   callback_context_open_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ENTRY_EVENT_CONTEXT_OPEN, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_anchor_clicked_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ENTRY_EVENT_ANCHOR_CLICKED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_ENTRY_EVENT_ANCHOR_CLICKED );
   }

   template <typename T>
   void
   callback_anchor_clicked_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ENTRY_EVENT_ANCHOR_CLICKED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_rejected_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ENTRY_EVENT_REJECTED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_ENTRY_EVENT_REJECTED );
   }

   template <typename T>
   void
   callback_rejected_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ENTRY_EVENT_REJECTED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_maxlength_reached_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ENTRY_EVENT_MAXLENGTH_REACHED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_ENTRY_EVENT_MAXLENGTH_REACHED );
   }

   template <typename T>
   void
   callback_maxlength_reached_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ENTRY_EVENT_MAXLENGTH_REACHED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_preedit_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ENTRY_EVENT_PREEDIT_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_ENTRY_EVENT_PREEDIT_CHANGED );
   }

   template <typename T>
   void
   callback_preedit_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ENTRY_EVENT_PREEDIT_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_press_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ENTRY_EVENT_PRESS, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_ENTRY_EVENT_PRESS );
   }

   template <typename T>
   void
   callback_press_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ENTRY_EVENT_PRESS, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_redo_request_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ENTRY_EVENT_REDO_REQUEST, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_ENTRY_EVENT_REDO_REQUEST );
   }

   template <typename T>
   void
   callback_redo_request_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ENTRY_EVENT_REDO_REQUEST, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_undo_request_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ENTRY_EVENT_UNDO_REQUEST, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_ENTRY_EVENT_UNDO_REQUEST );
   }

   template <typename T>
   void
   callback_undo_request_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ENTRY_EVENT_UNDO_REQUEST, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_text_set_done_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ENTRY_EVENT_TEXT_SET_DONE, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_ENTRY_EVENT_TEXT_SET_DONE );
   }

   template <typename T>
   void
   callback_text_set_done_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ENTRY_EVENT_TEXT_SET_DONE, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_aborted_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ENTRY_EVENT_ABORTED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_ENTRY_EVENT_ABORTED );
   }

   template <typename T>
   void
   callback_aborted_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ENTRY_EVENT_ABORTED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_anchor_down_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ENTRY_EVENT_ANCHOR_DOWN, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_ENTRY_EVENT_ANCHOR_DOWN );
   }

   template <typename T>
   void
   callback_anchor_down_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ENTRY_EVENT_ANCHOR_DOWN, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_anchor_hover_opened_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ENTRY_EVENT_ANCHOR_HOVER_OPENED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_ENTRY_EVENT_ANCHOR_HOVER_OPENED );
   }

   template <typename T>
   void
   callback_anchor_hover_opened_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ENTRY_EVENT_ANCHOR_HOVER_OPENED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_anchor_in_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ENTRY_EVENT_ANCHOR_IN, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_ENTRY_EVENT_ANCHOR_IN );
   }

   template <typename T>
   void
   callback_anchor_in_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ENTRY_EVENT_ANCHOR_IN, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_anchor_out_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ENTRY_EVENT_ANCHOR_OUT, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_ENTRY_EVENT_ANCHOR_OUT );
   }

   template <typename T>
   void
   callback_anchor_out_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ENTRY_EVENT_ANCHOR_OUT, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_anchor_up_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ENTRY_EVENT_ANCHOR_UP, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_ENTRY_EVENT_ANCHOR_UP );
   }

   template <typename T>
   void
   callback_anchor_up_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ENTRY_EVENT_ANCHOR_UP, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_cursor_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ENTRY_EVENT_CURSOR_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_ENTRY_EVENT_CURSOR_CHANGED );
   }

   template <typename T>
   void
   callback_cursor_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ENTRY_EVENT_CURSOR_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_cursor_changed_manual_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ENTRY_EVENT_CURSOR_CHANGED_MANUAL, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_ENTRY_EVENT_CURSOR_CHANGED_MANUAL );
   }

   template <typename T>
   void
   callback_cursor_changed_manual_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ENTRY_EVENT_CURSOR_CHANGED_MANUAL, info));
   }



   static Eo_Class const* _eo_class()
   {
      return(ELM_ENTRY_CLASS);
   }

   operator ::elm::entry() const;
   operator ::elm::entry&();
   operator ::elm::entry const&() const;

   /// @cond LOCAL
   template <typename D>
   struct address_of
   {
      operator ::elm::entry*() const { return static_cast<::elm::entry*>(static_cast<D const*>(this)->p); }
      operator ::elm::entry const*() const { return static_cast<::elm::entry const*>(static_cast<D const*>(this)->p); }
   };

   template <typename D>
   struct address_const_of
   {
      operator ::elm::entry const*() const { return static_cast<::elm::entry const*>(static_cast<D const*>(this)->p); }
   };
   /// @endcond

private:

   /// @internal
   Eo* _concrete_eo_ptr() const
   {
      return static_cast<::efl::eo::concrete const*>(static_cast<void const*>(this))->_eo_ptr();
   }

};

}

}
/// @endcond

namespace elm {

/// @brief Class entry
struct entry
      : ::efl::eo::concrete
      , EO_CXX_INHERIT(efl::file)
      , EO_CXX_INHERIT(efl::gfx::base)
      , EO_CXX_INHERIT(efl::gfx::stack)
      , EO_CXX_INHERIT(elm::container)
      , EO_CXX_INHERIT(elm::layout)
      , EO_CXX_INHERIT(elm::widget)
      , EO_CXX_INHERIT(elm_interface_atspi_accessible)
      , EO_CXX_INHERIT(elm_interface_atspi_component)
      , EO_CXX_INHERIT(elm_interface_atspi_editable_text)
      , EO_CXX_INHERIT(elm_interface_atspi_text)
      , EO_CXX_INHERIT(elm_interface_scrollable)
      , EO_CXX_INHERIT(eo::base)
      , EO_CXX_INHERIT(evas::clickable_interface)
      , EO_CXX_INHERIT(evas::common_interface)
      , EO_CXX_INHERIT(evas::object)
      , EO_CXX_INHERIT(evas::object_smart)
      , EO_CXX_INHERIT(evas::scrollable_interface)
      , EO_CXX_INHERIT(evas::selectable_interface)
      , EO_CXX_INHERIT(evas::signal_interface)
{
   //@{
   /**
      @brief Constructs a new elm::entry object.

      Constructs a new elm::entry object. If you want this object to be a child
      of another Eo object, use an @ref efl::eo::parent expression, like the example.

      Example:
      @code
      elm::entry my_entry(efl::eo::parent = parent_object);
      @endcode

      @see entry(Eo* eo)
   */
   explicit entry(::efl::eo::parent_type _p)
      : entry(_ctors_call(_p))
   {}

   explicit entry()
      : entry(_ctors_call(::efl::eo::parent = nullptr))
   {}
   //@}

   /// @brief Eo Constructor.
   ///
   /// Constructs the object from an Eo* pointer stealing its ownership.
   ///
   /// @param eo The Eo object pointer.
   ///
   explicit entry(Eo* eo)
      : ::efl::eo::concrete(eo)
   {}

   /// @brief nullptr_t Constructor.
   ///
   /// Constructs an empty (null) object.
   ///
   explicit entry(std::nullptr_t)
      : ::efl::eo::concrete(nullptr)
   {}

   /// @brief Copy Constructor.
   ///
   entry(entry const& other)
      : entry(eo_ref(other._eo_ptr()))
   {}

   ~entry() {}

   bool cursor_prev() const;

   void text_style_user_pop() const;

   /// @param func 
   /// @param data 
   ///
   void item_provider_prepend(Elm_Entry_Item_Provider_Cb func_, void * data_) const;

   void input_panel_show() const;

   void imf_context_reset() const;

   void calc_force() const;

   void anchor_hover_end() const;

   void cursor_selection_begin() const;

   bool cursor_down() const;

   void file_save() const;

   void selection_copy() const;

   /// @param style 
   ///
   void text_style_user_push(::efl::eina::string_view style_) const;

   /// @param func 
   /// @param data 
   ///
   void item_provider_remove(Elm_Entry_Item_Provider_Cb func_, void * data_) const;

   ::efl::eina::string_view text_style_user_peek() const;

   void context_menu_clear() const;

   bool cursor_up() const;

   /// @param entry 
   ///
   void entry_insert(::efl::eina::string_view entry_) const;

   /// @param data 
   /// @param len 
   ///
   void input_panel_imdata_set(const void * data_, int len_) const;

   /// @param[out] data 
   /// @param[out] len 
   ///
   void input_panel_imdata_get(void* data_, int* len_) const;

   void selection_paste() const;

   bool cursor_next() const;

   void select_none() const;

   void input_panel_hide() const;

   void select_all() const;

   void cursor_selection_end() const;

   void selection_cut() const;

   bool is_empty() const;

   /// @param func 
   /// @param data 
   ///
   void markup_filter_remove(Elm_Entry_Filter_Cb func_, void * data_) const;

   /// @param func 
   /// @param data 
   ///
   void item_provider_append(Elm_Entry_Item_Provider_Cb func_, void * data_) const;

   /// @param func 
   /// @param data 
   ///
   void markup_filter_append(Elm_Entry_Filter_Cb func_, void * data_) const;

   /// @param str 
   ///
   void entry_append(::efl::eina::string_view str_) const;

   /// @param label 
   /// @param icon_file 
   /// @param icon_type 
   /// @param func 
   /// @param data 
   ///
   void context_menu_item_add(::efl::eina::optional< ::efl::eina::string_view > label_, ::efl::eina::optional< ::efl::eina::string_view > icon_file_, Elm_Icon_Type icon_type_, Evas_Smart_Cb func_, const void * data_) const;

   /// @param func 
   /// @param data 
   ///
   void markup_filter_prepend(Elm_Entry_Filter_Cb func_, void * data_) const;

   bool scrollable_get() const;

   void scrollable_set(bool scroll_) const;

   bool input_panel_show_on_demand_get() const;

   void input_panel_show_on_demand_set(bool ondemand_) const;

   bool context_menu_disabled_get() const;

   void context_menu_disabled_set(bool disabled_) const;

   Elm_Cnp_Mode cnp_mode_get() const;

   void cnp_mode_set(Elm_Cnp_Mode cnp_mode_) const;

   void file_text_format_set(Elm_Text_Format format_) const;

   Elm_Input_Panel_Lang input_panel_language_get() const;

   void input_panel_language_set(Elm_Input_Panel_Lang lang_) const;

   bool selection_handler_disabled_get() const;

   void selection_handler_disabled_set(bool disabled_) const;

   int input_panel_layout_variation_get() const;

   void input_panel_layout_variation_set(int variation_) const;

   Elm_Autocapital_Type autocapital_type_get() const;

   void autocapital_type_set(Elm_Autocapital_Type autocapital_type_) const;

   bool editable_get() const;

   void editable_set(bool editable_) const;

   ::efl::eina::optional< ::efl::eina::string_view > anchor_hover_style_get() const;

   void anchor_hover_style_set(::efl::eina::optional< ::efl::eina::string_view > style_) const;

   bool single_line_get() const;

   void single_line_set(bool single_line_) const;

   bool password_get() const;

   void password_set(bool password_) const;

   bool input_panel_return_key_disabled_get() const;

   void input_panel_return_key_disabled_set(bool disabled_) const;

   bool autosave_get() const;

   void autosave_set(bool auto_save_) const;

   ::evas::object anchor_hover_parent_get() const;

   void anchor_hover_parent_set(::evas::object parent_) const;

   bool prediction_allow_get() const;

   void prediction_allow_set(bool prediction_) const;

   Elm_Input_Hints input_hint_get() const;

   void input_hint_set(Elm_Input_Hints hints_) const;

   Elm_Input_Panel_Layout input_panel_layout_get() const;

   void input_panel_layout_set(Elm_Input_Panel_Layout layout_) const;

   Elm_Input_Panel_Return_Key_Type input_panel_return_key_type_get() const;

   void input_panel_return_key_type_set(Elm_Input_Panel_Return_Key_Type return_key_type_) const;

   bool input_panel_enabled_get() const;

   void input_panel_enabled_set(bool enabled_) const;

   Elm_Wrap_Type line_wrap_get() const;

   void line_wrap_set(Elm_Wrap_Type wrap_) const;

   int cursor_pos_get() const;

   void cursor_pos_set(int pos_) const;

   void icon_visible_set(bool setting_) const;

   void cursor_line_end_set() const;

   void select_region_set(int start_, int end_) const;

   void input_panel_return_key_autoenabled_set(bool enabled_) const;

   void end_visible_set(bool setting_) const;

   void cursor_begin_set() const;

   void cursor_line_begin_set() const;

   void cursor_end_set() const;

   ::evas::object textblock_get() const;

   bool cursor_geometry_get(Evas_Coord* x_, Evas_Coord* y_, Evas_Coord* w_, Evas_Coord* h_) const;

   void * imf_context_get() const;

   bool cursor_is_format_get() const;

   char * cursor_content_get() const;

   ::efl::eina::string_view selection_get() const;

   bool cursor_is_visible_format_get() const;

   template <typename F>
   ::efl::eo::signal_connection
   callback_aborted_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ENTRY_EVENT_ABORTED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_ENTRY_EVENT_ABORTED );
   }

   template <typename T>
   void
   callback_aborted_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ENTRY_EVENT_ABORTED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_access_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIDGET_EVENT_ACCESS_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_WIDGET_EVENT_ACCESS_CHANGED );
   }

   template <typename T>
   void
   callback_access_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIDGET_EVENT_ACCESS_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_access_text_attributes_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_INTERFACE_ATSPI_TEXT_EVENT_ACCESS_TEXT_ATTRIBUTES_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_INTERFACE_ATSPI_TEXT_EVENT_ACCESS_TEXT_ATTRIBUTES_CHANGED );
   }

   template <typename T>
   void
   callback_access_text_attributes_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_INTERFACE_ATSPI_TEXT_EVENT_ACCESS_TEXT_ATTRIBUTES_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_access_text_bounds_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_INTERFACE_ATSPI_TEXT_EVENT_ACCESS_TEXT_BOUNDS_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_INTERFACE_ATSPI_TEXT_EVENT_ACCESS_TEXT_BOUNDS_CHANGED );
   }

   template <typename T>
   void
   callback_access_text_bounds_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_INTERFACE_ATSPI_TEXT_EVENT_ACCESS_TEXT_BOUNDS_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_access_text_caret_moved_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_INTERFACE_ATSPI_TEXT_EVENT_ACCESS_TEXT_CARET_MOVED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_INTERFACE_ATSPI_TEXT_EVENT_ACCESS_TEXT_CARET_MOVED );
   }

   template <typename T>
   void
   callback_access_text_caret_moved_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_INTERFACE_ATSPI_TEXT_EVENT_ACCESS_TEXT_CARET_MOVED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_access_text_inserted_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_INTERFACE_ATSPI_TEXT_EVENT_ACCESS_TEXT_INSERTED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_INTERFACE_ATSPI_TEXT_EVENT_ACCESS_TEXT_INSERTED );
   }

   template <typename T>
   void
   callback_access_text_inserted_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_INTERFACE_ATSPI_TEXT_EVENT_ACCESS_TEXT_INSERTED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_access_text_removed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_INTERFACE_ATSPI_TEXT_EVENT_ACCESS_TEXT_REMOVED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_INTERFACE_ATSPI_TEXT_EVENT_ACCESS_TEXT_REMOVED );
   }

   template <typename T>
   void
   callback_access_text_removed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_INTERFACE_ATSPI_TEXT_EVENT_ACCESS_TEXT_REMOVED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_access_text_selection_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_INTERFACE_ATSPI_TEXT_EVENT_ACCESS_TEXT_SELECTION_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_INTERFACE_ATSPI_TEXT_EVENT_ACCESS_TEXT_SELECTION_CHANGED );
   }

   template <typename T>
   void
   callback_access_text_selection_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_INTERFACE_ATSPI_TEXT_EVENT_ACCESS_TEXT_SELECTION_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_activated_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ENTRY_EVENT_ACTIVATED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_ENTRY_EVENT_ACTIVATED );
   }

   template <typename T>
   void
   callback_activated_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ENTRY_EVENT_ACTIVATED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_active_descendant_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_ACTIVE_DESCENDANT_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_ACTIVE_DESCENDANT_CHANGED );
   }

   template <typename T>
   void
   callback_active_descendant_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_ACTIVE_DESCENDANT_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_added_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_ADDED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_ADDED );
   }

   template <typename T>
   void
   callback_added_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_ADDED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_anchor_clicked_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ENTRY_EVENT_ANCHOR_CLICKED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_ENTRY_EVENT_ANCHOR_CLICKED );
   }

   template <typename T>
   void
   callback_anchor_clicked_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ENTRY_EVENT_ANCHOR_CLICKED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_anchor_down_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ENTRY_EVENT_ANCHOR_DOWN, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_ENTRY_EVENT_ANCHOR_DOWN );
   }

   template <typename T>
   void
   callback_anchor_down_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ENTRY_EVENT_ANCHOR_DOWN, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_anchor_hover_opened_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ENTRY_EVENT_ANCHOR_HOVER_OPENED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_ENTRY_EVENT_ANCHOR_HOVER_OPENED );
   }

   template <typename T>
   void
   callback_anchor_hover_opened_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ENTRY_EVENT_ANCHOR_HOVER_OPENED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_anchor_in_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ENTRY_EVENT_ANCHOR_IN, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_ENTRY_EVENT_ANCHOR_IN );
   }

   template <typename T>
   void
   callback_anchor_in_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ENTRY_EVENT_ANCHOR_IN, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_anchor_out_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ENTRY_EVENT_ANCHOR_OUT, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_ENTRY_EVENT_ANCHOR_OUT );
   }

   template <typename T>
   void
   callback_anchor_out_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ENTRY_EVENT_ANCHOR_OUT, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_anchor_up_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ENTRY_EVENT_ANCHOR_UP, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_ENTRY_EVENT_ANCHOR_UP );
   }

   template <typename T>
   void
   callback_anchor_up_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ENTRY_EVENT_ANCHOR_UP, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_async_error_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EFL_FILE_EVENT_ASYNC_ERROR, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EFL_FILE_EVENT_ASYNC_ERROR );
   }

   template <typename T>
   void
   callback_async_error_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EFL_FILE_EVENT_ASYNC_ERROR, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_async_opened_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EFL_FILE_EVENT_ASYNC_OPENED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EFL_FILE_EVENT_ASYNC_OPENED );
   }

   template <typename T>
   void
   callback_async_opened_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EFL_FILE_EVENT_ASYNC_OPENED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_callback_add_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EO_BASE_EVENT_CALLBACK_ADD, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EO_BASE_EVENT_CALLBACK_ADD );
   }

   template <typename T>
   void
   callback_callback_add_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EO_BASE_EVENT_CALLBACK_ADD, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_callback_del_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EO_BASE_EVENT_CALLBACK_DEL, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EO_BASE_EVENT_CALLBACK_DEL );
   }

   template <typename T>
   void
   callback_callback_del_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EO_BASE_EVENT_CALLBACK_DEL, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ENTRY_EVENT_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_ENTRY_EVENT_CHANGED );
   }

   template <typename T>
   void
   callback_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ENTRY_EVENT_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_changed_size_hints_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_CHANGED_SIZE_HINTS, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EVAS_OBJECT_EVENT_CHANGED_SIZE_HINTS );
   }

   template <typename T>
   void
   callback_changed_size_hints_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_CHANGED_SIZE_HINTS, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_changed_user_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ENTRY_EVENT_CHANGED_USER, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_ENTRY_EVENT_CHANGED_USER );
   }

   template <typename T>
   void
   callback_changed_user_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ENTRY_EVENT_CHANGED_USER, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_children_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_CHILDREN_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_CHILDREN_CHANGED );
   }

   template <typename T>
   void
   callback_children_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_CHILDREN_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_clicked_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_CLICKABLE_INTERFACE_EVENT_CLICKED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EVAS_CLICKABLE_INTERFACE_EVENT_CLICKED );
   }

   template <typename T>
   void
   callback_clicked_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_CLICKABLE_INTERFACE_EVENT_CLICKED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_clicked_double_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_CLICKABLE_INTERFACE_EVENT_CLICKED_DOUBLE, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EVAS_CLICKABLE_INTERFACE_EVENT_CLICKED_DOUBLE );
   }

   template <typename T>
   void
   callback_clicked_double_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_CLICKABLE_INTERFACE_EVENT_CLICKED_DOUBLE, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_clicked_right_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_CLICKABLE_INTERFACE_EVENT_CLICKED_RIGHT, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EVAS_CLICKABLE_INTERFACE_EVENT_CLICKED_RIGHT );
   }

   template <typename T>
   void
   callback_clicked_right_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_CLICKABLE_INTERFACE_EVENT_CLICKED_RIGHT, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_clicked_triple_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_CLICKABLE_INTERFACE_EVENT_CLICKED_TRIPLE, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EVAS_CLICKABLE_INTERFACE_EVENT_CLICKED_TRIPLE );
   }

   template <typename T>
   void
   callback_clicked_triple_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_CLICKABLE_INTERFACE_EVENT_CLICKED_TRIPLE, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_context_open_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ENTRY_EVENT_CONTEXT_OPEN, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_ENTRY_EVENT_CONTEXT_OPEN );
   }

   template <typename T>
   void
   callback_context_open_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ENTRY_EVENT_CONTEXT_OPEN, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_cursor_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ENTRY_EVENT_CURSOR_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_ENTRY_EVENT_CURSOR_CHANGED );
   }

   template <typename T>
   void
   callback_cursor_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ENTRY_EVENT_CURSOR_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_cursor_changed_manual_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ENTRY_EVENT_CURSOR_CHANGED_MANUAL, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_ENTRY_EVENT_CURSOR_CHANGED_MANUAL );
   }

   template <typename T>
   void
   callback_cursor_changed_manual_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ENTRY_EVENT_CURSOR_CHANGED_MANUAL, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_focus_in_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_FOCUS_IN, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EVAS_OBJECT_EVENT_FOCUS_IN );
   }

   template <typename T>
   void
   callback_focus_in_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_FOCUS_IN, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_focus_out_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_FOCUS_OUT, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EVAS_OBJECT_EVENT_FOCUS_OUT );
   }

   template <typename T>
   void
   callback_focus_out_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_FOCUS_OUT, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_focused_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIDGET_EVENT_FOCUSED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_WIDGET_EVENT_FOCUSED );
   }

   template <typename T>
   void
   callback_focused_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIDGET_EVENT_FOCUSED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_free_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_FREE, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EVAS_OBJECT_EVENT_FREE );
   }

   template <typename T>
   void
   callback_free_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_FREE, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_hide_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_HIDE, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EVAS_OBJECT_EVENT_HIDE );
   }

   template <typename T>
   void
   callback_hide_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_HIDE, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_hold_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_HOLD, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EVAS_OBJECT_EVENT_HOLD );
   }

   template <typename T>
   void
   callback_hold_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_HOLD, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_image_preloaded_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_IMAGE_PRELOADED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EVAS_OBJECT_EVENT_IMAGE_PRELOADED );
   }

   template <typename T>
   void
   callback_image_preloaded_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_IMAGE_PRELOADED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_image_resize_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_IMAGE_RESIZE, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EVAS_OBJECT_EVENT_IMAGE_RESIZE );
   }

   template <typename T>
   void
   callback_image_resize_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_IMAGE_RESIZE, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_image_unloaded_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_IMAGE_UNLOADED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EVAS_OBJECT_EVENT_IMAGE_UNLOADED );
   }

   template <typename T>
   void
   callback_image_unloaded_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_IMAGE_UNLOADED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_key_down_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_KEY_DOWN, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EVAS_OBJECT_EVENT_KEY_DOWN );
   }

   template <typename T>
   void
   callback_key_down_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_KEY_DOWN, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_key_up_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_KEY_UP, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EVAS_OBJECT_EVENT_KEY_UP );
   }

   template <typename T>
   void
   callback_key_up_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_KEY_UP, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_language_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIDGET_EVENT_LANGUAGE_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_WIDGET_EVENT_LANGUAGE_CHANGED );
   }

   template <typename T>
   void
   callback_language_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIDGET_EVENT_LANGUAGE_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_longpressed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_CLICKABLE_INTERFACE_EVENT_LONGPRESSED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EVAS_CLICKABLE_INTERFACE_EVENT_LONGPRESSED );
   }

   template <typename T>
   void
   callback_longpressed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_CLICKABLE_INTERFACE_EVENT_LONGPRESSED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_maxlength_reached_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ENTRY_EVENT_MAXLENGTH_REACHED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_ENTRY_EVENT_MAXLENGTH_REACHED );
   }

   template <typename T>
   void
   callback_maxlength_reached_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ENTRY_EVENT_MAXLENGTH_REACHED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_mouse_down_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_MOUSE_DOWN, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EVAS_OBJECT_EVENT_MOUSE_DOWN );
   }

   template <typename T>
   void
   callback_mouse_down_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_MOUSE_DOWN, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_mouse_in_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_MOUSE_IN, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EVAS_OBJECT_EVENT_MOUSE_IN );
   }

   template <typename T>
   void
   callback_mouse_in_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_MOUSE_IN, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_mouse_move_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_MOUSE_MOVE, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EVAS_OBJECT_EVENT_MOUSE_MOVE );
   }

   template <typename T>
   void
   callback_mouse_move_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_MOUSE_MOVE, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_mouse_out_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_MOUSE_OUT, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EVAS_OBJECT_EVENT_MOUSE_OUT );
   }

   template <typename T>
   void
   callback_mouse_out_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_MOUSE_OUT, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_mouse_up_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_MOUSE_UP, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EVAS_OBJECT_EVENT_MOUSE_UP );
   }

   template <typename T>
   void
   callback_mouse_up_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_MOUSE_UP, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_mouse_wheel_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_MOUSE_WHEEL, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EVAS_OBJECT_EVENT_MOUSE_WHEEL );
   }

   template <typename T>
   void
   callback_mouse_wheel_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_MOUSE_WHEEL, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_move_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_MOVE, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EVAS_OBJECT_EVENT_MOVE );
   }

   template <typename T>
   void
   callback_move_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_MOVE, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_moved_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIDGET_EVENT_MOVED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_WIDGET_EVENT_MOVED );
   }

   template <typename T>
   void
   callback_moved_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIDGET_EVENT_MOVED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_multi_down_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_MULTI_DOWN, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EVAS_OBJECT_EVENT_MULTI_DOWN );
   }

   template <typename T>
   void
   callback_multi_down_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_MULTI_DOWN, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_multi_move_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_MULTI_MOVE, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EVAS_OBJECT_EVENT_MULTI_MOVE );
   }

   template <typename T>
   void
   callback_multi_move_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_MULTI_MOVE, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_multi_up_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_MULTI_UP, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EVAS_OBJECT_EVENT_MULTI_UP );
   }

   template <typename T>
   void
   callback_multi_up_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_MULTI_UP, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_preedit_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ENTRY_EVENT_PREEDIT_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_ENTRY_EVENT_PREEDIT_CHANGED );
   }

   template <typename T>
   void
   callback_preedit_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ENTRY_EVENT_PREEDIT_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_press_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ENTRY_EVENT_PRESS, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_ENTRY_EVENT_PRESS );
   }

   template <typename T>
   void
   callback_press_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ENTRY_EVENT_PRESS, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_pressed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_CLICKABLE_INTERFACE_EVENT_PRESSED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EVAS_CLICKABLE_INTERFACE_EVENT_PRESSED );
   }

   template <typename T>
   void
   callback_pressed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_CLICKABLE_INTERFACE_EVENT_PRESSED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_property_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_PROPERTY_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_PROPERTY_CHANGED );
   }

   template <typename T>
   void
   callback_property_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_PROPERTY_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_redo_request_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ENTRY_EVENT_REDO_REQUEST, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_ENTRY_EVENT_REDO_REQUEST );
   }

   template <typename T>
   void
   callback_redo_request_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ENTRY_EVENT_REDO_REQUEST, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_rejected_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ENTRY_EVENT_REJECTED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_ENTRY_EVENT_REJECTED );
   }

   template <typename T>
   void
   callback_rejected_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ENTRY_EVENT_REJECTED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_removed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_REMOVED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_REMOVED );
   }

   template <typename T>
   void
   callback_removed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_REMOVED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_repeated_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_CLICKABLE_INTERFACE_EVENT_REPEATED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EVAS_CLICKABLE_INTERFACE_EVENT_REPEATED );
   }

   template <typename T>
   void
   callback_repeated_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_CLICKABLE_INTERFACE_EVENT_REPEATED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_resize_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_RESIZE, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EVAS_OBJECT_EVENT_RESIZE );
   }

   template <typename T>
   void
   callback_resize_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_RESIZE, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_restack_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_RESTACK, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EVAS_OBJECT_EVENT_RESTACK );
   }

   template <typename T>
   void
   callback_restack_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_RESTACK, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_scroll_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_SCROLLABLE_INTERFACE_EVENT_SCROLL, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EVAS_SCROLLABLE_INTERFACE_EVENT_SCROLL );
   }

   template <typename T>
   void
   callback_scroll_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_SCROLLABLE_INTERFACE_EVENT_SCROLL, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_scroll_anim_start_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_SCROLLABLE_INTERFACE_EVENT_SCROLL_ANIM_START, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EVAS_SCROLLABLE_INTERFACE_EVENT_SCROLL_ANIM_START );
   }

   template <typename T>
   void
   callback_scroll_anim_start_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_SCROLLABLE_INTERFACE_EVENT_SCROLL_ANIM_START, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_scroll_anim_stop_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_SCROLLABLE_INTERFACE_EVENT_SCROLL_ANIM_STOP, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EVAS_SCROLLABLE_INTERFACE_EVENT_SCROLL_ANIM_STOP );
   }

   template <typename T>
   void
   callback_scroll_anim_stop_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_SCROLLABLE_INTERFACE_EVENT_SCROLL_ANIM_STOP, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_scroll_drag_start_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_SCROLLABLE_INTERFACE_EVENT_SCROLL_DRAG_START, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EVAS_SCROLLABLE_INTERFACE_EVENT_SCROLL_DRAG_START );
   }

   template <typename T>
   void
   callback_scroll_drag_start_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_SCROLLABLE_INTERFACE_EVENT_SCROLL_DRAG_START, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_scroll_drag_stop_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_SCROLLABLE_INTERFACE_EVENT_SCROLL_DRAG_STOP, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EVAS_SCROLLABLE_INTERFACE_EVENT_SCROLL_DRAG_STOP );
   }

   template <typename T>
   void
   callback_scroll_drag_stop_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_SCROLLABLE_INTERFACE_EVENT_SCROLL_DRAG_STOP, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_selected_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_SELECTABLE_INTERFACE_EVENT_SELECTED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EVAS_SELECTABLE_INTERFACE_EVENT_SELECTED );
   }

   template <typename T>
   void
   callback_selected_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_SELECTABLE_INTERFACE_EVENT_SELECTED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_selection_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_SELECTABLE_INTERFACE_EVENT_SELECTION_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EVAS_SELECTABLE_INTERFACE_EVENT_SELECTION_CHANGED );
   }

   template <typename T>
   void
   callback_selection_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_SELECTABLE_INTERFACE_EVENT_SELECTION_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_selection_cleared_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_SELECTABLE_INTERFACE_EVENT_SELECTION_CLEARED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EVAS_SELECTABLE_INTERFACE_EVENT_SELECTION_CLEARED );
   }

   template <typename T>
   void
   callback_selection_cleared_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_SELECTABLE_INTERFACE_EVENT_SELECTION_CLEARED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_selection_copy_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_SELECTABLE_INTERFACE_EVENT_SELECTION_COPY, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EVAS_SELECTABLE_INTERFACE_EVENT_SELECTION_COPY );
   }

   template <typename T>
   void
   callback_selection_copy_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_SELECTABLE_INTERFACE_EVENT_SELECTION_COPY, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_selection_cut_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_SELECTABLE_INTERFACE_EVENT_SELECTION_CUT, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EVAS_SELECTABLE_INTERFACE_EVENT_SELECTION_CUT );
   }

   template <typename T>
   void
   callback_selection_cut_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_SELECTABLE_INTERFACE_EVENT_SELECTION_CUT, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_selection_paste_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_SELECTABLE_INTERFACE_EVENT_SELECTION_PASTE, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EVAS_SELECTABLE_INTERFACE_EVENT_SELECTION_PASTE );
   }

   template <typename T>
   void
   callback_selection_paste_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_SELECTABLE_INTERFACE_EVENT_SELECTION_PASTE, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_selection_start_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_SELECTABLE_INTERFACE_EVENT_SELECTION_START, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EVAS_SELECTABLE_INTERFACE_EVENT_SELECTION_START );
   }

   template <typename T>
   void
   callback_selection_start_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_SELECTABLE_INTERFACE_EVENT_SELECTION_START, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_show_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_SHOW, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EVAS_OBJECT_EVENT_SHOW );
   }

   template <typename T>
   void
   callback_show_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_SHOW, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_state_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_STATE_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_STATE_CHANGED );
   }

   template <typename T>
   void
   callback_state_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_STATE_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_text_set_done_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ENTRY_EVENT_TEXT_SET_DONE, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_ENTRY_EVENT_TEXT_SET_DONE );
   }

   template <typename T>
   void
   callback_text_set_done_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ENTRY_EVENT_TEXT_SET_DONE, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_theme_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_LAYOUT_EVENT_THEME_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_LAYOUT_EVENT_THEME_CHANGED );
   }

   template <typename T>
   void
   callback_theme_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_LAYOUT_EVENT_THEME_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_undo_request_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ENTRY_EVENT_UNDO_REQUEST, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_ENTRY_EVENT_UNDO_REQUEST );
   }

   template <typename T>
   void
   callback_undo_request_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ENTRY_EVENT_UNDO_REQUEST, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_unfocused_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIDGET_EVENT_UNFOCUSED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_WIDGET_EVENT_UNFOCUSED );
   }

   template <typename T>
   void
   callback_unfocused_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIDGET_EVENT_UNFOCUSED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_unpressed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_CLICKABLE_INTERFACE_EVENT_UNPRESSED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EVAS_CLICKABLE_INTERFACE_EVENT_UNPRESSED );
   }

   template <typename T>
   void
   callback_unpressed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_CLICKABLE_INTERFACE_EVENT_UNPRESSED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_unselected_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_SELECTABLE_INTERFACE_EVENT_UNSELECTED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         EVAS_SELECTABLE_INTERFACE_EVENT_UNSELECTED );
   }

   template <typename T>
   void
   callback_unselected_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_SELECTABLE_INTERFACE_EVENT_UNSELECTED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_validate_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_ENTRY_EVENT_VALIDATE, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_ENTRY_EVENT_VALIDATE );
   }

   template <typename T>
   void
   callback_validate_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_ENTRY_EVENT_VALIDATE, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_visible_data_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_VISIBLE_DATA_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::entry, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::entry, function_type>,
         ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_VISIBLE_DATA_CHANGED );
   }

   template <typename T>
   void
   callback_visible_data_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_VISIBLE_DATA_CHANGED, info));
   }



   static Eo_Class const* _eo_class()
   {
      return(ELM_ENTRY_CLASS);
   }

   /// @cond LOCAL
   struct address_of
      : ::eo_cxx::elm::entry::address_of<address_of>
      , ::eo_cxx::efl::file::address_of<address_of>
      , ::eo_cxx::efl::gfx::base::address_of<address_of>
      , ::eo_cxx::efl::gfx::stack::address_of<address_of>
      , ::eo_cxx::elm::container::address_of<address_of>
      , ::eo_cxx::elm::layout::address_of<address_of>
      , ::eo_cxx::elm::widget::address_of<address_of>
      , ::eo_cxx::elm_interface_atspi_accessible::address_of<address_of>
      , ::eo_cxx::elm_interface_atspi_component::address_of<address_of>
      , ::eo_cxx::elm_interface_atspi_editable_text::address_of<address_of>
      , ::eo_cxx::elm_interface_atspi_text::address_of<address_of>
      , ::eo_cxx::elm_interface_scrollable::address_of<address_of>
      , ::eo_cxx::eo::base::address_of<address_of>
      , ::eo_cxx::evas::clickable_interface::address_of<address_of>
      , ::eo_cxx::evas::common_interface::address_of<address_of>
      , ::eo_cxx::evas::object::address_of<address_of>
      , ::eo_cxx::evas::object_smart::address_of<address_of>
      , ::eo_cxx::evas::scrollable_interface::address_of<address_of>
      , ::eo_cxx::evas::selectable_interface::address_of<address_of>
      , ::eo_cxx::evas::signal_interface::address_of<address_of>
      , ::efl::eo::detail::concrete_address_of
   {
      explicit address_of(::elm::entry* p)
         : ::efl::eo::detail::concrete_address_of(p)
      {}
   };
   address_of operator&() { return address_of(this); }

   struct address_const_of
      : ::eo_cxx::elm::entry::address_const_of<address_const_of>
      , ::eo_cxx::efl::file::address_const_of<address_const_of>
      , ::eo_cxx::efl::gfx::base::address_const_of<address_const_of>
      , ::eo_cxx::efl::gfx::stack::address_const_of<address_const_of>
      , ::eo_cxx::elm::container::address_const_of<address_const_of>
      , ::eo_cxx::elm::layout::address_const_of<address_const_of>
      , ::eo_cxx::elm::widget::address_const_of<address_const_of>
      , ::eo_cxx::elm_interface_atspi_accessible::address_const_of<address_const_of>
      , ::eo_cxx::elm_interface_atspi_component::address_const_of<address_const_of>
      , ::eo_cxx::elm_interface_atspi_editable_text::address_const_of<address_const_of>
      , ::eo_cxx::elm_interface_atspi_text::address_const_of<address_const_of>
      , ::eo_cxx::elm_interface_scrollable::address_const_of<address_const_of>
      , ::eo_cxx::eo::base::address_const_of<address_const_of>
      , ::eo_cxx::evas::clickable_interface::address_const_of<address_const_of>
      , ::eo_cxx::evas::common_interface::address_const_of<address_const_of>
      , ::eo_cxx::evas::object::address_const_of<address_const_of>
      , ::eo_cxx::evas::object_smart::address_const_of<address_const_of>
      , ::eo_cxx::evas::scrollable_interface::address_const_of<address_const_of>
      , ::eo_cxx::evas::selectable_interface::address_const_of<address_const_of>
      , ::eo_cxx::evas::signal_interface::address_const_of<address_const_of>
      , ::efl::eo::detail::concrete_address_const_of
   {
      explicit address_const_of(::elm::entry const* p)
         : ::efl::eo::detail::concrete_address_const_of(p)
      {}
   };
   address_const_of operator&() const { return address_const_of(this); }

   /// @endcond

private:

   /// @internal
   static Eo* _ctors_call(::efl::eo::parent_type _p)
   {
      Eo* _ret_eo = eo_add_ref(ELM_ENTRY_CLASS, _p._eo_raw);

      return _ret_eo;
   }

   /// @internal
   Eo* _concrete_eo_ptr() const { return _eo_ptr(); }
};

static_assert(sizeof(::elm::entry) == sizeof(Eo*), "");
static_assert(std::is_standard_layout<::elm::entry>::value, "");

}


#include "elm_entry.eo.impl.hh"

#endif // EFL_GENERATED_ELM_ENTRY_HH

