/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process;

import org.jfree.layouting.renderer.model.FinishedRenderNode;
import org.jfree.layouting.renderer.model.ParagraphRenderBox;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.model.table.TableRenderBox;
import org.jfree.layouting.renderer.model.table.TableRowRenderBox;
import org.jfree.layouting.renderer.process.IterateVisualProcessStep;

public class ComputeBreakabilityStep
extends IterateVisualProcessStep {
    public void compute(LogicalPageBox logicalPageBox) {
        this.startProcessing(logicalPageBox);
    }

    protected void processParagraphChilds(ParagraphRenderBox paragraphRenderBox) {
    }

    protected void finishBlockLevelBox(RenderBox renderBox) {
        RenderNode renderNode;
        if (renderBox instanceof ParagraphRenderBox) {
            ParagraphRenderBox paragraphRenderBox = (ParagraphRenderBox)renderBox;
            this.finishParagraph(paragraphRenderBox);
            return;
        }
        if (renderBox instanceof TableRenderBox) {
            TableRenderBox tableRenderBox = (TableRenderBox)renderBox;
            this.finishTable(tableRenderBox);
            return;
        }
        if (renderBox instanceof TableRowRenderBox) {
            TableRowRenderBox tableRowRenderBox = (TableRowRenderBox)renderBox;
            this.finishTableRow(tableRowRenderBox);
            return;
        }
        RenderNode renderNode2 = this.findNonFinishedVisibleFirst(renderBox);
        if (renderNode2 instanceof RenderBox) {
            renderNode = (RenderBox)renderNode2;
            renderBox.setOrphansSize(((RenderBox)renderNode).getOrphansSize());
        } else if (renderNode2 != null) {
            renderBox.setOrphansSize(renderNode2.getHeight());
        }
        renderNode = this.findNonFinishedVisibleLast(renderBox);
        if (renderNode instanceof RenderBox) {
            RenderNode renderNode3 = renderNode;
            renderBox.setWidowsSize(((RenderBox)renderNode3).getOrphansSize());
        } else if (renderNode != null) {
            renderBox.setWidowsSize(renderNode.getHeight());
        }
    }

    private RenderNode findNonFinishedVisibleFirst(RenderBox renderBox) {
        RenderNode renderNode = renderBox.getVisibleFirst();
        while (renderNode instanceof FinishedRenderNode) {
            renderNode = renderNode.getVisibleNext();
        }
        return renderNode;
    }

    private RenderNode findNonFinishedVisibleLast(RenderBox renderBox) {
        RenderNode renderNode = renderBox.getVisibleLast();
        while (renderNode instanceof FinishedRenderNode) {
            renderNode = renderNode.getVisiblePrev();
        }
        return renderNode;
    }

    private void finishTableRow(TableRowRenderBox tableRowRenderBox) {
        long l = 0L;
        long l2 = 0L;
        int n = 0;
        RenderNode renderNode = tableRowRenderBox.getVisibleFirst();
        while (renderNode != null) {
            if (!(renderNode instanceof RenderBox)) {
                renderNode = renderNode.getVisibleNext();
                continue;
            }
            RenderBox renderBox = (RenderBox)renderNode;
            l = Math.max(renderBox.getOrphansSize(), l);
            l2 = Math.max(renderBox.getWidowsSize(), l2);
            n = Math.max(renderBox.getLineCount(), n);
            renderNode = renderNode.getVisibleNext();
        }
        tableRowRenderBox.setOrphansSize(l);
        tableRowRenderBox.setWidowsSize(l2);
        tableRowRenderBox.setLineCount(n);
    }

    private void finishTable(TableRenderBox tableRenderBox) {
        RenderBox renderBox;
        RenderNode renderNode = tableRenderBox.getVisibleFirst();
        if (renderNode instanceof RenderBox) {
            renderBox = (RenderBox)renderNode;
            tableRenderBox.setOrphansSize(renderBox.getOrphansSize());
        } else {
            tableRenderBox.setOrphansSize(tableRenderBox.getHeight());
        }
        renderNode = tableRenderBox.getVisibleLast();
        if (renderNode instanceof RenderBox) {
            renderBox = (RenderBox)renderNode;
            tableRenderBox.setWidowsSize(renderBox.getWidowsSize());
        } else {
            tableRenderBox.setWidowsSize(tableRenderBox.getHeight());
        }
    }

    private void finishParagraph(ParagraphRenderBox paragraphRenderBox) {
        long l;
        RenderNode renderNode;
        int n = 0;
        for (renderNode = paragraphRenderBox.getVisibleFirst(); renderNode != null && ++n != paragraphRenderBox.getOrphans(); renderNode = renderNode.getVisibleNext()) {
        }
        if (renderNode == null) {
            paragraphRenderBox.setOrphansSize(paragraphRenderBox.getHeight());
        } else {
            l = renderNode.getY() + renderNode.getHeight();
            paragraphRenderBox.setOrphansSize(l - paragraphRenderBox.getY());
        }
        n = 0;
        for (renderNode = paragraphRenderBox.getVisibleLast(); renderNode != null && ++n != paragraphRenderBox.getWidows(); renderNode = renderNode.getVisiblePrev()) {
        }
        if (renderNode == null) {
            paragraphRenderBox.setWidowsSize(paragraphRenderBox.getHeight());
        } else {
            l = renderNode.getY() + renderNode.getHeight();
            long l2 = paragraphRenderBox.getY() + paragraphRenderBox.getHeight();
            paragraphRenderBox.setWidowsSize(l2 - l);
        }
    }
}

