

  {extends file="main.tpl"}
    <!DOCTYPE head PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"><head xmlns="http://www.w3.org/1999/xhtml">
  {block name=title}GPSBabel development:DeLorme XMat HH Street Atlas USA .WPT (PPC) (xmapwpt){/block}
  {block name=body}
                       
  <div xmlns="http://www.w3.org/1999/xhtml" class="navheader"><table width="100%" summary="Navigation header"><tr><th colspan="3" align="center">DeLorme XMat HH Street Atlas USA .WPT (PPC) (xmapwpt)</th></tr><tr><td width="20%" align="left"><a accesskey="p" href="fmt_xmap2006.html">Prev</a> </td><th width="60%" align="center">Chapter 3. The Formats</th><td width="20%" align="right"> <a accesskey="n" href="fmt_destinator_itn.html">Next</a></td></tr></table><hr /></div><div xmlns="http://www.w3.org/1999/xhtml" class="section"><div class="titlepage"><div><div><h2 class="title" ><a id="fmt_xmapwpt"></a>DeLorme XMat HH Street Atlas USA .WPT (PPC) (xmapwpt)</h2></div></div></div><p class="fmtcapshdr">
    This format can...
    </p><div class="itemizedlist"><ul class="itemizedlist" style="list-style-type: disc; "><li class="listitem"><p class="fmtcapsitem">
          read and write waypoints
        </p></li></ul></div><p>
This format is derived from the <a class="link" href="fmt_xcsv.html" title="? Character Separated Values (xcsv)">xcsv</a>
format, so it has all of the same options as that format.
</p><p>
Delorme XMapHandHeld Street Atlas USA is another of the
billion <a class="link" href="fmt_csv.html" title="Comma separated values (csv)"> CSV variants</a>.  
This is the format used by XmapHH SA USA on (at least) PocketPC O/S. 
</p><p> 
This XMap is not the same as the simpler 
<a class="link" href="fmt_xmap.html" title="DeLorme XMap HH Native .WPT (xmap)">XMap</a> format, which is used with Topo USA 4.0
and XMapHH for Palm. 
</p><p>
Delorme XMap Handheld .WPT for PocketPC is a bit of a kludge.  This 
chapter covers XMap Handheld Street Atlas USA edition.
</p><p>
XMap on the PocketPC stores its waypoints in individual .wpt files.
For example, waypoints generated by XMap on the PocketPC are stored
by default in the "My Documents" folder using the sequential names
"XMap1.wpt", "XMap2.wpt", ad nauseum.  Needless to say, this is not very
efficient.
</p><p>
As writing multiple waypoint files is outside of the scope of GPSBabel,
GPSBabel chooses to write one big file, one waypoint per line.  
Extracting lines from this file is left as an exercise for the end user.  
A simple Perl script to handle this conversion is included at the end 
of this chapter.
</p><p>
It should also be noted that <span class="emphasis"><em>reading</em></span> multiple files 
is indeed possible, but if you have more than a few points, it can be a task. 
For example:
</p><p><strong class="userinput"><code>gpsbabel -i xmapwpt -f Xmap1.wpt -f Xmap2.wpt -o mapsend -F mapsend.wpt</code></strong></p><p>
will read the two Xmap .wpt files and write one mapsend file.  This
is fine for a small handful of points, but could be quite cumbersome
for folks like me who have 100+ waypoints loaded into XMap.  For *nix
folks, something as simple as:
</p><p><strong class="userinput"><code>cat *.wpt &gt; /tmp/foo.wpt</code></strong>
<strong class="userinput"><code>gpsbabel -i xmapwpt -f foo.wpt -o mapsend -F mapsend.wpt </code></strong></p><p>
will do the trick just fine.  
</p><pre class="programlisting">
#!/full/path/to/perl
$INPUTFILE = @ARGV[0];
$TARGETDIR = @ARGV[1];
$FILENAME  = @ARGV[2];

if (! $FILENAME) {
    print "Usage: xmap_split.pl " . 
	"INPUT_FILE OUTPUT_DIRECTORY FILENAME_BASE\n";
    print " (i.e. xmapl_split.pl points.wpt /tmp/points GPSB)\n";
    print " (created GPSB0001-GPSBXXXX " .
	" in /tmp/points/ from points.wpt)\n";
    exit;
}

open (INFILE, $INPUTFILE) || die "Cannot open $INPUTFILE for read!\n";

while (&lt;INFILE&gt;) {
    $lc++;
    $filename = sprintf("%s/Gpsb%04d.wpt", $TARGETDIR, $lc);

    open (OUTFILE, "&gt;$filename") || 
	die "Cannot open $filename for write!\n";

    print OUTFILE $_;

    close(OUTFILE);
}

exit;

</pre><p>Contributed to GPSBabel by Alex Mottram.</p></div><div xmlns="http://www.w3.org/1999/xhtml" class="navfooter"><hr /><table width="100%" summary="Navigation footer"><tr><td width="40%" align="left"><a accesskey="p" href="fmt_xmap2006.html">Prev</a> </td><td width="20%" align="center"><a accesskey="u" href="The_Formats.html">Up</a></td><td width="40%" align="right"> <a accesskey="n" href="fmt_destinator_itn.html">Next</a></td></tr><tr><td width="40%" align="left" valign="top">DeLorme XMap/SAHH 2006 Native .TXT (xmap2006) </td><td width="20%" align="center"><a accesskey="h" href="index.html">Home</a></td><td width="40%" align="right" valign="top"> Destinator Itineraries (.dat) (destinator_itn)</td></tr></table></div>
  
      {/block}
  