/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Method;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Kit;

public class WrappedException
extends EvaluatorException {
    private static Method initCauseMethod = null;
    private Throwable exception;

    public WrappedException(Throwable exception) {
        super(exception.getMessage());
        this.exception = exception;
        if (initCauseMethod != null) {
            try {
                initCauseMethod.invoke((Object)this, exception);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    public String getMessage() {
        return "WrappedException of " + this.exception.toString();
    }

    public String getLocalizedMessage() {
        return "WrappedException of " + this.exception.getLocalizedMessage();
    }

    public Throwable getWrappedException() {
        return this.exception;
    }

    public Object unwrap() {
        return this.getWrappedException();
    }

    static {
        try {
            Class ThrowableClass = Kit.classOrNull("java.lang.Throwable");
            initCauseMethod = ThrowableClass.getMethod("initCause", ThrowableClass);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

