/*
 * Decompiled with CFR 0.152.
 */
package com.github.arara.utils;

import com.github.arara.exception.AraraException;
import com.github.arara.model.AraraDirective;
import com.github.arara.model.AraraTask;
import com.github.arara.utils.AraraLocalization;
import com.github.arara.utils.AraraMethods;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectiveParser {
    static final Logger logger = LoggerFactory.getLogger(DirectiveParser.class);
    private List<AraraDirective> directives;
    private List<AraraTask> tasks;
    private List<String> fileNames;
    private List<String> items;
    private File file;
    static final AraraLocalization localization = AraraLocalization.getInstance();

    public DirectiveParser() {
    }

    public DirectiveParser(List<AraraDirective> directives) {
        this.directives = directives;
        this.tasks = new ArrayList<AraraTask>();
        this.fileNames = new ArrayList<String>();
        this.items = new ArrayList<String>();
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setDirectives(List<AraraDirective> directives) {
        this.directives = directives;
    }

    public List<AraraTask> parse() throws AraraException {
        logger.info("Parsing directives.");
        for (AraraDirective currentDirective : this.directives) {
            this.fileNames.clear();
            String taskName = "";
            HashMap taskConfig = new HashMap();
            if (currentDirective.getConfig().isEmpty()) {
                taskName = currentDirective.getName();
            } else {
                String directiveName;
                Map currentConfig = currentDirective.getConfig();
                taskName = directiveName = (String)currentConfig.keySet().iterator().next();
                Object currentConfigParameters = currentConfig.get(directiveName);
                if (currentConfigParameters instanceof Map) {
                    Map currentParameters = (Map)currentConfigParameters;
                    if (currentParameters.isEmpty()) {
                        throw new AraraException(localization.getMessage("Error_DirectiveEmptyCurlyBrackets", directiveName, currentDirective.getLineNumber()));
                    }
                    for (Object currentParameterKey : currentParameters.keySet()) {
                        if (currentParameters.get(currentParameterKey) instanceof String) {
                            if (((String)currentParameterKey).equals("files")) {
                                throw new AraraException(localization.getMessage("Error_DirectiveInvalidArgumentList", directiveName, currentDirective.getLineNumber(), "files"));
                            }
                            if (((String)currentParameterKey).equals("items")) {
                                throw new AraraException(localization.getMessage("Error_DirectiveInvalidArgumentList", directiveName, currentDirective.getLineNumber(), "items"));
                            }
                            if (((String)currentParameterKey).equals("file")) {
                                throw new AraraException(localization.getMessage("Error_DirectiveReservedKeyword", directiveName, currentDirective.getLineNumber(), "file", "files"));
                            }
                            if (((String)currentParameterKey).equals("item")) {
                                throw new AraraException(localization.getMessage("Error_DirectiveReservedKeyword", directiveName, currentDirective.getLineNumber(), "item", "items"));
                            }
                            taskConfig.put(currentParameterKey, (String)currentParameters.get(currentParameterKey));
                            continue;
                        }
                        if (currentParameters.get(currentParameterKey) instanceof List) {
                            if (((String)currentParameterKey).equals("files")) {
                                for (Object currentListValue : (List)currentParameters.get(currentParameterKey)) {
                                    this.fileNames.add(currentListValue.toString());
                                }
                                continue;
                            }
                            if (((String)currentParameterKey).equals("items")) {
                                for (Object currentListValue : (List)currentParameters.get(currentParameterKey)) {
                                    this.items.add(currentListValue.toString());
                                }
                                continue;
                            }
                            throw new AraraException(localization.getMessage("Error_DirectiveListError", directiveName, currentDirective.getLineNumber()));
                        }
                        throw new AraraException(localization.getMessage("Error_DirectiveGenericError", directiveName, currentDirective.getLineNumber()));
                    }
                } else {
                    throw new AraraException(localization.getMessage("Error_DirectiveGenericError", directiveName, currentDirective.getLineNumber()));
                }
            }
            AraraMethods.setOriginalFile(this.file.getName());
            if (this.fileNames.isEmpty()) {
                this.fileNames.add(this.file.getName());
            }
            if (this.items.isEmpty()) {
                this.items.add("");
            }
            for (String filename : this.fileNames) {
                for (String item : this.items) {
                    AraraTask araraTask = new AraraTask();
                    araraTask.setName(taskName);
                    HashMap<String, String> currentTaskConfig = new HashMap<String, String>(taskConfig);
                    currentTaskConfig.put("file", filename);
                    currentTaskConfig.put("item", item);
                    araraTask.setParameters(currentTaskConfig);
                    this.tasks.add(araraTask);
                    araraTask = null;
                }
            }
            this.fileNames.clear();
            this.items.clear();
        }
        return this.tasks;
    }
}

