/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.optimizers.dynamic;

import org.mvel2.ParserContext;
import org.mvel2.compiler.Accessor;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.optimizers.AbstractOptimizer;
import org.mvel2.optimizers.AccessorOptimizer;
import org.mvel2.optimizers.OptimizerFactory;
import org.mvel2.optimizers.dynamic.DynamicClassLoader;
import org.mvel2.optimizers.dynamic.DynamicCollectionAccessor;
import org.mvel2.optimizers.dynamic.DynamicGetAccessor;
import org.mvel2.optimizers.dynamic.DynamicSetAccessor;
import org.mvel2.optimizers.impl.asm.ASMAccessorOptimizer;

public class DynamicOptimizer
extends AbstractOptimizer
implements AccessorOptimizer {
    private AccessorOptimizer firstStage = OptimizerFactory.getAccessorCompiler(OptimizerFactory.SAFE_REFLECTIVE);
    private static final Object oLock = new Object();
    private static volatile DynamicClassLoader classLoader;
    public static int tenuringThreshold;
    public static long timeSpan;
    public static int maximumTenure;
    public static int totalRecycled;
    private static volatile boolean useSafeClassloading;
    public static final int REGULAR_ACCESSOR = 0;
    public static final int SET_ACCESSOR = 1;
    public static final int COLLECTION = 2;
    public static final int OBJ_CREATION = 3;

    public void init() {
        DynamicOptimizer._init();
    }

    private static void _init() {
        classLoader = new DynamicClassLoader(Thread.currentThread().getContextClassLoader(), maximumTenure);
        ASMAccessorOptimizer.setMVELClassLoader(classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enforceTenureLimit() {
        if (classLoader.isOverloaded()) {
            Object object = oLock;
            synchronized (object) {
                classLoader.deoptimizeAll();
                totalRecycled = classLoader.getTotalClasses();
                DynamicOptimizer._init();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Accessor optimizeAccessor(ParserContext pCtx, char[] property, Object ctx, Object thisRef, VariableResolverFactory factory, boolean rootThisRef, Class ingressType) {
        Object object = oLock;
        synchronized (object) {
            return classLoader.registerDynamicAccessor(new DynamicGetAccessor(pCtx, property, 0, this.firstStage.optimizeAccessor(pCtx, property, ctx, thisRef, factory, rootThisRef, ingressType)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Accessor optimizeSetAccessor(ParserContext pCtx, char[] property, Object ctx, Object thisRef, VariableResolverFactory factory, boolean rootThisRef, Object value, Class valueType) {
        Object object = oLock;
        synchronized (object) {
            return classLoader.registerDynamicAccessor(new DynamicSetAccessor(pCtx, property, this.firstStage.optimizeSetAccessor(pCtx, property, ctx, thisRef, factory, rootThisRef, value, valueType)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Accessor optimizeCollection(ParserContext pCtx, Object rootObject, Class type, char[] property, Object ctx, Object thisRef, VariableResolverFactory factory) {
        Object object = oLock;
        synchronized (object) {
            return classLoader.registerDynamicAccessor(new DynamicCollectionAccessor(rootObject, type, property, 2, this.firstStage.optimizeCollection(pCtx, rootObject, type, property, ctx, thisRef, factory)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Accessor optimizeObjectCreation(ParserContext pCtx, char[] property, Object ctx, Object thisRef, VariableResolverFactory factory) {
        Object object = oLock;
        synchronized (object) {
            return classLoader.registerDynamicAccessor(new DynamicGetAccessor(pCtx, property, 3, this.firstStage.optimizeObjectCreation(pCtx, property, ctx, thisRef, factory)));
        }
    }

    public static boolean isOverloaded() {
        return classLoader.isOverloaded();
    }

    public Object getResultOptPass() {
        return this.firstStage.getResultOptPass();
    }

    public Class getEgressType() {
        return this.firstStage.getEgressType();
    }

    public boolean isLiteralOnly() {
        return this.firstStage.isLiteralOnly();
    }

    static {
        tenuringThreshold = 50;
        timeSpan = 100L;
        maximumTenure = 1500;
        totalRecycled = 0;
        useSafeClassloading = false;
    }
}

