# This file was automatically generated by SWIG (http://www.swig.org).
# Version 1.3.40
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.
# This file is compatible with both classic and new-style classes.

from sys import version_info
if version_info >= (2,6,0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_gdal', [dirname(__file__)])
        except ImportError:
            import _gdal
            return _gdal
        if fp is not None:
            try:
                _mod = imp.load_module('_gdal', fp, pathname, description)
            finally:
                fp.close()
            return _mod
    _gdal = swig_import_helper()
    del swig_import_helper
else:
    import _gdal
del version_info
try:
    _swig_property = property
except NameError:
    pass # Python < 2.2 doesn't have 'property'.
def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "thisown"): return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static) or hasattr(self,name):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    if (name == "thisown"): return self.this.own()
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError(name)

def _swig_repr(self):
    try: strthis = "proxy of " + self.this.__repr__()
    except: strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0


have_warned = 0
def deprecation_warn( module ):
  global have_warned

  if have_warned == 1:
      return

  have_warned = 1

  from warnings import warn
  warn('%s.py was placed in a namespace, it is now available as osgeo.%s' % (module,module),
       DeprecationWarning)
       
       
from gdalconst import *
import gdalconst


import sys
byteorders = {"little": "<",
              "big": ">"}
array_modes = { gdalconst.GDT_Int16:    ("%si2" % byteorders[sys.byteorder]),
                gdalconst.GDT_UInt16:   ("%su2" % byteorders[sys.byteorder]),
                gdalconst.GDT_Int32:    ("%si4" % byteorders[sys.byteorder]),
                gdalconst.GDT_UInt32:   ("%su4" % byteorders[sys.byteorder]),
                gdalconst.GDT_Float32:  ("%sf4" % byteorders[sys.byteorder]),
                gdalconst.GDT_Float64:  ("%sf8" % byteorders[sys.byteorder]),
                gdalconst.GDT_CFloat32: ("%sf4" % byteorders[sys.byteorder]),
                gdalconst.GDT_CFloat64: ("%sf8" % byteorders[sys.byteorder]),
                gdalconst.GDT_Byte:     ("%st8" % byteorders[sys.byteorder]),
}

def RGBFile2PCTFile( src_filename, dst_filename ):
  src_ds = Open(src_filename)
  if src_ds is None or src_ds == 'NULL':
      return 1

  ct = ColorTable()
  err = ComputeMedianCutPCT( src_ds.GetRasterBand(1),
                             src_ds.GetRasterBand(2),
                             src_ds.GetRasterBand(3),
                             256, ct )
  if err != 0:
      return err

  gtiff_driver = GetDriverByName('GTiff')
  if gtiff_driver is None:
      return 1

  dst_ds = gtiff_driver.Create( dst_filename,
                                src_ds.RasterXSize, src_ds.RasterYSize )
  dst_ds.GetRasterBand(1).SetRasterColorTable( ct )

  err = DitherRGB2PCT( src_ds.GetRasterBand(1),
                       src_ds.GetRasterBand(2),
                       src_ds.GetRasterBand(3),
                       dst_ds.GetRasterBand(1),
                       ct )
  dst_ds = None
  src_ds = None

  return 0


def GetUseExceptions(*args):
  """GetUseExceptions() -> int"""
  return _gdal.GetUseExceptions(*args)

def UseExceptions(*args):
  """UseExceptions()"""
  return _gdal.UseExceptions(*args)

def DontUseExceptions(*args):
  """DontUseExceptions()"""
  return _gdal.DontUseExceptions(*args)

def VSIFReadL(*args):
  """VSIFReadL(int nMembSize, int nMembCount, VSILFILE fp) -> int"""
  return _gdal.VSIFReadL(*args)

def Debug(*args):
  """Debug(char msg_class, char message)"""
  return _gdal.Debug(*args)

def SetErrorHandler(*args):
  """SetErrorHandler(char pszCallbackName = None) -> CPLErr"""
  return _gdal.SetErrorHandler(*args)

def PushErrorHandler(*args):
  """PushErrorHandler(CPLErrorHandler pfnErrorHandler = None) -> CPLErr"""
  return _gdal.PushErrorHandler(*args)

def PopErrorHandler(*args):
  """PopErrorHandler()"""
  return _gdal.PopErrorHandler(*args)

def Error(*args):
  """Error(CPLErr msg_class = CE_Failure, int err_code = 0, char msg = "error")"""
  return _gdal.Error(*args)

def GOA2GetAuthorizationURL(*args):
  """GOA2GetAuthorizationURL(char pszScope) -> retStringAndCPLFree"""
  return _gdal.GOA2GetAuthorizationURL(*args)

def GOA2GetRefreshToken(*args):
  """GOA2GetRefreshToken(char pszAuthToken, char pszScope) -> retStringAndCPLFree"""
  return _gdal.GOA2GetRefreshToken(*args)

def GOA2GetAccessToken(*args):
  """GOA2GetAccessToken(char pszRefreshToken, char pszScope) -> retStringAndCPLFree"""
  return _gdal.GOA2GetAccessToken(*args)

def ErrorReset(*args):
  """ErrorReset()"""
  return _gdal.ErrorReset(*args)

def EscapeString(*args, **kwargs):
  """EscapeString(int len, int scheme = CPLES_SQL) -> retStringAndCPLFree"""
  return _gdal.EscapeString(*args, **kwargs)

def GetLastErrorNo(*args):
  """GetLastErrorNo() -> int"""
  return _gdal.GetLastErrorNo(*args)

def GetLastErrorType(*args):
  """GetLastErrorType() -> int"""
  return _gdal.GetLastErrorType(*args)

def GetLastErrorMsg(*args):
  """GetLastErrorMsg() -> char"""
  return _gdal.GetLastErrorMsg(*args)

def PushFinderLocation(*args):
  """PushFinderLocation(char utf8_path)"""
  return _gdal.PushFinderLocation(*args)

def PopFinderLocation(*args):
  """PopFinderLocation()"""
  return _gdal.PopFinderLocation(*args)

def FinderClean(*args):
  """FinderClean()"""
  return _gdal.FinderClean(*args)

def FindFile(*args):
  """FindFile(char pszClass, char utf8_path) -> char"""
  return _gdal.FindFile(*args)

def ReadDir(*args):
  """ReadDir(char utf8_path) -> char"""
  return _gdal.ReadDir(*args)

def ReadDirRecursive(*args):
  """ReadDirRecursive(char utf8_path) -> char"""
  return _gdal.ReadDirRecursive(*args)

def SetConfigOption(*args):
  """SetConfigOption(char pszKey, char pszValue)"""
  return _gdal.SetConfigOption(*args)

def GetConfigOption(*args):
  """GetConfigOption(char pszKey, char pszDefault = None) -> char"""
  return _gdal.GetConfigOption(*args)

def CPLBinaryToHex(*args):
  """CPLBinaryToHex(int nBytes) -> retStringAndCPLFree"""
  return _gdal.CPLBinaryToHex(*args)

def CPLHexToBinary(*args):
  """CPLHexToBinary(char pszHex, int pnBytes) -> GByte"""
  return _gdal.CPLHexToBinary(*args)

def FileFromMemBuffer(*args):
  """FileFromMemBuffer(char utf8_path, int nBytes)"""
  return _gdal.FileFromMemBuffer(*args)

def Unlink(*args):
  """Unlink(char utf8_path) -> VSI_RETVAL"""
  return _gdal.Unlink(*args)

def HasThreadSupport(*args):
  """HasThreadSupport() -> int"""
  return _gdal.HasThreadSupport(*args)

def Mkdir(*args):
  """Mkdir(char utf8_path, int mode) -> VSI_RETVAL"""
  return _gdal.Mkdir(*args)

def Rmdir(*args):
  """Rmdir(char utf8_path) -> VSI_RETVAL"""
  return _gdal.Rmdir(*args)

def Rename(*args):
  """Rename(char pszOld, char pszNew) -> VSI_RETVAL"""
  return _gdal.Rename(*args)
VSI_STAT_EXISTS_FLAG = _gdal.VSI_STAT_EXISTS_FLAG
VSI_STAT_NATURE_FLAG = _gdal.VSI_STAT_NATURE_FLAG
VSI_STAT_SIZE_FLAG = _gdal.VSI_STAT_SIZE_FLAG
class StatBuf(_object):
    """Proxy of C++ StatBuf class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, StatBuf, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, StatBuf, name)
    __repr__ = _swig_repr
    __swig_getmethods__["mode"] = _gdal.StatBuf_mode_get
    if _newclass:mode = _swig_property(_gdal.StatBuf_mode_get)
    __swig_getmethods__["size"] = _gdal.StatBuf_size_get
    if _newclass:size = _swig_property(_gdal.StatBuf_size_get)
    __swig_getmethods__["mtime"] = _gdal.StatBuf_mtime_get
    if _newclass:mtime = _swig_property(_gdal.StatBuf_mtime_get)
    def __init__(self, *args): 
        """__init__(self, StatBuf psStatBuf) -> StatBuf"""
        this = _gdal.new_StatBuf(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _gdal.delete_StatBuf
    __del__ = lambda self : None;
    def IsDirectory(self, *args):
        """IsDirectory(self) -> int"""
        return _gdal.StatBuf_IsDirectory(self, *args)

StatBuf_swigregister = _gdal.StatBuf_swigregister
StatBuf_swigregister(StatBuf)


def VSIStatL(*args):
  """VSIStatL(char utf8_path, int nFlags = 0) -> int"""
  return _gdal.VSIStatL(*args)

def VSIFOpenL(*args):
  """VSIFOpenL(char utf8_path, char pszMode) -> VSILFILE"""
  return _gdal.VSIFOpenL(*args)

def VSIFCloseL(*args):
  """VSIFCloseL(VSILFILE arg0) -> VSI_RETVAL"""
  return _gdal.VSIFCloseL(*args)

def VSIFSeekL(*args):
  """VSIFSeekL(VSILFILE arg0, GIntBig arg1, int arg2) -> int"""
  return _gdal.VSIFSeekL(*args)

def VSIFTellL(*args):
  """VSIFTellL(VSILFILE arg0) -> GIntBig"""
  return _gdal.VSIFTellL(*args)

def VSIFTruncateL(*args):
  """VSIFTruncateL(VSILFILE arg0, GIntBig arg1) -> int"""
  return _gdal.VSIFTruncateL(*args)

def VSIFWriteL(*args):
  """VSIFWriteL(int nLen, int size, int memb, VSILFILE f) -> int"""
  return _gdal.VSIFWriteL(*args)
class MajorObject(_object):
    """Proxy of C++ GDALMajorObjectShadow class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, MajorObject, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, MajorObject, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    def GetDescription(self, *args):
        """GetDescription(self) -> char"""
        return _gdal.MajorObject_GetDescription(self, *args)

    def SetDescription(self, *args):
        """SetDescription(self, char pszNewDesc)"""
        return _gdal.MajorObject_SetDescription(self, *args)

    def GetMetadataDomainList(self, *args):
        """GetMetadataDomainList(self) -> char"""
        return _gdal.MajorObject_GetMetadataDomainList(self, *args)

    def GetMetadata_Dict(self, *args):
        """GetMetadata_Dict(self, char pszDomain = "") -> char"""
        return _gdal.MajorObject_GetMetadata_Dict(self, *args)

    def GetMetadata_List(self, *args):
        """GetMetadata_List(self, char pszDomain = "") -> char"""
        return _gdal.MajorObject_GetMetadata_List(self, *args)

    def SetMetadata(self, *args):
        """
        SetMetadata(self, char papszMetadata, char pszDomain = "") -> CPLErr
        SetMetadata(self, char pszMetadataString, char pszDomain = "") -> CPLErr
        """
        return _gdal.MajorObject_SetMetadata(self, *args)

    def GetMetadataItem(self, *args):
        """GetMetadataItem(self, char pszName, char pszDomain = "") -> char"""
        return _gdal.MajorObject_GetMetadataItem(self, *args)

    def SetMetadataItem(self, *args):
        """SetMetadataItem(self, char pszName, char pszValue, char pszDomain = "") -> CPLErr"""
        return _gdal.MajorObject_SetMetadataItem(self, *args)

    def GetMetadata( self, domain = '' ):
      if domain[:4] == 'xml:':
        return self.GetMetadata_List( domain )
      return self.GetMetadata_Dict( domain )

MajorObject_swigregister = _gdal.MajorObject_swigregister
MajorObject_swigregister(MajorObject)

class Driver(MajorObject):
    """Proxy of C++ GDALDriverShadow class"""
    __swig_setmethods__ = {}
    for _s in [MajorObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Driver, name, value)
    __swig_getmethods__ = {}
    for _s in [MajorObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, Driver, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_getmethods__["ShortName"] = _gdal.Driver_ShortName_get
    if _newclass:ShortName = _swig_property(_gdal.Driver_ShortName_get)
    __swig_getmethods__["LongName"] = _gdal.Driver_LongName_get
    if _newclass:LongName = _swig_property(_gdal.Driver_LongName_get)
    __swig_getmethods__["HelpTopic"] = _gdal.Driver_HelpTopic_get
    if _newclass:HelpTopic = _swig_property(_gdal.Driver_HelpTopic_get)
    def Create(self, *args, **kwargs):
        """
        Create(self, char utf8_path, int xsize, int ysize, int bands = 1, 
            GDALDataType eType = GDT_Byte, char options = None) -> Dataset
        """
        return _gdal.Driver_Create(self, *args, **kwargs)

    def CreateCopy(self, *args, **kwargs):
        """
        CreateCopy(self, char utf8_path, Dataset src, int strict = 1, char options = None, 
            GDALProgressFunc callback = None, 
            void callback_data = None) -> Dataset
        """
        return _gdal.Driver_CreateCopy(self, *args, **kwargs)

    def Delete(self, *args):
        """Delete(self, char utf8_path) -> CPLErr"""
        return _gdal.Driver_Delete(self, *args)

    def Rename(self, *args):
        """Rename(self, char newName, char oldName) -> CPLErr"""
        return _gdal.Driver_Rename(self, *args)

    def CopyFiles(self, *args):
        """CopyFiles(self, char newName, char oldName) -> CPLErr"""
        return _gdal.Driver_CopyFiles(self, *args)

    def Register(self, *args):
        """Register(self) -> int"""
        return _gdal.Driver_Register(self, *args)

    def Deregister(self, *args):
        """Deregister(self)"""
        return _gdal.Driver_Deregister(self, *args)

Driver_swigregister = _gdal.Driver_swigregister
Driver_swigregister(Driver)

import ogr
import osr
class ColorEntry(_object):
    """Proxy of C++ GDALColorEntry class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ColorEntry, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ColorEntry, name)
    __repr__ = _swig_repr
    __swig_setmethods__["c1"] = _gdal.ColorEntry_c1_set
    __swig_getmethods__["c1"] = _gdal.ColorEntry_c1_get
    if _newclass:c1 = _swig_property(_gdal.ColorEntry_c1_get, _gdal.ColorEntry_c1_set)
    __swig_setmethods__["c2"] = _gdal.ColorEntry_c2_set
    __swig_getmethods__["c2"] = _gdal.ColorEntry_c2_get
    if _newclass:c2 = _swig_property(_gdal.ColorEntry_c2_get, _gdal.ColorEntry_c2_set)
    __swig_setmethods__["c3"] = _gdal.ColorEntry_c3_set
    __swig_getmethods__["c3"] = _gdal.ColorEntry_c3_get
    if _newclass:c3 = _swig_property(_gdal.ColorEntry_c3_get, _gdal.ColorEntry_c3_set)
    __swig_setmethods__["c4"] = _gdal.ColorEntry_c4_set
    __swig_getmethods__["c4"] = _gdal.ColorEntry_c4_get
    if _newclass:c4 = _swig_property(_gdal.ColorEntry_c4_get, _gdal.ColorEntry_c4_set)
    def __init__(self, *args): 
        """__init__(self) -> ColorEntry"""
        this = _gdal.new_ColorEntry(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _gdal.delete_ColorEntry
    __del__ = lambda self : None;
ColorEntry_swigregister = _gdal.ColorEntry_swigregister
ColorEntry_swigregister(ColorEntry)

class GCP(_object):
    """Proxy of C++ GDAL_GCP class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, GCP, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, GCP, name)
    __repr__ = _swig_repr
    __swig_setmethods__["GCPX"] = _gdal.GCP_GCPX_set
    __swig_getmethods__["GCPX"] = _gdal.GCP_GCPX_get
    if _newclass:GCPX = _swig_property(_gdal.GCP_GCPX_get, _gdal.GCP_GCPX_set)
    __swig_setmethods__["GCPY"] = _gdal.GCP_GCPY_set
    __swig_getmethods__["GCPY"] = _gdal.GCP_GCPY_get
    if _newclass:GCPY = _swig_property(_gdal.GCP_GCPY_get, _gdal.GCP_GCPY_set)
    __swig_setmethods__["GCPZ"] = _gdal.GCP_GCPZ_set
    __swig_getmethods__["GCPZ"] = _gdal.GCP_GCPZ_get
    if _newclass:GCPZ = _swig_property(_gdal.GCP_GCPZ_get, _gdal.GCP_GCPZ_set)
    __swig_setmethods__["GCPPixel"] = _gdal.GCP_GCPPixel_set
    __swig_getmethods__["GCPPixel"] = _gdal.GCP_GCPPixel_get
    if _newclass:GCPPixel = _swig_property(_gdal.GCP_GCPPixel_get, _gdal.GCP_GCPPixel_set)
    __swig_setmethods__["GCPLine"] = _gdal.GCP_GCPLine_set
    __swig_getmethods__["GCPLine"] = _gdal.GCP_GCPLine_get
    if _newclass:GCPLine = _swig_property(_gdal.GCP_GCPLine_get, _gdal.GCP_GCPLine_set)
    __swig_setmethods__["Info"] = _gdal.GCP_Info_set
    __swig_getmethods__["Info"] = _gdal.GCP_Info_get
    if _newclass:Info = _swig_property(_gdal.GCP_Info_get, _gdal.GCP_Info_set)
    __swig_setmethods__["Id"] = _gdal.GCP_Id_set
    __swig_getmethods__["Id"] = _gdal.GCP_Id_get
    if _newclass:Id = _swig_property(_gdal.GCP_Id_get, _gdal.GCP_Id_set)
    def __init__(self, *args): 
        """
        __init__(self, double x = 0.0, double y = 0.0, double z = 0.0, double pixel = 0.0, 
            double line = 0.0, char info = "", 
            char id = "") -> GCP
        """
        this = _gdal.new_GCP(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _gdal.delete_GCP
    __del__ = lambda self : None;
    def __str__(self):
      str = '%s (%.2fP,%.2fL) -> (%.7fE,%.7fN,%.2f) %s '\
            % (self.Id, self.GCPPixel, self.GCPLine,
               self.GCPX, self.GCPY, self.GCPZ, self.Info )
      return str

    def serialize(self,with_Z=0):
      base = [CXT_Element,'GCP']
      base.append([CXT_Attribute,'Id',[CXT_Text,self.Id]])
      pixval = '%0.15E' % self.GCPPixel       
      lineval = '%0.15E' % self.GCPLine
      xval = '%0.15E' % self.GCPX
      yval = '%0.15E' % self.GCPY
      zval = '%0.15E' % self.GCPZ
      base.append([CXT_Attribute,'Pixel',[CXT_Text,pixval]])
      base.append([CXT_Attribute,'Line',[CXT_Text,lineval]])
      base.append([CXT_Attribute,'X',[CXT_Text,xval]])
      base.append([CXT_Attribute,'Y',[CXT_Text,yval]])
      if with_Z:
          base.append([CXT_Attribute,'Z',[CXT_Text,zval]])        
      return base

GCP_swigregister = _gdal.GCP_swigregister
GCP_swigregister(GCP)


def GDAL_GCP_GCPX_get(*args):
  """GDAL_GCP_GCPX_get(GCP gcp) -> double"""
  return _gdal.GDAL_GCP_GCPX_get(*args)

def GDAL_GCP_GCPX_set(*args):
  """GDAL_GCP_GCPX_set(GCP gcp, double dfGCPX)"""
  return _gdal.GDAL_GCP_GCPX_set(*args)

def GDAL_GCP_GCPY_get(*args):
  """GDAL_GCP_GCPY_get(GCP gcp) -> double"""
  return _gdal.GDAL_GCP_GCPY_get(*args)

def GDAL_GCP_GCPY_set(*args):
  """GDAL_GCP_GCPY_set(GCP gcp, double dfGCPY)"""
  return _gdal.GDAL_GCP_GCPY_set(*args)

def GDAL_GCP_GCPZ_get(*args):
  """GDAL_GCP_GCPZ_get(GCP gcp) -> double"""
  return _gdal.GDAL_GCP_GCPZ_get(*args)

def GDAL_GCP_GCPZ_set(*args):
  """GDAL_GCP_GCPZ_set(GCP gcp, double dfGCPZ)"""
  return _gdal.GDAL_GCP_GCPZ_set(*args)

def GDAL_GCP_GCPPixel_get(*args):
  """GDAL_GCP_GCPPixel_get(GCP gcp) -> double"""
  return _gdal.GDAL_GCP_GCPPixel_get(*args)

def GDAL_GCP_GCPPixel_set(*args):
  """GDAL_GCP_GCPPixel_set(GCP gcp, double dfGCPPixel)"""
  return _gdal.GDAL_GCP_GCPPixel_set(*args)

def GDAL_GCP_GCPLine_get(*args):
  """GDAL_GCP_GCPLine_get(GCP gcp) -> double"""
  return _gdal.GDAL_GCP_GCPLine_get(*args)

def GDAL_GCP_GCPLine_set(*args):
  """GDAL_GCP_GCPLine_set(GCP gcp, double dfGCPLine)"""
  return _gdal.GDAL_GCP_GCPLine_set(*args)

def GDAL_GCP_Info_get(*args):
  """GDAL_GCP_Info_get(GCP gcp) -> char"""
  return _gdal.GDAL_GCP_Info_get(*args)

def GDAL_GCP_Info_set(*args):
  """GDAL_GCP_Info_set(GCP gcp, char pszInfo)"""
  return _gdal.GDAL_GCP_Info_set(*args)

def GDAL_GCP_Id_get(*args):
  """GDAL_GCP_Id_get(GCP gcp) -> char"""
  return _gdal.GDAL_GCP_Id_get(*args)

def GDAL_GCP_Id_set(*args):
  """GDAL_GCP_Id_set(GCP gcp, char pszId)"""
  return _gdal.GDAL_GCP_Id_set(*args)

def GCPsToGeoTransform(*args):
  """GCPsToGeoTransform(int nGCPs, int bApproxOK = 1) -> RETURN_NONE"""
  return _gdal.GCPsToGeoTransform(*args)
class VirtualMem(_object):
    """Proxy of C++ CPLVirtualMemShadow class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, VirtualMem, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, VirtualMem, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdal.delete_VirtualMem
    __del__ = lambda self : None;
    def GetAddr(self, *args):
        """GetAddr(self)"""
        return _gdal.VirtualMem_GetAddr(self, *args)

    def Pin(self, *args):
        """Pin(self, size_t start_offset = 0, size_t nsize = 0, int bWriteOp = 0)"""
        return _gdal.VirtualMem_Pin(self, *args)

VirtualMem_swigregister = _gdal.VirtualMem_swigregister
VirtualMem_swigregister(VirtualMem)

class AsyncReader(_object):
    """Proxy of C++ GDALAsyncReaderShadow class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, AsyncReader, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, AsyncReader, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _gdal.delete_AsyncReader
    __del__ = lambda self : None;
    def GetNextUpdatedRegion(self, *args):
        """GetNextUpdatedRegion(self, double timeout) -> GDALAsyncStatusType"""
        return _gdal.AsyncReader_GetNextUpdatedRegion(self, *args)

    def GetBuffer(self, *args):
        """GetBuffer(self)"""
        return _gdal.AsyncReader_GetBuffer(self, *args)

    def LockBuffer(self, *args):
        """LockBuffer(self, double timeout) -> int"""
        return _gdal.AsyncReader_LockBuffer(self, *args)

    def UnlockBuffer(self, *args):
        """UnlockBuffer(self)"""
        return _gdal.AsyncReader_UnlockBuffer(self, *args)

AsyncReader_swigregister = _gdal.AsyncReader_swigregister
AsyncReader_swigregister(AsyncReader)

class Dataset(MajorObject):
    """Proxy of C++ GDALDatasetShadow class"""
    __swig_setmethods__ = {}
    for _s in [MajorObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Dataset, name, value)
    __swig_getmethods__ = {}
    for _s in [MajorObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, Dataset, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_getmethods__["RasterXSize"] = _gdal.Dataset_RasterXSize_get
    if _newclass:RasterXSize = _swig_property(_gdal.Dataset_RasterXSize_get)
    __swig_getmethods__["RasterYSize"] = _gdal.Dataset_RasterYSize_get
    if _newclass:RasterYSize = _swig_property(_gdal.Dataset_RasterYSize_get)
    __swig_getmethods__["RasterCount"] = _gdal.Dataset_RasterCount_get
    if _newclass:RasterCount = _swig_property(_gdal.Dataset_RasterCount_get)
    __swig_destroy__ = _gdal.delete_Dataset
    __del__ = lambda self : None;
    def GetDriver(self, *args):
        """GetDriver(self) -> Driver"""
        return _gdal.Dataset_GetDriver(self, *args)

    def GetRasterBand(self, *args):
        """GetRasterBand(self, int nBand) -> Band"""
        return _gdal.Dataset_GetRasterBand(self, *args)

    def GetProjection(self, *args):
        """GetProjection(self) -> char"""
        return _gdal.Dataset_GetProjection(self, *args)

    def GetProjectionRef(self, *args):
        """GetProjectionRef(self) -> char"""
        return _gdal.Dataset_GetProjectionRef(self, *args)

    def SetProjection(self, *args):
        """SetProjection(self, char prj) -> CPLErr"""
        return _gdal.Dataset_SetProjection(self, *args)

    def GetGeoTransform(self, *args, **kwargs):
        """GetGeoTransform(self, int can_return_null = None)"""
        return _gdal.Dataset_GetGeoTransform(self, *args, **kwargs)

    def SetGeoTransform(self, *args):
        """SetGeoTransform(self, double argin) -> CPLErr"""
        return _gdal.Dataset_SetGeoTransform(self, *args)

    def BuildOverviews(self, *args, **kwargs):
        """
        BuildOverviews(self, char resampling = "NEAREST", int overviewlist = 0, 
            GDALProgressFunc callback = None, void callback_data = None) -> int
        """
        return _gdal.Dataset_BuildOverviews(self, *args, **kwargs)

    def GetGCPCount(self, *args):
        """GetGCPCount(self) -> int"""
        return _gdal.Dataset_GetGCPCount(self, *args)

    def GetGCPProjection(self, *args):
        """GetGCPProjection(self) -> char"""
        return _gdal.Dataset_GetGCPProjection(self, *args)

    def GetGCPs(self, *args):
        """GetGCPs(self)"""
        return _gdal.Dataset_GetGCPs(self, *args)

    def SetGCPs(self, *args):
        """SetGCPs(self, int nGCPs, char pszGCPProjection) -> CPLErr"""
        return _gdal.Dataset_SetGCPs(self, *args)

    def FlushCache(self, *args):
        """FlushCache(self)"""
        return _gdal.Dataset_FlushCache(self, *args)

    def AddBand(self, *args, **kwargs):
        """AddBand(self, GDALDataType datatype = GDT_Byte, char options = None) -> CPLErr"""
        return _gdal.Dataset_AddBand(self, *args, **kwargs)

    def CreateMaskBand(self, *args):
        """CreateMaskBand(self, int nFlags) -> CPLErr"""
        return _gdal.Dataset_CreateMaskBand(self, *args)

    def GetFileList(self, *args):
        """GetFileList(self) -> char"""
        return _gdal.Dataset_GetFileList(self, *args)

    def WriteRaster(self, *args, **kwargs):
        """
        WriteRaster(self, int xoff, int yoff, int xsize, int ysize, GIntBig buf_len, 
            int buf_xsize = None, int buf_ysize = None, 
            GDALDataType buf_type = None, int band_list = 0, 
            int buf_pixel_space = None, int buf_line_space = None, 
            int buf_band_space = None) -> CPLErr
        """
        return _gdal.Dataset_WriteRaster(self, *args, **kwargs)

    def BeginAsyncReader(self, *args, **kwargs):
        """
        BeginAsyncReader(self, int xOff, int yOff, int xSize, int ySize, int buf_len, 
            int buf_xsize, int buf_ysize, GDALDataType bufType = (GDALDataType) 0, 
            int band_list = 0, 
            int nPixelSpace = 0, int nLineSpace = 0, 
            int nBandSpace = 0, char options = None) -> AsyncReader
        """
        return _gdal.Dataset_BeginAsyncReader(self, *args, **kwargs)

    def EndAsyncReader(self, *args):
        """EndAsyncReader(self, AsyncReader ario)"""
        return _gdal.Dataset_EndAsyncReader(self, *args)

    def GetVirtualMem(self, *args, **kwargs):
        """
        GetVirtualMem(self, GDALRWFlag eRWFlag, int nXOff, int nYOff, int nXSize, 
            int nYSize, int nBufXSize, int nBufYSize, 
            GDALDataType eBufType, int band_list, int bIsBandSequential, 
            size_t nCacheSize, size_t nPageSizeHint, 
            char options = None) -> VirtualMem
        """
        return _gdal.Dataset_GetVirtualMem(self, *args, **kwargs)

    def GetTiledVirtualMem(self, *args, **kwargs):
        """
        GetTiledVirtualMem(self, GDALRWFlag eRWFlag, int nXOff, int nYOff, int nXSize, 
            int nYSize, int nTileXSize, int nTileYSize, 
            GDALDataType eBufType, int band_list, GDALTileOrganization eTileOrganization, 
            size_t nCacheSize, 
            char options = None) -> VirtualMem
        """
        return _gdal.Dataset_GetTiledVirtualMem(self, *args, **kwargs)

    def CreateLayer(self, *args, **kwargs):
        """
        CreateLayer(self, char name, SpatialReference srs = None, OGRwkbGeometryType geom_type = wkbUnknown, 
            char options = None) -> Layer
        """
        return _gdal.Dataset_CreateLayer(self, *args, **kwargs)

    def CopyLayer(self, *args, **kwargs):
        """CopyLayer(self, Layer src_layer, char new_name, char options = None) -> Layer"""
        return _gdal.Dataset_CopyLayer(self, *args, **kwargs)

    def DeleteLayer(self, *args):
        """DeleteLayer(self, int index) -> OGRErr"""
        return _gdal.Dataset_DeleteLayer(self, *args)

    def GetLayerCount(self, *args):
        """GetLayerCount(self) -> int"""
        return _gdal.Dataset_GetLayerCount(self, *args)

    def GetLayerByIndex(self, *args):
        """GetLayerByIndex(self, int index = 0) -> Layer"""
        return _gdal.Dataset_GetLayerByIndex(self, *args)

    def GetLayerByName(self, *args):
        """GetLayerByName(self, char layer_name) -> Layer"""
        return _gdal.Dataset_GetLayerByName(self, *args)

    def TestCapability(self, *args):
        """TestCapability(self, char cap) -> bool"""
        return _gdal.Dataset_TestCapability(self, *args)

    def ExecuteSQL(self, *args, **kwargs):
        """ExecuteSQL(self, char statement, Geometry spatialFilter = None, char dialect = "") -> Layer"""
        return _gdal.Dataset_ExecuteSQL(self, *args, **kwargs)

    def ReleaseResultSet(self, *args):
        """ReleaseResultSet(self, Layer layer)"""
        return _gdal.Dataset_ReleaseResultSet(self, *args)

    def GetStyleTable(self, *args):
        """GetStyleTable(self) -> StyleTable"""
        return _gdal.Dataset_GetStyleTable(self, *args)

    def SetStyleTable(self, *args):
        """SetStyleTable(self, StyleTable table)"""
        return _gdal.Dataset_SetStyleTable(self, *args)

    def StartTransaction(self, *args, **kwargs):
        """StartTransaction(self, int force = True) -> OGRErr"""
        return _gdal.Dataset_StartTransaction(self, *args, **kwargs)

    def CommitTransaction(self, *args):
        """CommitTransaction(self) -> OGRErr"""
        return _gdal.Dataset_CommitTransaction(self, *args)

    def RollbackTransaction(self, *args):
        """RollbackTransaction(self) -> OGRErr"""
        return _gdal.Dataset_RollbackTransaction(self, *args)

    def ReadRaster1(self, *args, **kwargs):
        """
        ReadRaster1(self, int xoff, int yoff, int xsize, int ysize, int buf_xsize = None, 
            int buf_ysize = None, GDALDataType buf_type = None, 
            int band_list = 0, GIntBig buf_pixel_space = None, 
            GIntBig buf_line_space = None, 
            GIntBig buf_band_space = None, GDALRIOResampleAlg resample_alg = GRIORA_NearestNeighbour, 
            GDALProgressFunc callback = None, 
            void callback_data = None) -> CPLErr
        """
        return _gdal.Dataset_ReadRaster1(self, *args, **kwargs)

    def ReadAsArray(self, xoff=0, yoff=0, xsize=None, ysize=None, buf_obj=None,
                    buf_xsize = None, buf_ysize = None, buf_type = None,
                    resample_alg = GRIORA_NearestNeighbour,
                    callback = None,
                    callback_data = None):
        """ Reading a chunk of a GDAL band into a numpy array. The optional (buf_xsize,buf_ysize,buf_type)
        parameters should generally not be specified if buf_obj is specified. The array is returned"""

        import gdalnumeric
        return gdalnumeric.DatasetReadAsArray( self, xoff, yoff, xsize, ysize, buf_obj,
                                               buf_xsize, buf_ysize, buf_type,
                                               resample_alg = resample_alg,
                                               callback = callback,
                                               callback_data = callback_data )

    def WriteRaster(self, xoff, yoff, xsize, ysize,
                    buf_string,
                    buf_xsize = None, buf_ysize = None, buf_type = None,
                    band_list = None,
                    buf_pixel_space = None, buf_line_space = None, buf_band_space = None ):

        if buf_xsize is None:
            buf_xsize = xsize;
        if buf_ysize is None:
            buf_ysize = ysize;
        if band_list is None:
            band_list = range(1,self.RasterCount+1)
        if buf_type is None:
            buf_type = self.GetRasterBand(1).DataType

        return _gdal.Dataset_WriteRaster(self,
                 xoff, yoff, xsize, ysize,
                buf_string, buf_xsize, buf_ysize, buf_type, band_list,
                buf_pixel_space, buf_line_space, buf_band_space )

    def ReadRaster(self, xoff = 0, yoff = 0, xsize = None, ysize = None,
                   buf_xsize = None, buf_ysize = None, buf_type = None,
                   band_list = None,
                   buf_pixel_space = None, buf_line_space = None, buf_band_space = None,
                   resample_alg = GRIORA_NearestNeighbour,
                   callback = None,
                   callback_data = None):

        if xsize is None:
            xsize = self.RasterXSize
        if ysize is None:
            ysize = self.RasterYSize
        if band_list is None:
            band_list = range(1,self.RasterCount+1)
        if buf_xsize is None:
            buf_xsize = xsize;
        if buf_ysize is None:
            buf_ysize = ysize;

        if buf_type is None:
            buf_type = self.GetRasterBand(1).DataType;

        return _gdal.Dataset_ReadRaster1(self, xoff, yoff, xsize, ysize,
                                            buf_xsize, buf_ysize, buf_type,
                                            band_list, buf_pixel_space, buf_line_space, buf_band_space,
                                          resample_alg, callback, callback_data )

    def GetVirtualMemArray(self, eAccess = gdalconst.GF_Read, xoff=0, yoff=0,
                           xsize=None, ysize=None, bufxsize=None, bufysize=None,
                           datatype = None, band_list = None, band_sequential = True,
                           cache_size = 10 * 1024 * 1024, page_size_hint = 0,
                           options = None):
        """Return a NumPy array for the dataset, seen as a virtual memory mapping.
           If there are several bands and band_sequential = True, an element is
           accessed with array[band][y][x].
           If there are several bands and band_sequential = False, an element is
           accessed with array[y][x][band].
           If there is only one band, an element is accessed with array[y][x].
           Any reference to the array must be dropped before the last reference to the
           related dataset is also dropped.
        """
        import gdalnumeric
        if xsize is None:
            xsize = self.RasterXSize
        if ysize is None:
            ysize = self.RasterYSize
        if bufxsize is None:
            bufxsize = self.RasterXSize
        if bufysize is None:
            bufysize = self.RasterYSize
        if datatype is None:
            datatype = self.GetRasterBand(1).DataType
        if band_list is None:
            band_list = range(1,self.RasterCount+1)
        if options is None:
            virtualmem = self.GetVirtualMem(eAccess,xoff,yoff,xsize,ysize,bufxsize,bufysize,datatype,band_list,band_sequential,cache_size,page_size_hint)
        else:
            virtualmem = self.GetVirtualMem(eAccess,xoff,yoff,xsize,ysize,bufxsize,bufysize,datatype,band_list,band_sequential,cache_size,page_size_hint, options)
        return gdalnumeric.VirtualMemGetArray( virtualmem )

    def GetTiledVirtualMemArray(self, eAccess = gdalconst.GF_Read, xoff=0, yoff=0,
                           xsize=None, ysize=None, tilexsize=256, tileysize=256,
                           datatype = None, band_list = None, tile_organization = gdalconst.GTO_BSQ,
                           cache_size = 10 * 1024 * 1024, options = None):
        """Return a NumPy array for the dataset, seen as a virtual memory mapping with
           a tile organization.
           If there are several bands and tile_organization = gdal.GTO_TIP, an element is
           accessed with array[tiley][tilex][y][x][band].
           If there are several bands and tile_organization = gdal.GTO_BIT, an element is
           accessed with array[tiley][tilex][band][y][x].
           If there are several bands and tile_organization = gdal.GTO_BSQ, an element is
           accessed with array[band][tiley][tilex][y][x].
           If there is only one band, an element is accessed with array[tiley][tilex][y][x].
           Any reference to the array must be dropped before the last reference to the
           related dataset is also dropped.
        """
        import gdalnumeric
        if xsize is None:
            xsize = self.RasterXSize
        if ysize is None:
            ysize = self.RasterYSize
        if datatype is None:
            datatype = self.GetRasterBand(1).DataType
        if band_list is None:
            band_list = range(1,self.RasterCount+1)
        if options is None:
            virtualmem = self.GetTiledVirtualMem(eAccess,xoff,yoff,xsize,ysize,tilexsize,tileysize,datatype,band_list,tile_organization,cache_size)
        else:
            virtualmem = self.GetTiledVirtualMem(eAccess,xoff,yoff,xsize,ysize,tilexsize,tileysize,datatype,band_list,tile_organization,cache_size, options)
        return gdalnumeric.VirtualMemGetArray( virtualmem )

    def GetSubDatasets(self):
        sd_list = []
        
        sd = self.GetMetadata('SUBDATASETS')
        if sd is None:
            return sd_list

        i = 1
        while 'SUBDATASET_'+str(i)+'_NAME' in sd:
            sd_list.append( ( sd['SUBDATASET_'+str(i)+'_NAME'],
                              sd['SUBDATASET_'+str(i)+'_DESC'] ) )
            i = i + 1
        return sd_list

    def BeginAsyncReader(self, xoff, yoff, xsize, ysize, buf_obj = None, buf_xsize = None, buf_ysize = None, buf_type = None, band_list = None, options=[]):
        if band_list is None:
            band_list = range(1, self.RasterCount + 1)
        if buf_xsize is None:
            buf_xsize = 0;
        if buf_ysize is None:
            buf_ysize = 0;
        if buf_type is None:
            buf_type = GDT_Byte

        if buf_xsize <= 0:
            buf_xsize = xsize
        if buf_ysize <= 0:
            buf_ysize = ysize

        if buf_obj is None:
            from sys import version_info
            nRequiredSize = int(buf_xsize * buf_ysize * len(band_list) * (_gdal.GetDataTypeSize(buf_type) / 8))
            if version_info >= (3,0,0):
                buf_obj_ar = [ None ]
                exec("buf_obj_ar[0] = b' ' * nRequiredSize")
                buf_obj = buf_obj_ar[0]
            else:
                buf_obj = ' ' * nRequiredSize
        return _gdal.Dataset_BeginAsyncReader(self, xoff, yoff, xsize, ysize, buf_obj, buf_xsize, buf_ysize, buf_type, band_list,  0, 0, 0, options)

    def GetLayer(self,iLayer=0):
        """Return the layer given an index or a name"""
        if isinstance(iLayer, str):
            return self.GetLayerByName(str(iLayer))
        elif isinstance(iLayer, int):
            return self.GetLayerByIndex(iLayer)
        else:
            raise TypeError("Input %s is not of String or Int type" % type(iLayer))

    def DeleteLayer(self, value):
        """Deletes the layer given an index or layer name"""
        if isinstance(value, str):
            for i in range(self.GetLayerCount()):
                name = self.GetLayer(i).GetName()
                if name == value:
                    return _gdal.Dataset_DeleteLayer(self, i)
            raise ValueError("Layer %s not found to delete" % value)
        elif isinstance(value, int):
            return _gdal.Dataset_DeleteLayer(self, value)
        else:
            raise TypeError("Input %s is not of String or Int type" % type(value))

Dataset_swigregister = _gdal.Dataset_swigregister
Dataset_swigregister(Dataset)

class Band(MajorObject):
    """Proxy of C++ GDALRasterBandShadow class"""
    __swig_setmethods__ = {}
    for _s in [MajorObject]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Band, name, value)
    __swig_getmethods__ = {}
    for _s in [MajorObject]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, Band, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_getmethods__["XSize"] = _gdal.Band_XSize_get
    if _newclass:XSize = _swig_property(_gdal.Band_XSize_get)
    __swig_getmethods__["YSize"] = _gdal.Band_YSize_get
    if _newclass:YSize = _swig_property(_gdal.Band_YSize_get)
    __swig_getmethods__["DataType"] = _gdal.Band_DataType_get
    if _newclass:DataType = _swig_property(_gdal.Band_DataType_get)
    def GetDataset(self, *args):
        """GetDataset(self) -> Dataset"""
        return _gdal.Band_GetDataset(self, *args)

    def GetBand(self, *args):
        """GetBand(self) -> int"""
        return _gdal.Band_GetBand(self, *args)

    def GetBlockSize(self, *args):
        """GetBlockSize(self)"""
        return _gdal.Band_GetBlockSize(self, *args)

    def GetColorInterpretation(self, *args):
        """GetColorInterpretation(self) -> GDALColorInterp"""
        return _gdal.Band_GetColorInterpretation(self, *args)

    def GetRasterColorInterpretation(self, *args):
        """GetRasterColorInterpretation(self) -> GDALColorInterp"""
        return _gdal.Band_GetRasterColorInterpretation(self, *args)

    def SetColorInterpretation(self, *args):
        """SetColorInterpretation(self, GDALColorInterp val) -> CPLErr"""
        return _gdal.Band_SetColorInterpretation(self, *args)

    def SetRasterColorInterpretation(self, *args):
        """SetRasterColorInterpretation(self, GDALColorInterp val) -> CPLErr"""
        return _gdal.Band_SetRasterColorInterpretation(self, *args)

    def GetNoDataValue(self, *args):
        """GetNoDataValue(self)"""
        return _gdal.Band_GetNoDataValue(self, *args)

    def SetNoDataValue(self, *args):
        """SetNoDataValue(self, double d) -> CPLErr"""
        return _gdal.Band_SetNoDataValue(self, *args)

    def GetUnitType(self, *args):
        """GetUnitType(self) -> char"""
        return _gdal.Band_GetUnitType(self, *args)

    def SetUnitType(self, *args):
        """SetUnitType(self, char val) -> CPLErr"""
        return _gdal.Band_SetUnitType(self, *args)

    def GetRasterCategoryNames(self, *args):
        """GetRasterCategoryNames(self) -> char"""
        return _gdal.Band_GetRasterCategoryNames(self, *args)

    def SetRasterCategoryNames(self, *args):
        """SetRasterCategoryNames(self, char names) -> CPLErr"""
        return _gdal.Band_SetRasterCategoryNames(self, *args)

    def GetMinimum(self, *args):
        """GetMinimum(self)"""
        return _gdal.Band_GetMinimum(self, *args)

    def GetMaximum(self, *args):
        """GetMaximum(self)"""
        return _gdal.Band_GetMaximum(self, *args)

    def GetOffset(self, *args):
        """GetOffset(self)"""
        return _gdal.Band_GetOffset(self, *args)

    def GetScale(self, *args):
        """GetScale(self)"""
        return _gdal.Band_GetScale(self, *args)

    def SetOffset(self, *args):
        """SetOffset(self, double val) -> CPLErr"""
        return _gdal.Band_SetOffset(self, *args)

    def SetScale(self, *args):
        """SetScale(self, double val) -> CPLErr"""
        return _gdal.Band_SetScale(self, *args)

    def GetStatistics(self, *args):
        """GetStatistics(self, int approx_ok, int force) -> CPLErr"""
        return _gdal.Band_GetStatistics(self, *args)

    def ComputeStatistics(self, *args):
        """ComputeStatistics(self, bool approx_ok, GDALProgressFunc callback = None, void callback_data = None) -> CPLErr"""
        return _gdal.Band_ComputeStatistics(self, *args)

    def SetStatistics(self, *args):
        """SetStatistics(self, double min, double max, double mean, double stddev) -> CPLErr"""
        return _gdal.Band_SetStatistics(self, *args)

    def GetOverviewCount(self, *args):
        """GetOverviewCount(self) -> int"""
        return _gdal.Band_GetOverviewCount(self, *args)

    def GetOverview(self, *args):
        """GetOverview(self, int i) -> Band"""
        return _gdal.Band_GetOverview(self, *args)

    def Checksum(self, *args, **kwargs):
        """Checksum(self, int xoff = 0, int yoff = 0, int xsize = None, int ysize = None) -> int"""
        return _gdal.Band_Checksum(self, *args, **kwargs)

    def ComputeRasterMinMax(self, *args):
        """ComputeRasterMinMax(self, int approx_ok = 0)"""
        return _gdal.Band_ComputeRasterMinMax(self, *args)

    def ComputeBandStats(self, *args):
        """ComputeBandStats(self, int samplestep = 1)"""
        return _gdal.Band_ComputeBandStats(self, *args)

    def Fill(self, *args):
        """Fill(self, double real_fill, double imag_fill = 0.0) -> CPLErr"""
        return _gdal.Band_Fill(self, *args)

    def WriteRaster(self, *args, **kwargs):
        """
        WriteRaster(self, int xoff, int yoff, int xsize, int ysize, GIntBig buf_len, 
            int buf_xsize = None, int buf_ysize = None, 
            int buf_type = None, int buf_pixel_space = None, 
            int buf_line_space = None) -> CPLErr
        """
        return _gdal.Band_WriteRaster(self, *args, **kwargs)

    def FlushCache(self, *args):
        """FlushCache(self)"""
        return _gdal.Band_FlushCache(self, *args)

    def GetRasterColorTable(self, *args):
        """GetRasterColorTable(self) -> ColorTable"""
        return _gdal.Band_GetRasterColorTable(self, *args)

    def GetColorTable(self, *args):
        """GetColorTable(self) -> ColorTable"""
        return _gdal.Band_GetColorTable(self, *args)

    def SetRasterColorTable(self, *args):
        """SetRasterColorTable(self, ColorTable arg) -> int"""
        return _gdal.Band_SetRasterColorTable(self, *args)

    def SetColorTable(self, *args):
        """SetColorTable(self, ColorTable arg) -> int"""
        return _gdal.Band_SetColorTable(self, *args)

    def GetDefaultRAT(self, *args):
        """GetDefaultRAT(self) -> RasterAttributeTable"""
        return _gdal.Band_GetDefaultRAT(self, *args)

    def SetDefaultRAT(self, *args):
        """SetDefaultRAT(self, RasterAttributeTable table) -> int"""
        return _gdal.Band_SetDefaultRAT(self, *args)

    def GetMaskBand(self, *args):
        """GetMaskBand(self) -> Band"""
        return _gdal.Band_GetMaskBand(self, *args)

    def GetMaskFlags(self, *args):
        """GetMaskFlags(self) -> int"""
        return _gdal.Band_GetMaskFlags(self, *args)

    def CreateMaskBand(self, *args):
        """CreateMaskBand(self, int nFlags) -> CPLErr"""
        return _gdal.Band_CreateMaskBand(self, *args)

    def GetHistogram(self, *args, **kwargs):
        """
        GetHistogram(self, double min = -0.5, double max = 255.5, int buckets = 256, 
            int include_out_of_range = 0, int approx_ok = 1, 
            GDALProgressFunc callback = None, 
            void callback_data = None) -> CPLErr
        """
        return _gdal.Band_GetHistogram(self, *args, **kwargs)

    def GetDefaultHistogram(self, *args, **kwargs):
        """
        GetDefaultHistogram(self, double min_ret = None, double max_ret = None, int buckets_ret = None, 
            GUIntBig ppanHistogram = None, 
            int force = 1, GDALProgressFunc callback = None, 
            void callback_data = None) -> CPLErr
        """
        return _gdal.Band_GetDefaultHistogram(self, *args, **kwargs)

    def SetDefaultHistogram(self, *args):
        """SetDefaultHistogram(self, double min, double max, int buckets_in) -> CPLErr"""
        return _gdal.Band_SetDefaultHistogram(self, *args)

    def HasArbitraryOverviews(self, *args):
        """HasArbitraryOverviews(self) -> bool"""
        return _gdal.Band_HasArbitraryOverviews(self, *args)

    def GetCategoryNames(self, *args):
        """GetCategoryNames(self) -> char"""
        return _gdal.Band_GetCategoryNames(self, *args)

    def SetCategoryNames(self, *args):
        """SetCategoryNames(self, char papszCategoryNames) -> CPLErr"""
        return _gdal.Band_SetCategoryNames(self, *args)

    def GetVirtualMem(self, *args, **kwargs):
        """
        GetVirtualMem(self, GDALRWFlag eRWFlag, int nXOff, int nYOff, int nXSize, 
            int nYSize, int nBufXSize, int nBufYSize, 
            GDALDataType eBufType, size_t nCacheSize, size_t nPageSizeHint, 
            char options = None) -> VirtualMem
        """
        return _gdal.Band_GetVirtualMem(self, *args, **kwargs)

    def GetVirtualMemAuto(self, *args, **kwargs):
        """GetVirtualMemAuto(self, GDALRWFlag eRWFlag, char options = None) -> VirtualMem"""
        return _gdal.Band_GetVirtualMemAuto(self, *args, **kwargs)

    def GetTiledVirtualMem(self, *args, **kwargs):
        """
        GetTiledVirtualMem(self, GDALRWFlag eRWFlag, int nXOff, int nYOff, int nXSize, 
            int nYSize, int nTileXSize, int nTileYSize, 
            GDALDataType eBufType, size_t nCacheSize, char options = None) -> VirtualMem
        """
        return _gdal.Band_GetTiledVirtualMem(self, *args, **kwargs)

    def ReadRaster1(self, *args, **kwargs):
        """
        ReadRaster1(self, int xoff, int yoff, int xsize, int ysize, int buf_xsize = None, 
            int buf_ysize = None, int buf_type = None, 
            GIntBig buf_pixel_space = None, GIntBig buf_line_space = None, 
            GDALRIOResampleAlg resample_alg = GRIORA_NearestNeighbour, 
            GDALProgressFunc callback = None, 
            void callback_data = None) -> CPLErr
        """
        return _gdal.Band_ReadRaster1(self, *args, **kwargs)

    def ReadBlock(self, *args, **kwargs):
        """ReadBlock(self, int xoff, int yoff) -> CPLErr"""
        return _gdal.Band_ReadBlock(self, *args, **kwargs)

    def ReadRaster(self, xoff = 0, yoff = 0, xsize = None, ysize = None,
                     buf_xsize = None, buf_ysize = None, buf_type = None,
                     buf_pixel_space = None, buf_line_space = None,
                     resample_alg = GRIORA_NearestNeighbour,
                     callback = None,
                     callback_data = None):

        if xsize is None:
            xsize = self.XSize
        if ysize is None:
            ysize = self.YSize

        return _gdal.Band_ReadRaster1(self, xoff, yoff, xsize, ysize,
                                      buf_xsize, buf_ysize, buf_type,
                                      buf_pixel_space, buf_line_space,
                                      resample_alg, callback, callback_data)

    def ReadAsArray(self, xoff=0, yoff=0, win_xsize=None, win_ysize=None,
                    buf_xsize=None, buf_ysize=None, buf_type=None, buf_obj=None,
                    resample_alg = GRIORA_NearestNeighbour,
                    callback = None,
                    callback_data = None):
        """ Reading a chunk of a GDAL band into a numpy array. The optional (buf_xsize,buf_ysize,buf_type)
        parameters should generally not be specified if buf_obj is specified. The array is returned"""

        import gdalnumeric

        return gdalnumeric.BandReadAsArray( self, xoff, yoff,
                                            win_xsize, win_ysize,
                                            buf_xsize, buf_ysize, buf_type, buf_obj,
                                            resample_alg = resample_alg,
                                            callback = callback,
                                            callback_data = callback_data)
      
    def WriteArray(self, array, xoff=0, yoff=0,
                   resample_alg = GRIORA_NearestNeighbour,
                   callback = None,
                   callback_data = None):
        import gdalnumeric

        return gdalnumeric.BandWriteArray( self, array, xoff, yoff,
                                           resample_alg = resample_alg,
                                           callback = callback,
                                           callback_data = callback_data )

    def GetVirtualMemArray(self, eAccess = gdalconst.GF_Read, xoff=0, yoff=0,
                           xsize=None, ysize=None, bufxsize=None, bufysize=None,
                           datatype = None,
                           cache_size = 10 * 1024 * 1024, page_size_hint = 0,
                           options = None):
          """Return a NumPy array for the band, seen as a virtual memory mapping.
             An element is accessed with array[y][x].
             Any reference to the array must be dropped before the last reference to the
             related dataset is also dropped.
          """
          import gdalnumeric
          if xsize is None:
              xsize = self.XSize
          if ysize is None:
              ysize = self.YSize
          if bufxsize is None:
              bufxsize = self.XSize
          if bufysize is None:
              bufysize = self.YSize
          if datatype is None:
              datatype = self.DataType
          if options is None:
              virtualmem = self.GetVirtualMem(eAccess,xoff,yoff,xsize,ysize,bufxsize,bufysize,datatype,cache_size,page_size_hint)
          else:
              virtualmem = self.GetVirtualMem(eAccess,xoff,yoff,xsize,ysize,bufxsize,bufysize,datatype,cache_size,page_size_hint,options)
          return gdalnumeric.VirtualMemGetArray( virtualmem )

    def GetVirtualMemAutoArray(self, eAccess = gdalconst.GF_Read, options = None):
          """Return a NumPy array for the band, seen as a virtual memory mapping.
             An element is accessed with array[y][x].
             Any reference to the array must be dropped before the last reference to the
             related dataset is also dropped.
          """
          import gdalnumeric
          if options is None:
              virtualmem = self.GetVirtualMemAuto(eAccess)
          else:
              virtualmem = self.GetVirtualMemAuto(eAccess,options)
          return gdalnumeric.VirtualMemGetArray( virtualmem )

    def GetTiledVirtualMemArray(self, eAccess = gdalconst.GF_Read, xoff=0, yoff=0,
                             xsize=None, ysize=None, tilexsize=256, tileysize=256,
                             datatype = None,
                             cache_size = 10 * 1024 * 1024, options = None):
          """Return a NumPy array for the band, seen as a virtual memory mapping with
             a tile organization.
             An element is accessed with array[tiley][tilex][y][x].
             Any reference to the array must be dropped before the last reference to the
             related dataset is also dropped.
          """
          import gdalnumeric
          if xsize is None:
              xsize = self.XSize
          if ysize is None:
              ysize = self.YSize
          if datatype is None:
              datatype = self.DataType
          if options is None:
              virtualmem = self.GetTiledVirtualMem(eAccess,xoff,yoff,xsize,ysize,tilexsize,tileysize,datatype,cache_size)
          else:
              virtualmem = self.GetTiledVirtualMem(eAccess,xoff,yoff,xsize,ysize,tilexsize,tileysize,datatype,cache_size,options)
          return gdalnumeric.VirtualMemGetArray( virtualmem )

    def __get_array_interface__(self):
        shape = [1, self.XSize, self.YSize]
        

Band_swigregister = _gdal.Band_swigregister
Band_swigregister(Band)

class ColorTable(_object):
    """Proxy of C++ GDALColorTableShadow class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ColorTable, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ColorTable, name)
    __repr__ = _swig_repr
    def __init__(self, *args, **kwargs): 
        """__init__(self, GDALPaletteInterp palette = GPI_RGB) -> ColorTable"""
        this = _gdal.new_ColorTable(*args, **kwargs)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _gdal.delete_ColorTable
    __del__ = lambda self : None;
    def Clone(self, *args):
        """Clone(self) -> ColorTable"""
        return _gdal.ColorTable_Clone(self, *args)

    def GetPaletteInterpretation(self, *args):
        """GetPaletteInterpretation(self) -> GDALPaletteInterp"""
        return _gdal.ColorTable_GetPaletteInterpretation(self, *args)

    def GetCount(self, *args):
        """GetCount(self) -> int"""
        return _gdal.ColorTable_GetCount(self, *args)

    def GetColorEntry(self, *args):
        """GetColorEntry(self, int entry) -> ColorEntry"""
        return _gdal.ColorTable_GetColorEntry(self, *args)

    def GetColorEntryAsRGB(self, *args):
        """GetColorEntryAsRGB(self, int entry, ColorEntry centry) -> int"""
        return _gdal.ColorTable_GetColorEntryAsRGB(self, *args)

    def SetColorEntry(self, *args):
        """SetColorEntry(self, int entry, ColorEntry centry)"""
        return _gdal.ColorTable_SetColorEntry(self, *args)

    def CreateColorRamp(self, *args):
        """
        CreateColorRamp(self, int nStartIndex, ColorEntry startcolor, int nEndIndex, 
            ColorEntry endcolor)
        """
        return _gdal.ColorTable_CreateColorRamp(self, *args)

ColorTable_swigregister = _gdal.ColorTable_swigregister
ColorTable_swigregister(ColorTable)

class RasterAttributeTable(_object):
    """Proxy of C++ GDALRasterAttributeTableShadow class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, RasterAttributeTable, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, RasterAttributeTable, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self) -> RasterAttributeTable"""
        this = _gdal.new_RasterAttributeTable(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _gdal.delete_RasterAttributeTable
    __del__ = lambda self : None;
    def Clone(self, *args):
        """Clone(self) -> RasterAttributeTable"""
        return _gdal.RasterAttributeTable_Clone(self, *args)

    def GetColumnCount(self, *args):
        """GetColumnCount(self) -> int"""
        return _gdal.RasterAttributeTable_GetColumnCount(self, *args)

    def GetNameOfCol(self, *args):
        """GetNameOfCol(self, int iCol) -> char"""
        return _gdal.RasterAttributeTable_GetNameOfCol(self, *args)

    def GetUsageOfCol(self, *args):
        """GetUsageOfCol(self, int iCol) -> GDALRATFieldUsage"""
        return _gdal.RasterAttributeTable_GetUsageOfCol(self, *args)

    def GetTypeOfCol(self, *args):
        """GetTypeOfCol(self, int iCol) -> GDALRATFieldType"""
        return _gdal.RasterAttributeTable_GetTypeOfCol(self, *args)

    def GetColOfUsage(self, *args):
        """GetColOfUsage(self, GDALRATFieldUsage eUsage) -> int"""
        return _gdal.RasterAttributeTable_GetColOfUsage(self, *args)

    def GetRowCount(self, *args):
        """GetRowCount(self) -> int"""
        return _gdal.RasterAttributeTable_GetRowCount(self, *args)

    def GetValueAsString(self, *args):
        """GetValueAsString(self, int iRow, int iCol) -> char"""
        return _gdal.RasterAttributeTable_GetValueAsString(self, *args)

    def GetValueAsInt(self, *args):
        """GetValueAsInt(self, int iRow, int iCol) -> int"""
        return _gdal.RasterAttributeTable_GetValueAsInt(self, *args)

    def GetValueAsDouble(self, *args):
        """GetValueAsDouble(self, int iRow, int iCol) -> double"""
        return _gdal.RasterAttributeTable_GetValueAsDouble(self, *args)

    def SetValueAsString(self, *args):
        """SetValueAsString(self, int iRow, int iCol, char pszValue)"""
        return _gdal.RasterAttributeTable_SetValueAsString(self, *args)

    def SetValueAsInt(self, *args):
        """SetValueAsInt(self, int iRow, int iCol, int nValue)"""
        return _gdal.RasterAttributeTable_SetValueAsInt(self, *args)

    def SetValueAsDouble(self, *args):
        """SetValueAsDouble(self, int iRow, int iCol, double dfValue)"""
        return _gdal.RasterAttributeTable_SetValueAsDouble(self, *args)

    def SetRowCount(self, *args):
        """SetRowCount(self, int nCount)"""
        return _gdal.RasterAttributeTable_SetRowCount(self, *args)

    def CreateColumn(self, *args):
        """CreateColumn(self, char pszName, GDALRATFieldType eType, GDALRATFieldUsage eUsage) -> int"""
        return _gdal.RasterAttributeTable_CreateColumn(self, *args)

    def GetLinearBinning(self, *args):
        """GetLinearBinning(self) -> bool"""
        return _gdal.RasterAttributeTable_GetLinearBinning(self, *args)

    def SetLinearBinning(self, *args):
        """SetLinearBinning(self, double dfRow0Min, double dfBinSize) -> int"""
        return _gdal.RasterAttributeTable_SetLinearBinning(self, *args)

    def GetRowOfValue(self, *args):
        """GetRowOfValue(self, double dfValue) -> int"""
        return _gdal.RasterAttributeTable_GetRowOfValue(self, *args)

    def ChangesAreWrittenToFile(self, *args):
        """ChangesAreWrittenToFile(self) -> int"""
        return _gdal.RasterAttributeTable_ChangesAreWrittenToFile(self, *args)

    def DumpReadable(self, *args):
        """DumpReadable(self)"""
        return _gdal.RasterAttributeTable_DumpReadable(self, *args)

    def WriteArray(self, array, field, start=0):
        import gdalnumeric

        return gdalnumeric.RATWriteArray(self, array, field, start)

    def ReadAsArray(self, field, start=0, length=None):
        import gdalnumeric

        return gdalnumeric.RATReadArray(self, field, start, length)

RasterAttributeTable_swigregister = _gdal.RasterAttributeTable_swigregister
RasterAttributeTable_swigregister(RasterAttributeTable)


def TermProgress_nocb(*args, **kwargs):
  """TermProgress_nocb(double dfProgress, char pszMessage = None, void pData = None) -> int"""
  return _gdal.TermProgress_nocb(*args, **kwargs)
TermProgress = _gdal.TermProgress

def ComputeMedianCutPCT(*args, **kwargs):
  """
    ComputeMedianCutPCT(Band red, Band green, Band blue, int num_colors, ColorTable colors, 
        GDALProgressFunc callback = None, 
        void callback_data = None) -> int
    """
  return _gdal.ComputeMedianCutPCT(*args, **kwargs)
ComputeMedianCutPCT = _gdal.ComputeMedianCutPCT

def DitherRGB2PCT(*args, **kwargs):
  """
    DitherRGB2PCT(Band red, Band green, Band blue, Band target, ColorTable colors, 
        GDALProgressFunc callback = None, 
        void callback_data = None) -> int
    """
  return _gdal.DitherRGB2PCT(*args, **kwargs)
DitherRGB2PCT = _gdal.DitherRGB2PCT

def ReprojectImage(*args):
  """
    ReprojectImage(Dataset src_ds, Dataset dst_ds, char src_wkt = None, 
        char dst_wkt = None, GDALResampleAlg eResampleAlg = GRA_NearestNeighbour, 
        double WarpMemoryLimit = 0.0, 
        double maxerror = 0.0, GDALProgressFunc callback = None, 
        void callback_data = None) -> CPLErr
    """
  return _gdal.ReprojectImage(*args)
ReprojectImage = _gdal.ReprojectImage

def ComputeProximity(*args, **kwargs):
  """
    ComputeProximity(Band srcBand, Band proximityBand, char options = None, 
        GDALProgressFunc callback = None, void callback_data = None) -> int
    """
  return _gdal.ComputeProximity(*args, **kwargs)
ComputeProximity = _gdal.ComputeProximity

def RasterizeLayer(*args, **kwargs):
  """
    RasterizeLayer(Dataset dataset, int bands, Layer layer, void pfnTransformer = None, 
        void pTransformArg = None, 
        int burn_values = 0, char options = None, GDALProgressFunc callback = None, 
        void callback_data = None) -> int
    """
  return _gdal.RasterizeLayer(*args, **kwargs)
RasterizeLayer = _gdal.RasterizeLayer

def Polygonize(*args, **kwargs):
  """
    Polygonize(Band srcBand, Band maskBand, Layer outLayer, int iPixValField, 
        char options = None, GDALProgressFunc callback = None, 
        void callback_data = None) -> int
    """
  return _gdal.Polygonize(*args, **kwargs)
Polygonize = _gdal.Polygonize

def FillNodata(*args, **kwargs):
  """
    FillNodata(Band targetBand, Band maskBand, double maxSearchDist, 
        int smoothingIterations, char options = None, 
        GDALProgressFunc callback = None, void callback_data = None) -> int
    """
  return _gdal.FillNodata(*args, **kwargs)
FillNodata = _gdal.FillNodata

def SieveFilter(*args, **kwargs):
  """
    SieveFilter(Band srcBand, Band maskBand, Band dstBand, int threshold, 
        int connectedness = 4, char options = None, 
        GDALProgressFunc callback = None, void callback_data = None) -> int
    """
  return _gdal.SieveFilter(*args, **kwargs)
SieveFilter = _gdal.SieveFilter

def RegenerateOverviews(*args, **kwargs):
  """
    RegenerateOverviews(Band srcBand, int overviewBandCount, char resampling = "average", 
        GDALProgressFunc callback = None, 
        void callback_data = None) -> int
    """
  return _gdal.RegenerateOverviews(*args, **kwargs)
RegenerateOverviews = _gdal.RegenerateOverviews

def RegenerateOverview(*args, **kwargs):
  """
    RegenerateOverview(Band srcBand, Band overviewBand, char resampling = "average", 
        GDALProgressFunc callback = None, 
        void callback_data = None) -> int
    """
  return _gdal.RegenerateOverview(*args, **kwargs)
RegenerateOverview = _gdal.RegenerateOverview

def ContourGenerate(*args, **kwargs):
  """
    ContourGenerate(Band srcBand, double contourInterval, double contourBase, 
        int fixedLevelCount, int useNoData, double noDataValue, 
        Layer dstLayer, int idField, 
        int elevField, GDALProgressFunc callback = None, 
        void callback_data = None) -> int
    """
  return _gdal.ContourGenerate(*args, **kwargs)
ContourGenerate = _gdal.ContourGenerate

def AutoCreateWarpedVRT(*args):
  """
    AutoCreateWarpedVRT(Dataset src_ds, char src_wkt = None, char dst_wkt = None, 
        GDALResampleAlg eResampleAlg = GRA_NearestNeighbour, 
        double maxerror = 0.0) -> Dataset
    """
  return _gdal.AutoCreateWarpedVRT(*args)
AutoCreateWarpedVRT = _gdal.AutoCreateWarpedVRT
class Transformer(_object):
    """Proxy of C++ GDALTransformerInfoShadow class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Transformer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Transformer, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """__init__(self, Dataset src, Dataset dst, char options) -> Transformer"""
        this = _gdal.new_Transformer(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _gdal.delete_Transformer
    __del__ = lambda self : None;
    def TransformPoint(self, *args):
        """
        TransformPoint(self, int bDstToSrc, double inout) -> int
        TransformPoint(self, int bDstToSrc, double x, double y, double z = 0.0) -> int
        """
        return _gdal.Transformer_TransformPoint(self, *args)

    def TransformPoints(self, *args):
        """TransformPoints(self, int bDstToSrc, int nCount) -> int"""
        return _gdal.Transformer_TransformPoints(self, *args)

    def TransformGeolocations(self, *args, **kwargs):
        """
        TransformGeolocations(self, Band xBand, Band yBand, Band zBand, GDALProgressFunc callback = None, 
            void callback_data = None, 
            char options = None) -> int
        """
        return _gdal.Transformer_TransformGeolocations(self, *args, **kwargs)

Transformer_swigregister = _gdal.Transformer_swigregister
Transformer_swigregister(Transformer)


def ApplyGeoTransform(*args):
  """ApplyGeoTransform(double padfGeoTransform, double dfPixel, double dfLine)"""
  return _gdal.ApplyGeoTransform(*args)
ApplyGeoTransform = _gdal.ApplyGeoTransform

def InvGeoTransform(*args):
  """InvGeoTransform(double gt_in) -> RETURN_NONE"""
  return _gdal.InvGeoTransform(*args)
InvGeoTransform = _gdal.InvGeoTransform

def VersionInfo(*args):
  """VersionInfo(char request = "VERSION_NUM") -> char"""
  return _gdal.VersionInfo(*args)
VersionInfo = _gdal.VersionInfo

def AllRegister(*args):
  """AllRegister()"""
  return _gdal.AllRegister(*args)
AllRegister = _gdal.AllRegister

def GDALDestroyDriverManager(*args):
  """GDALDestroyDriverManager()"""
  return _gdal.GDALDestroyDriverManager(*args)
GDALDestroyDriverManager = _gdal.GDALDestroyDriverManager

def GetCacheMax(*args):
  """GetCacheMax() -> GIntBig"""
  return _gdal.GetCacheMax(*args)
GetCacheMax = _gdal.GetCacheMax

def GetCacheUsed(*args):
  """GetCacheUsed() -> GIntBig"""
  return _gdal.GetCacheUsed(*args)
GetCacheUsed = _gdal.GetCacheUsed

def SetCacheMax(*args):
  """SetCacheMax(GIntBig nBytes)"""
  return _gdal.SetCacheMax(*args)
SetCacheMax = _gdal.SetCacheMax

def GetDataTypeSize(*args):
  """GetDataTypeSize(GDALDataType eDataType) -> int"""
  return _gdal.GetDataTypeSize(*args)
GetDataTypeSize = _gdal.GetDataTypeSize

def DataTypeIsComplex(*args):
  """DataTypeIsComplex(GDALDataType eDataType) -> int"""
  return _gdal.DataTypeIsComplex(*args)
DataTypeIsComplex = _gdal.DataTypeIsComplex

def GetDataTypeName(*args):
  """GetDataTypeName(GDALDataType eDataType) -> char"""
  return _gdal.GetDataTypeName(*args)
GetDataTypeName = _gdal.GetDataTypeName

def GetDataTypeByName(*args):
  """GetDataTypeByName(char pszDataTypeName) -> GDALDataType"""
  return _gdal.GetDataTypeByName(*args)
GetDataTypeByName = _gdal.GetDataTypeByName

def GetColorInterpretationName(*args):
  """GetColorInterpretationName(GDALColorInterp eColorInterp) -> char"""
  return _gdal.GetColorInterpretationName(*args)
GetColorInterpretationName = _gdal.GetColorInterpretationName

def GetPaletteInterpretationName(*args):
  """GetPaletteInterpretationName(GDALPaletteInterp ePaletteInterp) -> char"""
  return _gdal.GetPaletteInterpretationName(*args)
GetPaletteInterpretationName = _gdal.GetPaletteInterpretationName

def DecToDMS(*args):
  """DecToDMS(double arg0, char arg1, int arg2 = 2) -> char"""
  return _gdal.DecToDMS(*args)
DecToDMS = _gdal.DecToDMS

def PackedDMSToDec(*args):
  """PackedDMSToDec(double dfPacked) -> double"""
  return _gdal.PackedDMSToDec(*args)
PackedDMSToDec = _gdal.PackedDMSToDec

def DecToPackedDMS(*args):
  """DecToPackedDMS(double dfDec) -> double"""
  return _gdal.DecToPackedDMS(*args)
DecToPackedDMS = _gdal.DecToPackedDMS

def ParseXMLString(*args):
  """ParseXMLString(char pszXMLString) -> CPLXMLNode"""
  return _gdal.ParseXMLString(*args)
ParseXMLString = _gdal.ParseXMLString

def SerializeXMLTree(*args):
  """SerializeXMLTree(CPLXMLNode xmlnode) -> retStringAndCPLFree"""
  return _gdal.SerializeXMLTree(*args)
SerializeXMLTree = _gdal.SerializeXMLTree

def GetJPEG2000Structure(*args):
  """GetJPEG2000Structure(char pszFilename, char options = None) -> CPLXMLNode"""
  return _gdal.GetJPEG2000Structure(*args)
GetJPEG2000Structure = _gdal.GetJPEG2000Structure

def GetJPEG2000StructureAsString(*args):
  """GetJPEG2000StructureAsString(char pszFilename, char options = None) -> retStringAndCPLFree"""
  return _gdal.GetJPEG2000StructureAsString(*args)
GetJPEG2000StructureAsString = _gdal.GetJPEG2000StructureAsString

def GetDriverCount(*args):
  """GetDriverCount() -> int"""
  return _gdal.GetDriverCount(*args)
GetDriverCount = _gdal.GetDriverCount

def GetDriverByName(*args):
  """GetDriverByName(char name) -> Driver"""
  return _gdal.GetDriverByName(*args)
GetDriverByName = _gdal.GetDriverByName

def GetDriver(*args):
  """GetDriver(int i) -> Driver"""
  return _gdal.GetDriver(*args)
GetDriver = _gdal.GetDriver

def Open(*args):
  """Open(char utf8_path, GDALAccess eAccess = GA_ReadOnly) -> Dataset"""
  return _gdal.Open(*args)
Open = _gdal.Open

def OpenEx(*args, **kwargs):
  """
    OpenEx(char utf8_path, unsigned int nOpenFlags = 0, char allowed_drivers = None, 
        char open_options = None, 
        char sibling_files = None) -> Dataset
    """
  return _gdal.OpenEx(*args, **kwargs)
OpenEx = _gdal.OpenEx

def OpenShared(*args):
  """OpenShared(char utf8_path, GDALAccess eAccess = GA_ReadOnly) -> Dataset"""
  return _gdal.OpenShared(*args)
OpenShared = _gdal.OpenShared

def IdentifyDriver(*args):
  """IdentifyDriver(char utf8_path, char papszSiblings = None) -> Driver"""
  return _gdal.IdentifyDriver(*args)
IdentifyDriver = _gdal.IdentifyDriver

def GeneralCmdLineProcessor(*args):
  """GeneralCmdLineProcessor(char papszArgv, int nOptions = 0) -> char"""
  return _gdal.GeneralCmdLineProcessor(*args)
GeneralCmdLineProcessor = _gdal.GeneralCmdLineProcessor
__version__ = _gdal.VersionInfo("RELEASE_NAME") 



