/* This file is part of the KDE project
 * Copyright (C) 2014 Arjen Hiemstra <ahiemstra@heimr.nl>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// font size is dependent on the line height of the application
// pixel size is the pixel size of the font on a 1080p monitor, and adjusted for
// other resolutions

var values = {
    application: {
        family: "Source Sans Pro",
        style: "Regular",
        size: 1,
    },
    applicationSemi: {
        family: "Source Sans Pro",
        style: "Semibold",
        pixelSize: 18,
    },
    applicationLight: {
        family: "Source Sans Pro",
        style: "Light",
        pixelSize: 18,
    },
    optionsMenu: {
        family: "Source Sans Pro",
        style: "Semibold",
        pixelSize: 22,
    },
    small: {
        family: "Source Sans Pro",
        style: "Bold",
        size: 0.75,
    },
    pageHeader: {
        family: "Source Sans Pro",
        style: "Light",
        pixelSize: 38,
    },
    welcomeHeader: {
        family: "Source Sans Pro",
        style: "Semibold",
        pixelSize: 30,
    },
    welcomeSidebar: {
        family: "Source Sans Pro",
        style: "Regular",
        pixelSize: 24,
    },
    presentationTime: {
        family: "Source Sans Pro",
        style: "Extralight",
        pixelSize: 120,
    },
    presentationFx: {
        family: "Source Sans Pro",
        style: "Regular",
        pixelSize: 24,
    },
    filelistheader: {
        family: "Source Sans Pro",
        style: "Semibold",
        pixelSize: 18,
    },
    templateLabel: {
        family: "Source Sans Pro",
        style: "Light",
        pixelSize: 24
    },
    title: {
        family: "Source Sans Pro",
        style: "Light",
        pixelSize: 38,
    },
    panelHandle: {
        family: "Source Sans Pro",
        style: "Regular",
        size: 1.25,
    },
    panelHeader: {
        family: "Source Sans Pro",
        style: "Regular",
        size: 1.5,
    },
    panelSection: {
        family: "Source Sans Pro",
        style: "Regular",
        size: 1.25,
    },
    toolbar: {
        family: "Source Sans Pro",
        style: "Semibold",
        pixelSize: 24,
    }

}
