/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMISocketFactory;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.jcs.auxiliary.remote.RemoteLocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteUtils {
    private static final Log log = LogFactory.getLog(RemoteUtils.class);

    private RemoteUtils() {
    }

    public static Registry createRegistry(int n) {
        Registry registry = null;
        if (n < 1024) {
            if (log.isWarnEnabled()) {
                log.warn("createRegistry> Port chosen was less than 1024, will use default [1099] instead.");
            }
            n = 1099;
        }
        try {
            registry = LocateRegistry.createRegistry(n);
            log.info("createRegistry> Created the registry on port " + n);
        }
        catch (RemoteException remoteException) {
            log.warn("createRegistry> Problem creating registry. It may already be started. " + remoteException.getMessage());
        }
        catch (Throwable throwable) {
            log.error("createRegistry> Problem creating registry.", throwable);
        }
        if (registry == null) {
            try {
                registry = LocateRegistry.getRegistry(n);
            }
            catch (RemoteException remoteException) {
                log.error("createRegistry> Problem getting a registry reference.", remoteException);
            }
        }
        return registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProps(String string) throws IOException {
        InputStream inputStream = RemoteUtils.class.getResourceAsStream(string);
        if (null == inputStream) {
            inputStream = new File(string).exists() ? new FileInputStream(string) : new URL(string).openStream();
        }
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
            if (log.isDebugEnabled()) {
                log.debug("props.size=" + properties.size());
            }
            if (log.isDebugEnabled()) {
                Enumeration<Object> enumeration = properties.keys();
                StringBuilder stringBuilder = new StringBuilder();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    stringBuilder.append("\n" + string2 + " = " + properties.getProperty(string2));
                }
                log.debug(stringBuilder.toString());
            }
        }
        catch (Exception exception) {
            log.error("Error loading remote properties, for file name [" + string + "]", exception);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return properties;
    }

    public static void configureGlobalCustomSocketFactory(final int n) {
        block4: {
            try {
                if (n > 0) {
                    if (log.isInfoEnabled()) {
                        log.info("RmiSocketFactoryTimeoutMillis [" + n + "]. " + " Configuring a custom socket factory.");
                    }
                    RMISocketFactory.setSocketFactory(new RMISocketFactory(){

                        @Override
                        public Socket createSocket(String string, int n2) throws IOException {
                            Socket socket = new Socket();
                            socket.setSoTimeout(n);
                            socket.setSoLinger(false, 0);
                            socket.connect(new InetSocketAddress(string, n2), n);
                            return socket;
                        }

                        @Override
                        public ServerSocket createServerSocket(int n2) throws IOException {
                            return new ServerSocket(n2);
                        }
                    });
                }
            }
            catch (IOException iOException) {
                RMISocketFactory rMISocketFactory = RMISocketFactory.getSocketFactory();
                if (rMISocketFactory == null || rMISocketFactory.getClass().getName().startsWith("org.apache.commons.jcs")) break block4;
                log.info("Could not create new custom socket factory. " + iOException.getMessage() + " Factory in use = " + RMISocketFactory.getSocketFactory());
            }
        }
    }

    public static String getNamingURL(RemoteLocation remoteLocation, String string) {
        return RemoteUtils.getNamingURL(remoteLocation.getHost(), remoteLocation.getPort(), string);
    }

    public static String getNamingURL(String string, int n, String string2) {
        if (string.contains(":")) {
            return "//[" + string.replaceFirst("%", "%25") + "]:" + n + "/" + string2;
        }
        String string3 = "//" + string + ":" + n + "/" + string2;
        return string3;
    }
}

