/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.json;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import javax.json.spi.JsonProvider;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import javax.json.stream.JsonParser;
import javax.json.stream.JsonParserFactory;
import org.glassfish.json.BufferPoolImpl;
import org.glassfish.json.JsonArrayBuilderImpl;
import org.glassfish.json.JsonBuilderFactoryImpl;
import org.glassfish.json.JsonGeneratorFactoryImpl;
import org.glassfish.json.JsonGeneratorImpl;
import org.glassfish.json.JsonObjectBuilderImpl;
import org.glassfish.json.JsonParserFactoryImpl;
import org.glassfish.json.JsonParserImpl;
import org.glassfish.json.JsonReaderFactoryImpl;
import org.glassfish.json.JsonReaderImpl;
import org.glassfish.json.JsonWriterFactoryImpl;
import org.glassfish.json.JsonWriterImpl;
import org.glassfish.json.api.BufferPool;

public class JsonProviderImpl
extends JsonProvider {
    private final BufferPool bufferPool = new BufferPoolImpl();

    @Override
    public JsonGenerator createGenerator(Writer writer) {
        return new JsonGeneratorImpl(writer, this.bufferPool);
    }

    @Override
    public JsonGenerator createGenerator(OutputStream outputStream) {
        return new JsonGeneratorImpl(outputStream, this.bufferPool);
    }

    @Override
    public JsonParser createParser(Reader reader) {
        return new JsonParserImpl(reader, this.bufferPool);
    }

    @Override
    public JsonParser createParser(InputStream inputStream) {
        return new JsonParserImpl(inputStream, this.bufferPool);
    }

    @Override
    public JsonParserFactory createParserFactory(Map<String, ?> map) {
        BufferPool bufferPool = null;
        if (map != null && map.containsKey(BufferPool.class.getName())) {
            bufferPool = (BufferPool)map.get(BufferPool.class.getName());
        }
        if (bufferPool == null) {
            bufferPool = this.bufferPool;
        }
        return new JsonParserFactoryImpl(bufferPool);
    }

    @Override
    public JsonGeneratorFactory createGeneratorFactory(Map<String, ?> map) {
        BufferPool bufferPool;
        boolean bl;
        Map<String, Object> map2;
        if (map == null) {
            map2 = Collections.emptyMap();
            bl = false;
            bufferPool = this.bufferPool;
        } else {
            map2 = new HashMap();
            bl = JsonProviderImpl.isPrettyPrintingEnabled(map);
            if (bl) {
                map2.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
            }
            if ((bufferPool = (BufferPool)map.get(BufferPool.class.getName())) != null) {
                map2.put(BufferPool.class.getName(), bufferPool);
            } else {
                bufferPool = this.bufferPool;
            }
            map2 = Collections.unmodifiableMap(map2);
        }
        return new JsonGeneratorFactoryImpl(map2, bl, bufferPool);
    }

    @Override
    public JsonReader createReader(Reader reader) {
        return new JsonReaderImpl(reader, this.bufferPool);
    }

    @Override
    public JsonReader createReader(InputStream inputStream) {
        return new JsonReaderImpl(inputStream, this.bufferPool);
    }

    @Override
    public JsonWriter createWriter(Writer writer) {
        return new JsonWriterImpl(writer, this.bufferPool);
    }

    @Override
    public JsonWriter createWriter(OutputStream outputStream) {
        return new JsonWriterImpl(outputStream, this.bufferPool);
    }

    @Override
    public JsonWriterFactory createWriterFactory(Map<String, ?> map) {
        BufferPool bufferPool;
        boolean bl;
        Map<String, Object> map2;
        if (map == null) {
            map2 = Collections.emptyMap();
            bl = false;
            bufferPool = this.bufferPool;
        } else {
            map2 = new HashMap();
            bl = JsonProviderImpl.isPrettyPrintingEnabled(map);
            if (bl) {
                map2.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
            }
            if ((bufferPool = (BufferPool)map.get(BufferPool.class.getName())) != null) {
                map2.put(BufferPool.class.getName(), bufferPool);
            } else {
                bufferPool = this.bufferPool;
            }
            map2 = Collections.unmodifiableMap(map2);
        }
        return new JsonWriterFactoryImpl(map2, bl, bufferPool);
    }

    @Override
    public JsonReaderFactory createReaderFactory(Map<String, ?> map) {
        BufferPool bufferPool = null;
        if (map != null && map.containsKey(BufferPool.class.getName())) {
            bufferPool = (BufferPool)map.get(BufferPool.class.getName());
        }
        if (bufferPool == null) {
            bufferPool = this.bufferPool;
        }
        return new JsonReaderFactoryImpl(bufferPool);
    }

    @Override
    public JsonObjectBuilder createObjectBuilder() {
        return new JsonObjectBuilderImpl(this.bufferPool);
    }

    @Override
    public JsonArrayBuilder createArrayBuilder() {
        return new JsonArrayBuilderImpl(this.bufferPool);
    }

    @Override
    public JsonBuilderFactory createBuilderFactory(Map<String, ?> map) {
        BufferPool bufferPool = null;
        if (map != null && map.containsKey(BufferPool.class.getName())) {
            bufferPool = (BufferPool)map.get(BufferPool.class.getName());
        }
        if (bufferPool == null) {
            bufferPool = this.bufferPool;
        }
        return new JsonBuilderFactoryImpl(bufferPool);
    }

    static boolean isPrettyPrintingEnabled(Map<String, ?> map) {
        return map.containsKey("javax.json.stream.JsonGenerator.prettyPrinting");
    }
}

