/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ConvolveOp;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.Kernel;
import java.awt.image.LookupOp;
import java.awt.image.ShortLookupTable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ImageryAdjustAction;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.OffsetBookmark;
import org.openstreetmap.josm.data.preferences.ColorProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.gui.MenuScroller;
import org.openstreetmap.josm.gui.layer.ImageProcessor;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.TMSLayer;
import org.openstreetmap.josm.gui.layer.WMSLayer;
import org.openstreetmap.josm.gui.layer.WMTSLayer;
import org.openstreetmap.josm.gui.widgets.UrlLabel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public abstract class ImageryLayer
extends Layer {
    public static final ColorProperty PROP_FADE_COLOR = new ColorProperty(I18n.marktr("Imagery fade"), Color.white);
    public static final IntegerProperty PROP_FADE_AMOUNT = new IntegerProperty("imagery.fade_amount", 0);
    public static final IntegerProperty PROP_SHARPEN_LEVEL = new IntegerProperty("imagery.sharpen_level", 0);
    private final List<ImageProcessor> imageProcessors = new ArrayList<ImageProcessor>();
    protected final ImageryInfo info;
    protected Icon icon;
    protected double dx;
    protected double dy;
    protected GammaImageProcessor gammaImageProcessor = new GammaImageProcessor();
    protected SharpenImageProcessor sharpenImageProcessor = new SharpenImageProcessor();
    protected ColorfulImageProcessor collorfulnessImageProcessor = new ColorfulImageProcessor();
    private final ImageryAdjustAction adjustAction = new ImageryAdjustAction(this);

    public static Color getFadeColor() {
        return PROP_FADE_COLOR.get();
    }

    public static Color getFadeColorWithAlpha() {
        Color color = PROP_FADE_COLOR.get();
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), PROP_FADE_AMOUNT.get() * 255 / 100);
    }

    public ImageryLayer(ImageryInfo imageryInfo) {
        super(imageryInfo.getName());
        this.info = imageryInfo;
        if (imageryInfo.getIcon() != null) {
            this.icon = new ImageProvider(imageryInfo.getIcon()).setOptional(true).setMaxSize(ImageProvider.ImageSizes.LAYER).get();
        }
        if (this.icon == null) {
            this.icon = ImageProvider.get("imagery_small");
        }
        this.addImageProcessor(this.collorfulnessImageProcessor);
        this.addImageProcessor(this.gammaImageProcessor);
        this.addImageProcessor(this.sharpenImageProcessor);
        this.sharpenImageProcessor.setSharpenLevel(1.0f + (float)PROP_SHARPEN_LEVEL.get().intValue() / 2.0f);
    }

    public double getPPD() {
        if (!Main.isDisplayingMapView()) {
            return Main.getProjection().getDefaultZoomInPPD();
        }
        ProjectionBounds projectionBounds = Main.map.mapView.getProjectionBounds();
        return (double)Main.map.mapView.getWidth() / (projectionBounds.maxEast - projectionBounds.minEast);
    }

    public double getDx() {
        return this.dx;
    }

    public double getDy() {
        return this.dy;
    }

    public void setOffset(double d, double d2) {
        this.dx = d;
        this.dy = d2;
    }

    public void displace(double d, double d2) {
        this.setOffset(this.dx += d, this.dy += d2);
    }

    public ImageryInfo getInfo() {
        return this.info;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public boolean isMergable(Layer layer) {
        return false;
    }

    @Override
    public void mergeFrom(Layer layer) {
    }

    @Override
    public Object getInfoComponent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(this.getToolTipText()), GBC.eol());
        if (this.info != null) {
            String string = this.info.getUrl();
            if (string != null) {
                jPanel.add((Component)new JLabel(I18n.tr("URL: ", new Object[0])), GBC.std().insets(0, 5, 2, 0));
                jPanel.add((Component)new UrlLabel(string), GBC.eol().insets(2, 5, 10, 0));
            }
            if (this.dx != 0.0 || this.dy != 0.0) {
                jPanel.add((Component)new JLabel(I18n.tr("Offset: ", new Object[0]) + this.dx + ';' + this.dy), GBC.eol().insets(0, 5, 10, 0));
            }
        }
        return jPanel;
    }

    public static ImageryLayer create(ImageryInfo imageryInfo) {
        switch (imageryInfo.getImageryType()) {
            case WMS: 
            case HTML: {
                return new WMSLayer(imageryInfo);
            }
            case WMTS: {
                return new WMTSLayer(imageryInfo);
            }
            case TMS: 
            case BING: 
            case SCANEX: {
                return new TMSLayer(imageryInfo);
            }
        }
        throw new AssertionError((Object)I18n.tr("Unsupported imagery type: {0}", new Object[]{imageryInfo.getImageryType()}));
    }

    public JMenuItem getOffsetMenuItem() {
        JMenu jMenu = new JMenu(I18n.trc("layer", "Offset"));
        jMenu.setIcon(ImageProvider.get("mapmode", "adjustimg"));
        return (JMenuItem)this.getOffsetMenuItem(jMenu);
    }

    public JComponent getOffsetMenuItem(JComponent jComponent) {
        JMenuItem jMenuItem = new JMenuItem(this.adjustAction);
        if (OffsetBookmark.allBookmarks.isEmpty()) {
            return jMenuItem;
        }
        jComponent.add(jMenuItem);
        jComponent.add(new JSeparator());
        boolean bl = false;
        int n = 0;
        for (OffsetBookmark offsetBookmark : OffsetBookmark.allBookmarks) {
            if (!offsetBookmark.isUsable(this)) continue;
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(new ApplyOffsetAction(offsetBookmark));
            if (Utils.equalsEpsilon(offsetBookmark.dx, this.dx) && Utils.equalsEpsilon(offsetBookmark.dy, this.dy)) {
                jCheckBoxMenuItem.setSelected(true);
            }
            jComponent.add(jCheckBoxMenuItem);
            n = jCheckBoxMenuItem.getPreferredSize().height;
            bl = true;
        }
        if (n > 0) {
            if (jComponent instanceof JMenu) {
                MenuScroller.setScrollerFor((JMenu)jComponent);
            } else if (jComponent instanceof JPopupMenu) {
                MenuScroller.setScrollerFor((JPopupMenu)jComponent);
            }
        }
        return bl ? jComponent : jMenuItem;
    }

    public double getGamma() {
        return this.gammaImageProcessor.getGamma();
    }

    public void setGamma(double d) {
        this.gammaImageProcessor.setGamma(d);
    }

    public double getSharpenLevel() {
        return this.sharpenImageProcessor.getSharpenLevel();
    }

    public void setSharpenLevel(double d) {
        this.sharpenImageProcessor.setSharpenLevel((float)d);
    }

    public double getColorfulness() {
        return this.collorfulnessImageProcessor.getColorfulness();
    }

    public void setColorfulness(double d) {
        this.collorfulnessImageProcessor.setColorfulness(d);
    }

    public boolean addImageProcessor(ImageProcessor imageProcessor) {
        return imageProcessor != null && this.imageProcessors.add(imageProcessor);
    }

    public boolean removeImageProcessor(ImageProcessor imageProcessor) {
        return this.imageProcessors.remove(imageProcessor);
    }

    public static ImageProcessor createImageProcessor(final BufferedImageOp bufferedImageOp, final boolean bl) {
        return new ImageProcessor(){

            @Override
            public BufferedImage process(BufferedImage bufferedImage) {
                return bufferedImageOp.filter(bufferedImage, bl ? bufferedImage : null);
            }
        };
    }

    public List<ImageProcessor> getImageProcessors() {
        return this.imageProcessors;
    }

    public BufferedImage applyImageProcessors(BufferedImage bufferedImage) {
        for (ImageProcessor imageProcessor : this.imageProcessors) {
            bufferedImage = imageProcessor.process(bufferedImage);
        }
        return bufferedImage;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.adjustAction.destroy();
    }

    private static class ColorfulFilter
    implements BufferedImageOp {
        private final double colorfulness;

        ColorfulFilter(double d) {
            this.colorfulness = d;
        }

        @Override
        public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
            int n;
            int n2;
            int n3;
            if (bufferedImage.getWidth() == 0 || bufferedImage.getHeight() == 0) {
                return bufferedImage;
            }
            if (bufferedImage2 == null) {
                bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
            }
            DataBuffer dataBuffer = bufferedImage.getRaster().getDataBuffer();
            DataBuffer dataBuffer2 = bufferedImage2.getRaster().getDataBuffer();
            if (!(dataBuffer instanceof DataBufferByte) || !(dataBuffer2 instanceof DataBufferByte)) {
                Main.trace("Cannot apply color filter: Images do not use DataBufferByte.");
                return bufferedImage;
            }
            int n4 = bufferedImage.getType();
            if (n4 != bufferedImage2.getType()) {
                Main.trace("Cannot apply color filter: Src / Dest differ in type (" + n4 + "/" + bufferedImage2.getType() + ")");
                return bufferedImage;
            }
            int n5 = 0;
            switch (n4) {
                case 5: {
                    n3 = 0;
                    n2 = 1;
                    n = 2;
                    break;
                }
                case 6: 
                case 7: {
                    n3 = 1;
                    n2 = 2;
                    n = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n = 0;
                    n2 = 1;
                    n3 = 2;
                    n5 = 3;
                    break;
                }
                default: {
                    Main.trace("Cannot apply color filter: Source image is of wrong type (" + n4 + ").");
                    return bufferedImage;
                }
            }
            this.doFilter((DataBufferByte)dataBuffer, (DataBufferByte)dataBuffer2, n, n2, n3, n5, bufferedImage.getAlphaRaster() != null);
            return bufferedImage2;
        }

        private void doFilter(DataBufferByte dataBufferByte, DataBufferByte dataBufferByte2, int n, int n2, int n3, int n4, boolean bl) {
            byte[] byArray;
            byte[] byArray2 = dataBufferByte.getData();
            if (byArray2.length != (byArray = dataBufferByte2.getData()).length) {
                Main.trace("Cannot apply color filter: Source/Dest lengths differ.");
                return;
            }
            int n5 = bl ? 4 : 3;
            for (int i = 0; i < byArray2.length; i += n5) {
                int n6 = byArray2[i + n] & 0xFF;
                int n7 = byArray2[i + n2] & 0xFF;
                int n8 = byArray2[i + n3] & 0xFF;
                float f = (float)n6 * 0.21f + (float)n7 * 0.72f + (float)n8 * 0.07f;
                byArray[i + n] = this.mix(n6, f);
                byArray[i + n2] = this.mix(n7, f);
                byArray[i + n3] = this.mix(n8, f);
                if (!bl) continue;
                byArray[i + n4] = byArray2[i + n4];
            }
        }

        private byte mix(int n, float f) {
            int n2 = (int)(this.colorfulness * (double)n + (1.0 - this.colorfulness) * (double)f);
            if (n2 < 0) {
                return 0;
            }
            if (n2 > 255) {
                return -1;
            }
            return (byte)n2;
        }

        @Override
        public Rectangle2D getBounds2D(BufferedImage bufferedImage) {
            return new Rectangle(bufferedImage.getWidth(), bufferedImage.getHeight());
        }

        @Override
        public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
            return new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getType());
        }

        @Override
        public Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
            return (Point2D)point2D.clone();
        }

        @Override
        public RenderingHints getRenderingHints() {
            return null;
        }
    }

    public static class ColorfulImageProcessor
    implements ImageProcessor {
        private ColorfulFilter op = null;
        private double colorfulness = 1.0;

        public double getColorfulness() {
            return this.colorfulness;
        }

        public void setColorfulness(double d) {
            this.colorfulness = d < 0.0 ? 0.0 : d;
            this.op = this.colorfulness < 0.95 || this.colorfulness > 1.05 ? new ColorfulFilter(this.colorfulness) : null;
        }

        @Override
        public BufferedImage process(BufferedImage bufferedImage) {
            if (this.op != null) {
                return this.op.filter(bufferedImage, null);
            }
            return bufferedImage;
        }

        public String toString() {
            return "ColorfulImageProcessor [colorfulness=" + this.colorfulness + "]";
        }
    }

    public static class SharpenImageProcessor
    implements ImageProcessor {
        private float sharpenLevel = 0.0f;
        private ConvolveOp op;
        private static float[] KERNEL_IDENTITY = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        private static float[] KERNEL_BLUR = new float[]{0.0625f, 0.125f, 0.0625f, 0.125f, 0.25f, 0.125f, 0.0625f, 0.125f, 0.0625f};
        private static float[] KERNEL_SHARPEN = new float[]{-0.5f, -1.0f, -0.5f, -1.0f, 7.0f, -1.0f, -0.5f, -1.0f, -0.5f};

        public float getSharpenLevel() {
            return this.sharpenLevel;
        }

        public void setSharpenLevel(float f) {
            this.sharpenLevel = f < 0.0f ? 0.0f : f;
            this.op = (double)this.sharpenLevel < 0.95 ? this.generateMixed(this.sharpenLevel, KERNEL_IDENTITY, KERNEL_BLUR) : ((double)this.sharpenLevel > 1.05 ? this.generateMixed(this.sharpenLevel - 1.0f, KERNEL_SHARPEN, KERNEL_IDENTITY) : null);
        }

        private ConvolveOp generateMixed(float f, float[] fArray, float[] fArray2) {
            if (fArray.length != 9 || fArray2.length != 9) {
                throw new IllegalArgumentException("Illegal kernel array length.");
            }
            float[] fArray3 = new float[9];
            for (int i = 0; i < fArray3.length; ++i) {
                fArray3[i] = f * fArray[i] + (1.0f - f) * fArray2[i];
            }
            return new ConvolveOp(new Kernel(3, 3, fArray3), 1, null);
        }

        @Override
        public BufferedImage process(BufferedImage bufferedImage) {
            if (this.op != null) {
                return this.op.filter(bufferedImage, null);
            }
            return bufferedImage;
        }

        public String toString() {
            return "SharpenImageProcessor [sharpenLevel=" + this.sharpenLevel + "]";
        }
    }

    public static class GammaImageProcessor
    implements ImageProcessor {
        private double gamma = 1.0;
        final short[] gammaChange = new short[256];
        private final LookupOp op3 = new LookupOp(new ShortLookupTable(0, new short[][]{this.gammaChange, this.gammaChange, this.gammaChange}), null);
        private final LookupOp op4 = new LookupOp(new ShortLookupTable(0, new short[][]{this.gammaChange, this.gammaChange, this.gammaChange, this.gammaChange}), null);

        public double getGamma() {
            return this.gamma;
        }

        public void setGamma(double d) {
            this.gamma = d;
            for (int i = 0; i < 256; ++i) {
                this.gammaChange[i] = (short)(255.0 * Math.pow((double)i / 255.0, d));
            }
        }

        @Override
        public BufferedImage process(BufferedImage bufferedImage) {
            int n;
            block5: {
                if (this.gamma == 1.0) {
                    return bufferedImage;
                }
                try {
                    n = bufferedImage.getRaster().getNumBands();
                    if (bufferedImage.getType() != 0 && n == 3) {
                        return this.op3.filter(bufferedImage, null);
                    }
                    if (bufferedImage.getType() != 0 && n == 4) {
                        return this.op4.filter(bufferedImage, null);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (!Main.isTraceEnabled()) break block5;
                    Main.trace(illegalArgumentException.getMessage());
                }
            }
            n = bufferedImage.getTransparency() == 1 ? 1 : 2;
            BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), n);
            bufferedImage2.getGraphics().drawImage(bufferedImage, 0, 0, null);
            return this.process(bufferedImage2);
        }
    }

    public class OffsetAction
    extends AbstractAction
    implements Layer.LayerAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }

        @Override
        public Component createMenuComponent() {
            return ImageryLayer.this.getOffsetMenuItem();
        }

        @Override
        public boolean supportLayers(List<Layer> list) {
            return false;
        }
    }

    class ApplyOffsetAction
    extends AbstractAction {
        private final transient OffsetBookmark b;

        ApplyOffsetAction(OffsetBookmark offsetBookmark) {
            super(offsetBookmark.name);
            this.b = offsetBookmark;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ImageryLayer.this.setOffset(this.b.dx, this.b.dy);
            Main.main.menu.imageryMenu.refreshOffsetMenu();
            Main.map.repaint();
        }
    }
}

