/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.Color;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.mapcss.CSSColors;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.Utils;

public final class Cascade
implements Cloneable {
    private Map<String, Object> prop = new HashMap<String, Object>();
    private boolean defaultSelectedHandling = true;
    private static final Pattern HEX_COLOR_PATTERN = Pattern.compile("#([0-9a-fA-F]{3}|[0-9a-fA-F]{6}|[0-9a-fA-F]{8})");

    public <T> T get(String string, T t, Class<T> clazz) {
        return this.get(string, t, clazz, false);
    }

    public <T> T get(String string, T t, Class<T> clazz, boolean bl) {
        if (t != null && !clazz.isInstance(t)) {
            throw new IllegalArgumentException(t + " is not an instance of " + clazz);
        }
        Object object = this.prop.get(string);
        if (object == null) {
            return t;
        }
        T t2 = Cascade.convertTo(object, clazz);
        if (t2 == null) {
            if (!bl) {
                Main.warn(String.format("Unable to convert property %s to type %s: found %s of type %s!", string, clazz, object, object.getClass()));
            }
            return t;
        }
        return t2;
    }

    public Object get(String string) {
        return this.prop.get(string);
    }

    public void put(String string, Object object) {
        this.prop.put(string, object);
    }

    public void putOrClear(String string, Object object) {
        if (object != null) {
            this.prop.put(string, object);
        } else {
            this.prop.remove(string);
        }
    }

    public void remove(String string) {
        this.prop.remove(string);
    }

    public static <T> T convertTo(Object object, Class<T> clazz) {
        if (object == null) {
            return null;
        }
        if (clazz.isInstance(object)) {
            return (T)object;
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return (T)Cascade.toFloat(object);
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            if ((object = Cascade.toFloat(object)) != null) {
                object = (double)((Float)object).floatValue();
            }
            return (T)object;
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return (T)Cascade.toBool(object);
        }
        if (clazz == float[].class) {
            return (T)Cascade.toFloatArray(object);
        }
        if (clazz == Color.class) {
            return (T)Cascade.toColor(object);
        }
        if (clazz == String.class) {
            if (object instanceof Keyword) {
                return (T)((Keyword)object).val;
            }
            if (object instanceof Color) {
                Color color = (Color)object;
                int n = color.getAlpha();
                if (n != 255) {
                    return (T)String.format("#%06x%02x", ((Color)object).getRGB() & 0xFFFFFF, n);
                }
                return (T)String.format("#%06x", ((Color)object).getRGB() & 0xFFFFFF);
            }
            return (T)object.toString();
        }
        return null;
    }

    private static Float toFloat(Object object) {
        block4: {
            if (object instanceof Number) {
                return Float.valueOf(((Number)object).floatValue());
            }
            if (object instanceof String && !((String)object).isEmpty()) {
                try {
                    return Float.valueOf((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!Main.isDebugEnabled()) break block4;
                    Main.debug("'" + object + "' cannot be converted to float");
                }
            }
        }
        return null;
    }

    private static Boolean toBool(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        String string = null;
        if (object instanceof Keyword) {
            string = ((Keyword)object).val;
        } else if (object instanceof String) {
            string = (String)object;
        }
        if (string != null) {
            return !string.isEmpty() && !"false".equals(string) && !"no".equals(string) && !"0".equals(string) && !"0.0".equals(string);
        }
        if (object instanceof Number) {
            return ((Number)object).floatValue() != 0.0f;
        }
        if (object instanceof List) {
            return !((List)object).isEmpty();
        }
        if (object instanceof float[]) {
            return ((float[])object).length != 0;
        }
        return null;
    }

    private static float[] toFloatArray(Object object) {
        if (object instanceof float[]) {
            return (float[])object;
        }
        if (object instanceof List) {
            List list = (List)object;
            float[] fArray = new float[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Float f = Cascade.toFloat(list.get(i));
                if (f == null) {
                    return null;
                }
                fArray[i] = f.floatValue();
            }
            return fArray;
        }
        Float f = Cascade.toFloat(object);
        if (f != null) {
            return new float[]{f.floatValue()};
        }
        return null;
    }

    private static Color toColor(Object object) {
        if (object instanceof Color) {
            return (Color)object;
        }
        if (object instanceof Keyword) {
            return CSSColors.get(((Keyword)object).val);
        }
        if (object instanceof String) {
            Color color = CSSColors.get((String)object);
            if (color != null) {
                return color;
            }
            if (HEX_COLOR_PATTERN.matcher((String)object).matches()) {
                return ColorHelper.html2color((String)object);
            }
        }
        return null;
    }

    public Cascade clone() {
        Map map = (Map)((HashMap)this.prop).clone();
        Cascade cascade = new Cascade();
        cascade.prop = map;
        return cascade;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Cascade{ ");
        for (Map.Entry<String, Object> entry : this.prop.entrySet()) {
            stringBuilder.append(entry.getKey() + ':');
            Object object = entry.getValue();
            if (object instanceof float[]) {
                stringBuilder.append(Arrays.toString((float[])object));
            } else if (object instanceof Color) {
                stringBuilder.append(Utils.toString((Color)object));
            } else if (object != null) {
                stringBuilder.append(object);
            }
            stringBuilder.append("; ");
        }
        return stringBuilder.append('}').toString();
    }

    public boolean containsKey(String string) {
        return this.prop.containsKey(string);
    }

    public boolean isDefaultSelectedHandling() {
        return this.defaultSelectedHandling;
    }

    public void setDefaultSelectedHandling(boolean bl) {
        this.defaultSelectedHandling = bl;
    }
}

