# -*- coding: utf-8 -*-

# Copyright (C) 2007 Osmo Salomaa
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.

"""
Website URLs.

:var BUG_REPORT_URL: Web page where to submit new bug reports
:var EXTENSIONS_URL: Web page listing third party extensions
:var HOMEPAGE_URL: Web page of the Gaupol project
:var PREVIEW_HELP_URL: Documentation on the preview function
:var REGEX_HELP_URL: Documentation on regular expressions
:var WIKI_URL: Wiki documentation
"""

__all__ = ("BUG_REPORT_URL",
           "EXTENSIONS_URL",
           "HOMEPAGE_URL",
           "PREVIEW_HELP_URL",
           "REGEX_HELP_URL",
           "WIKI_URL")

BUG_REPORT_URL = "http://bugzilla.gnome.org/enter_bug.cgi?product=gaupol"
EXTENSIONS_URL = "http://wiki.gnome.org/Apps/Gaupol/Extensions"
HOMEPAGE_URL = "http://home.gna.org/gaupol/"
PREVIEW_HELP_URL = "http://wiki.gnome.org/Apps/Gaupol/Preview"
REGEX_HELP_URL = "http://docs.python.org/3/library/re.html#regular-expression-syntax"
WIKI_URL = "http://wiki.gnome.org/Apps/Gaupol"
