/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.logging.Logger;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.AbstractCanvasListener;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;

public final class CanvasMouseMotionListener
extends AbstractCanvasListener
implements MouseMotionListener {
    private static final Logger logger = Logger.getLogger(CanvasMouseMotionListener.class.getName());
    private static final int DRAG_THRESHOLD = 16;
    private Tile lastTile;

    public CanvasMouseMotionListener(FreeColClient freeColClient, Canvas canvas) {
        super(freeColClient, canvas);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (e.getY() >= 1) {
            this.performAutoScrollIfActive(e);
        }
        if (this.canvas.isGotoStarted()) {
            Tile tile;
            if (this.canvas.getActiveUnit() == null) {
                this.canvas.stopGoto();
            }
            if ((tile = this.canvas.convertToMapTile(e.getX(), e.getY())) != null && this.lastTile != tile) {
                Unit active = this.canvas.getActiveUnit();
                this.lastTile = tile;
                if (active != null && active.getTile() != tile) {
                    PathNode dragPath = active.findPath(tile);
                    this.canvas.setGotoPath(dragPath);
                } else {
                    this.canvas.setGotoPath(null);
                }
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.performDragScrollIfActive(e);
        Tile tile = this.canvas.convertToMapTile(e.getX(), e.getY());
        if (tile != null && (e.getModifiers() & 0x10) == 16) {
            if (this.canvas.isGotoStarted()) {
                Unit active = this.canvas.getActiveUnit();
                if (active == null) {
                    this.canvas.stopGoto();
                } else if (this.lastTile != tile) {
                    this.lastTile = tile;
                    PathNode dragPath = active.findPath(tile);
                    this.canvas.setGotoPath(dragPath);
                }
            } else {
                Point dragPoint = this.canvas.getDragPoint();
                int deltaX = Math.abs(e.getX() - dragPoint.x);
                int deltaY = Math.abs(e.getY() - dragPoint.y);
                if (deltaX >= 16 || deltaY >= 16) {
                    this.canvas.startGoto();
                }
            }
        }
    }
}

