/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.io.FreeColModFile;
import net.sf.freecol.common.io.FreeColTcFile;
import net.sf.freecol.common.util.LogBuilder;

public class Mods {
    private static final Logger logger = Logger.getLogger(Mods.class.getName());
    private static final Map<String, FreeColModFile> allMods = new HashMap<String, FreeColModFile>();

    private static void loadModDirectory(File directory) {
        if (directory != null && directory.isDirectory()) {
            LogBuilder lb = new LogBuilder(64);
            lb.add("In ", directory.getPath(), " found mod:");
            lb.mark();
            for (File f : directory.listFiles(FreeColModFile.getFileFilter())) {
                try {
                    FreeColModFile fcmf = new FreeColModFile(f);
                    allMods.put(fcmf.getId(), fcmf);
                    lb.add(" ", fcmf.getId());
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Bad mod in " + f.getPath(), e);
                }
            }
            if (lb.grew(new Object[0])) {
                lb.log(logger, Level.INFO);
            }
        }
    }

    public static void loadMods() {
        Mods.loadModDirectory(FreeColDirectories.getStandardModsDirectory());
        Mods.loadModDirectory(FreeColDirectories.getUserModsDirectory());
    }

    public static FreeColModFile getModFile(String id) {
        return allMods.get(id);
    }

    public static Collection<FreeColModFile> getAllMods() {
        return allMods.values();
    }

    public static FreeColModFile getFreeColModFile(String id) {
        return allMods.get(id);
    }

    public static List<FreeColTcFile> getRuleSets() {
        ArrayList<FreeColTcFile> result = new ArrayList<FreeColTcFile>();
        File directory = FreeColDirectories.getRulesDirectory();
        for (File f : directory.listFiles(FreeColTcFile.getFileFilter())) {
            try {
                result.add(new FreeColTcFile(f));
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, "Failed to load rule set " + f, ioe);
            }
        }
        return result;
    }
}

