/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import java.util.Objects;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.TransformNodesCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.I18n;

public class ScaleCommand
extends TransformNodesCommand {
    private final EastNorth pivot = this.getNodesCenter();
    private double scalingFactor;
    private final EastNorth startEN;

    public ScaleCommand(Collection<OsmPrimitive> collection, EastNorth eastNorth) {
        super(collection);
        this.startEN = eastNorth;
        this.handleEvent(eastNorth);
    }

    @Override
    public final void handleEvent(EastNorth eastNorth) {
        double d = Math.atan2(this.startEN.east() - this.pivot.east(), this.startEN.north() - this.pivot.north());
        double d2 = Math.atan2(eastNorth.east() - this.pivot.east(), eastNorth.north() - this.pivot.north());
        double d3 = this.pivot.distance(this.startEN);
        double d4 = this.pivot.distance(eastNorth);
        this.scalingFactor = Math.cos(d - d2) * d4 / d3;
        this.transformNodes();
    }

    @Override
    protected void transformNodes() {
        for (Node node : this.nodes) {
            EastNorth eastNorth = ((Command.OldNodeState)this.oldStates.get(node)).getEastNorth();
            double d = eastNorth.east() - this.pivot.east();
            double d2 = eastNorth.north() - this.pivot.north();
            double d3 = this.pivot.east() + this.scalingFactor * d;
            double d4 = this.pivot.north() + this.scalingFactor * d2;
            node.setEastNorth(new EastNorth(d3, d4));
        }
    }

    @Override
    public String getDescriptionText() {
        return I18n.trn("Scale {0} node", "Scale {0} nodes", this.nodes.size(), this.nodes.size());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.pivot, this.scalingFactor, this.startEN);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        ScaleCommand scaleCommand = (ScaleCommand)object;
        return Double.compare(scaleCommand.scalingFactor, this.scalingFactor) == 0 && Objects.equals(this.pivot, scaleCommand.pivot) && Objects.equals(this.startEN, scaleCommand.startEN);
    }
}

