/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.preferences.CollectionProperty;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Predicates;
import org.openstreetmap.josm.tools.Utils;

public class OverlappingWays
extends Test {
    private MultiMap<Pair<Node, Node>, WaySegment> nodePairs;
    protected static final int OVERLAPPING_HIGHWAY = 101;
    protected static final int OVERLAPPING_RAILWAY = 102;
    protected static final int OVERLAPPING_WAY = 103;
    protected static final int OVERLAPPING_HIGHWAY_AREA = 111;
    protected static final int OVERLAPPING_RAILWAY_AREA = 112;
    protected static final int OVERLAPPING_WAY_AREA = 113;
    protected static final int OVERLAPPING_AREA = 120;
    protected static final int DUPLICATE_WAY_SEGMENT = 121;
    protected static final CollectionProperty IGNORED_KEYS = new CollectionProperty("overlapping-ways.ignored-keys", (Collection<String>)Arrays.asList("barrier", "building", "historic:building", "man_made"));

    public OverlappingWays() {
        super(I18n.tr("Overlapping ways", new Object[0]), I18n.tr("This test checks that a connection between two nodes is not used by more than one way.", new Object[0]));
    }

    @Override
    public void startTest(ProgressMonitor progressMonitor) {
        super.startTest(progressMonitor);
        this.nodePairs = new MultiMap(1000);
    }

    private static boolean parentMultipolygonConcernsArea(OsmPrimitive osmPrimitive) {
        for (Relation relation : OsmPrimitive.getFilteredList(osmPrimitive.getReferrers(), Relation.class)) {
            if (!relation.concernsArea()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void endTest() {
        Object object;
        Object object2;
        int n;
        HashMap<Object, Set<WaySegment>> hashMap = new HashMap<Object, Set<WaySegment>>(500);
        ArrayList<TestError> arrayList = new ArrayList<TestError>();
        for (Set<WaySegment> object3 : this.nodePairs.values()) {
            n = object3.size();
            if (n <= 1) continue;
            object2 = new ArrayList();
            object = new ArrayList();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            for (WaySegment waySegment : object3) {
                if (waySegment.way.get("highway") != null) {
                    ++n2;
                } else if (waySegment.way.get("railway") != null) {
                    ++n3;
                }
                Boolean bl = OsmUtils.getOsmBoolean(waySegment.way.get("area"));
                if (bl != null && bl.booleanValue()) {
                    ++n4;
                }
                if (waySegment.way.concernsArea() || OverlappingWays.parentMultipolygonConcernsArea(waySegment.way)) {
                    ++n4;
                    --n;
                }
                object2.add(waySegment.way);
                object.add(waySegment.way);
            }
            Collection collection = (Collection)hashMap.get(object);
            if (collection == null) {
                int n5;
                Object object4;
                if (n4 > 0) {
                    if (n == 0 || object3.size() == n4) {
                        object4 = I18n.tr("Areas share segment", new Object[0]);
                        n5 = 120;
                    } else if (n2 == n) {
                        object4 = I18n.tr("Highways share segment with area", new Object[0]);
                        n5 = 111;
                    } else if (n3 == n) {
                        object4 = I18n.tr("Railways share segment with area", new Object[0]);
                        n5 = 112;
                    } else {
                        object4 = I18n.tr("Ways share segment with area", new Object[0]);
                        n5 = 113;
                    }
                } else if (n2 == n) {
                    object4 = I18n.tr("Overlapping highways", new Object[0]);
                    n5 = 101;
                } else if (n3 == n) {
                    object4 = I18n.tr("Overlapping railways", new Object[0]);
                    n5 = 102;
                } else {
                    object4 = I18n.tr("Overlapping ways", new Object[0]);
                    n5 = 103;
                }
                arrayList.add(new TestError(this, n5 < 111 ? Severity.WARNING : Severity.OTHER, (String)object4, n5, (Collection<? extends OsmPrimitive>)object2, object3));
                hashMap.put(object, object3);
                continue;
            }
            collection.addAll(object3);
        }
        for (TestError testError : arrayList) {
            if (!testError.getSeverity().equals((Object)Severity.WARNING) && testError.getHighlighted().size() / testError.getPrimitives().size() < 3) continue;
            n = 0;
            object2 = IGNORED_KEYS.get().iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                if (!Utils.exists(testError.getPrimitives(), Predicates.hasKey((String)object))) continue;
                n = 1;
                break;
            }
            if (n != 0) continue;
            this.errors.add(testError);
        }
        super.endTest();
        this.nodePairs = null;
    }

    protected static Set<WaySegment> checkDuplicateWaySegment(Way way) {
        TreeSet<WaySegment> treeSet = new TreeSet<WaySegment>(new Comparator<WaySegment>(){

            @Override
            public int compare(WaySegment waySegment, WaySegment waySegment2) {
                List<Node> list = Arrays.asList(waySegment.getFirstNode(), waySegment.getSecondNode());
                List<Node> list2 = Arrays.asList(waySegment2.getFirstNode(), waySegment2.getSecondNode());
                Collections.sort(list);
                Collections.sort(list2);
                int n = list.get(0).compareTo(list2.get(0));
                int n2 = list.get(1).compareTo(list2.get(1));
                return n != 0 ? n : n2;
            }
        });
        HashSet<WaySegment> hashSet = new HashSet<WaySegment>();
        for (int i = 0; i < way.getNodesCount() - 1; ++i) {
            boolean bl;
            WaySegment waySegment = new WaySegment(way, i);
            boolean bl2 = bl = !treeSet.add(waySegment);
            if (!bl) continue;
            hashSet.add(waySegment);
        }
        if (hashSet.size() > 1) {
            return hashSet;
        }
        return null;
    }

    @Override
    public void visit(Way way) {
        Set<WaySegment> set = OverlappingWays.checkDuplicateWaySegment(way);
        if (set != null) {
            this.errors.add(new TestError(this, Severity.ERROR, I18n.tr("Way contains segment twice", new Object[0]), 121, Collections.singleton(way), set));
            return;
        }
        Node node = null;
        int n = -2;
        for (Node node2 : way.getNodes()) {
            ++n;
            if (node == null) {
                node = node2;
                continue;
            }
            this.nodePairs.put(Pair.sort(new Pair<Node, Node>(node, node2)), new WaySegment(way, n));
            node = node2;
        }
    }
}

