/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset;

import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.date.DateUtils;

public abstract class AbstractCellRenderer
extends JLabel
implements TableCellRenderer {
    protected void reset(JComponent jComponent, boolean bl) {
        jComponent.setBackground(UIManager.getColor("Table.background"));
        jComponent.setForeground(UIManager.getColor("Table.foreground"));
        if (bl) {
            jComponent.setFont(UIManager.getFont("Table.font"));
        }
        jComponent.setToolTipText(null);
        jComponent.setOpaque(true);
    }

    protected void reset() {
        this.reset(this, true);
    }

    protected void renderColors(JComponent jComponent, boolean bl) {
        if (bl) {
            jComponent.setBackground(UIManager.getColor("Table.selectionBackground"));
            jComponent.setForeground(UIManager.getColor("Table.selectionForeground"));
        } else {
            jComponent.setBackground(UIManager.getColor("Table.background"));
            jComponent.setForeground(UIManager.getColor("Table.foreground"));
        }
    }

    protected void renderColors(boolean bl) {
        this.renderColors(this, bl);
    }

    protected void renderId(long l) {
        this.setText(Long.toString(l));
        this.setToolTipText(null);
    }

    protected void renderUser(User user) {
        if (user == null || user.getName().trim().isEmpty()) {
            this.setFont(UIManager.getFont("Table.font").deriveFont(2));
            this.setText(I18n.tr("anonymous", new Object[0]));
        } else {
            this.setFont(UIManager.getFont("Table.font"));
            this.setText(user.getName());
            this.setToolTipText(user.getName());
        }
    }

    protected void renderDate(Date date) {
        if (date == null) {
            this.setText("");
        } else {
            this.setText(DateUtils.formatDateTime(date, 3, 3));
        }
        this.setToolTipText(null);
    }
}

