/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets.items;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetType;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.xml.sax.SAXException;

public class Roles
extends TaggingPresetItem {
    public final List<Role> roles = new LinkedList<Role>();

    @Override
    public boolean addToPanel(JPanel jPanel, Collection<OsmPrimitive> collection, boolean bl) {
        jPanel.add((Component)new JLabel(" "), GBC.eol());
        if (!this.roles.isEmpty()) {
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            jPanel2.add((Component)new JLabel(I18n.tr("Available roles", new Object[0])), GBC.std().insets(0, 0, 10, 0));
            jPanel2.add((Component)new JLabel(I18n.tr("role", new Object[0])), GBC.std().insets(0, 0, 10, 0));
            jPanel2.add((Component)new JLabel(I18n.tr("count", new Object[0])), GBC.std().insets(0, 0, 10, 0));
            jPanel2.add((Component)new JLabel(I18n.tr("elements", new Object[0])), GBC.eol());
            for (Role role : this.roles) {
                role.addToPanel(jPanel2);
            }
            jPanel.add((Component)jPanel2, GBC.eol());
        }
        return false;
    }

    @Override
    public void addCommands(List<Tag> list) {
    }

    public static class Role {
        public Set<TaggingPresetType> types;
        public String key;
        public String text;
        public String text_context;
        public String locale_text;
        public SearchCompiler.Match memberExpression;
        public boolean required;
        private long count;

        public void setType(String string) throws SAXException {
            this.types = Roles.getType(string);
        }

        public void setRequisite(String string) throws SAXException {
            if ("required".equals(string)) {
                this.required = true;
            } else if (!"optional".equals(string)) {
                throw new SAXException(I18n.tr("Unknown requisite: {0}", string));
            }
        }

        public void setMember_expression(String string) throws SAXException {
            try {
                SearchAction.SearchSetting searchSetting = new SearchAction.SearchSetting();
                searchSetting.text = string;
                searchSetting.caseSensitive = true;
                searchSetting.regexSearch = true;
                this.memberExpression = SearchCompiler.compile(searchSetting);
            }
            catch (SearchCompiler.ParseError parseError) {
                throw new SAXException(I18n.tr("Illegal member expression: {0}", parseError.getMessage()), parseError);
            }
        }

        public void setCount(String string) {
            this.count = Long.parseLong(string);
        }

        public long getValidCount(long l) {
            if (this.count > 0L && !this.required) {
                return l != 0L ? this.count : 0L;
            }
            if (this.count > 0L) {
                return this.count;
            }
            if (!this.required) {
                return l != 0L ? l : 0L;
            }
            return l != 0L ? l : 1L;
        }

        public boolean addToPanel(JPanel jPanel) {
            String string = this.count > 0L && !this.required ? "0," + this.count : (this.count > 0L ? String.valueOf(this.count) : (!this.required ? "0-..." : "1-..."));
            if (this.locale_text == null) {
                this.locale_text = Roles.getLocaleText(this.text, this.text_context, null);
            }
            jPanel.add((Component)new JLabel(this.locale_text + ':'), GBC.std().insets(0, 0, 10, 0));
            jPanel.add((Component)new JLabel(this.key), GBC.std().insets(0, 0, 10, 0));
            jPanel.add((Component)new JLabel(string), this.types == null ? GBC.eol() : GBC.std().insets(0, 0, 10, 0));
            if (this.types != null) {
                JPanel jPanel2 = new JPanel();
                for (TaggingPresetType taggingPresetType : this.types) {
                    jPanel2.add(new JLabel(ImageProvider.get(taggingPresetType.getIconName())));
                }
                jPanel.add((Component)jPanel2, GBC.eol());
            }
            return true;
        }
    }
}

