/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumnModel;
import org.openstreetmap.josm.actions.ZoomToAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.widgets.JosmTable;
import org.openstreetmap.josm.gui.widgets.OsmPrimitivesTableModel;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;

public abstract class OsmPrimitivesTable
extends JosmTable {
    private transient OsmDataLayer layer;
    private JPopupMenu popupMenu;
    private ZoomToAction zoomToAction;

    public OsmPrimitivesTable(OsmPrimitivesTableModel osmPrimitivesTableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(osmPrimitivesTableModel, tableColumnModel, listSelectionModel);
        this.addMouseListener(new PopupMenuLauncher(this.getPopUpMenu()));
        this.addMouseListener(new DblClickHandler());
    }

    public OsmPrimitivesTableModel getOsmPrimitivesTableModel() {
        return (OsmPrimitivesTableModel)this.getModel();
    }

    public final OsmDataLayer getLayer() {
        return this.layer;
    }

    public final void setLayer(OsmDataLayer osmDataLayer) {
        this.layer = osmDataLayer;
    }

    protected final JPopupMenu getPopUpMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = this.buildPopupMenu();
        }
        return this.popupMenu;
    }

    protected abstract ZoomToAction buildZoomToAction();

    protected JPopupMenu buildPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.zoomToAction = this.buildZoomToAction();
        MapView.addLayerChangeListener(this.zoomToAction);
        this.getSelectionModel().addListSelectionListener(this.zoomToAction);
        jPopupMenu.add(this.zoomToAction);
        return jPopupMenu;
    }

    public void unlinkAsListener() {
        MapView.removeLayerChangeListener(this.zoomToAction);
    }

    public OsmPrimitive getPrimitiveInLayer(int n, OsmDataLayer osmDataLayer) {
        return this.getOsmPrimitivesTableModel().getReferredPrimitive(n);
    }

    protected class DblClickHandler
    extends MouseAdapter {
        protected DblClickHandler() {
        }

        protected void setSelection(MouseEvent mouseEvent) {
            int n = OsmPrimitivesTable.this.rowAtPoint(mouseEvent.getPoint());
            if (n < 0) {
                return;
            }
            OsmPrimitive osmPrimitive = OsmPrimitivesTable.this.getPrimitiveInLayer(n, OsmPrimitivesTable.this.layer);
            if (OsmPrimitivesTable.this.layer != null && osmPrimitive != null) {
                ((OsmPrimitivesTable)OsmPrimitivesTable.this).layer.data.setSelected(osmPrimitive.getPrimitiveId());
            }
        }

        protected void addSelection(MouseEvent mouseEvent) {
            int n = OsmPrimitivesTable.this.rowAtPoint(mouseEvent.getPoint());
            if (n < 0) {
                return;
            }
            OsmPrimitive osmPrimitive = OsmPrimitivesTable.this.getPrimitiveInLayer(n, OsmPrimitivesTable.this.layer);
            OsmPrimitivesTable.this.getSelectionModel().addSelectionInterval(n, n);
            if (OsmPrimitivesTable.this.layer != null && osmPrimitive != null) {
                ((OsmPrimitivesTable)OsmPrimitivesTable.this).layer.data.addSelected(osmPrimitive.getPrimitiveId());
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() > 1) {
                if (mouseEvent.isControlDown()) {
                    this.addSelection(mouseEvent);
                } else {
                    this.setSelection(mouseEvent);
                }
            }
        }
    }
}

