/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol;

import java.io.File;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.io.remotecontrol.RemoteControlHttpServer;
import org.openstreetmap.josm.io.remotecontrol.RemoteControlHttpsServer;
import org.openstreetmap.josm.io.remotecontrol.RequestProcessor;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;

public class RemoteControl {
    public static final BooleanProperty PROP_REMOTECONTROL_ENABLED = new BooleanProperty("remotecontrol.enabled", false);
    public static final BooleanProperty PROP_REMOTECONTROL_HTTPS_ENABLED = new BooleanProperty("remotecontrol.https.enabled", false);
    static final int protocolMajorVersion = 1;
    static final int protocolMinorVersion = 7;

    public static void start() {
        RemoteControlHttpServer.restartRemoteControlHttpServer();
        RemoteControlHttpsServer.restartRemoteControlHttpsServer();
    }

    public static void stop() {
        RemoteControlHttpServer.stopRemoteControlHttpServer();
        RemoteControlHttpsServer.stopRemoteControlHttpsServer();
    }

    public void addRequestHandler(String string, Class<? extends RequestHandler> clazz) {
        RequestProcessor.addRequestHandlerClass(string, clazz);
    }

    public static String getRemoteControlDir() {
        return new File(Main.pref.getUserDataDirectory(), "remotecontrol").getAbsolutePath();
    }

    public static InetAddress getInet6Address() throws UnknownHostException {
        for (InetAddress inetAddress : InetAddress.getAllByName(Main.pref.get("remote.control.host.ipv6", "::1"))) {
            if (!(inetAddress instanceof Inet6Address)) continue;
            return inetAddress;
        }
        throw new UnknownHostException();
    }

    public static InetAddress getInet4Address() throws UnknownHostException {
        for (InetAddress inetAddress : InetAddress.getAllByName(Main.pref.get("remote.control.host.ipv4", "127.0.0.1"))) {
            if (!(inetAddress instanceof Inet4Address)) continue;
            return inetAddress;
        }
        throw new UnknownHostException();
    }
}

