/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.factories.report.flow;

import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.jfree.report.JFreeReport;
import org.jfree.report.modules.factories.data.base.DataFactoryReadHandler;
import org.jfree.report.modules.factories.data.base.DataFactoryReadHandlerFactory;
import org.jfree.report.modules.factories.report.flow.SectionReadHandler;
import org.jfree.report.modules.factories.report.flow.StyleSheetReadHandler;
import org.jfree.report.structure.Element;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.PropertiesReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.StringReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ReportReadHandler
extends SectionReadHandler {
    private StringReadHandler queryReadHandler;
    private PropertiesReadHandler propertiesReadHandler;
    private DataFactoryReadHandler datasourceFactoryReadHandler;
    private ArrayList styleSheetReadHandlers;
    private JFreeReport report = new JFreeReport();

    public ReportReadHandler() {
        this.styleSheetReadHandlers = new ArrayList();
    }

    protected XmlReadHandler getHandlerForChild(String string, String string2, Attributes attributes) throws SAXException {
        XmlReadHandler xmlReadHandler = super.getHandlerForChild(string, string2, attributes);
        if (xmlReadHandler != null) {
            return xmlReadHandler;
        }
        DataFactoryReadHandlerFactory dataFactoryReadHandlerFactory = DataFactoryReadHandlerFactory.getInstance();
        DataFactoryReadHandler dataFactoryReadHandler = (DataFactoryReadHandler)dataFactoryReadHandlerFactory.getHandler(string, string2);
        if (dataFactoryReadHandler != null) {
            this.datasourceFactoryReadHandler = dataFactoryReadHandler;
            return dataFactoryReadHandler;
        }
        if ("http://jfreereport.sourceforge.net/namespaces/reports/flow".equals(string)) {
            if ("query".equals(string2)) {
                this.queryReadHandler = new StringReadHandler();
                return this.queryReadHandler;
            }
            if ("configuration".equals(string2)) {
                this.propertiesReadHandler = new PropertiesReadHandler();
                return this.propertiesReadHandler;
            }
            if ("stylesheet".equals(string2)) {
                StyleSheetReadHandler styleSheetReadHandler = new StyleSheetReadHandler();
                this.styleSheetReadHandlers.add(styleSheetReadHandler);
                return styleSheetReadHandler;
            }
            if ("inline-stylesheet".equals(string2)) {
                StyleSheetReadHandler styleSheetReadHandler = new StyleSheetReadHandler();
                this.styleSheetReadHandlers.add(styleSheetReadHandler);
                return styleSheetReadHandler;
            }
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        if (this.queryReadHandler == null) {
            throw new ParseException("Required element 'query' is missing.", this.getLocator());
        }
        super.doneParsing();
        JFreeReport jFreeReport = (JFreeReport)this.getElement();
        jFreeReport.setQuery(this.queryReadHandler.getResult());
        if (this.propertiesReadHandler != null) {
            Properties properties = this.propertiesReadHandler.getResult();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                jFreeReport.getEditableConfiguration().setConfigProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.datasourceFactoryReadHandler != null) {
            jFreeReport.setDataFactory(this.datasourceFactoryReadHandler.getDataFactory());
        }
        for (int i = 0; i < this.styleSheetReadHandlers.size(); ++i) {
            StyleSheetReadHandler styleSheetReadHandler = (StyleSheetReadHandler)((Object)this.styleSheetReadHandlers.get(i));
            jFreeReport.addStyleSheet(styleSheetReadHandler.getStyleSheet());
        }
    }

    protected Element getElement() {
        return this.report;
    }
}

