// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IGESSolid_Loop_HeaderFile
#define _IGESSolid_Loop_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_IGESSolid_Loop.hxx>

#include <Handle_TColStd_HArray1OfInteger.hxx>
#include <Handle_IGESData_HArray1OfIGESEntity.hxx>
#include <Handle_IGESBasic_HArray1OfHArray1OfInteger.hxx>
#include <Handle_IGESBasic_HArray1OfHArray1OfIGESEntity.hxx>
#include <IGESData_IGESEntity.hxx>
#include <Standard_Boolean.hxx>
#include <Standard_Integer.hxx>
#include <Handle_IGESData_IGESEntity.hxx>
class TColStd_HArray1OfInteger;
class IGESData_HArray1OfIGESEntity;
class IGESBasic_HArray1OfHArray1OfInteger;
class IGESBasic_HArray1OfHArray1OfIGESEntity;
class Standard_DimensionMismatch;
class Standard_OutOfRange;
class IGESData_IGESEntity;


//! defines Loop, Type <508> Form Number <1>
//! in package IGESSolid
//! A Loop entity specifies a bound of a face. It represents
//! a connected collection of face boundaries, seams, and
//! poles of a single face.
//!
//! From IGES-5.3, a Loop can be free with Form Number 0,
//! else it is a bound of a face (it is the default)
class IGESSolid_Loop : public IGESData_IGESEntity
{

public:

  
  Standard_EXPORT IGESSolid_Loop();
  
  //! This method is used to set the fields of the class Loop
  //! - types              : 0 = Edge; 1 = Vertex
  //! - edges              : Pointer to the EdgeList or VertexList
  //! - index              : Index of the edge into the EdgeList
  //! VertexList entity
  //! - orient             : Orientation flag of the edge
  //! - nbParameterCurves  : the number of parameter space curves
  //! for each edge
  //! - isoparametricFlags : the isoparametric flag of the
  //! parameter space curve
  //! - curves             : the parameter space curves
  //! raises exception if length of types, edges, index, orient and
  //! nbParameterCurves do not match or the length of
  //! isoparametricFlags and curves do not match
  Standard_EXPORT   void Init (const Handle(TColStd_HArray1OfInteger)& types, const Handle(IGESData_HArray1OfIGESEntity)& edges, const Handle(TColStd_HArray1OfInteger)& index, const Handle(TColStd_HArray1OfInteger)& orient, const Handle(TColStd_HArray1OfInteger)& nbParameterCurves, const Handle(IGESBasic_HArray1OfHArray1OfInteger)& isoparametricFlags, const Handle(IGESBasic_HArray1OfHArray1OfIGESEntity)& curves) ;
  
  //! Tells if a Loop is a Bound (FN 1) else it is free (FN 0)
  Standard_EXPORT   Standard_Boolean IsBound()  const;
  
  //! Sets or Unset the Bound Status (from Form Number)
  //! Default is True
  Standard_EXPORT   void SetBound (const Standard_Boolean bound) ;
  
  //! returns the number of edge tuples
  Standard_EXPORT   Standard_Integer NbEdges()  const;
  
  //! returns the type of Index'th edge (0 = Edge, 1 = Vertex)
  //! raises exception if Index <= 0 or Index > NbEdges()
  Standard_EXPORT   Standard_Integer EdgeType (const Standard_Integer Index)  const;
  
  //! return the EdgeList or VertexList corresponding to the Index
  //! raises exception if Index <= 0 or Index > NbEdges()
  Standard_EXPORT   Handle(IGESData_IGESEntity) Edge (const Standard_Integer Index)  const;
  
  //! returns the orientation flag corresponding to Index'th edge
  //! raises exception if Index <= 0 or Index > NbEdges()
  Standard_EXPORT   Standard_Boolean Orientation (const Standard_Integer Index)  const;
  
  //! return the number of parameter space curves associated with
  //! Index'th Edge
  //! raises exception if Index <= 0 or Index > NbEdges()
  Standard_EXPORT   Standard_Integer NbParameterCurves (const Standard_Integer Index)  const;
  
  Standard_EXPORT   Standard_Boolean IsIsoparametric (const Standard_Integer EdgeIndex, const Standard_Integer CurveIndex)  const;
  
  //! returns the CurveIndex'th parameter space curve associated with
  //! EdgeIndex'th edge
  //! raises exception if EdgeIndex <= 0 or EdgeIndex > NbEdges() or
  //! if CurveIndex <= 0 or CurveIndex > NbParameterCurves(EdgeIndex)
  Standard_EXPORT   Handle(IGESData_IGESEntity) ParametricCurve (const Standard_Integer EdgeIndex, const Standard_Integer CurveIndex)  const;
  
  //! raises exception If num <= 0 or num > NbEdges()
  Standard_EXPORT   Standard_Integer ListIndex (const Standard_Integer num)  const;




  DEFINE_STANDARD_RTTI(IGESSolid_Loop)

protected:




private: 


  Handle(TColStd_HArray1OfInteger) theTypes;
  Handle(IGESData_HArray1OfIGESEntity) theEdges;
  Handle(TColStd_HArray1OfInteger) theIndex;
  Handle(TColStd_HArray1OfInteger) theOrientationFlags;
  Handle(TColStd_HArray1OfInteger) theNbParameterCurves;
  Handle(IGESBasic_HArray1OfHArray1OfInteger) theIsoparametricFlags;
  Handle(IGESBasic_HArray1OfHArray1OfIGESEntity) theCurves;


};







#endif // _IGESSolid_Loop_HeaderFile
