/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util.logging;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.swing.text.html.HTMLDocument;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.logging.ConsoleOutputPaneModel;
import net.sourceforge.jnlp.util.logging.LogConfig;
import net.sourceforge.jnlp.util.logging.OutputController;
import net.sourceforge.jnlp.util.logging.headers.ObservableMessagesProvider;

public class ConsoleOutputPane
extends JPanel
implements Observer {
    private boolean canChange = true;
    private final ConsoleOutputPaneModel model;
    private int lastPostion;
    private final DefaultHighlighter.DefaultHighlightPainter searchHighligh = new DefaultHighlighter.DefaultHighlightPainter(Color.blue);
    private Object lastSearchTag;
    final ActionListener defaultActionSingleton = this.createDefaultAction();
    private final AtomicBoolean done = new AtomicBoolean(true);
    private final JButton apply;
    private final JCheckBox autorefresh;
    private final JCheckBox caseSensitive;
    private final JButton copyPlain;
    private final JButton copyRich;
    private final JCheckBox highLight;
    private final JEditorPane jEditorPane1;
    private final JScrollPane jpanel2scrollpane;
    private final JPanel jPanel2;
    private final JScrollPane jScrollPane1;
    private final JCheckBox mark;
    private final JRadioButton match;
    private final JButton next;
    private final JRadioButton notMatch;
    private final JButton previous;
    private final JButton refresh;
    private final JTextField regExFilter;
    private final JCheckBox regExLabel;
    private final JCheckBox revertSort;
    private final JTextField search;
    private final JLabel searchLabel;
    private final JCheckBox showCode;
    private final JCheckBox showComplete;
    private final JCheckBox showDate;
    private final JCheckBox showDebug;
    private final JCheckBox showErr;
    private final JCheckBox showHeaders;
    private final JButton showHide;
    private final JCheckBox showIncomplete;
    private final JCheckBox showInfo;
    private final JCheckBox showItw;
    private final JCheckBox showApp;
    private final JCheckBox showJava;
    private final JCheckBox showLevel;
    private final JCheckBox showMessage;
    private final JCheckBox showOrigin;
    private final JCheckBox showOut;
    private final JCheckBox showPlugin;
    private final JCheckBox showPostInit;
    private final JCheckBox showPreInit;
    private final JCheckBox showThread1;
    private final JCheckBox showThread2;
    private final JCheckBox showUser;
    private final JCheckBox sortCopyAll;
    private final JComboBox<String> sortBy;
    private final JLabel sortByLabel;
    private final JLabel statistics;
    private final JCheckBox wordWrap;
    private final JPopupMenu insertChars;

    @Override
    public synchronized void update(Observable o, Object arg) {
        boolean force = false;
        if (arg instanceof Boolean && ((Boolean)arg).booleanValue()) {
            force = true;
        }
        if (force) {
            this.refreshPane();
            return;
        }
        if (!this.autorefresh.isSelected()) {
            this.statistics.setText(this.model.createStatisticHint());
            return;
        }
        boolean passed = this.model.shouldUpdate();
        if (!passed) {
            this.statistics.setText(this.model.createStatisticHint());
            return;
        }
        if (this.sortBy.getSelectedIndex() == 0) {
            this.updatePane(false);
        } else {
            this.refreshPane();
        }
    }

    public ConsoleOutputPane(ObservableMessagesProvider dataProvider) {
        this.model = new ConsoleOutputPaneModel(dataProvider);
        this.jPanel2 = new JPanel();
        this.jpanel2scrollpane = new JScrollPane(this.jPanel2);
        this.showHeaders = new JCheckBox();
        this.showUser = new JCheckBox();
        this.sortCopyAll = new JCheckBox();
        this.showOrigin = new JCheckBox();
        this.showLevel = new JCheckBox();
        this.showDate = new JCheckBox();
        this.showThread1 = new JCheckBox();
        this.showThread2 = new JCheckBox();
        this.showMessage = new JCheckBox();
        this.showOut = new JCheckBox();
        this.showErr = new JCheckBox();
        this.showJava = new JCheckBox();
        this.showPlugin = new JCheckBox();
        this.showPreInit = new JCheckBox();
        this.sortByLabel = new JLabel();
        this.regExLabel = new JCheckBox();
        this.sortBy = new JComboBox();
        this.searchLabel = new JLabel();
        this.autorefresh = new JCheckBox();
        this.refresh = new JButton();
        this.apply = new JButton();
        this.regExFilter = new JTextField();
        this.copyPlain = new JButton();
        this.copyRich = new JButton();
        this.next = new JButton();
        this.previous = new JButton();
        this.search = new JTextField();
        this.caseSensitive = new JCheckBox();
        this.showIncomplete = new JCheckBox();
        this.highLight = new JCheckBox();
        this.wordWrap = new JCheckBox();
        this.showDebug = new JCheckBox();
        this.showInfo = new JCheckBox();
        this.showItw = new JCheckBox();
        this.showApp = new JCheckBox();
        this.showCode = new JCheckBox();
        this.statistics = new JLabel();
        this.showPostInit = new JCheckBox();
        this.showComplete = new JCheckBox();
        this.match = new JRadioButton();
        this.notMatch = new JRadioButton();
        this.revertSort = new JCheckBox();
        this.mark = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.jEditorPane1 = new JTextPane();
        this.showHide = new JButton();
        this.insertChars = new JPopupMenu();
        this.initComponents();
        this.regExFilter.setText(ConsoleOutputPaneModel.defaultPattern.pattern());
        this.showHeaders.setSelected(LogConfig.getLogConfig().isEnableHeaders());
        this.setHeadersCheckBoxesEnabled(this.showHeaders.isSelected());
        this.setMessagesCheckBoxesEnabled(this.showMessage.isSelected());
        this.refresh.setEnabled(!this.autorefresh.isSelected());
        if (JNLPRuntime.isWebstartApplication()) {
            this.showPlugin.setSelected(false);
            this.showPreInit.setSelected(false);
            this.showPostInit.setSelected(false);
            this.showIncomplete.setSelected(false);
            this.showComplete.setSelected(false);
            this.showPlugin.setEnabled(false);
            this.showPreInit.setEnabled(false);
            this.showPostInit.setEnabled(false);
            this.showIncomplete.setEnabled(false);
            this.showComplete.setEnabled(false);
        }
        this.regExFilter.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public final void insertUpdate(DocumentEvent e) {
                this.colorize();
            }

            @Override
            public final void removeUpdate(DocumentEvent e) {
                this.colorize();
            }

            @Override
            public final void changedUpdate(DocumentEvent e) {
                this.colorize();
            }

            private final void colorize() {
                try {
                    Pattern p;
                    String s = ConsoleOutputPane.this.regExFilter.getText();
                    ((ConsoleOutputPane)ConsoleOutputPane.this).model.lastValidPattern = p = Pattern.compile(s);
                    ConsoleOutputPane.this.regExLabel.setForeground(Color.green);
                }
                catch (Exception ex) {
                    ConsoleOutputPane.this.regExLabel.setForeground(Color.red);
                }
            }
        });
        this.regExFilter.addMouseListener(new MouseAdapter(){

            @Override
            public final void mouseClicked(final MouseEvent e) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public final void run() {
                        try {
                            if (e.getButton() != 3) {
                                ConsoleOutputPane.this.insertChars.setVisible(false);
                                return;
                            }
                            ConsoleOutputPane.this.insertChars.setLocation(e.getXOnScreen(), e.getYOnScreen());
                            ConsoleOutputPane.this.insertChars.setVisible(!ConsoleOutputPane.this.insertChars.isVisible());
                        }
                        catch (Exception ex) {
                            OutputController.getLogger().log(ex);
                        }
                    }
                });
            }
        });
        this.regExFilter.addKeyListener(new KeyAdapter(){

            @Override
            public final void keyPressed(KeyEvent e) {
                if (e.getKeyCode() != 525) {
                    return;
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public final void run() {
                        try {
                            ConsoleOutputPane.this.insertChars.setLocation(ConsoleOutputPane.this.regExFilter.getLocationOnScreen());
                            ConsoleOutputPane.this.insertChars.setVisible(!ConsoleOutputPane.this.insertChars.isVisible());
                        }
                        catch (Exception ex) {
                            OutputController.getLogger().log(ex);
                        }
                    }
                });
            }
        });
        ButtonGroup matches = new ButtonGroup();
        matches.add(this.match);
        matches.add(this.notMatch);
        this.showHideActionPerformed(null);
        this.updateModel();
        this.refreshPane();
    }

    private final ActionListener createDefaultAction() {
        return new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent evt) {
                if (evt == null) {
                    return;
                }
                Object source = evt.getSource();
                if (source == ConsoleOutputPane.this.showHeaders) {
                    ConsoleOutputPane.this.setHeadersCheckBoxesEnabled(ConsoleOutputPane.this.showHeaders.isSelected());
                } else if (source == ConsoleOutputPane.this.showMessage) {
                    ConsoleOutputPane.this.setMessagesCheckBoxesEnabled(ConsoleOutputPane.this.showMessage.isSelected());
                } else if (source == ConsoleOutputPane.this.autorefresh) {
                    ConsoleOutputPane.this.refresh.setEnabled(!ConsoleOutputPane.this.autorefresh.isSelected());
                }
                ConsoleOutputPane.this.refreshAction();
            }
        };
    }

    private final ActionListener getDefaultActionSingleton() {
        return this.defaultActionSingleton;
    }

    private final synchronized void refreshPane() {
        if (this.highLight.isSelected()) {
            this.jEditorPane1.setContentType("text/html");
        } else {
            this.jEditorPane1.setContentType("text/plain");
        }
        this.model.lastUpdateIndex = 0;
        this.updatePane(true);
    }

    private final synchronized void updatePane(final boolean reset) {
        if (!this.done.get()) {
            return;
        }
        this.done.set(false);
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final void run() {
                try {
                    ConsoleOutputPane.this.refreshPaneBody(reset);
                }
                catch (Exception ex) {
                    OutputController.getLogger().log(ex);
                }
                finally {
                    ConsoleOutputPane.this.done.set(true);
                }
            }
        });
    }

    private final void refreshPaneBody(boolean reset) throws BadLocationException, IOException {
        if (reset) {
            this.jEditorPane1.setText(this.model.importList(0));
        } else {
            String s = this.model.importList();
            if (this.highLight.isSelected()) {
                HTMLDocument orig = (HTMLDocument)this.jEditorPane1.getDocument();
                if (this.revertSort.isSelected()) {
                    orig.insertAfterEnd(orig.getRootElements()[0].getElement(0), s);
                } else {
                    orig.insertBeforeEnd(orig.getRootElements()[0], s);
                }
            } else if (this.revertSort.isSelected()) {
                this.jEditorPane1.setText(s + this.jEditorPane1.getText());
            } else {
                this.jEditorPane1.setText(this.jEditorPane1.getText() + s);
            }
        }
        this.jEditorPane1.setCaretPosition(0);
        if (this.mark.isSelected()) {
            this.markActionPerformed(null);
        }
        this.statistics.setText(this.model.createStatisticHint());
    }

    private final void initComponents() {
        ((PlainDocument)this.regExFilter.getDocument()).getDocumentProperties().remove("filterNewlines");
        this.sortCopyAll.setSelected(true);
        this.sortCopyAll.setText(Translator.R("COPsortCopyAllDate"));
        this.sortCopyAll.setToolTipText("The sort by date is a bit more time consuming, but most natural for posting purposes");
        this.showHeaders.setSelected(true);
        this.showHeaders.setText(Translator.R("COPshowHeaders"));
        this.showHeaders.addActionListener(this.getDefaultActionSingleton());
        this.showUser.setSelected(true);
        this.showUser.setText(Translator.R("COPuser"));
        this.showUser.addActionListener(this.getDefaultActionSingleton());
        this.showOrigin.setSelected(true);
        this.showOrigin.setText(Translator.R("COPorigin"));
        this.showOrigin.addActionListener(this.getDefaultActionSingleton());
        this.showLevel.setSelected(true);
        this.showLevel.setText(Translator.R("COPlevel"));
        this.showLevel.addActionListener(this.getDefaultActionSingleton());
        this.showDate.setSelected(true);
        this.showDate.setText(Translator.R("COPdate"));
        this.showDate.addActionListener(this.getDefaultActionSingleton());
        this.showThread1.setSelected(true);
        this.showThread1.setText(Translator.R("COPthread1"));
        this.showThread1.addActionListener(this.getDefaultActionSingleton());
        this.showThread2.setSelected(true);
        this.showThread2.setText(Translator.R("COPthread2"));
        this.showThread2.addActionListener(this.getDefaultActionSingleton());
        this.showMessage.setSelected(true);
        this.showMessage.setText(Translator.R("COPShowMessages"));
        this.showMessage.addActionListener(this.getDefaultActionSingleton());
        this.showOut.setSelected(true);
        this.showOut.setText(Translator.R("COPstdOut"));
        this.showOut.addActionListener(this.getDefaultActionSingleton());
        this.showErr.setSelected(true);
        this.showErr.setText(Translator.R("COPstdErr"));
        this.showErr.addActionListener(this.getDefaultActionSingleton());
        this.showJava.setSelected(true);
        this.showJava.setText(Translator.R("COPjava"));
        this.showJava.addActionListener(this.getDefaultActionSingleton());
        this.showPlugin.setSelected(true);
        this.showPlugin.setText(Translator.R("COPplugin"));
        this.showPlugin.addActionListener(this.getDefaultActionSingleton());
        this.showPreInit.setSelected(true);
        this.showPreInit.setText(Translator.R("COPpreInit"));
        this.showPreInit.setToolTipText(Translator.R("COPpluginOnly"));
        this.showPreInit.addActionListener(this.getDefaultActionSingleton());
        this.sortByLabel.setText(Translator.R("COPSortBy") + ":");
        this.regExLabel.setText(Translator.R("COPregex") + ":");
        this.regExLabel.addActionListener(this.getDefaultActionSingleton());
        this.sortBy.setModel(new DefaultComboBoxModel<String>(new String[]{Translator.R("COPAsArrived"), Translator.R("COPuser"), Translator.R("COPorigin"), Translator.R("COPlevel"), Translator.R("COPdate"), Translator.R("COPcode"), Translator.R("COPthread1"), Translator.R("COPthread2"), Translator.R("COPmessage")}));
        this.sortBy.addActionListener(this.getDefaultActionSingleton());
        this.searchLabel.setText(Translator.R("COPSearch") + ":");
        this.autorefresh.setSelected(true);
        this.autorefresh.setText(Translator.R("COPautoRefresh"));
        this.autorefresh.addActionListener(this.getDefaultActionSingleton());
        this.refresh.setText(Translator.R("COPrefresh"));
        this.refresh.addActionListener(this.getDefaultActionSingleton());
        this.apply.setText(Translator.R("COPApply"));
        this.apply.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent evt) {
                ((ConsoleOutputPane)ConsoleOutputPane.this).model.usedPattern = ((ConsoleOutputPane)ConsoleOutputPane.this).model.lastValidPattern;
                ConsoleOutputPane.this.refreshAction();
            }
        });
        this.regExFilter.setText(".*");
        this.copyPlain.setText(Translator.R("COPCopyAllPlain"));
        this.copyPlain.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent evt) {
                ConsoleOutputPane.this.copyPlainActionPerformed(evt);
            }
        });
        this.copyRich.setText(Translator.R("COPCopyAllRich"));
        this.copyRich.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent evt) {
                ConsoleOutputPane.this.copyRichActionPerformed(evt);
            }
        });
        this.next.setText(Translator.R("COPnext"));
        this.next.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent evt) {
                ConsoleOutputPane.this.nextActionPerformed(evt);
            }
        });
        this.previous.setText(Translator.R("COPprevious"));
        this.previous.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent evt) {
                ConsoleOutputPane.this.previousActionPerformed(evt);
            }
        });
        this.caseSensitive.setText(Translator.R("COPcaseSensitive"));
        this.showIncomplete.setSelected(true);
        this.showIncomplete.setText(Translator.R("COPincomplete"));
        this.showIncomplete.setToolTipText(Translator.R("COPpluginOnly"));
        this.showIncomplete.addActionListener(this.getDefaultActionSingleton());
        this.highLight.setSelected(true);
        this.highLight.setText(Translator.R("COPhighlight"));
        this.highLight.addActionListener(this.getDefaultActionSingleton());
        this.wordWrap.setText(Translator.R("COPwordWrap"));
        this.wordWrap.addActionListener(this.getDefaultActionSingleton());
        this.showDebug.setSelected(true);
        this.showDebug.setText(Translator.R("COPdebug"));
        this.showDebug.addActionListener(this.getDefaultActionSingleton());
        this.showInfo.setSelected(true);
        this.showInfo.setText(Translator.R("COPinfo"));
        this.showInfo.addActionListener(this.getDefaultActionSingleton());
        this.showItw.setSelected(true);
        this.showItw.setText(Translator.R("COPitw"));
        this.showItw.addActionListener(this.getDefaultActionSingleton());
        this.showApp.setSelected(true);
        this.showApp.setText(Translator.R("COPclientApp"));
        this.showApp.addActionListener(this.getDefaultActionSingleton());
        this.showCode.setSelected(true);
        this.showCode.setText(Translator.R("COPcode"));
        this.showCode.addActionListener(this.getDefaultActionSingleton());
        this.statistics.setText("x/y");
        this.showPostInit.setSelected(true);
        this.showPostInit.setText(Translator.R("COPpostInit"));
        this.showPostInit.setToolTipText(Translator.R("COPpluginOnly"));
        this.showPostInit.addActionListener(this.getDefaultActionSingleton());
        this.showComplete.setSelected(true);
        this.showComplete.setText(Translator.R("COPcomplete"));
        this.showComplete.setToolTipText(Translator.R("COPpluginOnly"));
        this.showComplete.addActionListener(this.getDefaultActionSingleton());
        this.match.setSelected(true);
        this.match.setText(Translator.R("COPmatch"));
        this.match.addActionListener(this.getDefaultActionSingleton());
        this.notMatch.setText(Translator.R("COPnot"));
        this.notMatch.addActionListener(this.getDefaultActionSingleton());
        this.revertSort.setSelected(true);
        this.revertSort.setText(Translator.R("COPrevert"));
        this.revertSort.addActionListener(this.getDefaultActionSingleton());
        this.mark.setText(Translator.R("COPmark"));
        this.mark.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent evt) {
                ConsoleOutputPane.this.markActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.showHeaders).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showUser).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.showOrigin).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showLevel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.showDate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showCode).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showThread1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showThread2)).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addComponent(this.previous).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mark).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.next).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 15, Short.MAX_VALUE).addComponent(this.wordWrap).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.highLight).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sortCopyAll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.copyRich).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.copyPlain)).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addComponent(this.searchLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.search, -1, 438, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.caseSensitive)).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addComponent(this.showMessage).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showOut).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showErr).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showJava).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showPlugin).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showDebug).addGap(6, 6, 6).addComponent(this.showInfo).addGap(6, 6, 6).addComponent(this.showItw).addGap(6, 6, 6).addComponent(this.showApp))).addGap(2, 2, 2).addComponent(this.statistics)).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.showPreInit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showPostInit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showIncomplete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showComplete)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.autorefresh).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.refresh).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sortByLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.revertSort).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.sortBy, 0, 327, Short.MAX_VALUE)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.regExLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.match).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.notMatch).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.regExFilter, -1, 237, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.apply, -2, 106, -2))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.showHeaders).addComponent(this.showUser).addComponent(this.showLevel).addComponent(this.showDate).addComponent(this.showOrigin).addComponent(this.showCode).addComponent(this.showThread1).addComponent(this.showThread2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.showMessage).addComponent(this.showOut).addComponent(this.showErr).addComponent(this.showJava).addComponent(this.showPlugin).addComponent(this.showDebug).addComponent(this.showInfo).addComponent(this.showItw).addComponent(this.showApp).addComponent(this.statistics)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.showPreInit).addComponent(this.showIncomplete).addComponent(this.showPostInit).addComponent(this.showComplete)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(32, 32, 32).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.regExLabel).addComponent(this.regExFilter, -2, -1, -2).addComponent(this.apply).addComponent(this.match).addComponent(this.notMatch))).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.autorefresh).addComponent(this.refresh).addComponent(this.sortByLabel).addComponent(this.sortBy, -2, -1, -2).addComponent(this.revertSort))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.searchLabel).addComponent(this.search, -2, -1, -2)).addComponent(this.caseSensitive)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.previous).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sortCopyAll).addComponent(this.copyPlain).addComponent(this.copyRich).addComponent(this.highLight).addComponent(this.wordWrap)).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mark).addComponent(this.next))).addContainerGap(-1, Short.MAX_VALUE)));
        this.jEditorPane1.setEditable(false);
        this.jScrollPane1.setViewportView(this.jEditorPane1);
        this.showHide.setText(Translator.R("ButHideDetails"));
        this.showHide.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent evt) {
                ConsoleOutputPane.this.showHideActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this);
        super.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 684, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.showHide, GroupLayout.Alignment.LEADING, -1, 672, Short.MAX_VALUE).addComponent(this.jpanel2scrollpane, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 329, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jpanel2scrollpane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showHide).addContainerGap()));
        JMenuItem tab = new JMenuItem("insert \\t");
        tab.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public final void run() {
                        try {
                            int i = ConsoleOutputPane.this.regExFilter.getCaretPosition();
                            StringBuilder s = new StringBuilder(ConsoleOutputPane.this.regExFilter.getText());
                            s.insert(i, "\t");
                            ConsoleOutputPane.this.regExFilter.setText(s.toString());
                            ConsoleOutputPane.this.regExFilter.setCaretPosition(i + 1);
                            ConsoleOutputPane.this.insertChars.setVisible(false);
                        }
                        catch (Exception ex) {
                            OutputController.getLogger().log(ex);
                        }
                    }
                });
            }
        });
        JMenuItem newLine = new JMenuItem("insert \\n");
        newLine.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public final void run() {
                        try {
                            int i = ConsoleOutputPane.this.regExFilter.getCaretPosition();
                            StringBuilder s = new StringBuilder(ConsoleOutputPane.this.regExFilter.getText());
                            s.insert(i, "\n");
                            ConsoleOutputPane.this.regExFilter.setText(s.toString());
                            ConsoleOutputPane.this.regExFilter.setCaretPosition(i + 1);
                            ConsoleOutputPane.this.insertChars.setVisible(false);
                        }
                        catch (Exception ex) {
                            OutputController.getLogger().log(ex);
                        }
                    }
                });
            }
        });
        JMenuItem resetRegex = new JMenuItem("reset default");
        resetRegex.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public final void run() {
                        try {
                            ConsoleOutputPane.this.regExFilter.setText(ConsoleOutputPaneModel.defaultPattern.pattern());
                            ((ConsoleOutputPane)ConsoleOutputPane.this).model.usedPattern = ((ConsoleOutputPane)ConsoleOutputPane.this).model.lastValidPattern = ConsoleOutputPaneModel.defaultPattern;
                            ConsoleOutputPane.this.insertChars.setVisible(false);
                        }
                        catch (Exception ex) {
                            OutputController.getLogger().log(ex);
                        }
                    }
                });
            }
        });
        this.insertChars.add(newLine);
        this.insertChars.add(tab);
        this.insertChars.add(resetRegex);
        this.validate();
    }

    private final void setHeadersCheckBoxesEnabled(boolean enable) {
        this.showUser.setEnabled(enable);
        this.showOrigin.setEnabled(enable);
        this.showLevel.setEnabled(enable);
        this.showDate.setEnabled(enable);
        this.showCode.setEnabled(enable);
        this.showThread1.setEnabled(enable);
        this.showThread2.setEnabled(enable);
    }

    private final void setMessagesCheckBoxesEnabled(boolean enable) {
        this.showOut.setEnabled(enable);
        this.showErr.setEnabled(enable);
        this.showJava.setEnabled(enable);
        this.showPlugin.setEnabled(enable);
        this.showDebug.setEnabled(enable);
        this.showInfo.setEnabled(enable);
        this.showItw.setEnabled(enable);
        this.showApp.setEnabled(enable);
    }

    private final void refreshAction() {
        this.updateModel();
        this.refreshPane();
    }

    private final void markActionPerformed(ActionEvent evt) {
        int matches = 0;
        if (!this.mark.isSelected()) {
            this.jEditorPane1.getHighlighter().removeAllHighlights();
            return;
        }
        try {
            Document document = this.jEditorPane1.getDocument();
            String find = this.search.getText();
            if (find.length() == 0) {
                this.jEditorPane1.getHighlighter().removeAllHighlights();
                return;
            }
            int index = 0;
            while (index + find.length() < document.getLength()) {
                String subMatch = document.getText(index, find.length());
                if (this.caseSensitive.isSelected() && find.equals(subMatch) || !this.caseSensitive.isSelected() && find.equalsIgnoreCase(subMatch)) {
                    ++matches;
                    DefaultHighlighter.DefaultHighlightPainter highlightPainter = new DefaultHighlighter.DefaultHighlightPainter(Color.orange);
                    this.jEditorPane1.getHighlighter().addHighlight(index, index + find.length(), highlightPainter);
                }
                ++index;
            }
            this.mark.setText(Translator.R("COPmark") + "(" + matches + ")");
        }
        catch (BadLocationException ex) {
            OutputController.getLogger().log(ex);
        }
    }

    private final void previousActionPerformed(ActionEvent evt) {
        try {
            Document document = this.jEditorPane1.getDocument();
            String find = this.search.getText();
            if (find.length() == 0) {
                this.lastPostion = document.getLength() - find.length() - 1;
                return;
            }
            for (int index = this.lastPostion; index >= 0; --index) {
                String subMatch = document.getText(index, find.length());
                if ((!this.caseSensitive.isSelected() || !find.equals(subMatch)) && (this.caseSensitive.isSelected() || !find.equalsIgnoreCase(subMatch))) continue;
                if (this.lastSearchTag != null) {
                    this.jEditorPane1.getHighlighter().removeHighlight(this.lastSearchTag);
                }
                this.lastSearchTag = this.jEditorPane1.getHighlighter().addHighlight(index, index + find.length(), this.searchHighligh);
                this.jEditorPane1.setCaretPosition(index);
                this.lastPostion = index - find.length() - 1;
                return;
            }
            this.lastPostion = document.getLength() - find.length() - 1;
        }
        catch (BadLocationException ex) {
            OutputController.getLogger().log(ex);
        }
    }

    private final void nextActionPerformed(ActionEvent evt) {
        try {
            Document document = this.jEditorPane1.getDocument();
            String find = this.search.getText();
            if (find.length() == 0) {
                this.lastPostion = 0;
                return;
            }
            int index = this.lastPostion;
            while (index + find.length() < document.getLength()) {
                String subMatch = document.getText(index, find.length());
                if (this.caseSensitive.isSelected() && find.equals(subMatch) || !this.caseSensitive.isSelected() && find.equalsIgnoreCase(subMatch)) {
                    if (this.lastSearchTag != null) {
                        this.jEditorPane1.getHighlighter().removeHighlight(this.lastSearchTag);
                    }
                    this.lastSearchTag = this.jEditorPane1.getHighlighter().addHighlight(index, index + find.length(), this.searchHighligh);
                    this.jEditorPane1.setCaretPosition(index);
                    this.lastPostion = index + 1;
                    return;
                }
                ++index;
            }
            this.lastPostion = 0;
        }
        catch (BadLocationException ex) {
            OutputController.getLogger().log(ex);
        }
    }

    private final void showHideActionPerformed(ActionEvent evt) {
        if (this.jpanel2scrollpane.isVisible()) {
            this.jpanel2scrollpane.setVisible(false);
            this.showHide.setText(Translator.R("ButShowDetails"));
        } else {
            this.jpanel2scrollpane.setVisible(true);
            this.showHide.setText(Translator.R("ButHideDetails"));
        }
    }

    private final void copyPlainActionPerformed(ActionEvent evt) {
        if (this.canChange) {
            this.showApp.setSelected(false);
            this.refreshAction();
            this.canChange = false;
        }
        this.fillClipBoard(false, this.sortCopyAll.isSelected());
    }

    private final void copyRichActionPerformed(ActionEvent evt) {
        if (this.canChange) {
            this.showApp.setSelected(false);
            this.refreshAction();
            this.canChange = false;
        }
        this.fillClipBoard(true, this.sortCopyAll.isSelected());
    }

    private final void fillClipBoard(boolean mark, boolean forceSort) {
        StringSelection stringSelection = forceSort ? new StringSelection(this.model.importList(mark, 0, 4)) : new StringSelection(this.model.importList(mark, 0));
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, null);
    }

    public static final void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public final void run() {
                JFrame dialog = new JFrame();
                dialog.setSize(800, 600);
                dialog.setDefaultCloseOperation(3);
                ConsoleOutputPaneModel.TestMessagesProvider producer = new ConsoleOutputPaneModel.TestMessagesProvider();
                ConsoleOutputPane jPanel1 = new ConsoleOutputPane(producer);
                producer.getObservable().addObserver(jPanel1);
                dialog.getContentPane().add((Component)jPanel1, "Center");
                dialog.pack();
                dialog.setVisible(true);
            }
        });
    }

    private final void updateModel() {
        this.model.highLight = this.highLight.isSelected();
        this.model.matchPattern = this.match.isSelected();
        this.model.regExLabel = this.regExLabel.isSelected();
        this.model.revertSort = this.revertSort.isSelected();
        this.model.showCode = this.showCode.isSelected();
        this.model.showComplete = this.showComplete.isSelected();
        this.model.showDate = this.showDate.isSelected();
        this.model.showDebug = this.showDebug.isSelected();
        this.model.showErr = this.showErr.isSelected();
        this.model.showHeaders = this.showHeaders.isSelected();
        this.model.showIncomplete = this.showIncomplete.isSelected();
        this.model.showInfo = this.showInfo.isSelected();
        this.model.showItw = this.showItw.isSelected();
        this.model.showApp = this.showApp.isSelected();
        this.model.showJava = this.showJava.isSelected();
        this.model.showLevel = this.showLevel.isSelected();
        this.model.showMessage = this.showMessage.isSelected();
        this.model.showOrigin = this.showOrigin.isSelected();
        this.model.showOut = this.showOut.isSelected();
        this.model.showPlugin = this.showPlugin.isSelected();
        this.model.showPostInit = this.showPostInit.isSelected();
        this.model.showPreInit = this.showPreInit.isSelected();
        this.model.showThread1 = this.showThread1.isSelected();
        this.model.showThread2 = this.showThread2.isSelected();
        this.model.showUser = this.showUser.isSelected();
        this.model.sortBy = this.sortBy.getSelectedIndex();
        this.model.wordWrap = this.wordWrap.isSelected();
    }
}

