/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.browse;

import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XIntrospectionAccess;
import com.sun.star.container.ElementExistException;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.NoSupportException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lib.uno.helper.PropertySet;
import com.sun.star.reflection.InvocationTargetException;
import com.sun.star.script.CannotConvertException;
import com.sun.star.script.XInvocation;
import com.sun.star.script.browse.XBrowseNode;
import com.sun.star.script.framework.container.Parcel;
import com.sun.star.script.framework.container.ScriptEntry;
import com.sun.star.script.framework.container.ScriptMetaData;
import com.sun.star.script.framework.log.LogUtils;
import com.sun.star.script.framework.provider.ScriptProvider;
import com.sun.star.script.provider.XScriptContext;
import com.sun.star.ucb.XSimpleFileAccess;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.util.HashMap;

public class ScriptBrowseNode
extends PropertySet
implements XBrowseNode,
XInvocation {
    private final ScriptProvider provider;
    private Parcel parent;
    private String name;
    public String uri;
    public String description;
    public boolean editable;
    public boolean deletable;
    public boolean renamable;

    public ScriptBrowseNode(ScriptProvider provider, Parcel parent, String name) {
        block5: {
            this.deletable = false;
            this.renamable = false;
            this.provider = provider;
            this.name = name;
            this.parent = parent;
            ScriptMetaData data = null;
            XComponentContext xCtx = provider.getScriptingContext().getComponentContext();
            XMultiComponentFactory xFac = xCtx.getServiceManager();
            try {
                data = (ScriptMetaData)parent.getByName(name);
                XSimpleFileAccess xSFA = (XSimpleFileAccess)UnoRuntime.queryInterface(XSimpleFileAccess.class, (Object)xFac.createInstanceWithContext("com.sun.star.ucb.SimpleFileAccess", xCtx));
                this.uri = data.getShortFormScriptURL();
                this.description = data.getDescription();
                if (!provider.hasScriptEditor()) break block5;
                this.editable = true;
                try {
                    if (!parent.isUnoPkg() && !xSFA.isReadOnly(parent.getPathToParcel())) {
                        this.deletable = true;
                        this.renamable = true;
                    }
                }
                catch (Exception e) {
                    LogUtils.DEBUG("Caught exception in creation of ScriptBrowseNode");
                    LogUtils.DEBUG(LogUtils.getTrace(e));
                }
            }
            catch (Exception e) {
                LogUtils.DEBUG("** caught exception getting script data for " + name + " ->" + e.toString());
            }
        }
        this.registerProperty("Deletable", new Type(Boolean.TYPE), (short)0, "deletable");
        this.registerProperty("Editable", new Type(Boolean.TYPE), (short)0, "editable");
        this.registerProperty("Renamable", new Type(Boolean.TYPE), (short)0, "renamable");
        this.registerProperty("URI", new Type(String.class), (short)0, "uri");
        this.registerProperty("Description", new Type(String.class), (short)0, "description");
    }

    public String getName() {
        return this.name;
    }

    public XBrowseNode[] getChildNodes() {
        return new XBrowseNode[0];
    }

    public boolean hasChildNodes() {
        return false;
    }

    public short getType() {
        return 0;
    }

    public String toString() {
        return this.getName();
    }

    public void updateURI(Parcel p) {
        this.parent = p;
        try {
            ScriptMetaData data = (ScriptMetaData)this.parent.getByName(this.name);
            this.uri = data.getShortFormScriptURL();
        }
        catch (Exception e) {
            LogUtils.DEBUG("** caught exception getting script data for " + this.name + " ->" + e.toString());
        }
    }

    public XIntrospectionAccess getIntrospection() {
        return null;
    }

    public Object invoke(String aFunctionName, Object[] aParams, short[][] aOutParamIndex, Object[][] aOutParam) throws IllegalArgumentException, CannotConvertException, InvocationTargetException {
        aOutParamIndex[0] = new short[0];
        aOutParam[0] = new Object[0];
        Any result = new Any(new Type(Boolean.class), (Object)Boolean.TRUE);
        if (aFunctionName.equals("Editable")) {
            if (!this.editable) {
                NoSupportException nse = new NoSupportException(aFunctionName + " is not editable ");
                throw new InvocationTargetException("Scripting framework error editing script", null, (Object)nse);
            }
            XScriptContext ctxt = this.provider.getScriptingContext();
            ScriptMetaData data = null;
            try {
                data = (ScriptMetaData)this.parent.getByName(this.name);
            }
            catch (NoSuchElementException nse) {
                throw new IllegalArgumentException((Throwable)nse, this.name + " does not exist or can't be found ");
            }
            catch (WrappedTargetException wte) {
                throw new InvocationTargetException("Scripting framework editing script ", null, wte.TargetException);
            }
            this.provider.getScriptEditor().edit(ctxt, data);
        } else if (aFunctionName.equals("Deletable")) {
            if (!this.deletable) {
                NoSupportException nse = new NoSupportException(aFunctionName + " is not supported for this node");
                throw new InvocationTargetException("Scripting framework error deleting script", null, (Object)nse);
            }
            try {
                this.parent.removeByName(this.name);
                result = new Any(new Type(Boolean.class), (Object)Boolean.TRUE);
            }
            catch (NoSuchElementException nse) {
                throw new IllegalArgumentException((Throwable)nse, this.name + " does not exist or can't be found ");
            }
            catch (WrappedTargetException wte) {
                throw new InvocationTargetException("Scripting framework deleting script ", null, wte.TargetException);
            }
        } else if (aFunctionName.equals("Renamable")) {
            result = new Any(new Type(XBrowseNode.class), (Object)new XBrowseNode[0]);
            if (!this.renamable) {
                NoSupportException nse = new NoSupportException(aFunctionName + " is not supported for this node");
                throw new InvocationTargetException("Scripting framework error renaming script", null, (Object)nse);
            }
            try {
                String newName = AnyConverter.toString((Object)aParams[0]);
                ScriptMetaData oldData = (ScriptMetaData)this.parent.getByName(this.name);
                oldData.loadSource();
                String oldSource = oldData.getSource();
                LogUtils.DEBUG("Create renamed script");
                String languageName = newName + "." + this.provider.getScriptEditor().getExtension();
                String language = this.provider.getName();
                ScriptEntry entry = new ScriptEntry(language, languageName, "", new HashMap<String, String>());
                ScriptMetaData data = new ScriptMetaData(this.parent, entry, oldSource);
                this.parent.insertByName(languageName, data);
                LogUtils.DEBUG("Now remove old script");
                this.parent.removeByName(this.name);
                this.uri = data.getShortFormScriptURL();
                this.name = languageName;
                result = new Any(new Type(XBrowseNode.class), (Object)this);
            }
            catch (NoSuchElementException nse) {
                throw new IllegalArgumentException((Throwable)nse, this.name + " does not exist or can't be found ");
            }
            catch (ElementExistException eee) {
                throw new InvocationTargetException("Scripting framework error renaming script ", null, (Object)eee);
            }
            catch (WrappedTargetException wte) {
                throw new InvocationTargetException("Scripting framework rename script ", null, wte.TargetException);
            }
        } else {
            throw new IllegalArgumentException("Function " + aFunctionName + " not supported.");
        }
        return result;
    }

    public void setValue(String aPropertyName, Object aValue) throws UnknownPropertyException, CannotConvertException, InvocationTargetException {
    }

    public Object getValue(String aPropertyName) throws UnknownPropertyException {
        return null;
    }

    public boolean hasMethod(String aName) {
        return false;
    }

    public boolean hasProperty(String aName) {
        return false;
    }
}

