/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.provider.javascript;

import com.sun.star.script.framework.container.ScriptMetaData;
import com.sun.star.script.framework.log.LogUtils;
import com.sun.star.script.framework.provider.ScriptEditor;
import com.sun.star.script.framework.provider.SwingInvocation;
import com.sun.star.script.provider.XScriptContext;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.tools.debugger.Main;
import org.mozilla.javascript.tools.debugger.ScopeProvider;

public class ScriptEditorForJavaScript
implements ScriptEditor {
    private static ScriptEditorForJavaScript theScriptEditorForJavaScript;
    private static String JSTEMPLATE;
    private static Main rhinoWindow;
    private URL scriptURL;
    private static Map<String, ScriptEditorForJavaScript> BEING_EDITED;

    public static synchronized ScriptEditorForJavaScript getEditor() {
        if (theScriptEditorForJavaScript == null) {
            theScriptEditorForJavaScript = new ScriptEditorForJavaScript();
        }
        return theScriptEditorForJavaScript;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScriptEditorForJavaScript getEditor(URL url) {
        Map<String, ScriptEditorForJavaScript> map = BEING_EDITED;
        synchronized (map) {
            return BEING_EDITED.get(url.toExternalForm());
        }
    }

    public boolean isModified() {
        return rhinoWindow.isModified(this.scriptURL);
    }

    public String getText() {
        return rhinoWindow.getText(this.scriptURL);
    }

    public String getURL() {
        return this.scriptURL.toString();
    }

    public String getTemplate() {
        return JSTEMPLATE;
    }

    public String getExtension() {
        return "js";
    }

    public void edit(final XScriptContext context, ScriptMetaData entry) {
        try {
            String sUrl = entry.getParcelLocation();
            if (!sUrl.endsWith("/")) {
                sUrl = sUrl + "/";
            }
            sUrl = sUrl + entry.getLanguageName();
            final URL url = entry.getSourceURL();
            SwingInvocation.invoke(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Map map = BEING_EDITED;
                    synchronized (map) {
                        ScriptEditorForJavaScript editor = (ScriptEditorForJavaScript)BEING_EDITED.get(url.toExternalForm());
                        if (editor == null) {
                            editor = new ScriptEditorForJavaScript(context, url);
                            BEING_EDITED.put(url.toExternalForm(), editor);
                        }
                    }
                    assert (rhinoWindow != null);
                    rhinoWindow.showScriptWindow(url);
                    rhinoWindow.toFront();
                }
            });
        }
        catch (IOException e) {
            LogUtils.DEBUG("Caught exception: " + e);
            LogUtils.DEBUG(LogUtils.getTrace(e));
        }
    }

    private ScriptEditorForJavaScript() {
    }

    private ScriptEditorForJavaScript(XScriptContext context, URL url) {
        this.initUI();
        Scriptable scope = this.getScope(context);
        rhinoWindow.openFile(url, scope, new CloseHandler(url));
        this.scriptURL = url;
    }

    public Object execute() throws Exception {
        rhinoWindow.toFront();
        return rhinoWindow.runScriptWindow(this.scriptURL);
    }

    public void indicateErrorLine(int lineNum) {
        rhinoWindow.toFront();
        rhinoWindow.highlighLineInScriptWindow(this.scriptURL, lineNum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initUI() {
        try {
            Class<ScriptEditorForJavaScript> clazz = ScriptEditorForJavaScript.class;
            synchronized (ScriptEditorForJavaScript.class) {
                if (rhinoWindow != null) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                final Main sdb = new Main("Rhino JavaScript Debugger");
                sdb.pack();
                sdb.setSize(640, 640);
                sdb.setVisible(true);
                sdb.setExitAction(new Runnable(){

                    public void run() {
                        sdb.clearAllBreakpoints();
                        sdb.dispose();
                        ScriptEditorForJavaScript.this.shutdown();
                    }
                });
                Context.addContextListener(sdb);
                sdb.setScopeProvider(new ScopeProvider(){

                    public Scriptable getScope() {
                        return org.mozilla.javascript.tools.shell.Main.getScope();
                    }
                });
                sdb.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        ScriptEditorForJavaScript.this.shutdown();
                    }
                });
                rhinoWindow = sdb;
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        catch (Exception exc) {
            LogUtils.DEBUG(LogUtils.getTrace(exc));
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown() {
        rhinoWindow = null;
        this.scriptURL = null;
        Map<String, ScriptEditorForJavaScript> map = BEING_EDITED;
        synchronized (map) {
            Iterator<String> iter = BEING_EDITED.keySet().iterator();
            ArrayList<String> keysToRemove = new ArrayList<String>();
            while (iter.hasNext()) {
                String key = iter.next();
                keysToRemove.add(key);
            }
            for (int i = 0; i < keysToRemove.size(); ++i) {
                BEING_EDITED.remove(keysToRemove.get(i));
            }
            Object var3_3 = null;
        }
    }

    private Scriptable getScope(XScriptContext xsctxt) {
        Context ctxt = Context.enter();
        ImporterTopLevel scope = new ImporterTopLevel(ctxt);
        Scriptable jsCtxt = Context.toObject(xsctxt, scope);
        scope.put("XSCRIPTCONTEXT", (Scriptable)scope, (Object)jsCtxt);
        Scriptable jsArgs = Context.toObject(new Object[0], scope);
        scope.put("ARGUMENTS", (Scriptable)scope, (Object)jsArgs);
        Context.exit();
        return scope;
    }

    static {
        BEING_EDITED = new HashMap<String, ScriptEditorForJavaScript>();
        try {
            int len;
            URL url = ScriptEditorForJavaScript.class.getResource("template.js");
            InputStream in = url.openStream();
            StringBuilder buf = new StringBuilder();
            byte[] b = new byte[1024];
            while ((len = in.read(b)) != -1) {
                buf.append(new String(b, 0, len));
            }
            in.close();
            JSTEMPLATE = buf.toString();
        }
        catch (IOException ioe) {
            JSTEMPLATE = "// JavaScript script";
        }
        catch (Exception e) {
            JSTEMPLATE = "// JavaScript script";
        }
    }

    private static class CloseHandler
    implements Runnable {
        private final URL url;

        private CloseHandler(URL url) {
            this.url = url;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Map map = BEING_EDITED;
            synchronized (map) {
                BEING_EDITED.remove(this.url.toExternalForm());
            }
        }
    }
}

