/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import org.jmol.util.Node;

public abstract class Edge {
    public static final int BOND_RENDER_SINGLE = 65536;
    public static final int TYPE_ATROPISOMER = 65537;
    public static final int TYPE_ATROPISOMER_REV = 65538;
    private static final int ATROPISOMER_SHIFT = 11;
    public static final int BOND_STEREO_MASK = 1024;
    public static final int BOND_STEREO_NEAR = 1025;
    public static final int BOND_STEREO_FAR = 1041;
    public static final int BOND_AROMATIC_MASK = 512;
    public static final int BOND_AROMATIC_SINGLE = 513;
    public static final int BOND_AROMATIC_DOUBLE = 514;
    public static final int BOND_AROMATIC = 515;
    public static final int BOND_SULFUR_MASK = 256;
    public static final int BOND_PARTIAL_MASK = 224;
    public static final int BOND_PARTIAL01 = 33;
    public static final int BOND_PARTIAL12 = 66;
    public static final int BOND_PARTIAL23 = 97;
    public static final int BOND_PARTIAL32 = 100;
    public static final int BOND_COVALENT_MASK = 1023;
    public static final int BOND_COVALENT_SINGLE = 1;
    public static final int BOND_COVALENT_DOUBLE = 2;
    public static final int BOND_COVALENT_TRIPLE = 3;
    public static final int BOND_COVALENT_QUADRUPLE = 4;
    public static final int BOND_ORDER_UNSPECIFIED = 17;
    public static final int BOND_ORDER_ANY = 65535;
    public static final int BOND_ORDER_NULL = 131071;
    public static final int BOND_STRUT = 32768;
    public static final int BOND_PYMOL_NOMULT = 65536;
    public static final int BOND_PYMOL_MULT = 98304;
    public static final int BOND_NEW = 131072;
    public static final int BOND_HBOND_SHIFT = 11;
    public static final int BOND_HYDROGEN_MASK = 30720;
    public static final int BOND_H_REGULAR = 2048;
    public static final int BOND_H_CALC_MASK = 28672;
    public static final int BOND_H_CALC = 4096;
    public static final int BOND_H_PLUS_2 = 6144;
    public static final int BOND_H_PLUS_3 = 8192;
    public static final int BOND_H_PLUS_4 = 10240;
    public static final int BOND_H_PLUS_5 = 12288;
    public static final int BOND_H_MINUS_3 = 14336;
    public static final int BOND_H_MINUS_4 = 16384;
    public static final int BOND_H_NUCLEOTIDE = 18432;
    public static final int[] argbsHbondType = new int[]{-38476, -256, -256, -1, -65281, -65536, -23296, -16711681, -16711936, -32640};
    public int index = -1;
    public int order;

    public abstract int getAtomIndex1();

    public abstract int getAtomIndex2();

    public abstract int getCovalentOrder();

    public abstract Node getOtherAtomNode(Node var1);

    public abstract boolean isCovalent();

    public abstract boolean isHydrogen();

    public static int getArgbHbondType(int order) {
        int argbIndex = (order & 0x7800) >> 11;
        return argbsHbondType[argbIndex];
    }

    public static final String getBondOrderNumberFromOrder(int order) {
        if ((order &= 0xFFFDFFFF) == 131071 || order == 65535) {
            return "0";
        }
        if (Edge.isOrderH(order) || Edge.isAtropism(order) || (order & 0x100) != 0) {
            return EnumBondOrder.SINGLE.number;
        }
        if ((order & 0xE0) != 0) {
            return (order >> 5) + "." + (order & 0x1F);
        }
        return EnumBondOrder.getNumberFromCode(order);
    }

    public static final String getCmlBondOrder(int order) {
        String sname = Edge.getBondOrderNameFromOrder(order);
        switch (sname.charAt(0)) {
            case 'd': 
            case 's': 
            case 't': {
                return "" + sname.toUpperCase().charAt(0);
            }
            case 'a': {
                if (sname.indexOf("Double") >= 0) {
                    return "D";
                }
                if (sname.indexOf("Single") >= 0) {
                    return "S";
                }
                return "aromatic";
            }
            case 'p': {
                if (sname.indexOf(" ") >= 0) {
                    return sname.substring(sname.indexOf(" ") + 1);
                }
                return "partial12";
            }
        }
        return null;
    }

    public static final String getBondOrderNameFromOrder(int order) {
        switch (order &= 0xFFFDFFFF) {
            case 65535: 
            case 131071: {
                return "";
            }
            case 32768: {
                return EnumBondOrder.STRUT.name;
            }
            case 1: {
                return EnumBondOrder.SINGLE.name;
            }
            case 2: {
                return EnumBondOrder.DOUBLE.name;
            }
        }
        if ((order & 0xE0) != 0) {
            return "partial " + Edge.getBondOrderNumberFromOrder(order);
        }
        if (Edge.isOrderH(order)) {
            return EnumBondOrder.H_REGULAR.name;
        }
        if ((order & 0x10001) == 65537) {
            int code = Edge.getAtropismCode(order);
            return "atropisomer_" + code / 4 + code % 4;
        }
        if ((order & 0x100) != 0) {
            return EnumBondOrder.SINGLE.name;
        }
        return EnumBondOrder.getNameFromCode(order);
    }

    public static int getAtropismOrder(int nn, int mm) {
        return Edge.getAtropismOrder12((nn + 1 << 2) + mm + 1);
    }

    public static int getAtropismOrder12(int nnmm) {
        return nnmm << 11 | 0x10001;
    }

    private static int getAtropismCode(int order) {
        return order >> 11 & 0xF;
    }

    public static Node getAtropismNode(int order, Node a1, boolean isFirst) {
        int i1 = order >> 11 + (isFirst ? 2 : 0) & 3;
        return a1.getEdges()[i1 - 1].getOtherAtomNode(a1);
    }

    public static boolean isAtropism(int order) {
        return (order & 0x10001) == 65537;
    }

    public static boolean isOrderH(int order) {
        return (order & 0x7800) != 0 && (order & 0x10001) == 0;
    }

    public static final int getPartialBondDotted(int order) {
        return order & 0x1F;
    }

    public static final int getPartialBondOrder(int order) {
        return (order & 0xFFFDFFFF) >> 5;
    }

    protected static final int getCovalentBondOrder(int order) {
        if ((order & 0x3FF) == 0) {
            return 0;
        }
        if (((order &= 0xFFFDFFFF) & 0xE0) != 0) {
            return Edge.getPartialBondOrder(order);
        }
        if ((order & 0x100) != 0) {
            order &= 0xFFFFFEFF;
        }
        if ((order & 0xF8) != 0) {
            order = 1;
        }
        return order & 7;
    }

    public static final int getBondOrderFromFloat(float fOrder) {
        switch ((int)(fOrder * 10.0f)) {
            case 10: {
                return 1;
            }
            case -10: 
            case 5: {
                return 33;
            }
            case 15: {
                return 515;
            }
            case -15: {
                return 66;
            }
            case 20: {
                return 2;
            }
            case 25: {
                return 97;
            }
            case -25: {
                return 100;
            }
            case 30: {
                return 3;
            }
            case 40: {
                return 4;
            }
        }
        return 131071;
    }

    public static int getBondOrderFromString(String name) {
        int order = EnumBondOrder.getCodeFromName(name);
        try {
            if (order == 131071 && name.length() == 14 && name.toLowerCase().startsWith("atropisomer_")) {
                order = Edge.getAtropismOrder(Integer.parseInt(name.substring(12, 13)), Integer.parseInt(name.substring(13, 14)));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return order;
    }

    private static enum EnumBondOrder {
        SINGLE(1, "1", "single"),
        DOUBLE(2, "2", "double"),
        TRIPLE(3, "3", "triple"),
        QUADRUPLE(4, "4", "quadruple"),
        AROMATIC(515, "1.5", "aromatic"),
        STRUT(32768, "1", "struts"),
        H_REGULAR(2048, "1", "hbond"),
        PARTIAL01(33, "0.5", "partial"),
        PARTIAL12(66, "1.5", "partialDouble"),
        PARTIAL23(97, "2.5", "partialTriple"),
        PARTIAL32(100, "2.5", "partialTriple2"),
        AROMATIC_SINGLE(513, "1", "aromaticSingle"),
        AROMATIC_DOUBLE(514, "2", "aromaticDouble"),
        ATROPISOMER(65537, "1", "atropisomer"),
        UNSPECIFIED(17, "1", "unspecified");

        private int code;
        protected String number;
        protected String name;

        private EnumBondOrder(int code, String number, String name) {
            this.code = code;
            this.number = number;
            this.name = name;
        }

        protected static int getCodeFromName(String name) {
            for (EnumBondOrder item : EnumBondOrder.values()) {
                if (!item.name.equalsIgnoreCase(name)) continue;
                return item.code;
            }
            return 131071;
        }

        protected static String getNameFromCode(int code) {
            for (EnumBondOrder item : EnumBondOrder.values()) {
                if (item.code != code) continue;
                return item.name;
            }
            return "?";
        }

        protected static String getNumberFromCode(int code) {
            for (EnumBondOrder item : EnumBondOrder.values()) {
                if (item.code != code) continue;
                return item.number;
            }
            return "?";
        }
    }
}

