/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.values;

import edu.berkeley.nlp.lm.array.CustomWidthArray;
import edu.berkeley.nlp.lm.bits.BitList;
import edu.berkeley.nlp.lm.bits.BitStream;
import edu.berkeley.nlp.lm.bits.VariableLengthBitCompressor;
import edu.berkeley.nlp.lm.collections.LongRepresentable;
import edu.berkeley.nlp.lm.map.NgramMap;
import edu.berkeley.nlp.lm.util.Annotations;
import edu.berkeley.nlp.lm.values.CompressibleValueContainer;
import edu.berkeley.nlp.lm.values.ValueContainer;
import java.io.Serializable;
import java.util.Arrays;

abstract class RankedValueContainer<V extends LongRepresentable<V>>
implements CompressibleValueContainer<V>,
Serializable {
    private static final long serialVersionUID = 964277160049236607L;
    @Annotations.PrintMemoryCount
    protected final CustomWidthArray[] valueRanks;
    protected final boolean storeSuffixIndexes;
    protected final VariableLengthBitCompressor valueCoder;
    protected final int valueRadix;
    protected int valueWidth;
    protected final int defaultValRank = 10;
    protected final long[] numNgramsForEachOrder;
    protected final int[] suffixBitsForOrder;
    protected boolean useMapValueArray = false;
    private NgramMap<V> ngramMap;

    public RankedValueContainer(int valueRadix, boolean storePrefixIndexes, long[] numNgramsForEachOrder) {
        this.valueRadix = valueRadix;
        this.suffixBitsForOrder = new int[numNgramsForEachOrder.length];
        this.numNgramsForEachOrder = numNgramsForEachOrder;
        this.valueCoder = new VariableLengthBitCompressor(valueRadix);
        this.storeSuffixIndexes = storePrefixIndexes;
        this.valueRanks = new CustomWidthArray[numNgramsForEachOrder.length];
    }

    @Override
    public void setMap(NgramMap<V> map) {
        this.ngramMap = map;
    }

    protected boolean useValueStoringArray() {
        return false;
    }

    @Override
    public void swap(long a, long b, int ngramOrder) {
        long temp = this.valueRanks[ngramOrder].get(a);
        assert (temp >= 0L);
        long val = this.valueRanks[ngramOrder].get(b);
        assert (val >= 0L);
        this.valueRanks[ngramOrder].set(a, val);
        this.valueRanks[ngramOrder].set(b, temp);
    }

    @Override
    public boolean add(int[] ngram, int startPos, int endPos, int ngramOrder, long offset, long prefixOffset, int word, V val_, long suffixOffset, boolean ngramIsNew) {
        if (suffixOffset < 0L && this.storeSuffixIndexes) {
            return false;
        }
        assert (suffixOffset < 0L || ngramOrder == 0 || CustomWidthArray.numBitsNeeded(suffixOffset) <= this.suffixBitsForOrder[ngramOrder]) : "Problem with suffix offset bits " + suffixOffset + " " + this.numNgramsForEachOrder[ngramOrder - 1] + " " + Arrays.toString(ngram);
        V val = val_;
        if (val == null) {
            val = this.getDefaultVal();
        }
        this.setSizeAtLeast(10L, ngramOrder);
        long indexOfCounts = this.getCountRank(val.asLong());
        assert (indexOfCounts >= 0L);
        CustomWidthArray valueRanksHere = this.valueRanks[ngramOrder];
        int widthOffset = ngramOrder == 0 || !this.useMapValueArray ? 0 : valueRanksHere.getKeyWidth();
        valueRanksHere.setAndGrowIfNeeded(offset, indexOfCounts, widthOffset, this.valueWidth);
        if (this.storeSuffixIndexes && ngramOrder > 0) {
            assert (suffixOffset >= 0L);
            assert (suffixOffset <= Integer.MAX_VALUE);
            valueRanksHere.setAndGrowIfNeeded(offset, suffixOffset, widthOffset + this.valueWidth, this.suffixBitsForOrder[ngramOrder]);
        }
        return true;
    }

    protected abstract long getCountRank(long var1);

    @Override
    public BitList getCompressed(long offset, int ngramOrder) {
        long l = this.getRank(ngramOrder, offset);
        return this.valueCoder.compress(l);
    }

    @Override
    public void decompress(BitStream bits, int ngramOrder, boolean justConsume, @Annotations.OutputParameter V outputVal) {
        long longIndex = this.valueCoder.decompress(bits);
        if (justConsume) {
            return;
        }
        if (outputVal != null) {
            int rank = (int)longIndex;
            this.getFromRank(rank, outputVal);
        }
    }

    protected abstract V getDefaultVal();

    protected abstract void getFromRank(long var1, @Annotations.OutputParameter V var3);

    @Override
    public void setSizeAtLeast(long size, int ngramOrder) {
        if (this.valueRanks[ngramOrder] == null) {
            CustomWidthArray valueStoringArray;
            boolean useValueStoringArrayHere;
            int suffixBits;
            int n = suffixBits = ngramOrder == 0 ? 0 : this.suffixBitsForOrder[ngramOrder];
            if (ngramOrder < this.suffixBitsForOrder.length - 1) {
                this.suffixBitsForOrder[ngramOrder + 1] = !this.storeSuffixIndexes ? 0 : CustomWidthArray.numBitsNeeded(size);
            }
            boolean bl = useValueStoringArrayHere = (valueStoringArray = this.ngramMap.getValueStoringArray(ngramOrder)) != null && this.useValueStoringArray();
            if (useValueStoringArrayHere) {
                this.useMapValueArray = true;
                this.valueRanks[ngramOrder] = valueStoringArray;
            } else {
                this.valueRanks[ngramOrder] = new CustomWidthArray(size, this.valueWidth, this.valueWidth + suffixBits);
                this.valueRanks[ngramOrder].setAndGrowIfNeeded(size - 1L, 0L);
            }
        }
    }

    public long getSuffixOffset(long index, int ngramOrder) {
        assert (ngramOrder > 0);
        CustomWidthArray valueRanksHere = this.valueRanks[ngramOrder];
        int widthOffset = !this.useMapValueArray ? 0 : valueRanksHere.getKeyWidth();
        int width = widthOffset + this.valueWidth;
        return valueRanksHere.get(index, width, valueRanksHere.getFullWidth() - width);
    }

    protected int getSuffixOffsetFromInternalVal(long internalVal) {
        return !this.storeSuffixIndexes ? -1 : (int)internalVal;
    }

    @Override
    public void setFromOtherValues(ValueContainer<V> other) {
        RankedValueContainer o = (RankedValueContainer)other;
        for (int i = 0; i < this.valueRanks.length; ++i) {
            this.valueRanks[i] = o.valueRanks[i];
        }
    }

    protected long getRank(int ngramOrder, long offset) {
        CustomWidthArray valueRanksHere = this.valueRanks[ngramOrder];
        int widthOffset = ngramOrder == 0 || !this.useMapValueArray ? 0 : valueRanksHere.getKeyWidth();
        return valueRanksHere.get(offset, widthOffset, this.valueWidth);
    }

    @Override
    public void clearStorageAfterCompression(int ngramOrder) {
        if (ngramOrder > 0) {
            this.valueRanks[ngramOrder] = null;
        }
    }

    @Override
    public void trimAfterNgram(int ngramOrder, long size) {
        this.valueRanks[ngramOrder].trim();
    }

    @Override
    public void trim() {
    }

    @Override
    public void clearStorageForOrder(int ngramOrder) {
        this.valueRanks[ngramOrder] = null;
    }

    @Override
    public boolean storeSuffixoffsets() {
        return this.storeSuffixIndexes;
    }

    @Override
    public int numValueBits(int ngramOrder) {
        return this.valueWidth + this.suffixBitsForOrder[ngramOrder];
    }
}

