/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling.hunspell;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.rules.Categories;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.rules.spelling.hunspell.Hunspell;

public class HunspellRule
extends SpellingCheckRule {
    public static final String RULE_ID = "HUNSPELL_RULE";
    protected boolean needsInit = true;
    protected Hunspell.Dictionary hunspellDict = null;
    private static final String NON_ALPHABETIC = "[^\\p{L}]";
    private Pattern nonWordPattern;

    public HunspellRule(ResourceBundle messages, Language language) {
        super(messages, language);
        super.setCategory(Categories.TYPOS.getCategory(messages));
    }

    @Override
    public String getId() {
        return RULE_ID;
    }

    @Override
    public String getDescription() {
        return this.messages.getString("desc_spelling");
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        if (this.needsInit) {
            this.init();
        }
        if (this.hunspellDict == null) {
            return this.toRuleMatchArray(ruleMatches);
        }
        String[] tokens = this.tokenizeText(this.getSentenceTextWithoutUrlsAndImmunizedTokens(sentence));
        int len = sentence.getTokens()[1].getStartPos();
        for (int i = 0; i < tokens.length; ++i) {
            String word = tokens[i];
            if (this.ignoreWord(Arrays.asList(tokens), i) || this.ignoreWord(word)) {
                len += word.length() + 1;
                continue;
            }
            if (this.isMisspelled(word)) {
                RuleMatch ruleMatch = new RuleMatch(this, len, len + word.length(), this.messages.getString("spelling"), this.messages.getString("desc_spelling_short"));
                List<String> suggestions = this.getSuggestions(word);
                suggestions.addAll(0, this.getAdditionalTopSuggestions(suggestions, word));
                suggestions.addAll(this.getAdditionalSuggestions(suggestions, word));
                if (!suggestions.isEmpty()) {
                    this.filterSuggestions(suggestions);
                    ruleMatch.setSuggestedReplacements(suggestions);
                }
                ruleMatches.add(ruleMatch);
            }
            len += word.length() + 1;
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    boolean isMisspelled(String word) {
        boolean isAlphabetic = true;
        if (word.length() == 1) {
            isAlphabetic = Character.isAlphabetic(word.charAt(0));
        }
        return isAlphabetic && !word.equals("--") && this.hunspellDict.misspelled(word) || this.isProhibited(this.removeTrailingDot(word));
    }

    private String removeTrailingDot(String word) {
        if (word.endsWith(".")) {
            return word.substring(0, word.length() - 1);
        }
        return word;
    }

    public List<String> getSuggestions(String word) throws IOException {
        if (this.needsInit) {
            this.init();
        }
        return this.hunspellDict.suggest(word);
    }

    protected String[] tokenizeText(String sentence) {
        return this.nonWordPattern.split(sentence);
    }

    private String getSentenceTextWithoutUrlsAndImmunizedTokens(AnalyzedSentence sentence) {
        StringBuilder sb = new StringBuilder();
        AnalyzedTokenReadings[] sentenceTokens = this.getSentenceWithImmunization(sentence).getTokens();
        for (int i = 1; i < sentenceTokens.length; ++i) {
            String token = sentenceTokens[i].getToken();
            if (this.isUrl(token) || sentenceTokens[i].isImmunized() || sentenceTokens[i].isIgnoredBySpeller()) {
                for (int j = 0; j < token.length(); ++j) {
                    sb.append(' ');
                }
                continue;
            }
            sb.append(token);
        }
        return sb.toString();
    }

    @Override
    protected void init() throws IOException {
        super.init();
        String langCountry = this.language.getCountries().length > 0 ? this.language.getShortName() + "_" + this.language.getCountries()[0] : this.language.getShortName();
        String shortDicPath = "/" + this.language.getShortName() + "/hunspell/" + langCountry + ".dic";
        String wordChars = "";
        if (JLanguageTool.getDataBroker().resourceExists(shortDicPath)) {
            String path = this.getDictionaryPath(langCountry, shortDicPath);
            if ("".equals(path)) {
                this.hunspellDict = null;
            } else {
                this.hunspellDict = Hunspell.getInstance().getDictionary(path);
                if (!"".equals(this.hunspellDict.getWordChars())) {
                    wordChars = "(?![" + this.hunspellDict.getWordChars().replace("-", "\\-") + "])";
                }
                this.addIgnoreWords();
            }
        }
        this.nonWordPattern = Pattern.compile(wordChars + NON_ALPHABETIC);
        this.needsInit = false;
    }

    private void addIgnoreWords() throws IOException {
        this.hunspellDict.addWord("LanguageTool");
        this.hunspellDict.addWord("LanguageToolFx");
        URL ignoreUrl = JLanguageTool.getDataBroker().getFromResourceDirAsUrl(this.getIgnoreFileName());
        List ignoreLines = Resources.readLines((URL)ignoreUrl, (Charset)Charsets.UTF_8);
        for (String ignoreLine : ignoreLines) {
            if (ignoreLine.startsWith("#")) continue;
            this.hunspellDict.addWord(ignoreLine);
        }
    }

    private String getDictionaryPath(String dicName, String originalPath) throws IOException {
        String dictionaryPath;
        URL dictURL = JLanguageTool.getDataBroker().getFromResourceDirAsUrl(originalPath);
        if ("jar".equals(dictURL.getProtocol()) || "vfs".equals(dictURL.getProtocol()) || "bundle".equals(dictURL.getProtocol())) {
            File tempDir = new File(System.getProperty("java.io.tmpdir"));
            File tempDicFile = new File(tempDir, dicName + ".dic");
            JLanguageTool.addTemporaryFile(tempDicFile);
            try (InputStream dicStream = JLanguageTool.getDataBroker().getFromResourceDirAsStream(originalPath);){
                this.fileCopy(dicStream, tempDicFile);
            }
            File tempAffFile = new File(tempDir, dicName + ".aff");
            JLanguageTool.addTemporaryFile(tempAffFile);
            try (InputStream affStream = JLanguageTool.getDataBroker().getFromResourceDirAsStream(originalPath.replaceFirst(".dic$", ".aff"));){
                this.fileCopy(affStream, tempAffFile);
            }
            dictionaryPath = tempDir.getAbsolutePath() + "/" + dicName;
        } else {
            int suffixLength = ".dic".length();
            try {
                dictionaryPath = new File(dictURL.toURI()).getAbsolutePath();
                dictionaryPath = dictionaryPath.substring(0, dictionaryPath.length() - suffixLength);
            }
            catch (URISyntaxException e) {
                return "";
            }
        }
        return dictionaryPath;
    }

    private void fileCopy(InputStream in, File targetFile) throws IOException {
        try (FileOutputStream out = new FileOutputStream(targetFile);){
            int len;
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            in.close();
        }
    }
}

