/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;

public class ProjectUtil {
    private static final Logger LOGGER = Logger.getLogger(ProjectUtil.class.getName());

    public static Set<Profile> getSupportedProfiles(Project project) {
        Set<Object> supportedProfiles = new HashSet<Profile>();
        J2eePlatform j2eePlatform = ProjectUtil.getPlatform(project);
        if (j2eePlatform != null) {
            supportedProfiles = j2eePlatform.getSupportedProfiles();
        }
        return supportedProfiles;
    }

    public static J2eePlatform getPlatform(Project project) {
        try {
            String instance;
            J2eeModuleProvider provider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
            if (provider != null && (instance = provider.getServerInstanceID()) != null) {
                return Deployment.getDefault().getServerInstance(provider.getServerInstanceID()).getJ2eePlatform();
            }
        }
        catch (InstanceRemovedException instanceRemovedException) {
            // empty catch block
        }
        return null;
    }

    public static boolean isJavaEE5orHigher(Project project) {
        J2eeModule j2eeModule;
        if (project == null) {
            return false;
        }
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider != null && (j2eeModule = j2eeModuleProvider.getJ2eeModule()) != null) {
            J2eeModule.Type type = j2eeModule.getType();
            String strVersion = j2eeModule.getModuleVersion();
            assert (strVersion != null) : "Module type " + j2eeModule.getType() + " returned null module version";
            try {
                double version = Double.parseDouble(strVersion);
                if (J2eeModule.Type.EJB.equals(type) && version > 2.1) {
                    return true;
                }
                if (J2eeModule.Type.WAR.equals(type) && version > 2.4) {
                    return true;
                }
                if (J2eeModule.Type.CAR.equals(type) && version > 1.4) {
                    return true;
                }
            }
            catch (NumberFormatException ex) {
                LOGGER.log(Level.INFO, "Module version invalid " + strVersion, ex);
            }
        }
        return false;
    }
}

