/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.ui;

import java.awt.Dialog;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.common.ui.BrokenServerAlertPanel;
import org.netbeans.modules.j2ee.common.ui.BrokenServerLibraryAlertPanel;
import org.netbeans.modules.j2ee.common.ui.J2EEUISettings;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerLibraryDependency;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class BrokenServerLibrarySupport {
    public static String OFFER_LIBRARY_DEPLOYMENT = "offerLibraryDeployment";
    private static final Logger LOGGER = Logger.getLogger(BrokenServerLibrarySupport.class.getName());
    private static long brokenAlertLastTime = 0L;
    private static boolean brokenAlertShown = false;
    private static int BROKEN_ALERT_TIMEOUT = 1000;

    private BrokenServerLibrarySupport() {
    }

    public static boolean isBroken(Project project) {
        return !BrokenServerLibrarySupport.getMissingServerLibraries(project).isEmpty() || !BrokenServerLibrarySupport.getDeployableServerLibraries(project).isEmpty();
    }

    public static void fixServerLibraries(final Project project, final Runnable post) {
        if (!BrokenServerLibrarySupport.getMissingServerLibraries(project).isEmpty()) {
            LOGGER.log(Level.WARNING, "Missing libraries - FIX THIS USECASE");
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BrokenServerLibrarySupport.fixServerLibraries(project, post);
                }
            });
            return;
        }
        String title = NbBundle.getMessage(BrokenServerLibrarySupport.class, (String)"LBL_Resolve_Broken_Server_Library_Title");
        String msg = NbBundle.getMessage(BrokenServerLibrarySupport.class, (String)"MSG_Resolve_Broken_Server_Library_Fix_Message");
        NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)msg, title, 0);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) == NotifyDescriptor.YES_OPTION) {
            RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    J2eeModuleProvider jmp = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
                    String serverInstanceID = jmp.getServerInstanceID();
                    ServerInstance inst = Deployment.getDefault().getServerInstance(serverInstanceID);
                    try {
                        ServerInstance.LibraryManager manager = inst.getLibraryManager();
                        if (manager != null) {
                            try {
                                manager.deployLibraries(BrokenServerLibrarySupport.getDeployableServerLibraries(project));
                            }
                            catch (ConfigurationException ex) {
                                LOGGER.log(Level.INFO, null, ex);
                            }
                        }
                    }
                    catch (InstanceRemovedException ex) {
                        LOGGER.log(Level.FINE, null, ex);
                    }
                    finally {
                        if (post != null) {
                            post.run();
                        }
                    }
                }
            });
        }
    }

    public static Set<ServerLibraryDependency> getMissingServerLibraries(Project project) {
        J2eeModuleProvider jmp = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        Set<ServerLibraryDependency> deps = BrokenServerLibrarySupport.getDependencies(jmp);
        String serverInstanceID = jmp.getServerInstanceID();
        if (serverInstanceID != null) {
            ServerInstance inst = Deployment.getDefault().getServerInstance(serverInstanceID);
            try {
                ServerInstance.LibraryManager manager = inst.getLibraryManager();
                if (manager != null) {
                    return manager.getMissingDependencies(deps);
                }
            }
            catch (InstanceRemovedException ex) {
                LOGGER.log(Level.FINE, null, ex);
            }
        }
        return Collections.emptySet();
    }

    public static Set<ServerLibraryDependency> getDeployableServerLibraries(Project project) {
        J2eeModuleProvider jmp = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        Set<ServerLibraryDependency> deps = BrokenServerLibrarySupport.getDependencies(jmp);
        String serverInstanceID = jmp.getServerInstanceID();
        if (serverInstanceID != null) {
            ServerInstance inst = Deployment.getDefault().getServerInstance(serverInstanceID);
            try {
                ServerInstance.LibraryManager manager = inst.getLibraryManager();
                if (manager != null) {
                    return manager.getDeployableDependencies(deps);
                }
            }
            catch (InstanceRemovedException ex) {
                LOGGER.log(Level.FINE, null, ex);
            }
        }
        return Collections.emptySet();
    }

    private static Set<ServerLibraryDependency> getDependencies(J2eeModuleProvider jmp) {
        Object deps = null;
        try {
            return jmp.getConfigSupport().getLibraries();
        }
        catch (ConfigurationException e) {
            return Collections.emptySet();
        }
    }

    public static synchronized void fixOrShowAlert(Project project, Runnable postFix) {
        Preferences prefs = ProjectUtils.getPreferences((Project)project, ProjectUtils.class, (boolean)true);
        boolean offerLibraryDeployment = prefs.getBoolean(OFFER_LIBRARY_DEPLOYMENT, false);
        if (offerLibraryDeployment) {
            prefs.remove(OFFER_LIBRARY_DEPLOYMENT);
            BrokenServerLibrarySupport.fixServerLibraries(project, postFix);
        } else {
            BrokenServerLibrarySupport.showAlert();
        }
    }

    private static void showAlert() {
        if (brokenAlertShown || brokenAlertLastTime + (long)BROKEN_ALERT_TIMEOUT > System.currentTimeMillis() || !J2EEUISettings.getDefault().isShowAgainBrokenServerLibsAlert()) {
            return;
        }
        brokenAlertShown = true;
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    BrokenServerLibraryAlertPanel alert = new BrokenServerLibraryAlertPanel();
                    JButton close = new JButton(NbBundle.getMessage(BrokenServerLibrarySupport.class, (String)"LBL_BrokenServerLibrariesCustomizer_Close"));
                    close.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrokenServerLibrarySupport.class, (String)"ACSD_BrokenServerLibrariesCustomizer_Close"));
                    DialogDescriptor dd = new DialogDescriptor((Object)alert, NbBundle.getMessage(BrokenServerAlertPanel.class, (String)"MSG_Broken_Server_Libraries_Title"), true, new Object[]{close}, (Object)close, 0, null, null);
                    dd.setMessageType(2);
                    Dialog dlg = DialogDisplayer.getDefault().createDialog(dd);
                    dlg.setVisible(true);
                }
                finally {
                    Class<BrokenServerLibrarySupport> clazz = BrokenServerLibrarySupport.class;
                    synchronized (BrokenServerLibrarySupport.class) {
                        brokenAlertLastTime = System.currentTimeMillis();
                        brokenAlertShown = false;
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                    }
                }
            }
        });
    }
}

