/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.modules.dlight.libs.common.PathUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.FileInfoProvider;
import org.netbeans.modules.remote.impl.RemoteLogger;
import org.netbeans.modules.remote.impl.fs.DirEntry;
import org.netbeans.modules.remote.impl.fs.RemoteDirectory;
import org.netbeans.modules.remote.impl.fs.RemoteFileObject;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectBase;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.impl.fs.RemoteLink;
import org.netbeans.modules.remote.impl.fs.RemoteLinkBase;
import org.netbeans.modules.remote.impl.fs.RemoteLinkChild;
import org.netbeans.modules.remote.impl.fs.RemotePlainFile;
import org.netbeans.modules.remote.impl.fs.SpecialRemoteFileObject;
import org.netbeans.modules.remote.impl.fs.WeakCache;
import org.openide.filesystems.FileChangeListener;

public class RemoteFileObjectFactory {
    private final ExecutionEnvironment env;
    private final RemoteFileSystem fileSystem;
    private final WeakCache<String, RemoteFileObjectBase> fileObjectsCache = new WeakCache();
    private final Object lock = new Object();
    private final Map<String, List<FileChangeListener>> pendingListeners = new HashMap<String, List<FileChangeListener>>();
    private int cacheRequests = 0;
    private int cacheHits = 0;

    public RemoteFileObjectFactory(RemoteFileSystem fileSystem) {
        this.fileSystem = fileSystem;
        this.env = fileSystem.getExecutionEnvironment();
    }

    Collection<RemoteFileObjectBase> getCachedFileObjects() {
        return this.fileObjectsCache.values();
    }

    int getCachedFileObjectsCount() {
        return this.fileObjectsCache.size();
    }

    public RemoteFileObjectBase getCachedFileObject(String path) {
        String normalizedPath = PathUtilities.normalizeUnixPath((String)path);
        return this.fileObjectsCache.get(normalizedPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeImplementor(RemoteDirectory parent, DirEntry oldEntry, DirEntry newEntry) {
        String path = parent.getPath() + '/' + oldEntry.getName();
        Object object = this.lock;
        synchronized (object) {
            RemoteFileObject owner = this.invalidate(path);
            RemoteFileObjectBase newImpl = this.createFileObject(parent, newEntry, owner);
        }
    }

    public RemoteFileObjectBase createFileObject(RemoteDirectory parent, DirEntry entry) {
        return this.createFileObject(parent, entry, null);
    }

    public RemoteFileObjectBase createFileObject(RemoteDirectory parent, DirEntry entry, RemoteFileObject owner) {
        File childCache = new File(parent.getCache(), entry.getCache());
        String childPath = parent.getPath() + '/' + entry.getName();
        RemoteFileObjectBase fo = entry.isDirectory() ? this.createRemoteDirectory(parent, childPath, childCache, owner) : (entry.isLink() ? this.createRemoteLink(parent, childPath, entry.getLinkTarget(), owner) : (entry.isPlainFile() ? this.createRemotePlainFile(parent, childPath, childCache, FileInfoProvider.StatInfo.FileType.Regular, owner) : this.createSpecialFile(parent, childPath, childCache, entry.getFileType(), owner)));
        return fo;
    }

    public RemoteFileObjectBase register(RemoteFileObjectBase fo) {
        return this.putIfAbsent(fo.getPath(), fo);
    }

    private RemoteFileObjectBase createRemoteDirectory(RemoteDirectory parent, String remotePath, File cacheFile, RemoteFileObject owner) {
        RemoteFileObjectBase result;
        ++this.cacheRequests;
        String normalizedRemotePath = PathUtilities.normalizeUnixPath((String)remotePath);
        RemoteFileObjectBase fo = this.fileObjectsCache.get(normalizedRemotePath);
        if (fo instanceof RemoteDirectory && fo.isValid() && fo.getCache().equals(cacheFile)) {
            if (fo.getParent() == parent) {
                ++this.cacheHits;
                return (RemoteDirectory)fo;
            }
            fo = null;
        }
        if (fo != null && parent.isValid()) {
            fo.invalidate();
            this.fileObjectsCache.remove(normalizedRemotePath, fo);
        }
        if (owner == null) {
            owner = new RemoteFileObject(this.fileSystem);
        }
        if ((fo = new RemoteDirectory(owner, this.fileSystem, this.env, parent, normalizedRemotePath, cacheFile)).isValid() && (result = this.putIfAbsent(normalizedRemotePath, fo)) instanceof RemoteDirectory && result.getParent() == parent) {
            return (RemoteDirectory)result;
        }
        return fo;
    }

    private RemoteFileObjectBase createRemotePlainFile(RemoteDirectory parent, String remotePath, File cacheFile, FileInfoProvider.StatInfo.FileType fileType, RemoteFileObject owner) {
        RemoteFileObjectBase result;
        ++this.cacheRequests;
        String normalizedRemotePath = PathUtilities.normalizeUnixPath((String)remotePath);
        RemoteFileObjectBase fo = this.fileObjectsCache.get(normalizedRemotePath);
        if (fo instanceof RemotePlainFile && fo.isValid() && fo.getCache().equals(cacheFile)) {
            if (fo.getParent() == parent) {
                ++this.cacheHits;
                return (RemotePlainFile)fo;
            }
            fo = null;
        }
        if (fo != null && parent.isValid()) {
            fo.invalidate();
            this.fileObjectsCache.remove(normalizedRemotePath, fo);
        }
        if (owner == null) {
            owner = new RemoteFileObject(this.fileSystem);
        }
        if ((fo = new RemotePlainFile(owner, this.fileSystem, this.env, parent, normalizedRemotePath, cacheFile, fileType)).isValid() && (result = this.putIfAbsent(normalizedRemotePath, fo)) instanceof RemotePlainFile && result.getParent() == parent) {
            return (RemotePlainFile)result;
        }
        return fo;
    }

    private RemoteFileObjectBase createSpecialFile(RemoteDirectory parent, String remotePath, File cacheFile, FileInfoProvider.StatInfo.FileType fileType, RemoteFileObject owner) {
        RemoteFileObjectBase result;
        ++this.cacheRequests;
        String normalizedRemotePath = PathUtilities.normalizeUnixPath((String)remotePath);
        RemoteFileObjectBase fo = this.fileObjectsCache.get(normalizedRemotePath);
        if (fo instanceof SpecialRemoteFileObject && fo.isValid()) {
            if (fo.getParent() == parent) {
                ++this.cacheHits;
                return (SpecialRemoteFileObject)fo;
            }
            fo = null;
        }
        if (fo != null && parent.isValid()) {
            fo.invalidate();
            this.fileObjectsCache.remove(normalizedRemotePath, fo);
        }
        if (owner == null) {
            owner = new RemoteFileObject(this.fileSystem);
        }
        if ((fo = new SpecialRemoteFileObject(owner, this.fileSystem, this.env, parent, normalizedRemotePath, fileType)).isValid() && (result = this.putIfAbsent(normalizedRemotePath, fo)) instanceof SpecialRemoteFileObject && result.getParent() == parent) {
            return (SpecialRemoteFileObject)result;
        }
        return fo;
    }

    private RemoteFileObjectBase createRemoteLink(RemoteFileObjectBase parent, String remotePath, String link, RemoteFileObject owner) {
        RemoteLink fo;
        String normalizedRemotePath;
        RemoteFileObjectBase result;
        if (owner == null) {
            owner = new RemoteFileObject(this.fileSystem);
        }
        if ((result = this.putIfAbsent(normalizedRemotePath = PathUtilities.normalizeUnixPath((String)remotePath), fo = new RemoteLink(owner, this.fileSystem, this.env, parent, normalizedRemotePath, link))) instanceof RemoteLink && result == fo) {
            ((RemoteLink)result).initListeners(true);
        }
        return result;
    }

    public RemoteFileObjectBase createRemoteLinkChild(RemoteLinkBase parent, String remotePath, RemoteFileObjectBase delegate) {
        RemoteLinkChild fo;
        String normalizedRemotePath = PathUtilities.normalizeUnixPath((String)remotePath);
        RemoteFileObjectBase result = this.putIfAbsent(normalizedRemotePath, fo = new RemoteLinkChild(new RemoteFileObject(this.fileSystem), this.fileSystem, this.env, parent, normalizedRemotePath, delegate));
        if (result instanceof RemoteLinkChild) {
            if (result == fo) {
                ((RemoteLinkChild)result).initListeners(true);
            } else {
                RemoteFileObjectBase oldDelegate = ((RemoteLinkChild)result).getCanonicalDelegate();
                if (oldDelegate != delegate) {
                    RemoteFileObject ownerFileObject = result.getOwnerFileObject();
                    result.invalidate();
                    this.fileObjectsCache.remove(normalizedRemotePath, result);
                    fo = new RemoteLinkChild(ownerFileObject, this.fileSystem, this.env, parent, normalizedRemotePath, delegate);
                    result = this.putIfAbsent(normalizedRemotePath, fo);
                    if (result == fo) {
                        ((RemoteLinkChild)result).initListeners(true);
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteFileObjectBase putIfAbsent(String remotePath, RemoteFileObjectBase fo) {
        this.fileObjectsCache.tryCleaningDeadEntries();
        Object object = this.lock;
        synchronized (object) {
            RemoteFileObjectBase prev = this.fileObjectsCache.get(remotePath);
            if (prev == null || !prev.isValid()) {
                List<FileChangeListener> listeners = this.pendingListeners.remove(remotePath);
                if (listeners != null) {
                    for (FileChangeListener l : listeners) {
                        fo.addFileChangeListener(l);
                    }
                }
                this.fileObjectsCache.put(remotePath, fo);
                return fo;
            }
            return prev;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileChangeListener(String path, FileChangeListener listener) {
        String normalizedPath = PathUtilities.normalizeUnixPath((String)path);
        RemoteFileObjectBase fo = this.getCachedFileObject(normalizedPath);
        if (fo == null) {
            Object object = this.lock;
            synchronized (object) {
                fo = this.getCachedFileObject(normalizedPath);
                if (fo != null) {
                    List<FileChangeListener> listeners = this.pendingListeners.get(normalizedPath);
                    if (listeners == null) {
                        listeners = new ArrayList<FileChangeListener>();
                        this.pendingListeners.put(normalizedPath, listeners);
                    }
                    listeners.add(listener);
                }
            }
        } else {
            fo.addFileChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFileChangeListener(String path, FileChangeListener listener) {
        String normalizedPath = PathUtilities.normalizeUnixPath((String)path);
        RemoteFileObjectBase fo = this.getCachedFileObject(normalizedPath);
        if (fo == null) {
            Object object = this.lock;
            synchronized (object) {
                List<FileChangeListener> listeners;
                fo = this.getCachedFileObject(normalizedPath);
                if (fo != null && (listeners = this.pendingListeners.get(normalizedPath)) != null) {
                    listeners.remove(listener);
                }
            }
        } else {
            fo.removeFileChangeListener(listener);
        }
    }

    public void invalidate(RemoteFileObjectBase fo) {
        fo.invalidate();
        String path = PathUtilities.normalizeUnixPath((String)fo.getPath());
        this.fileObjectsCache.remove(path);
    }

    public RemoteFileObject invalidate(String remotePath) {
        String normalizedRemotePath = PathUtilities.normalizeUnixPath((String)remotePath);
        RemoteFileObjectBase fo = this.fileObjectsCache.remove(normalizedRemotePath);
        if (fo != null) {
            fo.invalidate();
            return fo.getOwnerFileObject();
        }
        return null;
    }

    public void rename(String path2Rename, String newPath, RemoteFileObjectBase fo2Rename) {
        RemoteFileObjectBase[] existentChildren = fo2Rename.isFolder() ? fo2Rename.getExistentChildren() : null;
        String normalizedPath2Rename = PathUtilities.normalizeUnixPath((String)path2Rename);
        String normalizedNewPath = PathUtilities.normalizeUnixPath((String)newPath);
        this.fileObjectsCache.remove(normalizedPath2Rename, fo2Rename);
        fo2Rename.renamePath(normalizedNewPath);
        this.putIfAbsent(normalizedNewPath, fo2Rename);
        if (existentChildren != null && existentChildren.length > 0) {
            for (RemoteFileObjectBase fo : existentChildren) {
                String curPath = fo.getPath();
                String changedPath = normalizedNewPath + '/' + fo.getNameExt();
                this.rename(curPath, changedPath, fo);
            }
        }
    }

    public void setLink(RemoteDirectory parent, String linkRemotePath, String linkTarget) {
        String normalizedPath = PathUtilities.normalizeUnixPath((String)linkRemotePath);
        RemoteFileObjectBase fo = this.fileObjectsCache.get(normalizedPath);
        if (fo != null) {
            if (fo instanceof RemoteLink) {
                ((RemoteLink)fo).setLink(linkTarget, parent);
            } else {
                RemoteLogger.getInstance().log(Level.FINE, "Called setLink on {0} - invalidating", fo.getClass().getSimpleName());
                fo.invalidate();
            }
        }
    }
}

