/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.IOException;
import java.util.HashSet;
import org.netbeans.modules.dlight.libs.common.PathUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.FileInfoProvider;
import org.netbeans.modules.remote.impl.fs.DirEntryList;
import org.netbeans.modules.remote.impl.fs.RemoteFileObject;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectBase;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemTransport;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemUtils;
import org.netbeans.modules.remote.impl.fs.RemoteLinkBase;
import org.openide.filesystems.FileLock;

public final class RemoteLink
extends RemoteLinkBase {
    private String normalizedTargetPath;

    RemoteLink(RemoteFileObject wrapper, RemoteFileSystem fileSystem, ExecutionEnvironment execEnv, RemoteFileObjectBase parent, String remotePath, String link) {
        super(wrapper, fileSystem, execEnv, parent, remotePath);
        this.normalizedTargetPath = RemoteLink.normalize(link, parent);
    }

    private static String normalize(String link, RemoteFileObjectBase parent) {
        String path = link;
        if (!path.startsWith("/")) {
            String parentPath = parent.getPath();
            if (!parentPath.startsWith("/")) {
                parentPath = "/" + parentPath;
            }
            path = parentPath + '/' + link;
        }
        return PathUtilities.normalizeUnixPath((String)path);
    }

    @Override
    public FileInfoProvider.StatInfo.FileType getType() {
        return FileInfoProvider.StatInfo.FileType.SymbolicLink;
    }

    @Override
    public RemoteFileObjectBase getCanonicalDelegate() {
        try {
            return RemoteFileSystemUtils.getCanonicalFileObject(this);
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    protected String getDelegateNormalizedPath() {
        return this.normalizedTargetPath;
    }

    final void setLink(String link, RemoteFileObjectBase parent) {
        this.initListeners(false);
        this.normalizedTargetPath = RemoteLink.normalize(link, parent);
        RemoteFileObjectBase delegate = this.getCanonicalDelegate();
        if (delegate != null && delegate.isFolder()) {
            for (RemoteFileObject child : delegate.getChildren()) {
                String childAbsPath = this.getPath() + '/' + child.getNameExt();
                this.getFileSystem().getFactory().createRemoteLinkChild(this, childAbsPath, child.getImplementor());
            }
        }
        this.initListeners(true);
    }

    @Override
    protected void postDeleteOrCreateChild(RemoteFileObject child, DirEntryList entryList) {
        this.getCanonicalDelegate().postDeleteOrCreateChild(child, entryList);
    }

    @Override
    protected DirEntryList deleteImpl(FileLock lock) throws IOException {
        return RemoteFileSystemTransport.delete(this.getExecutionEnvironment(), this.getPath(), false);
    }

    @Override
    protected RemoteFileObjectBase getDelegateImpl() {
        HashSet<String> antiLoop = new HashSet<String>();
        antiLoop.add(this.getPath());
        RemoteFileObjectBase delegate = this.getFileSystem().findResourceImpl(this.normalizedTargetPath, antiLoop);
        return delegate;
    }

    @Override
    public RemoteFileObjectBase readSymbolicLink() {
        return this.getDelegateImpl();
    }

    @Override
    public String readSymbolicLinkPath() {
        return this.getDelegateNormalizedPath();
    }
}

