/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2.features;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.lib.profiler.ui.memory.LiveMemoryView;
import org.netbeans.lib.profiler.ui.swing.GrayLabel;
import org.netbeans.modules.profiler.actions.ResetResultsAction;
import org.netbeans.modules.profiler.actions.TakeSnapshotAction;
import org.netbeans.modules.profiler.api.GoToSource;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.v2.features.Bundle;
import org.netbeans.modules.profiler.v2.features.FeatureUI;
import org.openide.util.Lookup;

abstract class ObjectsFeatureUI
extends FeatureUI {
    private ProfilerToolbar toolbar;
    private LiveMemoryView memoryView;
    private JLabel lrLabel;
    private JToggleButton lrPauseButton;
    private JButton lrRefreshButton;
    private JToggleButton lrDeltasButton;
    private JLabel pdLabel;
    private JButton pdSnapshotButton;
    private JButton pdResetResultsButton;
    private boolean popupPause;

    ObjectsFeatureUI() {
    }

    abstract Set<ClientUtils.SourceCodeSelection> getSelection();

    abstract void selectForProfiling(ClientUtils.SourceCodeSelection var1);

    abstract Lookup.Provider getProject();

    abstract ProfilerClient getProfilerClient();

    abstract void refreshResults();

    @Override
    ProfilerToolbar getToolbar() {
        if (this.toolbar == null) {
            this.initUI();
        }
        return this.toolbar;
    }

    @Override
    JPanel getResultsUI() {
        if (this.memoryView == null) {
            this.initUI();
        }
        return this.memoryView;
    }

    boolean hasResultsUI() {
        return this.memoryView != null;
    }

    @Override
    void sessionStateChanged(int sessionState) {
        this.refreshToolbar(sessionState);
    }

    void resetPause() {
        if (this.lrPauseButton != null) {
            this.lrPauseButton.setSelected(false);
        }
    }

    void setForceRefresh() {
        if (this.memoryView != null) {
            this.memoryView.setForceRefresh(true);
        }
    }

    void refreshData() throws ClientUtils.TargetAppOrVMTerminated {
        if (this.memoryView != null) {
            this.memoryView.refreshData();
        }
    }

    void resetData() {
        if (this.lrDeltasButton != null) {
            this.lrDeltasButton.setSelected(false);
            this.lrDeltasButton.setToolTipText(Bundle.ObjectsFeatureUI_showDeltas());
        }
        if (this.memoryView != null) {
            this.memoryView.resetData();
            this.memoryView.setDiffView(false);
        }
    }

    void cleanup() {
        if (this.memoryView != null) {
            this.memoryView.cleanup();
        }
    }

    private void initUI() {
        assert (SwingUtilities.isEventDispatchThread());
        this.memoryView = new LiveMemoryView(this.getSelection()){

            protected ProfilerClient getProfilerClient() {
                return ObjectsFeatureUI.this.getProfilerClient();
            }

            protected boolean showSourceSupported() {
                return GoToSource.isAvailable();
            }

            protected void showSource(ClientUtils.SourceCodeSelection value) {
                String className = value.getClassName();
                String methodName = value.getMethodName();
                String methodSig = value.getMethodSignature();
                GoToSource.openSource((Lookup.Provider)ObjectsFeatureUI.this.getProject(), (String)className, (String)methodName, (String)methodSig);
            }

            protected void selectForProfiling(ClientUtils.SourceCodeSelection value) {
                ObjectsFeatureUI.this.selectForProfiling(value);
            }

            protected void popupShowing() {
                if (ObjectsFeatureUI.this.lrPauseButton.isEnabled() && !ObjectsFeatureUI.this.lrRefreshButton.isEnabled()) {
                    ObjectsFeatureUI.this.popupPause = true;
                    ObjectsFeatureUI.this.lrPauseButton.setSelected(true);
                }
            }

            protected void popupHidden() {
                if (ObjectsFeatureUI.this.lrPauseButton.isEnabled() && ObjectsFeatureUI.this.popupPause) {
                    ObjectsFeatureUI.this.popupPause = false;
                    ObjectsFeatureUI.this.lrPauseButton.setSelected(false);
                }
            }
        };
        this.memoryView.putClientProperty((Object)"HelpCtx.Key", (Object)"ProfileObjects.HelpCtx");
        this.lrLabel = new GrayLabel(Bundle.ObjectsFeatureUI_liveResults());
        this.lrPauseButton = new JToggleButton(Icons.getIcon((String)"GeneralIcons.Pause")){

            @Override
            protected void fireItemStateChanged(ItemEvent event) {
                boolean paused = this.isSelected();
                ObjectsFeatureUI.this.memoryView.setPaused(paused);
                if (!paused) {
                    ObjectsFeatureUI.this.refreshResults();
                }
                ObjectsFeatureUI.this.refreshToolbar(ObjectsFeatureUI.this.getSessionState());
            }
        };
        this.lrPauseButton.setToolTipText(Bundle.ObjectsFeatureUI_pauseResults());
        this.lrPauseButton.setEnabled(false);
        this.lrRefreshButton = new JButton(Icons.getIcon((String)"GeneralIcons.UpdateNow")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                ObjectsFeatureUI.this.refreshResults();
            }
        };
        this.lrRefreshButton.setToolTipText(Bundle.ObjectsFeatureUI_updateResults());
        Icon icon = Icons.getIcon((String)"ProfilerIcons.DeltaResults");
        this.lrDeltasButton = new JToggleButton(icon){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                if (!ObjectsFeatureUI.this.memoryView.setDiffView(this.isSelected())) {
                    this.setSelected(false);
                }
                this.setToolTipText(this.isSelected() ? Bundle.ObjectsFeatureUI_showAbsolute() : Bundle.ObjectsFeatureUI_showDeltas());
            }
        };
        this.lrDeltasButton.setToolTipText(Bundle.ObjectsFeatureUI_showDeltas());
        this.pdLabel = new GrayLabel(Bundle.ObjectsFeatureUI_profilingData());
        this.pdSnapshotButton = new JButton((Action)((Object)TakeSnapshotAction.getInstance()));
        this.pdSnapshotButton.setHideActionText(true);
        this.pdResetResultsButton = new JButton((Action)((Object)ResetResultsAction.getInstance()));
        this.pdResetResultsButton.setHideActionText(true);
        this.toolbar = ProfilerToolbar.create((boolean)true);
        this.toolbar.addSpace(2);
        this.toolbar.addSeparator();
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)this.lrLabel);
        this.toolbar.addSpace(2);
        this.toolbar.add((Component)this.lrPauseButton);
        this.toolbar.add((Component)this.lrRefreshButton);
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)this.lrDeltasButton);
        this.toolbar.addSpace(2);
        this.toolbar.addSeparator();
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)this.pdLabel);
        this.toolbar.addSpace(2);
        this.toolbar.add((Component)this.pdSnapshotButton);
        this.toolbar.addSpace(3);
        this.toolbar.add((Component)this.pdResetResultsButton);
        this.sessionStateChanged(this.getSessionState());
    }

    private void refreshToolbar(final int state) {
        if (this.toolbar != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    boolean running = state == 4;
                    ObjectsFeatureUI.this.lrPauseButton.setEnabled(running);
                    ObjectsFeatureUI.this.lrRefreshButton.setEnabled(!ObjectsFeatureUI.this.popupPause && running && ObjectsFeatureUI.this.lrPauseButton.isSelected());
                    ObjectsFeatureUI.this.lrDeltasButton.setEnabled(running);
                }
            });
        }
    }
}

