/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ThreadDeathEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.LazyActionsManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.ExceptionBreakpoint;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.ThreadBreakpoint;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.netbeans.modules.debugger.jpda.DebuggerConsoleIO;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.ui.models.BreakpointsNodeModel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.NodeModel;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class BreakpointOutput
extends LazyActionsManagerListener
implements DebuggerManagerListener,
JPDABreakpointListener,
PropertyChangeListener {
    private static final Pattern dollarEscapePattern = Pattern.compile("\\$");
    private static final Pattern backslashEscapePattern = Pattern.compile("\\\\");
    private static final String threadNamePattern = "{threadName}";
    private static final String classNamePattern = "{className}";
    private static final Pattern methodNamePattern = Pattern.compile("\\{methodName\\}");
    private static final Pattern lineNumberPattern = Pattern.compile("\\{lineNumber\\}");
    private static final String exceptionClassNamePattern = "{exceptionClassName}";
    private static final String exceptionMessagePattern = "{exceptionMessage}";
    private static final Pattern expressionPattern = Pattern.compile("\\{=(.*?)\\}");
    private static final String threadStartedCondition = "{? threadStarted}";
    private JPDADebugger debugger;
    private ContextProvider contextProvider;
    private final Object lock = new Object();
    private BreakpointsNodeModel breakpointsNodeModel;

    public BreakpointOutput(ContextProvider contextProvider) {
        this.contextProvider = contextProvider;
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
        this.debugger.addPropertyChangeListener("state", (PropertyChangeListener)this);
        this.hookBreakpoints();
        DebuggerManager.getDebuggerManager().addDebuggerListener("breakpoints", (DebuggerManagerListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        JPDADebugger dbg;
        DebuggerManager.getDebuggerManager().removeDebuggerListener("breakpoints", (DebuggerManagerListener)this);
        this.unhookBreakpoints();
        Object object = this.lock;
        synchronized (object) {
            dbg = this.debugger;
            this.debugger = null;
        }
        dbg.removePropertyChangeListener("state", (PropertyChangeListener)this);
    }

    public String[] getProperties() {
        return new String[]{"actionPerformed"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakpointReached(JPDABreakpointEvent event) {
        JPDADebugger dbg;
        Object object = this.lock;
        synchronized (object) {
            dbg = this.debugger;
            if (event.getDebugger() != dbg) {
                return;
            }
        }
        if (event.getConditionResult() == 2) {
            return;
        }
        JPDABreakpoint breakpoint = (JPDABreakpoint)event.getSource();
        if (breakpoint.getSuspend() != 0) {
            this.getBreakpointsNodeModel().setCurrentBreakpoint(((JPDADebuggerImpl)dbg).getSession(), breakpoint);
        }
        String printText = breakpoint.getPrintText();
        this.substituteAndPrintText(printText, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void substituteAndPrintText(String printText, JPDABreakpointEvent event) {
        JPDADebuggerImpl dbg;
        if (printText == null || printText.length() == 0) {
            return;
        }
        printText = this.substitute(printText, event);
        Object object = this.lock;
        synchronized (object) {
            dbg = (JPDADebuggerImpl)this.debugger;
        }
        if (dbg != null) {
            dbg.getConsoleIO().println(printText, null);
        }
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        this.hookBreakpoint(breakpoint);
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        this.unhookBreakpoint(breakpoint);
    }

    public Breakpoint[] initBreakpoints() {
        return new Breakpoint[0];
    }

    public void initWatches() {
    }

    public void watchAdded(Watch watch) {
    }

    public void watchRemoved(Watch watch) {
    }

    public void sessionAdded(Session session) {
    }

    public void sessionRemoved(Session session) {
    }

    public void engineAdded(DebuggerEngine engine) {
    }

    public void engineRemoved(DebuggerEngine engine) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        JPDADebuggerImpl dbg;
        if ("validity".equals(evt.getPropertyName())) {
            JPDABreakpoint bp = (JPDABreakpoint)evt.getSource();
            if (bp.isHidden()) {
                return;
            }
            String url = null;
            int lineNumber = -1;
            if (bp instanceof LineBreakpoint) {
                url = ((LineBreakpoint)bp).getURL();
                lineNumber = ((LineBreakpoint)bp).getLineNumber();
            }
            this.printValidityMessage((Breakpoint)bp, (Breakpoint.VALIDITY)evt.getNewValue(), url, lineNumber);
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.debugger == null || !"state".equals(evt.getPropertyName()) || this.debugger.getState() == 3) {
                return;
            }
            dbg = (JPDADebuggerImpl)this.debugger;
        }
        this.getBreakpointsNodeModel().setCurrentBreakpoint(dbg.getSession(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printValidityMessage(Breakpoint bp, Breakpoint.VALIDITY newValidity, String url, int lineNumber) {
        JPDADebuggerImpl dbg;
        Object object = this.lock;
        synchronized (object) {
            dbg = (JPDADebuggerImpl)this.debugger;
        }
        if (dbg == null) {
            return;
        }
        DebuggerConsoleIO consoleIO = dbg.getConsoleIO();
        if (Breakpoint.VALIDITY.INVALID.equals((Object)newValidity)) {
            String msg = bp.getValidityMessage();
            String printText = msg != null ? NbBundle.getMessage(BreakpointOutput.class, (String)"MSG_InvalidBreakpointWithReason", (Object)bp.toString(), (Object)msg) : NbBundle.getMessage(BreakpointOutput.class, (String)"MSG_InvalidBreakpoint", (Object)bp.toString());
            DebuggerConsoleIO.Line line = null;
            if (url != null && lineNumber >= 0) {
                line = new DebuggerConsoleIO.Line(url, lineNumber, (JPDADebugger)dbg);
            }
            consoleIO.println(printText, null, true);
            if (line != null) {
                consoleIO.println(NbBundle.getMessage(BreakpointOutput.class, (String)"Link_InvalidBreakpoint", (Object)bp.toString()), line, true);
            }
        } else if (Breakpoint.VALIDITY.VALID.equals((Object)newValidity)) {
            String msg = bp.getValidityMessage();
            String printText = msg != null && msg.trim().length() > 0 ? NbBundle.getMessage(BreakpointOutput.class, (String)"MSG_ValidBreakpointWithReason", (Object)bp.toString(), (Object)msg) : NbBundle.getMessage(BreakpointOutput.class, (String)"MSG_ValidBreakpoint", (Object)bp.toString());
            DebuggerConsoleIO.Line line = null;
            if (bp instanceof LineBreakpoint) {
                line = new DebuggerConsoleIO.Line(((LineBreakpoint)bp).getURL(), ((LineBreakpoint)bp).getLineNumber(), (JPDADebugger)dbg);
            }
            consoleIO.println(printText, line, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String substitute(String printText, JPDABreakpointEvent event) {
        Matcher m;
        Variable exception;
        String methodName;
        String language;
        JPDAThread t = event.getThread();
        printText = t != null ? printText.replace(threadNamePattern, t.getName()) : printText.replace(threadNamePattern, "?");
        boolean isThreadDeath = false;
        if (t != null) {
            try {
                Field f = event.getClass().getDeclaredField("event");
                f.setAccessible(true);
                Event je = (Event)f.get(event);
                isThreadDeath = je instanceof ThreadDeathEvent;
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        printText = event.getReferenceType() != null ? printText.replace(classNamePattern, event.getReferenceType().name()) : printText.replace(classNamePattern, "?");
        Session session = null;
        Session[] sessions = DebuggerManager.getDebuggerManager().getSessions();
        for (int i = 0; i < sessions.length; ++i) {
            if (sessions[i].lookupFirst(null, JPDADebugger.class) != this.debugger) continue;
            session = sessions[i];
            break;
        }
        String string = language = session != null ? session.getCurrentLanguage() : null;
        if (t != null && !isThreadDeath) {
            methodName = t.getMethodName();
            if ("".equals(methodName)) {
                methodName = "?";
            }
        } else {
            methodName = "?";
        }
        methodName = dollarEscapePattern.matcher(methodName).replaceAll("\\\\\\$");
        printText = methodNamePattern.matcher(printText).replaceAll(methodName);
        int lineNumber = t != null && !isThreadDeath ? t.getLineNumber(language) : -1;
        printText = lineNumber < 0 ? lineNumberPattern.matcher(printText).replaceAll("?") : lineNumberPattern.matcher(printText).replaceAll(String.valueOf(lineNumber));
        if (event.getSource() instanceof ExceptionBreakpoint && (exception = event.getVariable()) != null) {
            String exceptionClassName = exception.getType();
            printText = printText.replace(exceptionClassNamePattern, exceptionClassName);
            String exceptionMessage = "";
            try {
                Variable var = ((ObjectVariable)exception).invokeMethod("getLocalizedMessage", null, new Variable[0]);
                if (var != null) {
                    exceptionMessage = var.getValue();
                }
            }
            catch (NoSuchMethodException ex) {
                exceptionMessage = "<" + ex.getLocalizedMessage() + ">";
            }
            catch (InvalidExpressionException ex) {
                exceptionMessage = "<" + ex.getLocalizedMessage() + ">";
            }
            printText = printText.replace(exceptionMessagePattern, exceptionMessage);
        }
        if (event.getSource() instanceof ThreadBreakpoint) {
            Variable startedThread = event.getVariable();
            printText = startedThread instanceof ObjectVariable && ((ObjectVariable)startedThread).getUniqueID() != 0L ? BreakpointOutput.selectCondition(printText, threadStartedCondition, true) : BreakpointOutput.selectCondition(printText, threadStartedCondition, false);
        }
        while ((m = expressionPattern.matcher(printText)).find()) {
            String value;
            block32: {
                String expression = m.group(1);
                value = "";
                try {
                    JPDADebugger theDebugger;
                    Object object = this.lock;
                    synchronized (object) {
                        if (this.debugger == null) {
                            return value;
                        }
                        theDebugger = this.debugger;
                    }
                    CallStackFrame csf = null;
                    if (t != null && !isThreadDeath) {
                        try {
                            CallStackFrame[] topFramePtr = t.getCallStack(0, 1);
                            if (topFramePtr.length > 0) {
                                csf = topFramePtr[0];
                            }
                        }
                        catch (AbsentInformationException aiex) {
                            // empty catch block
                        }
                    }
                    try {
                        value = ((Variable)theDebugger.getClass().getMethod("evaluate", String.class, CallStackFrame.class).invoke((Object)theDebugger, expression, csf)).getValue();
                    }
                    catch (InvocationTargetException itex) {
                        if (itex.getTargetException() instanceof InvalidExpressionException) {
                            throw (InvalidExpressionException)itex.getTargetException();
                        }
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    value = backslashEscapePattern.matcher(value).replaceAll("\\\\\\\\");
                    value = dollarEscapePattern.matcher(value).replaceAll("\\\\\\$");
                }
                catch (InvalidExpressionException e) {
                    JPDADebuggerImpl dbg;
                    String msg = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
                    Object object = this.lock;
                    synchronized (object) {
                        dbg = (JPDADebuggerImpl)this.debugger;
                    }
                    if (dbg == null) break block32;
                    dbg.getConsoleIO().println("Cannot evaluate expression '" + expression + "' : " + msg, null);
                }
            }
            printText = m.replaceFirst(value);
        }
        Throwable thr = event.getConditionException();
        if (thr != null) {
            printText = printText + "\n***\n" + thr.getLocalizedMessage() + "\n***\n";
        }
        return printText;
    }

    private static String selectCondition(String printText, String condition, boolean isTrue) {
        int index = printText.indexOf(condition);
        if (index >= 0) {
            int index2;
            index += condition.length();
            int l = printText.length();
            while (index < l && printText.charAt(index) != '{') {
                ++index;
            }
            if (index < l && (index2 = BreakpointOutput.findPair(printText, index + 1, '{', '}')) > 0) {
                if (isTrue) {
                    return printText.substring(index + 1, index2).trim();
                }
                for (index = index2 + 1; index < l && printText.charAt(index) != '{'; ++index) {
                }
                if (index < l && (index2 = BreakpointOutput.findPair(printText, index + 1, '{', '}')) > 0) {
                    return printText.substring(index + 1, index2).trim();
                }
            }
        }
        return printText;
    }

    private static int findPair(String printText, int index, char co, char cc) {
        int l = printText.length();
        int ci = 1;
        while (index < l) {
            char c = printText.charAt(index);
            if (c == co) {
                ++ci;
            }
            if (c == cc) {
                --ci;
            }
            if (ci == 0) break;
            ++index;
        }
        if (index < l) {
            return index;
        }
        return -1;
    }

    private void hookBreakpoints() {
        Breakpoint[] bpts = DebuggerManager.getDebuggerManager().getBreakpoints();
        for (int i = 0; i < bpts.length; ++i) {
            Breakpoint bpt = bpts[i];
            this.hookBreakpoint(bpt);
        }
    }

    private void unhookBreakpoints() {
        Breakpoint[] bpts = DebuggerManager.getDebuggerManager().getBreakpoints();
        for (int i = 0; i < bpts.length; ++i) {
            Breakpoint bpt = bpts[i];
            this.unhookBreakpoint(bpt);
        }
    }

    private void hookBreakpoint(Breakpoint breakpoint) {
        if (breakpoint instanceof JPDABreakpoint) {
            JPDABreakpoint jpdaBreakpoint = (JPDABreakpoint)breakpoint;
            jpdaBreakpoint.addJPDABreakpointListener((JPDABreakpointListener)this);
            jpdaBreakpoint.addPropertyChangeListener("validity", (PropertyChangeListener)this);
        }
    }

    private void unhookBreakpoint(Breakpoint breakpoint) {
        if (breakpoint instanceof JPDABreakpoint) {
            JPDABreakpoint jpdaBreakpoint = (JPDABreakpoint)breakpoint;
            jpdaBreakpoint.removeJPDABreakpointListener((JPDABreakpointListener)this);
            jpdaBreakpoint.removePropertyChangeListener("validity", (PropertyChangeListener)this);
        }
    }

    private BreakpointsNodeModel getBreakpointsNodeModel() {
        if (this.breakpointsNodeModel == null) {
            List l = DebuggerManager.getDebuggerManager().lookup("BreakpointsView", NodeModel.class);
            for (NodeModel nm : l) {
                if (!(nm instanceof BreakpointsNodeModel)) continue;
                this.breakpointsNodeModel = (BreakpointsNodeModel)nm;
                break;
            }
        }
        return this.breakpointsNodeModel;
    }
}

