/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.InvalidObjectException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.MutableVariable;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Super;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.expr.JDIVariable;
import org.netbeans.modules.debugger.jpda.models.ShortenedStrings;
import org.netbeans.modules.debugger.jpda.ui.models.BigStringCustomEditor;
import org.netbeans.modules.debugger.jpda.ui.models.VariablesTableModel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.TableModel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

class ValuePropertyEditor
implements ExPropertyEditor {
    private static final Logger logger = Logger.getLogger(ValuePropertyEditor.class.getName());
    private static final Set<Class> CLASSES_2_IGNORE = new HashSet<Class>(Arrays.asList(Object.class, File.class));
    private ContextProvider contextProvider;
    private PropertyEditor delegatePropertyEditor;
    private Class mirrorClass;
    private Object currentValue;
    private Object delegateValue;
    private PropertyEnv env;
    private final List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();
    private VariablesTableModel vtm;
    private Validate validate = new Validate();
    private static final Map<Class, Boolean> classesWithPE = Collections.synchronizedMap(new WeakHashMap());

    ValuePropertyEditor(ContextProvider contextProvider) {
        this.contextProvider = contextProvider;
    }

    static boolean hasPropertyEditorFor(Variable var) {
        if (!(var instanceof ObjectVariable)) {
            return false;
        }
        String type = var.getType();
        try {
            Class<?> clazz = Class.forName(type);
            return ValuePropertyEditor.hasPropertyEditorFor(clazz);
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
        catch (ExceptionInInitializerError eie) {
            return false;
        }
        catch (LinkageError le) {
            return false;
        }
    }

    private static boolean hasPropertyEditorFor(final Class clazz) {
        if (CLASSES_2_IGNORE.contains(clazz)) {
            return false;
        }
        Boolean hasPE = classesWithPE.get(clazz);
        if (hasPE != null) {
            return hasPE;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            return ValuePropertyEditor.findThePropertyEditor(clazz) != null;
        }
        final boolean[] has = new boolean[]{false};
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    has[0] = ValuePropertyEditor.findThePropertyEditor(clazz) != null;
                }
            });
        }
        catch (InterruptedException ex) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return has[0];
    }

    private static PropertyEditor findPropertyEditor(final Class clazz) {
        if (SwingUtilities.isEventDispatchThread()) {
            return ValuePropertyEditor.findThePropertyEditor(clazz);
        }
        final PropertyEditor[] peRef = new PropertyEditor[]{null};
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    peRef[0] = ValuePropertyEditor.findThePropertyEditor(clazz);
                }
            });
        }
        catch (InterruptedException ex) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return peRef[0];
    }

    private static PropertyEditor findThePropertyEditor(Class clazz) {
        PropertyEditor pe;
        if (Object.class.equals((Object)clazz)) {
            pe = null;
        } else {
            Class sclazz;
            pe = PropertyEditorManager.findEditor(clazz);
            if (pe == null && (sclazz = clazz.getSuperclass()) != null) {
                pe = ValuePropertyEditor.findPropertyEditor(sclazz);
            }
        }
        classesWithPE.put(clazz, pe != null);
        return pe;
    }

    private static PropertyEditor testPropertyEditorOnValue(PropertyEditor propertyEditor, Object valueMirror) {
        propertyEditor.setValue(valueMirror);
        Object value = propertyEditor.getValue();
        if (!(value == valueMirror || value != null && value.equals(valueMirror))) {
            return null;
        }
        return propertyEditor;
    }

    public void setValue(Object value) {
        Object valueMirror;
        Class clazz;
        logger.log(Level.FINE, "ValuePropertyEditor.setValue({0})", value);
        if (this.currentValue == value) {
            return;
        }
        this.currentValue = value;
        if (value instanceof String) {
            clazz = String.class;
            valueMirror = value;
        } else if (value instanceof VariableWithMirror) {
            valueMirror = ((VariableWithMirror)value).createMirrorObject();
            clazz = valueMirror.getClass();
        } else if (value instanceof Variable) {
            Variable var = (Variable)value;
            valueMirror = VariablesTableModel.getMirrorFor(var);
            if (valueMirror != null) {
                clazz = valueMirror.getClass();
            } else {
                clazz = String.class;
                valueMirror = VariablesTableModel.getValueOf(var);
            }
        } else {
            throw new IllegalArgumentException(value.toString());
        }
        boolean doAttach = false;
        if (this.delegatePropertyEditor == null || clazz != this.mirrorClass) {
            if (this.delegatePropertyEditor != null) {
                for (PropertyChangeListener l : this.listeners) {
                    this.delegatePropertyEditor.removePropertyChangeListener(l);
                }
            }
            PropertyEditor propertyEditor = ValuePropertyEditor.findPropertyEditor(clazz);
            if ((propertyEditor = ValuePropertyEditor.testPropertyEditorOnValue(propertyEditor, valueMirror)) == null) {
                clazz = String.class;
                propertyEditor = ValuePropertyEditor.findPropertyEditor(clazz);
                valueMirror = VariablesTableModel.getValueOf((Variable)value);
            }
            this.mirrorClass = clazz;
            this.delegatePropertyEditor = propertyEditor;
            if (this.env != null && propertyEditor instanceof ExPropertyEditor) {
                doAttach = true;
            }
            for (PropertyChangeListener l : this.listeners) {
                this.delegatePropertyEditor.addPropertyChangeListener(l);
            }
        }
        this.delegateValue = valueMirror;
        this.delegatePropertyEditor.setValue(valueMirror);
        if (doAttach) {
            ((ExPropertyEditor)this.delegatePropertyEditor).attachEnv(this.env);
        }
        logger.log(Level.FINE, "  delegatePropertyEditor = {0}", this.delegatePropertyEditor);
    }

    public Object getValue() {
        if (this.delegatePropertyEditor == null) {
            logger.log(Level.FINE, "ValuePropertyEditor.getValue() = (null) {0}", this.currentValue);
            return this.currentValue;
        }
        Object dpeValue = this.delegatePropertyEditor.getValue();
        if (dpeValue instanceof String) {
            logger.log(Level.FINE, "ValuePropertyEditor.getValue() = (delegate''s) {0}", dpeValue);
            return dpeValue;
        }
        logger.log(Level.FINE, "ValuePropertyEditor.getValue() = (current) {0}", this.currentValue);
        return this.currentValue;
    }

    private void setOrigValue(Object obj) {
        if (obj instanceof Variable) {
            Variable var = (Variable)obj;
            if (this.vtm == null) {
                List models = this.contextProvider.lookup("LocalsView", TableModel.class);
                for (TableModel tm : models) {
                    if (!(tm instanceof VariablesTableModel)) continue;
                    this.vtm = (VariablesTableModel)tm;
                    break;
                }
                if (this.vtm == null) {
                    return;
                }
            }
            this.vtm.setOrigValue(var);
        }
    }

    private void setVarFromMirror(final MutableVariable var, final Object mirror) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                String javaInitStr = ValuePropertyEditor.this.delegatePropertyEditor.getJavaInitializationString();
                boolean setFromMirror = false;
                try {
                    var.setValue(javaInitStr);
                    if (mirror == null || ((JDIVariable)var).getJDIValue() != null) {
                        setFromMirror = true;
                    }
                }
                catch (InvalidExpressionException ex) {
                    logger.log(Level.INFO, "InvalidExpressionException when evaluating " + javaInitStr + ":", ex);
                }
                if (!setFromMirror) {
                    try {
                        var.setFromMirrorObject(mirror);
                    }
                    catch (InvalidObjectException ioex) {
                        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)ioex.getLocalizedMessage(), 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    }
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            RequestProcessor rp = (RequestProcessor)this.contextProvider.lookupFirst(null, RequestProcessor.class);
            rp.post(run);
        } else {
            run.run();
        }
    }

    public boolean isPaintable() {
        return this.delegatePropertyEditor != null && this.delegatePropertyEditor.isPaintable();
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        this.delegatePropertyEditor.paintValue(gfx, box);
    }

    public String getJavaInitializationString() {
        return this.delegatePropertyEditor.getJavaInitializationString();
    }

    public String getAsText() {
        return this.delegatePropertyEditor.getAsText();
    }

    public void setAsText(String text) throws IllegalArgumentException {
        logger.log(Level.FINE, "ValuePropertyEditor.setAsText({0}) calling {1}", new Object[]{text, this.delegatePropertyEditor});
        this.delegatePropertyEditor.setAsText(text);
    }

    public String[] getTags() {
        return this.delegatePropertyEditor.getTags();
    }

    public Component getCustomEditor() {
        BigStringCustomEditor bsce;
        if (this.delegateValue instanceof String && (bsce = BigStringCustomEditor.createIfBig(this.delegatePropertyEditor, (String)this.delegateValue)) != null) {
            return bsce;
        }
        return this.delegatePropertyEditor.getCustomEditor();
    }

    public boolean supportsCustomEditor() {
        logger.log(Level.FINE, "ValuePropertyEditor.supportsCustomEditor({0})", this.delegatePropertyEditor);
        return this.delegatePropertyEditor != null && this.delegatePropertyEditor.supportsCustomEditor();
    }

    public void attachEnv(PropertyEnv env) {
        env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        env.addVetoableChangeListener((VetoableChangeListener)this.validate);
        if (this.delegatePropertyEditor instanceof ExPropertyEditor) {
            FeatureDescriptor desc;
            ShortenedStrings.StringInfo shortenedInfo;
            if (this.delegateValue instanceof String && (shortenedInfo = ShortenedStrings.getShortenedInfo((String)((String)this.delegateValue))) != null && (desc = env.getFeatureDescriptor()) instanceof Node.Property) {
                Node.Property prop = (Node.Property)desc;
                try {
                    Method forceNotEditableMethod = prop.getClass().getDeclaredMethod("forceNotEditable", new Class[0]);
                    forceNotEditableMethod.setAccessible(true);
                    forceNotEditableMethod.invoke((Object)prop, new Object[0]);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            ((ExPropertyEditor)this.delegatePropertyEditor).attachEnv(env);
            this.env = env;
        }
    }

    void checkPropertyEnv() {
        if (this.env != null && this.delegatePropertyEditor instanceof ExPropertyEditor) {
            ((ExPropertyEditor)this.delegatePropertyEditor).attachEnv(this.env);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.add(listener);
        logger.log(Level.FINE, "ValuePropertyEditor.addPropertyChangeListener({0})", listener);
        this.delegatePropertyEditor.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
        logger.log(Level.FINE, "ValuePropertyEditor.removePropertyChangeListener({0})", listener);
        this.delegatePropertyEditor.removePropertyChangeListener(listener);
    }

    static class VariableWithMirror
    implements MutableVariable,
    ObjectVariable {
        private Object mirror;

        VariableWithMirror(Object mirror) {
            this.mirror = mirror;
        }

        public void setValue(String value) throws InvalidExpressionException {
            throw new UnsupportedOperationException("Not supported.");
        }

        public void setFromMirrorObject(Object obj) {
            this.mirror = obj;
        }

        public String getType() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public String getValue() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public Object createMirrorObject() {
            return this.mirror;
        }

        public String getToStringValue() throws InvalidExpressionException {
            throw new UnsupportedOperationException("Not supported.");
        }

        public Variable invokeMethod(String methodName, String signature, Variable[] arguments) throws NoSuchMethodException, InvalidExpressionException {
            throw new UnsupportedOperationException("Not supported.");
        }

        public int getFieldsCount() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public Field getField(String name) {
            throw new UnsupportedOperationException("Not supported.");
        }

        public Field[] getFields(int from, int to) {
            throw new UnsupportedOperationException("Not supported.");
        }

        public Field[] getAllStaticFields(int from, int to) {
            throw new UnsupportedOperationException("Not supported.");
        }

        public Field[] getInheritedFields(int from, int to) {
            throw new UnsupportedOperationException("Not supported.");
        }

        public List<ObjectVariable> getReferringObjects(long maxReferrers) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Not supported.");
        }

        public Super getSuper() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public JPDAClassType getClassType() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public long getUniqueID() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    private class Validate
    implements VetoableChangeListener {
        private Validate() {
        }

        @Override
        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            logger.log(Level.FINE, "ValuePropertyEditor.Validate.vetoableChange({0})", evt);
            if ("state".equals(evt.getPropertyName())) {
                Object newValue = ValuePropertyEditor.this.delegatePropertyEditor.getValue();
                logger.log(Level.FINE, "  vetoableChange: delegate PE value = {0}", newValue);
                if (newValue != ValuePropertyEditor.this.delegateValue && !(newValue instanceof String)) {
                    ValuePropertyEditor.this.setVarFromMirror((MutableVariable)ValuePropertyEditor.this.currentValue, newValue);
                }
            }
        }
    }
}

