/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projectsui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Keymap;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.editor.ext.ToolTipSupport;
import org.netbeans.spi.debugger.ui.ViewFactory;
import org.openide.util.HelpCtx;

public class ToolTipView
extends JComponent
implements HelpCtx.Provider {
    public static final String TOOLTIP_VIEW_NAME = "ToolTipView";
    private static volatile String expression;
    private static volatile ObjectVariable variable;
    private transient JComponent contentComponent;
    private transient JPDADebugger debugger;
    private transient ToolTipSupport toolTipSupport;
    private transient DebuggerStateChangeListener debuggerStateChangeListener;
    private String name;

    private ToolTipView(JPDADebugger debugger, String expression, ObjectVariable v, String icon) {
        this.debugger = debugger;
        ToolTipView.expression = expression;
        variable = v;
        this.name = TOOLTIP_VIEW_NAME;
        JComponent c = ViewFactory.getDefault().createViewComponent(icon, TOOLTIP_VIEW_NAME, "NetbeansDebuggerJPDAToolTipNode", null);
        this.setLayout(new BorderLayout());
        this.add((Component)c, "Center");
        this.debuggerStateChangeListener = new DebuggerStateChangeListener();
        debugger.addPropertyChangeListener("state", (PropertyChangeListener)this.debuggerStateChangeListener);
    }

    static String getExpression() {
        return expression;
    }

    static ObjectVariable getVariable() {
        return variable;
    }

    void setToolTipSupport(ToolTipSupport toolTipSupport) {
        this.toolTipSupport = toolTipSupport;
    }

    private void closeToolTip() {
        this.toolTipSupport.setToolTipVisible(false);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        variable = null;
        this.debugger.removePropertyChangeListener("state", (PropertyChangeListener)this.debuggerStateChangeListener);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerJPDAToolTipNode");
    }

    @Override
    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        if (this.contentComponent == null) {
            return false;
        }
        return this.contentComponent.requestFocusInWindow();
    }

    public static synchronized ToolTipView getToolTipView(JPDADebugger debugger, String expression, ObjectVariable v) {
        return new ToolTipView(debugger, expression, v, "org/netbeans/modules/debugger/resources/localsView/local_variable_16.png");
    }

    static ExpandableTooltip createExpandableTooltip(String toolTipText) {
        return new ExpandableTooltip(toolTipText);
    }

    static class ExpandableTooltip
    extends JPanel {
        private static final String UI_PREFIX = "ToolTip";
        private JButton expButton;
        private JComponent textToolTip;
        private boolean widthCheck = true;
        private boolean sizeSet = false;

        public ExpandableTooltip(String toolTipText) {
            Font font = UIManager.getFont("ToolTip.font");
            Color backColor = UIManager.getColor("ToolTip.background");
            Color foreColor = UIManager.getColor("ToolTip.foreground");
            if (backColor != null) {
                this.setBackground(backColor);
            }
            this.setOpaque(true);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(this.getForeground()), BorderFactory.createEmptyBorder(0, 3, 0, 3)));
            this.setLayout(new BoxLayout(this, 0));
            Icon expIcon = UIManager.getIcon("Tree.collapsedIcon");
            this.expButton = new JButton(expIcon);
            this.expButton.setBorder(new EmptyBorder(0, 0, 0, 5));
            this.expButton.setBorderPainted(false);
            this.expButton.setContentAreaFilled(false);
            this.add(this.expButton);
            JTextArea l = ExpandableTooltip.createMultiLineToolTip(toolTipText, true);
            if (font != null) {
                l.setFont(font);
            }
            if (foreColor != null) {
                l.setForeground(foreColor);
            }
            if (backColor != null) {
                l.setBackground(backColor);
            }
            this.textToolTip = l;
            this.add(l);
        }

        void addExpansionListener(ActionListener treeExpansionListener) {
            this.expButton.addActionListener(treeExpansionListener);
        }

        void setWidthCheck(boolean widthCheck) {
            this.widthCheck = widthCheck;
        }

        @Override
        public Dimension getPreferredSize() {
            if (!this.sizeSet) {
                return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
            }
            Dimension preferredSize = super.getPreferredSize();
            return new Dimension(Integer.MAX_VALUE, preferredSize.height);
        }

        @Override
        public void setSize(int width, int height) {
            Dimension prefSize = this.getPreferredSize();
            Dimension buttonSize = this.expButton.getPreferredSize();
            if (this.widthCheck) {
                Insets insets = this.getInsets();
                int textWidth = width - insets.left - buttonSize.width - insets.right;
                height = Math.max(height, buttonSize.height);
                this.textToolTip.setSize(textWidth, height);
                Dimension textPreferredSize = this.textToolTip.getPreferredSize();
                super.setSize(insets.left + buttonSize.width + textPreferredSize.width + insets.right, insets.top + Math.max(buttonSize.height, textPreferredSize.height) + insets.bottom);
            } else {
                if (height >= prefSize.height) {
                    height = prefSize.height;
                }
                super.setSize(width, height);
            }
            this.sizeSet = true;
        }

        private static JTextArea createMultiLineToolTip(String toolTipText, boolean wrapLines) {
            TextToolTip ta = new TextToolTip(wrapLines);
            ta.setText(toolTipText);
            return ta;
        }

        private static class TextToolTip
        extends JTextArea {
            private static final String ELIPSIS = "...";
            private final boolean wrapLines;

            public TextToolTip(boolean wrapLines) {
                this.wrapLines = wrapLines;
                this.setLineWrap(false);
            }

            @Override
            public void setSize(int width, int height) {
                Dimension prefSize = this.getPreferredSize();
                if (width >= prefSize.width) {
                    width = prefSize.width;
                } else {
                    if (this.wrapLines) {
                        this.setLineWrap(true);
                        this.setWrapStyleWord(true);
                    }
                    super.setSize(width, Integer.MAX_VALUE);
                    prefSize = this.getPreferredSize();
                }
                if (height >= prefSize.height) {
                    height = prefSize.height;
                } else {
                    super.setSize(width, Integer.MAX_VALUE);
                    int offset = this.viewToModel(new Point(0, height));
                    Document doc = this.getDocument();
                    try {
                        if (offset > ELIPSIS.length()) {
                            doc.remove(offset -= ELIPSIS.length(), doc.getLength() - offset);
                            doc.insertString(offset, ELIPSIS, null);
                        }
                    }
                    catch (BadLocationException ble) {
                        // empty catch block
                    }
                    height = Math.min(height, this.getPreferredSize().height);
                }
                super.setSize(width, height);
            }

            @Override
            public void setKeymap(Keymap map) {
                super.setKeymap(TextToolTip.addKeymap(null, map));
            }
        }
    }

    private class DebuggerStateChangeListener
    implements PropertyChangeListener,
    Runnable {
        private DebuggerStateChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            int state = (Integer)evt.getNewValue();
            if (4 == state || 2 == state) {
                SwingUtilities.invokeLater(this);
            }
        }

        @Override
        public void run() {
            ToolTipView.this.closeToolTip();
        }
    }
}

