/*
 * Decompiled with CFR 0.152.
 */
package org.clang.frontend;

import org.clang.ast.ASTConsumer;
import org.clang.ast.ASTContext;
import org.clang.ast.DeclContext;
import org.clang.ast.ExternalASTSource;
import org.clang.ast.ImportDecl;
import org.clang.ast.TranslationUnitDecl;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.DiagnosticConsumer;
import org.clang.basic.DiagnosticIDs;
import org.clang.basic.DiagnosticOptions;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.FileEntry;
import org.clang.basic.FileManager;
import org.clang.basic.FileSystemOptions;
import org.clang.basic.FixItHint;
import org.clang.basic.IdentifierInfo;
import org.clang.basic.IdentifierInfoLookup;
import org.clang.basic.LangOptions;
import org.clang.basic.Module;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.basic.SourceRange;
import org.clang.basic.SrcMgr;
import org.clang.basic.TranslationUnitKind;
import org.clang.basic.WarningsClangGlobals;
import org.clang.basic.target.TargetInfo;
import org.clang.basic.target.TargetOptions;
import org.clang.basic.vfs.FileSystem;
import org.clang.basic.vfs.VfsGlobals;
import org.clang.frontend.ClangGlobals;
import org.clang.frontend.CodeGenOptions;
import org.clang.frontend.CompilerInvocation;
import org.clang.frontend.DependencyCollector;
import org.clang.frontend.DependencyFileGenerator;
import org.clang.frontend.DependencyOutputOptions;
import org.clang.frontend.FrontendAction;
import org.clang.frontend.FrontendInputFile;
import org.clang.frontend.FrontendOptions;
import org.clang.frontend.ModuleDependencyCollector;
import org.clang.frontend.ParsedSourceLocation;
import org.clang.frontend.PreprocessorOutputOptions;
import org.clang.frontend.TextDiagnosticPrinter;
import org.clang.frontend.VerifyDiagnosticConsumer;
import org.clang.frontend.frontend;
import org.clang.frontend.impl.CompilerInstanceStatics;
import org.clang.lex.HeaderSearch;
import org.clang.lex.HeaderSearchOptions;
import org.clang.lex.ModuleIdPath;
import org.clang.lex.ModuleLoadResult;
import org.clang.lex.ModuleLoader;
import org.clang.lex.ModuleMap;
import org.clang.lex.PTHManager;
import org.clang.lex.Preprocessor;
import org.clang.lex.PreprocessorOptions;
import org.clang.sema.CodeCompleteConsumer;
import org.clang.sema.CodeCompleteOptions;
import org.clang.sema.PrintingCodeCompleteConsumer;
import org.clang.sema.Sema;
import org.clang.serialization.ASTDeserializationListener;
import org.clang.serialization.ASTReader;
import org.clang.serialization.ASTReaderListener;
import org.clang.serialization.GlobalModuleIndex;
import org.clang.serialization.ModuleFile;
import org.clang.serialization.serialization;
import org.clang.staticanalyzer.core.AnalyzerOptions;
import org.clank.java.std;
import org.clank.java.std_errors;
import org.clank.java.std_ptr;
import org.clank.java.stdimpl.aliases.StdVector;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.clank.support.aliases.int;
import org.clank.support.aliases.type;
import org.llvm.adt.DenseMapInfo;
import org.llvm.adt.DenseMapInfoObject;
import org.llvm.adt.IntrusiveRefCntPtr;
import org.llvm.adt.SmallPtrSet;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.DenseMap;
import org.llvm.adt.aliases.DenseMapIterator;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.aliases.SmallVectorImplChar;
import org.llvm.adt.aliases.StringMap;
import org.llvm.adt.aliases.StringMapConstIterator;
import org.llvm.adt.aliases.StringMapIterator;
import org.llvm.support.BumpPtrAllocator;
import org.llvm.support.ErrorOr;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.Timer;
import org.llvm.support.llvm;
import org.llvm.support.raw_fd_ostream;
import org.llvm.support.raw_null_ostream;
import org.llvm.support.raw_ostream;
import org.llvm.support.sys.fs;
import org.llvm.support.sys.path;
import org.llvm.support.sys.sys;

public class CompilerInstance
extends ModuleLoader
implements Destructors.ClassWithDestructor {
    private IntrusiveRefCntPtr<CompilerInvocation> Invocation;
    private IntrusiveRefCntPtr<DiagnosticsEngine> Diagnostics;
    private IntrusiveRefCntPtr<TargetInfo> Target;
    private IntrusiveRefCntPtr<FileSystem> VirtualFileSystem;
    private IntrusiveRefCntPtr<FileManager> FileMgr;
    private IntrusiveRefCntPtr<SourceManager> SourceMgr;
    private IntrusiveRefCntPtr<Preprocessor> PP;
    private IntrusiveRefCntPtr<ASTContext> Context;
    private std_ptr.unique_ptr<ASTConsumer> Consumer;
    private std_ptr.unique_ptr<CodeCompleteConsumer> CompletionConsumer;
    private std_ptr.unique_ptr<Sema> TheSema;
    private std_ptr.unique_ptr<Timer> FrontendTimer;
    private IntrusiveRefCntPtr<ASTReader> ModuleManager;
    private std_ptr.shared_ptr<ModuleDependencyCollector> ModuleDepCollector;
    private std_ptr.unique_ptr<DependencyFileGenerator> TheDependencyFileGenerator;
    private std.vector<std_ptr.shared_ptr<DependencyCollector>> DependencyCollectors;
    private DenseMap<IdentifierInfo, Module> KnownModules;
    private StringMap<std.string, BumpPtrAllocator> ModuleFileOverrides;
    private SourceLocation LastModuleImportLoc;
    private ModuleLoadResult LastModuleImportResult;
    private boolean BuildGlobalModuleIndex;
    private boolean HaveFullGlobalModuleIndex;
    private boolean ModuleBuildFailed;
    private std.list<OutputFile> OutputFiles;

    private CompilerInstance(CompilerInstance $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    private void $assign(CompilerInstance $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    public CompilerInstance() {
        this(false);
    }

    public CompilerInstance(boolean BuildingModule) {
        this.Invocation = new IntrusiveRefCntPtr((Object)new CompilerInvocation());
        this.Diagnostics = new IntrusiveRefCntPtr();
        this.Target = new IntrusiveRefCntPtr();
        this.VirtualFileSystem = new IntrusiveRefCntPtr();
        this.FileMgr = new IntrusiveRefCntPtr();
        this.SourceMgr = new IntrusiveRefCntPtr();
        this.PP = new IntrusiveRefCntPtr();
        this.Context = new IntrusiveRefCntPtr();
        this.Consumer = new std_ptr.unique_ptr();
        this.CompletionConsumer = new std_ptr.unique_ptr();
        this.TheSema = new std_ptr.unique_ptr();
        this.FrontendTimer = new std_ptr.unique_ptr();
        this.ModuleManager = new IntrusiveRefCntPtr((Object)null);
        this.ModuleDepCollector = new std_ptr.shared_ptr();
        this.TheDependencyFileGenerator = new std_ptr.unique_ptr();
        this.DependencyCollectors = new std.vector((Object)new std_ptr.shared_ptr());
        this.KnownModules = new DenseMap(IdentifierInfo.DenseMapInfo, (Object)null);
        this.ModuleFileOverrides = new StringMap((Object)std.string.EMPTY);
        this.LastModuleImportLoc = new SourceLocation();
        this.LastModuleImportResult = new ModuleLoadResult();
        this.BuildGlobalModuleIndex = false;
        this.HaveFullGlobalModuleIndex = false;
        this.ModuleBuildFailed = false;
        this.OutputFiles = new std.list((Object)null);
    }

    public void $destroy() {
        assert (this.OutputFiles.empty()) : "Still output files in flight?";
        this.OutputFiles.$destroy();
        this.ModuleFileOverrides.$destroy();
        this.KnownModules.$destroy();
        this.DependencyCollectors.$destroy();
        this.TheDependencyFileGenerator.$destroy();
        this.ModuleDepCollector.$destroy();
        this.ModuleManager.$destroy();
        this.FrontendTimer.$destroy();
        this.TheSema.$destroy();
        this.CompletionConsumer.$destroy();
        this.Consumer.$destroy();
        this.Context.$destroy();
        this.PP.$destroy();
        this.SourceMgr.$destroy();
        this.FileMgr.$destroy();
        this.VirtualFileSystem.$destroy();
        this.Target.$destroy();
        this.Diagnostics.$destroy();
        this.Invocation.$destroy();
        super.$destroy();
    }

    public boolean ExecuteAction(FrontendAction Act) {
        assert (this.hasDiagnostics()) : "Diagnostics engine is not initialized!";
        assert (!this.getFrontendOpts().ShowHelp) : "Client must handle '-help'!";
        assert (!this.getFrontendOpts().ShowVersion) : "Client must handle '-version'!";
        raw_ostream OS = llvm.errs();
        this.setTarget(TargetInfo.CreateTargetInfo((DiagnosticsEngine)this.getDiagnostics(), (std_ptr.shared_ptr)this.getInvocation().TargetOpts));
        if (!this.hasTarget()) {
            return false;
        }
        this.getTarget().adjust(this.getLangOpts());
        if (this.getFrontendOpts().ProgramAction == frontend.ActionKind.RewriteObjC) {
            this.getTarget().noSignedCharForObjCBool();
        }
        if (this.getHeaderSearchOpts().Verbose) {
            OS.$out(NativePointer.$((String)"clang -cc1 version 3.6.0")).$out(NativePointer.$((String)" based upon ")).$out(NativePointer.$((String)"LLVM 3.6.0")).$out(NativePointer.$((String)" default target ")).$out(sys.getDefaultTargetTriple()).$out(NativePointer.$((String)"\n"));
        }
        if (this.getFrontendOpts().ShowTimers) {
            this.createFrontendTimer();
        }
        if (this.getFrontendOpts().ShowStats) {
            llvm.EnableStatistics();
        }
        long e = this.getFrontendOpts().Inputs.size();
        for (long i = 0L; i != e; ++i) {
            if (this.hasSourceManager() && !Act.isModelParsingAction()) {
                this.getSourceManager().clearIDTables();
            }
            if (!Act.BeginSourceFile(this, (FrontendInputFile)this.getFrontendOpts().Inputs.$at(i))) continue;
            Act.Execute();
            Act.EndSourceFile();
        }
        this.getDiagnostics().getClient().finish();
        if (this.getDiagnosticOpts().ShowCarets) {
            long NumWarnings = this.getDiagnostics().getClient().getNumWarnings();
            long NumErrors = this.getDiagnostics().getClient().getNumErrors();
            if (NumWarnings != 0L) {
                OS.$out_uint(NumWarnings).$out(NativePointer.$((String)" warning")).$out(NumWarnings == 1L ? NativePointer.$((String)"") : NativePointer.$((String)"s"));
            }
            if (NumWarnings != 0L && NumErrors != 0L) {
                OS.$out(NativePointer.$((String)" and "));
            }
            if (NumErrors != 0L) {
                OS.$out_uint(NumErrors).$out(NativePointer.$((String)" error")).$out(NumErrors == 1L ? NativePointer.$((String)"") : NativePointer.$((String)"s"));
            }
            if (NumWarnings != 0L || NumErrors != 0L) {
                OS.$out(NativePointer.$((String)" generated.\n"));
            }
        }
        if (this.getFrontendOpts().ShowStats && this.hasFileManager()) {
            this.getFileManager().PrintStats();
            OS.$out(NativePointer.$((String)"\n"));
        }
        return this.getDiagnostics().getClient().getNumErrors() == 0;
    }

    public boolean hasInvocation() {
        return this.Invocation.$Void2Type() != null;
    }

    public CompilerInvocation getInvocation() {
        assert (this.Invocation.$boolean()) : "Compiler instance has no invocation!";
        return (CompilerInvocation)((Object)this.Invocation.$star());
    }

    public void setInvocation(CompilerInvocation Value) {
        this.Invocation.$assign(new IntrusiveRefCntPtr((Object)Value));
    }

    public boolean shouldBuildGlobalModuleIndex() {
        return (this.BuildGlobalModuleIndex || this.ModuleManager.$boolean() && ((ASTReader)this.ModuleManager.$arrow()).isGlobalIndexUnavailable() && this.getFrontendOpts().GenerateGlobalModuleIndex) && !this.ModuleBuildFailed;
    }

    public void setBuildGlobalModuleIndex(boolean Build) {
        this.BuildGlobalModuleIndex = Build;
    }

    public IntrusiveRefCntPtr<AnalyzerOptions> getAnalyzerOpts() {
        return ((CompilerInvocation)((Object)this.Invocation.$arrow())).getAnalyzerOpts();
    }

    public CodeGenOptions getCodeGenOpts() {
        return ((CompilerInvocation)((Object)this.Invocation.$arrow())).getCodeGenOpts();
    }

    public DependencyOutputOptions getDependencyOutputOpts() {
        return ((CompilerInvocation)((Object)this.Invocation.$arrow())).getDependencyOutputOpts();
    }

    public DiagnosticOptions getDiagnosticOpts() {
        return ((CompilerInvocation)((Object)this.Invocation.$arrow())).getDiagnosticOpts();
    }

    public FileSystemOptions getFileSystemOpts() {
        return ((CompilerInvocation)((Object)this.Invocation.$arrow())).getFileSystemOpts();
    }

    public FrontendOptions getFrontendOpts() {
        return ((CompilerInvocation)((Object)this.Invocation.$arrow())).getFrontendOpts();
    }

    public HeaderSearchOptions getHeaderSearchOpts() {
        return ((CompilerInvocation)((Object)this.Invocation.$arrow())).getHeaderSearchOpts();
    }

    public LangOptions getLangOpts() {
        return ((CompilerInvocation)((Object)this.Invocation.$arrow())).getLangOpts();
    }

    public PreprocessorOptions getPreprocessorOpts() {
        return ((CompilerInvocation)((Object)this.Invocation.$arrow())).getPreprocessorOpts();
    }

    public PreprocessorOutputOptions getPreprocessorOutputOpts() {
        return ((CompilerInvocation)((Object)this.Invocation.$arrow())).getPreprocessorOutputOpts();
    }

    public TargetOptions getTargetOpts() {
        return ((CompilerInvocation)((Object)this.Invocation.$arrow())).getTargetOpts();
    }

    public boolean hasDiagnostics() {
        return this.Diagnostics.$Void2Type() != null;
    }

    public DiagnosticsEngine getDiagnostics() {
        assert (this.Diagnostics.$boolean()) : "Compiler instance has no diagnostics!";
        return (DiagnosticsEngine)this.Diagnostics.$star();
    }

    public void setDiagnostics(DiagnosticsEngine Value) {
        this.Diagnostics.$assign(new IntrusiveRefCntPtr((Object)Value));
    }

    public DiagnosticConsumer getDiagnosticClient() {
        assert (this.Diagnostics.$boolean() && ((DiagnosticsEngine)this.Diagnostics.$arrow()).getClient() != null) : "Compiler instance has no diagnostic client!";
        return ((DiagnosticsEngine)this.Diagnostics.$arrow()).getClient();
    }

    public boolean hasTarget() {
        return this.Target.$Void2Type() != null;
    }

    public TargetInfo getTarget() {
        assert (this.Target.$boolean()) : "Compiler instance has no target!";
        return (TargetInfo)this.Target.$star();
    }

    public void setTarget(TargetInfo Value) {
        this.Target.$assign(new IntrusiveRefCntPtr((Object)Value));
    }

    public boolean hasVirtualFileSystem() {
        return this.VirtualFileSystem.$Void2Type() != null;
    }

    public FileSystem getVirtualFileSystem() {
        assert (this.hasVirtualFileSystem()) : "Compiler instance has no virtual file system";
        return (FileSystem)this.VirtualFileSystem.$star();
    }

    public void setVirtualFileSystem(IntrusiveRefCntPtr<FileSystem> FS) {
        this.VirtualFileSystem.$assign(new IntrusiveRefCntPtr(FS));
    }

    public boolean hasFileManager() {
        return this.FileMgr.$Void2Type() != null;
    }

    public FileManager getFileManager() {
        assert (this.FileMgr.$boolean()) : "Compiler instance has no file manager!";
        return (FileManager)this.FileMgr.$star();
    }

    public void resetAndLeakFileManager() {
        ClangGlobals.BuryPointer(this.FileMgr.get());
        this.FileMgr.resetWithoutRelease();
    }

    public void setFileManager(FileManager Value) {
        this.FileMgr.$assign(new IntrusiveRefCntPtr((Object)Value));
        if (Value != null) {
            this.VirtualFileSystem.$assign(Value.getVirtualFileSystem());
        } else {
            this.VirtualFileSystem.reset();
        }
    }

    public boolean hasSourceManager() {
        return this.SourceMgr.$Void2Type() != null;
    }

    public SourceManager getSourceManager() {
        assert (this.SourceMgr.$boolean()) : "Compiler instance has no source manager!";
        return (SourceManager)this.SourceMgr.$star();
    }

    public void resetAndLeakSourceManager() {
        ClangGlobals.BuryPointer(this.SourceMgr.get());
        this.SourceMgr.resetWithoutRelease();
    }

    public void setSourceManager(SourceManager Value) {
        this.SourceMgr.$assign(new IntrusiveRefCntPtr((Object)Value));
    }

    public boolean hasPreprocessor() {
        return this.PP.$Void2Type() != null;
    }

    public Preprocessor getPreprocessor() {
        assert (this.PP.$boolean()) : "Compiler instance has no preprocessor!";
        return (Preprocessor)this.PP.$star();
    }

    public void resetAndLeakPreprocessor() {
        ClangGlobals.BuryPointer(this.PP.get());
        this.PP.resetWithoutRelease();
    }

    public void setPreprocessor(Preprocessor Value) {
        this.PP.$assign(new IntrusiveRefCntPtr((Object)Value));
    }

    public boolean hasASTContext() {
        return this.Context.$Void2Type() != null;
    }

    public ASTContext getASTContext() {
        assert (this.Context.$boolean()) : "Compiler instance has no AST context!";
        return (ASTContext)this.Context.$star();
    }

    public void resetAndLeakASTContext() {
        ClangGlobals.BuryPointer(this.Context.get());
        this.Context.resetWithoutRelease();
    }

    public void setASTContext(ASTContext Value) {
        this.Context.$assign(new IntrusiveRefCntPtr((Object)Value));
    }

    public void setSema(Sema S) {
        this.TheSema.reset((Object)S);
    }

    public boolean hasASTConsumer() {
        return this.Consumer.$boolean();
    }

    public ASTConsumer getASTConsumer() {
        assert (this.Consumer.$boolean()) : "Compiler instance has no AST consumer!";
        return (ASTConsumer)this.Consumer.$star();
    }

    public std_ptr.unique_ptr<ASTConsumer> takeASTConsumer() {
        return new std_ptr.unique_ptr(std.move(this.Consumer));
    }

    public void setASTConsumer(std_ptr.unique_ptr<ASTConsumer> Value) {
        this.Consumer = std.move(Value);
    }

    public boolean hasSema() {
        return this.TheSema.$boolean();
    }

    public Sema getSema() {
        assert (this.TheSema.$boolean()) : "Compiler instance has no Sema object!";
        return (Sema)this.TheSema.$star();
    }

    public std_ptr.unique_ptr<Sema> takeSema() {
        return new std_ptr.unique_ptr(std.move(this.TheSema));
    }

    public void resetAndLeakSema() {
        ClangGlobals.BuryPointer(this.takeSema());
    }

    public IntrusiveRefCntPtr<ASTReader> getModuleManager() {
        return new IntrusiveRefCntPtr(this.ModuleManager);
    }

    public void setModuleManager(IntrusiveRefCntPtr<ASTReader> Reader) {
        this.ModuleManager.$assign(new IntrusiveRefCntPtr(Reader));
    }

    public std_ptr.shared_ptr<ModuleDependencyCollector> getModuleDepCollector() {
        return new std_ptr.shared_ptr(this.ModuleDepCollector);
    }

    public void setModuleDepCollector(std_ptr.shared_ptr<ModuleDependencyCollector> Collector) {
        this.ModuleDepCollector.$assign(Collector);
    }

    public boolean hasCodeCompletionConsumer() {
        return this.CompletionConsumer.$boolean();
    }

    public CodeCompleteConsumer getCodeCompletionConsumer() {
        assert (this.CompletionConsumer.$boolean()) : "Compiler instance has no code completion consumer!";
        return (CodeCompleteConsumer)this.CompletionConsumer.$star();
    }

    public void setCodeCompletionConsumer(CodeCompleteConsumer Value) {
        this.CompletionConsumer.reset((Object)Value);
    }

    public boolean hasFrontendTimer() {
        return this.FrontendTimer.$boolean();
    }

    public Timer getFrontendTimer() {
        assert (this.FrontendTimer.$boolean()) : "Compiler instance has no frontend timer!";
        return (Timer)this.FrontendTimer.$star();
    }

    public void addOutputFile(OutputFile OutFile) {
        assert (OutFile.OS != null) : "Attempt to add empty stream to output list!";
        this.OutputFiles.push_back((Object)OutFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void clearOutputFiles(boolean EraseFiles) {
        it = this.OutputFiles.begin();
        ie = this.OutputFiles.end();
        while (it.$noteq((Object)ie)) {
            if (((OutputFile)it.$arrow()).OS != null) {
                ((OutputFile)it.$arrow()).OS.$destroy();
            }
            if (!((OutputFile)it.$arrow()).TempFilename.empty()) {
                if (EraseFiles) {
                    fs.remove((Twine)new Twine(((OutputFile)it.$arrow()).TempFilename));
                } else {
                    NewOutFile = null;
                    try {
                        NewOutFile = new SmallString(new StringRef(((OutputFile)it.$arrow()).Filename), 128);
                        ((FileManager)this.FileMgr.$arrow()).FixupRelativePath((SmallVectorImplChar)NewOutFile);
                        ec = fs.rename((Twine)new Twine(((OutputFile)it.$arrow()).TempFilename), (Twine)new Twine(NewOutFile.str()));
                        if (!ec.$boolean()) ** GOTO lbl28
                        org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.getDiagnostics().Report(33L), (StringRef)new StringRef(((OutputFile)it.$arrow()).TempFilename)), (StringRef)new StringRef(((OutputFile)it.$arrow()).Filename)), (StringRef)new StringRef(ec.message())).$destroy();
                        fs.remove((Twine)new Twine(((OutputFile)it.$arrow()).TempFilename));
                    }
                    finally {
                        if (NewOutFile != null) {
                            NewOutFile.$destroy();
                        }
                    }
                }
            } else if (!((OutputFile)it.$arrow()).Filename.empty() && EraseFiles) {
                fs.remove((Twine)new Twine(((OutputFile)it.$arrow()).Filename));
            }
lbl28:
            // 6 sources

            it.$preInc();
        }
        this.OutputFiles.clear();
    }

    public void createDiagnostics() {
        this.createDiagnostics(null, true);
    }

    public void createDiagnostics(DiagnosticConsumer Client) {
        this.createDiagnostics(Client, true);
    }

    public void createDiagnostics(DiagnosticConsumer Client, boolean ShouldOwnClient) {
        this.Diagnostics.$assign(CompilerInstance.createDiagnostics(this.getDiagnosticOpts(), Client, ShouldOwnClient, this.getCodeGenOpts()));
    }

    public static IntrusiveRefCntPtr<DiagnosticsEngine> createDiagnostics(DiagnosticOptions Opts) {
        return CompilerInstance.createDiagnostics(Opts, null, true, null);
    }

    public static IntrusiveRefCntPtr<DiagnosticsEngine> createDiagnostics(DiagnosticOptions Opts, DiagnosticConsumer Client) {
        return CompilerInstance.createDiagnostics(Opts, Client, true, null);
    }

    public static IntrusiveRefCntPtr<DiagnosticsEngine> createDiagnostics(DiagnosticOptions Opts, DiagnosticConsumer Client, boolean ShouldOwnClient) {
        return CompilerInstance.createDiagnostics(Opts, Client, ShouldOwnClient, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IntrusiveRefCntPtr<DiagnosticsEngine> createDiagnostics(DiagnosticOptions Opts, DiagnosticConsumer Client, boolean ShouldOwnClient, CodeGenOptions CodeGenOpts) {
        IntrusiveRefCntPtr DiagID = null;
        IntrusiveRefCntPtr Diags = null;
        try {
            DiagID = new IntrusiveRefCntPtr((Object)new DiagnosticIDs());
            Diags = new IntrusiveRefCntPtr((Object)new DiagnosticsEngine(DiagID, Opts));
            if (Client != null) {
                ((DiagnosticsEngine)Diags.$arrow()).setClient(Client, ShouldOwnClient);
            } else {
                ((DiagnosticsEngine)Diags.$arrow()).setClient((DiagnosticConsumer)new TextDiagnosticPrinter(llvm.errs(), Opts));
            }
            if (Opts.VerifyDiagnostics) {
                ((DiagnosticsEngine)Diags.$arrow()).setClient((DiagnosticConsumer)new VerifyDiagnosticConsumer((DiagnosticsEngine)Diags.$star()));
            }
            if (!Opts.DiagnosticLogFile.empty()) {
                CompilerInstanceStatics.SetUpDiagnosticLog(Opts, CodeGenOpts, (DiagnosticsEngine)Diags.$star());
            }
            if (!Opts.DiagnosticSerializationFile.empty()) {
                CompilerInstanceStatics.SetupSerializedDiagnostics(Opts, (DiagnosticsEngine)Diags.$star(), new StringRef(Opts.DiagnosticSerializationFile));
            }
            WarningsClangGlobals.ProcessWarningOptions((DiagnosticsEngine)((DiagnosticsEngine)Diags.$star()), (DiagnosticOptions)Opts);
            IntrusiveRefCntPtr intrusiveRefCntPtr = new IntrusiveRefCntPtr(Diags);
            return intrusiveRefCntPtr;
        }
        finally {
            if (Diags != null) {
                Diags.$destroy();
            }
            if (DiagID != null) {
                DiagID.$destroy();
            }
        }
    }

    public void createFileManager() {
        if (!this.hasVirtualFileSystem()) {
            this.setVirtualFileSystem((IntrusiveRefCntPtr<FileSystem>)VfsGlobals.getRealFileSystem());
        }
        this.FileMgr.$assign(new IntrusiveRefCntPtr((Object)new FileManager(this.getFileSystemOpts(), new IntrusiveRefCntPtr(this.VirtualFileSystem))));
    }

    public void createSourceManager(FileManager FileMgr) {
        this.SourceMgr.$assign(new IntrusiveRefCntPtr((Object)new SourceManager(this.getDiagnostics(), FileMgr)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPreprocessor(TranslationUnitKind TUKind) {
        SmallString SpecificModuleCache = null;
        JavaCleaner $c = Native.$createJavaCleaner();
        try {
            PreprocessorOptions PPOpts = this.getPreprocessorOpts();
            PTHManager PTHMgr = null;
            if (!PPOpts.TokenCache.empty()) {
                PTHMgr = PTHManager.Create((std.string)PPOpts.TokenCache, (DiagnosticsEngine)this.getDiagnostics());
            }
            HeaderSearch HeaderInfo = (HeaderSearch)$c.clean((Object)new HeaderSearch((IntrusiveRefCntPtr)$c.track((Object)new IntrusiveRefCntPtr((Object)this.getHeaderSearchOpts())), this.getSourceManager(), this.getDiagnostics(), this.getLangOpts(), this.getTarget()));
            $c.clean((Object)this.PP.$assign((IntrusiveRefCntPtr)$c.track((Object)new IntrusiveRefCntPtr((Object)new Preprocessor((IntrusiveRefCntPtr)$c.track((Object)new IntrusiveRefCntPtr((Object)this.getPreprocessorOpts())), this.getDiagnostics(), this.getLangOpts(), this.getSourceManager(), HeaderInfo, (ModuleLoader)this, (IdentifierInfoLookup)PTHMgr, true, TUKind)))));
            ((Preprocessor)this.PP.$arrow()).Initialize(this.getTarget());
            if (PTHMgr != null) {
                PTHMgr.setPreprocessor((Preprocessor)this.PP.$star());
                ((Preprocessor)this.PP.$arrow()).setPTHManager(PTHMgr);
            }
            if (PPOpts.DetailedRecord) {
                ((Preprocessor)this.PP.$arrow()).createPreprocessingRecord();
            }
            CompilerInstanceStatics.InitializeFileRemapping(((Preprocessor)this.PP.$arrow()).getDiagnostics(), ((Preprocessor)this.PP.$arrow()).getSourceManager(), ((Preprocessor)this.PP.$arrow()).getFileManager(), PPOpts);
            ClangGlobals.InitializePreprocessor((Preprocessor)this.PP.$star(), PPOpts, this.getFrontendOpts());
            ClangGlobals.ApplyHeaderSearchOptions(((Preprocessor)this.PP.$arrow()).getHeaderSearchInfo(), this.getHeaderSearchOpts(), ((Preprocessor)this.PP.$arrow()).getLangOpts(), ((Preprocessor)this.PP.$arrow()).getTargetInfo().getTriple());
            ((Preprocessor)this.PP.$arrow()).setPreprocessedOutput(this.getPreprocessorOutputOpts().ShowCPP);
            SpecificModuleCache = new SmallString(new StringRef(this.getHeaderSearchOpts().ModuleCachePath), 256);
            if (!this.getHeaderSearchOpts().DisableModuleHash) {
                path.append((SmallString)SpecificModuleCache, (std.string)((std.string)$c.track((Object)this.getInvocation().getModuleHash())));
                $c.clean();
            }
            ((Preprocessor)this.PP.$arrow()).getHeaderSearchInfo().setModuleCachePath(SpecificModuleCache.$StringRef());
            DependencyOutputOptions DepOpts = this.getDependencyOutputOpts();
            if (!DepOpts.OutputFile.empty()) {
                this.TheDependencyFileGenerator.reset((Object)DependencyFileGenerator.CreateAndAttachToPreprocessor((Preprocessor)this.PP.$star(), DepOpts));
            }
            if (!DepOpts.DOTOutputFile.empty()) {
                ClangGlobals.AttachDependencyGraphGen((Preprocessor)this.PP.$star(), new StringRef(DepOpts.DOTOutputFile), new StringRef(this.getHeaderSearchOpts().Sysroot));
            }
            for (std_ptr.shared_ptr Listener : this.DependencyCollectors) {
                ((DependencyCollector)Listener.$arrow()).attachToPreprocessor((Preprocessor)this.PP.$star());
            }
            if (!this.ModuleDepCollector.$boolean() && !DepOpts.ModuleDependencyOutputDir.empty()) {
                this.ModuleDepCollector = (std_ptr.shared_ptr)$c.track((Object)std.make_shared((Object)new ModuleDependencyCollector(DepOpts.ModuleDependencyOutputDir)));
                $c.clean((Object)this.ModuleDepCollector);
            }
            if (DepOpts.ShowHeaderIncludes) {
                ClangGlobals.AttachHeaderIncludeGen((Preprocessor)this.PP.$star());
            }
            if (!DepOpts.HeaderIncludeOutputFile.empty()) {
                StringRef OutputPath = new StringRef(DepOpts.HeaderIncludeOutputFile);
                if (llvm.$eq_StringRef((StringRef)new StringRef(OutputPath), (StringRef)StringRef.MINUS)) {
                    OutputPath = StringRef.EMPTY;
                }
                ClangGlobals.AttachHeaderIncludeGen((Preprocessor)this.PP.$star(), true, new StringRef(OutputPath), false);
            }
            if (DepOpts.PrintShowIncludes) {
                ClangGlobals.AttachHeaderIncludeGen((Preprocessor)this.PP.$star(), false, StringRef.EMPTY, true, true);
            }
            for (std.string Filename : this.getFrontendOpts().ModuleMapFiles) {
                FileEntry File = this.getFileManager().getFile(new StringRef(Filename));
                if (File != null) {
                    ((Preprocessor)this.PP.$arrow()).getHeaderSearchInfo().loadModuleMapFile(File, false);
                    continue;
                }
                $c.clean((Object)org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c.track((Object)this.getDiagnostics().Report(435L))), (StringRef)new StringRef(Filename)));
            }
        }
        finally {
            if (SpecificModuleCache != null) {
                SpecificModuleCache.$destroy();
            }
            $c.$destroy();
        }
    }

    public void createASTContext() {
        Preprocessor PP = this.getPreprocessor();
        this.Context.$assign(new IntrusiveRefCntPtr((Object)new ASTContext(this.getLangOpts(), PP.getSourceManager(), PP.getIdentifierTable(), PP.getSelectorTable(), PP.getBuiltinInfo())));
        ((ASTContext)this.Context.$arrow()).InitBuiltinTypes(this.getTarget());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPCHExternalASTSource(StringRef Path, boolean DisablePCHValidation, boolean AllowPCHWithCompilerErrors, Object DeserializationListener, boolean OwnDeserializationListener) {
        IntrusiveRefCntPtr Source = null;
        try {
            Source = new IntrusiveRefCntPtr();
            boolean Preamble = this.getPreprocessorOpts().PrecompiledPreambleBytes.first != 0L;
            Source.$assign(new IntrusiveRefCntPtr((Object)CompilerInstance.createPCHExternalASTSource(new StringRef(Path), this.getHeaderSearchOpts().Sysroot, DisablePCHValidation, AllowPCHWithCompilerErrors, this.getPreprocessor(), this.getASTContext(), DeserializationListener, OwnDeserializationListener, Preamble, this.getFrontendOpts().UseGlobalModuleIndex)));
            this.ModuleManager.$assign(new IntrusiveRefCntPtr((Object)((ASTReader)Source.get())));
            this.getASTContext().setExternalSource(new IntrusiveRefCntPtr(Source));
        }
        finally {
            if (Source != null) {
                Source.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExternalASTSource createPCHExternalASTSource(StringRef Path, std.string Sysroot, boolean DisablePCHValidation, boolean AllowPCHWithCompilerErrors, Preprocessor PP, ASTContext Context2, Object DeserializationListener, boolean OwnDeserializationListener, boolean Preamble, boolean UseGlobalModuleIndex) {
        std_ptr.unique_ptr Reader = null;
        try {
            HeaderSearchOptions HSOpts = PP.getHeaderSearchInfo().getHeaderSearchOpts();
            Reader = new std_ptr.unique_ptr();
            Reader.reset((Object)new ASTReader(PP, Context2, new StringRef(Sysroot.empty() ? NativePointer.$((String)"") : Sysroot.c_str()), DisablePCHValidation, AllowPCHWithCompilerErrors, false, HSOpts.ModulesValidateSystemHeaders, UseGlobalModuleIndex));
            ((ASTReader)Reader.$arrow()).setDeserializationListener((ASTDeserializationListener)DeserializationListener, OwnDeserializationListener);
            switch (ASTReader.ASTReadResult.valueOf((Object)((ASTReader)Reader.$arrow()).ReadAST(Path.$basic_string(), Preamble ? serialization.ModuleKind.MK_Preamble : serialization.ModuleKind.MK_PCH, new SourceLocation(), (long)ASTReader.LoadFailureCapabilities.ARR_None.getValue()).getValue())) {
                case Success: {
                    PP.setPredefines(((ASTReader)Reader.$arrow()).getSuggestedPredefines());
                    ExternalASTSource externalASTSource = (ExternalASTSource)Reader.release();
                    return externalASTSource;
                }
                case Failure: {
                    break;
                }
            }
            ExternalASTSource externalASTSource = null;
            return externalASTSource;
        }
        finally {
            if (Reader != null) {
                Reader.$destroy();
            }
        }
    }

    public void createCodeCompletionConsumer() {
        ParsedSourceLocation Loc = this.getFrontendOpts().CodeCompletionAt;
        if (!this.CompletionConsumer.$boolean()) {
            this.setCodeCompletionConsumer(CompilerInstance.createCodeCompletionConsumer(this.getPreprocessor(), Loc.FileName, Loc.Line, Loc.Column, this.getFrontendOpts().CodeCompleteOpts, llvm.outs()));
            if (!this.CompletionConsumer.$boolean()) {
                return;
            }
        } else if (CompilerInstanceStatics.EnableCodeCompletion(this.getPreprocessor(), Loc.FileName, Loc.Line, Loc.Column)) {
            this.setCodeCompletionConsumer(null);
            return;
        }
        if (((CodeCompleteConsumer)this.CompletionConsumer.$arrow()).isOutputBinary() && sys.ChangeStdoutToBinary().$boolean()) {
            this.getPreprocessor().getDiagnostics().Report(421L).$destroy();
            this.setCodeCompletionConsumer(null);
        }
    }

    public static CodeCompleteConsumer createCodeCompletionConsumer(Preprocessor PP, std.string Filename, long Line, long Column, CodeCompleteOptions Opts, raw_ostream OS) {
        if (CompilerInstanceStatics.EnableCodeCompletion(PP, Filename, Line, Column)) {
            return null;
        }
        return new PrintingCodeCompleteConsumer(Opts, OS);
    }

    public void createSema(TranslationUnitKind TUKind, CodeCompleteConsumer CompletionConsumer) {
        this.TheSema.reset((Object)new Sema(this.getPreprocessor(), this.getASTContext(), this.getASTConsumer(), TUKind, CompletionConsumer));
    }

    public void createFrontendTimer() {
        this.FrontendTimer.reset((Object)new Timer(new StringRef(NativePointer.$((String)"Clang front-end timer"))));
    }

    public raw_fd_ostream createDefaultOutputFile() {
        return this.createDefaultOutputFile(true, StringRef.EMPTY, StringRef.EMPTY);
    }

    public raw_fd_ostream createDefaultOutputFile(boolean Binary) {
        return this.createDefaultOutputFile(Binary, StringRef.EMPTY, StringRef.EMPTY);
    }

    public raw_fd_ostream createDefaultOutputFile(boolean Binary, StringRef InFile) {
        return this.createDefaultOutputFile(Binary, InFile, StringRef.EMPTY);
    }

    public raw_fd_ostream createDefaultOutputFile(boolean Binary, StringRef InFile, StringRef Extension) {
        return this.createOutputFile(new StringRef(this.getFrontendOpts().OutputFile), Binary, true, new StringRef(InFile), new StringRef(Extension), true);
    }

    public raw_fd_ostream createOutputFile(StringRef OutputPath, boolean Binary, boolean RemoveFileOnSignal, StringRef InFile, StringRef Extension, boolean UseTemporary) {
        return this.createOutputFile(OutputPath, Binary, RemoveFileOnSignal, InFile, Extension, UseTemporary, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public raw_fd_ostream createOutputFile(StringRef OutputPath, boolean Binary, boolean RemoveFileOnSignal, StringRef InFile, StringRef Extension, boolean UseTemporary, boolean CreateMissingDirectories) {
        std.string OutputPathName = null;
        std.string TempPathName = null;
        try {
            OutputPathName = new std.string();
            TempPathName = new std.string();
            std_errors.error_code EC = new std_errors.error_code();
            raw_fd_ostream OS = CompilerInstance.createOutputFile(new StringRef(OutputPath), EC, Binary, RemoveFileOnSignal, new StringRef(InFile), new StringRef(Extension), UseTemporary, CreateMissingDirectories, OutputPathName, TempPathName);
            if (OS == null) {
                org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.getDiagnostics().Report(426L), (StringRef)new StringRef(OutputPath)), (StringRef)new StringRef(EC.message())).$destroy();
                raw_fd_ostream raw_fd_ostream2 = null;
                return raw_fd_ostream2;
            }
            this.addOutputFile(new OutputFile(std.$noteq_str_T((std.string)OutputPathName, (char.iterator)NativePointer.$((String)"-")) ? new std.string(OutputPathName) : new std.string(NativePointer.$((String)"")), TempPathName, (raw_ostream)OS));
            raw_fd_ostream raw_fd_ostream3 = OS;
            return raw_fd_ostream3;
        }
        finally {
            if (TempPathName != null) {
                TempPathName.$destroy();
            }
            if (OutputPathName != null) {
                OutputPathName.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static raw_fd_ostream createOutputFile(StringRef OutputPath, std_errors.error_code Error2, boolean Binary, boolean RemoveFileOnSignal, StringRef InFile, StringRef Extension, boolean UseTemporary, boolean CreateMissingDirectories, std.string ResultPathName, std.string TempPathName) {
        std.string OutFile = null;
        std.string TempFile = null;
        std_ptr.unique_ptr OS = null;
        std.string OSFile = null;
        try {
            raw_fd_ostream raw_fd_ostream2;
            assert (!CreateMissingDirectories || UseTemporary) : "CreateMissingDirectories is only allowed when using temporary files";
            OutFile = new std.string();
            TempFile = new std.string();
            if (!OutputPath.empty()) {
                OutFile.$assign(OutputPath.$basic_string());
            } else if (llvm.$eq_StringRef((StringRef)new StringRef(InFile), (StringRef)StringRef.MINUS)) {
                OutFile.$assign(NativePointer.$((String)"-"));
            } else if (!Extension.empty()) {
                SmallString Path = null;
                try {
                    Path = new SmallString(new StringRef(InFile), 128);
                    path.replace_extension((SmallString)Path, (Twine)new Twine(Extension));
                    OutFile.$assign(Path.str().$basic_string());
                }
                finally {
                    if (Path != null) {
                        Path.$destroy();
                    }
                }
            } else {
                OutFile.$assign(NativePointer.$((String)"-"));
            }
            OS = new std_ptr.unique_ptr();
            OSFile = new std.string();
            if (UseTemporary) {
                if (std.$eq_str_T((std.string)OutFile, (char.iterator)NativePointer.$((String)"-"))) {
                    UseTemporary = false;
                } else {
                    fs.file_status Status = new fs.file_status();
                    fs.status((Twine)new Twine(OutputPath), (fs.file_status)Status);
                    if (fs.exists((fs.file_status)new fs.file_status(Status))) {
                        if (!fs.can_write((Twine)new Twine(OutputPath))) {
                            raw_fd_ostream raw_fd_ostream3 = null;
                            return raw_fd_ostream3;
                        }
                        if (!fs.is_regular_file((fs.file_status)new fs.file_status(Status))) {
                            UseTemporary = false;
                        }
                    }
                }
            }
            if (UseTemporary) {
                SmallString TempPath = null;
                try {
                    TempPath = new SmallString(128);
                    TempPath.$assign(OutFile);
                    TempPath.$addassign((CharSequence)"-%%%%%%%%");
                    int.ref fd = NativePointer.create_int$ref();
                    std_errors.error_code EC = fs.createUniqueFile((Twine)new Twine(TempPath.str()), (int.ref)fd, (SmallString)TempPath);
                    if (CreateMissingDirectories && std.$eq_error_code((std_errors.error_code)EC, (std_errors.error_code)std_errors.errc.no_such_file_or_directory.make_error_code())) {
                        StringRef Parent = path.parent_path((StringRef)new StringRef(OutputPath));
                        EC.$assign(fs.create_directories((Twine)new Twine(Parent)));
                        if (!EC.$boolean()) {
                            EC.$assign(fs.createUniqueFile((Twine)new Twine(TempPath.str()), (int.ref)fd, (SmallString)TempPath));
                        }
                    }
                    if (!EC.$boolean()) {
                        OS.reset((Object)new raw_fd_ostream(fd.$deref(), true));
                        OSFile.$assign(TempFile.$assign(TempPath.str().$basic_string()));
                    }
                }
                finally {
                    if (TempPath != null) {
                        TempPath.$destroy();
                    }
                }
            }
            if (!OS.$boolean()) {
                OSFile.$assign(OutFile);
                OS.reset((Object)new raw_fd_ostream(new StringRef(OSFile), Error2, Binary ? fs.OpenFlags.F_None : fs.OpenFlags.F_Text));
                if (Error2.$boolean()) {
                    raw_fd_ostream2 = null;
                    return raw_fd_ostream2;
                }
            }
            if (RemoveFileOnSignal) {
                sys.RemoveFileOnSignal((StringRef)new StringRef(OSFile));
            }
            if (ResultPathName != null) {
                ResultPathName.$assign(OutFile);
            }
            if (TempPathName != null) {
                TempPathName.$assign(TempFile);
            }
            raw_fd_ostream2 = (raw_fd_ostream)OS.release();
            return raw_fd_ostream2;
        }
        finally {
            if (OSFile != null) {
                OSFile.$destroy();
            }
            if (OS != null) {
                OS.$destroy();
            }
            if (TempFile != null) {
                TempFile.$destroy();
            }
            if (OutFile != null) {
                OutFile.$destroy();
            }
        }
    }

    public raw_null_ostream createNullOutputFile() {
        raw_null_ostream OS = new raw_null_ostream();
        this.addOutputFile(new OutputFile(new std.string(NativePointer.$((String)"")), new std.string(NativePointer.$((String)"")), (raw_ostream)OS));
        return OS;
    }

    public boolean InitializeSourceManager(FrontendInputFile Input) {
        return CompilerInstance.InitializeSourceManager(Input, this.getDiagnostics(), this.getFileManager(), this.getSourceManager(), this.getFrontendOpts());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean InitializeSourceManager(FrontendInputFile Input, DiagnosticsEngine Diags, FileManager FileMgr, SourceManager SourceMgr, FrontendOptions Opts) {
        SrcMgr.CharacteristicKind Kind2;
        SrcMgr.CharacteristicKind characteristicKind = Kind2 = Input.isSystem() ? SrcMgr.CharacteristicKind.C_System : SrcMgr.CharacteristicKind.C_User;
        if (Input.isBuffer()) {
            SourceMgr.setMainFileID(SourceMgr.createFileID(new std_ptr.unique_ptr((Object)Input.getBuffer()), Kind2));
            assert (!SourceMgr.getMainFileID().isInvalid()) : "Couldn't establish MainFileID!";
            return true;
        }
        StringRef InputFile = Input.getFile();
        if (llvm.$noteq_StringRef((StringRef)InputFile, (StringRef)StringRef.MINUS)) {
            FileEntry File;
            block18: {
                File = FileMgr.getFile(InputFile, true);
                if (File == null) {
                    org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)Diags.Report(410L), (StringRef)new StringRef(InputFile)).$destroy();
                    return false;
                }
                if (File.isNamedPipe()) {
                    ErrorOr MB = null;
                    try {
                        MB = FileMgr.getBufferForFile(File, true);
                        if (MB.$boolean()) {
                            File = FileMgr.getVirtualFile(new StringRef(InputFile), (long)((MemoryBuffer)((std_ptr.unique_ptr)MB.$star()).$arrow()).getBufferSize(), 0L);
                            SourceMgr.overrideFileContents(File, new std_ptr.unique_ptr(std.move((std_ptr.unique_ptr)((std_ptr.unique_ptr)MB.$star()))));
                            break block18;
                        }
                        org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)Diags.Report(3L), (StringRef)new StringRef(InputFile)), (StringRef)new StringRef(MB.getError().message())).$destroy();
                        boolean bl = false;
                        return bl;
                    }
                    finally {
                        if (MB != null) {
                            MB.$destroy();
                        }
                    }
                }
            }
            SourceMgr.setMainFileID(SourceMgr.createFileID(File, new SourceLocation(), Kind2));
        } else {
            ErrorOr SBOrErr = null;
            try {
                SBOrErr = MemoryBuffer.getSTDIN();
                std_errors.error_code EC = SBOrErr.getError();
                if (EC.$boolean()) {
                    org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)Diags.Report(411L), (StringRef)new StringRef(EC.message())).$destroy();
                    boolean bl = false;
                    return bl;
                }
                std_ptr.unique_ptr SB = new std_ptr.unique_ptr(std.move((std_ptr.unique_ptr)((std_ptr.unique_ptr)SBOrErr.get())));
                FileEntry File = FileMgr.getVirtualFile(new StringRef(((MemoryBuffer)SB.$arrow()).getBufferIdentifier()), (long)((MemoryBuffer)SB.$arrow()).getBufferSize(), 0L);
                SourceMgr.setMainFileID(SourceMgr.createFileID(File, new SourceLocation(), Kind2));
                SourceMgr.overrideFileContents(File, new std_ptr.unique_ptr(std.move((std_ptr.unique_ptr)SB)));
            }
            finally {
                if (SBOrErr != null) {
                    SBOrErr.$destroy();
                }
            }
        }
        assert (!SourceMgr.getMainFileID().isInvalid()) : "Couldn't establish MainFileID!";
        return true;
    }

    public void createModuleManager() {
        if (!this.ModuleManager.$boolean()) {
            if (!this.hasASTContext()) {
                this.createASTContext();
            }
            if (this.getSourceManager().getModuleBuildStack().empty() && this.getHeaderSearchOpts().ModuleCachePruneInterval > 0L && this.getHeaderSearchOpts().ModuleCachePruneAfter > 0L) {
                CompilerInstanceStatics.pruneModuleCache(this.getHeaderSearchOpts());
            }
            HeaderSearchOptions HSOpts = this.getHeaderSearchOpts();
            std.string Sysroot = new std.string(HSOpts.Sysroot);
            PreprocessorOptions PPOpts = this.getPreprocessorOpts();
            this.ModuleManager.$assign(new IntrusiveRefCntPtr((Object)new ASTReader(this.getPreprocessor(), (ASTContext)this.Context.$star(), new StringRef(Sysroot.empty() ? NativePointer.$((String)"") : Sysroot.c_str()), PPOpts.DisablePCHValidation, false, false, HSOpts.ModulesValidateSystemHeaders, this.getFrontendOpts().UseGlobalModuleIndex)));
            if (this.hasASTConsumer()) {
                ((ASTReader)this.ModuleManager.$arrow()).setDeserializationListener(this.getASTConsumer().GetASTDeserializationListener());
                this.getASTContext().setASTMutationListener(this.getASTConsumer().GetASTMutationListener());
            }
            this.getASTContext().setExternalSource(new IntrusiveRefCntPtr(this.ModuleManager));
            if (this.hasSema()) {
                ((ASTReader)this.ModuleManager.$arrow()).InitializeSema(this.getSema());
            }
            if (this.hasASTConsumer()) {
                ((ASTReader)this.ModuleManager.$arrow()).StartTranslationUnit(this.getASTConsumer());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadModuleFile(StringRef FileName) {
        ReadModuleNames RMN = null;
        try {
            RMN = new ReadModuleNames(this);
            RMN.visitImport(new StringRef(FileName));
            if (RMN.Failed) {
                boolean bl = false;
                return bl;
            }
            if (!RMN.TopFileIsModule) {
                org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.getDiagnostics().Report(new SourceLocation(), 433L), (StringRef)new StringRef(FileName)).$destroy();
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (RMN != null) {
                RMN.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ModuleLoadResult loadModule(SourceLocation ImportLoc, ModuleIdPath Path, Module.NameVisibilityKind Visibility, boolean IsInclusionDirective) {
        boolean IsInModuleIncludes;
        StringRef ModuleName = ((IdentifierInfo)((std.pair)Path.$at((int)0)).first).getName();
        SourceLocation ModuleNameLoc = new SourceLocation((SourceLocation)((std.pair)Path.$at((int)0)).second);
        if (!ImportLoc.isInvalid() && org.clang.basic.ClangGlobals.$eq_SourceLocation((SourceLocation)this.LastModuleImportLoc, (SourceLocation)ImportLoc)) {
            if (this.LastModuleImportResult.$ModulePtr() == null) return new ModuleLoadResult(this.LastModuleImportResult);
            if (!llvm.$noteq_StringRef((StringRef)ModuleName, (std.string)this.getLangOpts().CurrentModule)) return new ModuleLoadResult(this.LastModuleImportResult);
            if (!llvm.$noteq_StringRef((StringRef)ModuleName, (std.string)this.getLangOpts().ImplementationOfModule)) return new ModuleLoadResult(this.LastModuleImportResult);
            ((ASTReader)this.ModuleManager.$arrow()).makeModuleVisible(this.LastModuleImportResult.$ModulePtr(), Visibility, new SourceLocation(ImportLoc), false);
            return new ModuleLoadResult(this.LastModuleImportResult);
        }
        Module Module2 = null;
        DenseMapIterator Known = this.KnownModules.find(((std.pair)Path.$at((int)0)).first);
        if (Known.$noteq(this.KnownModules.end())) {
            Module2 = (Module)((std.pair)Known.$arrow().$star()).second;
        } else if (llvm.$eq_StringRef((StringRef)new StringRef(ModuleName), (StringRef)new StringRef(this.getLangOpts().CurrentModule)) || llvm.$eq_StringRef((StringRef)new StringRef(ModuleName), (StringRef)new StringRef(this.getLangOpts().ImplementationOfModule))) {
            Module2 = ((Preprocessor)this.PP.$arrow()).getHeaderSearchInfo().lookupModule(new StringRef(ModuleName));
            Known = (DenseMapIterator)this.KnownModules.insert((std.pair)new std.pair((std.pair)std.make_pair((Object)((std.pair)Path.$at((int)0)).first, (Object)Module2))).first;
        } else {
            std.string ModuleFileName = null;
            try {
                Module2 = ((Preprocessor)this.PP.$arrow()).getHeaderSearchInfo().lookupModule(new StringRef(ModuleName));
                if (Module2 == null) {
                    org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_SourceRange((DiagnosticBuilder)org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.getDiagnostics().Report(new SourceLocation(ModuleNameLoc), 23L), (StringRef)new StringRef(ModuleName)), (SourceRange)new SourceRange(new SourceLocation(ImportLoc), new SourceLocation(ModuleNameLoc))).$destroy();
                    this.ModuleBuildFailed = true;
                    ModuleLoadResult moduleLoadResult = new ModuleLoadResult();
                    return moduleLoadResult;
                }
                StringMapIterator Override = this.ModuleFileOverrides.find(new StringRef(ModuleName));
                boolean Explicit = Override.$noteq((StringMapConstIterator)this.ModuleFileOverrides.end());
                std.string string2 = ModuleFileName = Explicit ? new std.string((std.string)Override.$arrow().second) : ((Preprocessor)this.PP.$arrow()).getHeaderSearchInfo().getModuleFileName(Module2);
                if (!this.ModuleManager.$boolean()) {
                    this.createModuleManager();
                }
                if (this.TheDependencyFileGenerator.$boolean()) {
                    ((DependencyFileGenerator)this.TheDependencyFileGenerator.$arrow()).AttachToASTReader((ASTReader)this.ModuleManager.$star());
                }
                if (this.ModuleDepCollector.$boolean()) {
                    ((ModuleDependencyCollector)this.ModuleDepCollector.$arrow()).attachToASTReader((ASTReader)this.ModuleManager.$star());
                }
                for (std_ptr.shared_ptr Listener : this.DependencyCollectors) {
                    ((DependencyCollector)Listener.$arrow()).attachToASTReader((ASTReader)this.ModuleManager.$star());
                }
                long ARRFlags = Explicit ? 0L : (long)(ASTReader.LoadFailureCapabilities.ARR_OutOfDate.getValue() | ASTReader.LoadFailureCapabilities.ARR_Missing.getValue());
                switch (((ASTReader)this.ModuleManager.$arrow()).ReadAST(ModuleFileName, Explicit ? serialization.ModuleKind.MK_ExplicitModule : serialization.ModuleKind.MK_ImplicitModule, new SourceLocation(ImportLoc), ARRFlags)) {
                    case Success: {
                        break;
                    }
                    case Missing: 
                    case OutOfDate: {
                        if (Explicit) {
                            this.HadFatalFailure = true;
                            this.KnownModules.insert(new std.pair(((std.pair)Path.$at((int)0)).first, null));
                            ModuleLoadResult moduleLoadResult = new ModuleLoadResult();
                            return moduleLoadResult;
                        }
                        assert (Module2 != null) : "missing module file";
                        ArrayRef ModPath = this.getSourceManager().getModuleBuildStack();
                        type.ptr Pos = ModPath.begin();
                        type.ptr PosEnd = ModPath.end();
                        while (!Pos.$eq((Object)PosEnd) && !llvm.$eq_StringRef((StringRef)new StringRef((std.string)((std.pair)Pos.$star()).first), (StringRef)new StringRef(ModuleName))) {
                            Pos.$preInc();
                        }
                        if (Pos != PosEnd) {
                            SmallString CyclePath = null;
                            try {
                                CyclePath = new SmallString(256);
                                while (Pos.$eq((Object)PosEnd)) {
                                    CyclePath.$addassign((std.string)((std.pair)Pos.$star()).first);
                                    CyclePath.$addassign((CharSequence)" -> ");
                                    Pos.$preInc();
                                }
                                CyclePath.$addassign(ModuleName);
                                org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.getDiagnostics().Report(new SourceLocation(ModuleNameLoc), 19L), (StringRef)new StringRef(ModuleName)), (StringRef)CyclePath.$StringRef()).$destroy();
                                ModuleLoadResult moduleLoadResult = new ModuleLoadResult();
                                return moduleLoadResult;
                            }
                            finally {
                                if (CyclePath != null) {
                                    CyclePath.$destroy();
                                }
                            }
                        }
                        if (this.getPreprocessorOpts().FailedModules.$boolean() && ((PreprocessorOptions.FailedModulesSet)this.getPreprocessorOpts().FailedModules.$arrow()).hasAlreadyFailed(new StringRef(ModuleName))) {
                            org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_SourceRange((DiagnosticBuilder)org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.getDiagnostics().Report(new SourceLocation(ModuleNameLoc), 22L), (StringRef)new StringRef(ModuleName)), (SourceRange)new SourceRange(new SourceLocation(ImportLoc), new SourceLocation(ModuleNameLoc))).$destroy();
                            this.ModuleBuildFailed = true;
                            ModuleLoadResult CyclePath = new ModuleLoadResult();
                            return CyclePath;
                        }
                        if (CompilerInstanceStatics.compileAndLoadModule(this, new SourceLocation(ImportLoc), new SourceLocation(ModuleNameLoc), Module2, new StringRef(ModuleFileName))) break;
                        assert (this.getDiagnostics().hasErrorOccurred()) : "undiagnosed error in compileAndLoadModule";
                        if (this.getPreprocessorOpts().FailedModules.$boolean()) {
                            ((PreprocessorOptions.FailedModulesSet)this.getPreprocessorOpts().FailedModules.$arrow()).addFailed(new StringRef(ModuleName));
                        }
                        this.KnownModules.insert(new std.pair(((std.pair)Path.$at((int)0)).first, null));
                        this.ModuleBuildFailed = true;
                        ModuleLoadResult CyclePath = new ModuleLoadResult();
                        return CyclePath;
                    }
                    case VersionMismatch: 
                    case ConfigurationMismatch: 
                    case HadErrors: {
                        this.HadFatalFailure = true;
                        this.KnownModules.insert(new std.pair(((std.pair)Path.$at((int)0)).first, null));
                        ModuleLoadResult ModPath = new ModuleLoadResult();
                        return ModPath;
                    }
                    case Failure: {
                        this.HadFatalFailure = true;
                        this.KnownModules.insert(new std.pair(((std.pair)Path.$at((int)0)).first, null));
                        this.ModuleBuildFailed = true;
                        ModuleLoadResult ModPath = new ModuleLoadResult();
                        return ModPath;
                    }
                }
                Known = (DenseMapIterator)this.KnownModules.insert((std.pair)new std.pair((std.pair)std.make_pair((Object)((std.pair)Path.$at((int)0)).first, (Object)Module2))).first;
            }
            finally {
                if (ModuleFileName != null) {
                    ModuleFileName.$destroy();
                }
            }
        }
        if (Module2 == null) {
            return new ModuleLoadResult();
        }
        if (Path.size() > 1) {
            int N = Path.size();
            for (int I = 1; I != N; ++I) {
                StringRef Name = ((IdentifierInfo)((std.pair)Path.$at((int)I)).first).getName();
                Module Sub = Module2.findSubmodule(new StringRef(Name));
                if (Sub == null) {
                    SmallVector Best = null;
                    try {
                        Best = new SmallVector(2, (Object)new StringRef());
                        int BestEditDistance = std.numeric_limits_int.max();
                        StdVector.iterator J = Module2.submodule_begin();
                        StdVector.iterator JEnd = Module2.submodule_end();
                        while (std.$noteq___normal_iterator((StdVector.iterator)J, (StdVector.iterator)JEnd)) {
                            int ED = Name.edit_distance(new StringRef(((Module)J.$star()).Name), true, BestEditDistance);
                            if (ED <= BestEditDistance) {
                                if (ED < BestEditDistance) {
                                    Best.clear();
                                    BestEditDistance = ED;
                                }
                                Best.push_back((Object)new StringRef(((Module)J.$star()).Name));
                            }
                            J.$preInc();
                        }
                        if (Best.size() == 1) {
                            org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_FixItHint((DiagnosticBuilder)org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_SourceRange((DiagnosticBuilder)org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_IdentifierInfo((DiagnosticBuilder)this.getDiagnostics().Report(new SourceLocation((SourceLocation)((std.pair)Path.$at((int)I)).second), 438L), (IdentifierInfo)((IdentifierInfo)((std.pair)Path.$at((int)I)).first)), (StringRef)new StringRef(Module2.getFullModuleName())), (StringRef)new StringRef((StringRef)Best.$at(0))), (SourceRange)new SourceRange(new SourceLocation((SourceLocation)((std.pair)Path.$at((int)0)).second), new SourceLocation((SourceLocation)((std.pair)Path.$at((int)(I - 1))).second))), (FixItHint)FixItHint.CreateReplacement((SourceRange)new SourceRange(new SourceLocation((SourceLocation)((std.pair)Path.$at((int)I)).second)), (StringRef)new StringRef((StringRef)Best.$at(0)))).$destroy();
                            Sub = Module2.findSubmodule(new StringRef((StringRef)Best.$at(0)));
                        }
                    }
                    finally {
                        if (Best != null) {
                            Best.$destroy();
                        }
                    }
                }
                if (Sub == null) {
                    org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_SourceRange((DiagnosticBuilder)org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_IdentifierInfo((DiagnosticBuilder)this.getDiagnostics().Report(new SourceLocation((SourceLocation)((std.pair)Path.$at((int)I)).second), 437L), (IdentifierInfo)((IdentifierInfo)((std.pair)Path.$at((int)I)).first)), (StringRef)new StringRef(Module2.getFullModuleName())), (SourceRange)new SourceRange(new SourceLocation((SourceLocation)((std.pair)Path.$at((int)0)).second), new SourceLocation((SourceLocation)((std.pair)Path.$at((int)(I - 1))).second))).$destroy();
                    break;
                }
                Module2 = Sub;
            }
        }
        if (llvm.$eq_StringRef((StringRef)ModuleName, (std.string)this.getLangOpts().ImplementationOfModule)) {
            return new ModuleLoadResult(Module2, false);
        }
        if (llvm.$noteq_StringRef((StringRef)ModuleName, (std.string)this.getLangOpts().CurrentModule)) {
            std.pairTypeBool Requirement = null;
            Module.UnresolvedHeaderDirective MissingHeader = null;
            try {
                if (!Module2.IsFromModuleFile) {
                    org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_SourceRange((DiagnosticBuilder)org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.getDiagnostics().Report(new SourceLocation(ImportLoc), 483L), (StringRef)new StringRef(Module2.getFullModuleName())), (SourceRange)new SourceRange(new SourceLocation((SourceLocation)((std.pair)Path.front()).second), new SourceLocation((SourceLocation)((std.pair)Path.back()).second))).$destroy();
                    ModuleLoadResult Name = new ModuleLoadResult(null, true);
                    return Name;
                }
                Requirement = new std.pairTypeBool();
                MissingHeader = new Module.UnresolvedHeaderDirective();
                if (!Module2.isAvailable(this.getLangOpts(), this.getTarget(), Requirement, MissingHeader)) {
                    if (MissingHeader.FileNameLoc.isValid()) {
                        org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_T((DiagnosticBuilder)this.getDiagnostics().Report(new SourceLocation(MissingHeader.FileNameLoc), 434L), (boolean)MissingHeader.IsUmbrella), (StringRef)new StringRef(MissingHeader.FileName)).$destroy();
                    } else {
                        org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_SourceRange((DiagnosticBuilder)org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_T((DiagnosticBuilder)org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.getDiagnostics().Report(new SourceLocation(ImportLoc), 436L), (StringRef)new StringRef(Module2.getFullModuleName())), (boolean)Requirement.second), (StringRef)new StringRef((std.string)Requirement.first)), (SourceRange)new SourceRange(new SourceLocation((SourceLocation)((std.pair)Path.front()).second), new SourceLocation((SourceLocation)((std.pair)Path.back()).second))).$destroy();
                    }
                    this.LastModuleImportLoc.$assign(ImportLoc);
                    this.LastModuleImportResult = new ModuleLoadResult();
                    ModuleLoadResult Name = new ModuleLoadResult();
                    return Name;
                }
                ((ASTReader)this.ModuleManager.$arrow()).makeModuleVisible(Module2, Visibility, new SourceLocation(ImportLoc), true);
            }
            finally {
                if (MissingHeader != null) {
                    MissingHeader.$destroy();
                }
            }
        }
        Module TopModule = Module2.getTopLevelModule();
        long N = TopModule.ConfigMacros.size();
        for (long I = 0L; I != N; ++I) {
            CompilerInstanceStatics.checkConfigMacro(this.getPreprocessor(), new StringRef(TopModule.ConfigMacros.$at(I)), Module2, new SourceLocation(ImportLoc));
        }
        boolean bl = IsInModuleIncludes = !this.getLangOpts().CurrentModule.empty() && this.getSourceManager().getFileID(new SourceLocation(ImportLoc)).$eq(this.getSourceManager().getMainFileID());
        if (IsInclusionDirective && this.hasASTContext() && !IsInModuleIncludes) {
            TranslationUnitDecl TU = this.getASTContext().getTranslationUnitDecl();
            ImportDecl ImportD = ImportDecl.CreateImplicit((ASTContext)this.getASTContext(), (DeclContext)TU, (SourceLocation)new SourceLocation(ImportLoc), (Module)Module2, (SourceLocation)new SourceLocation((SourceLocation)((std.pair)Path.back()).second));
            TU.addDecl(ImportD);
            if (this.Consumer.$boolean()) {
                ((ASTConsumer)this.Consumer.$arrow()).HandleImplicitImportDecl((Object)ImportD);
            }
        }
        this.LastModuleImportLoc.$assign(ImportLoc);
        this.LastModuleImportResult = new ModuleLoadResult(Module2, false);
        return new ModuleLoadResult(this.LastModuleImportResult);
    }

    public void makeModuleVisible(Module Mod, Module.NameVisibilityKind Visibility, SourceLocation ImportLoc, boolean Complain) {
        ((ASTReader)this.ModuleManager.$arrow()).makeModuleVisible(Mod, Visibility, new SourceLocation(ImportLoc), Complain);
    }

    public boolean hadModuleLoaderFatalFailure() {
        return this.HadFatalFailure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lookupMissingImports(StringRef Name, SourceLocation TriggerLoc) {
        GlobalModuleIndex GlobalIndex;
        if (!this.buildingModule() && (GlobalIndex = this.loadGlobalModuleIndex(new SourceLocation(TriggerLoc))) != null) {
            SmallPtrSet FoundModules = null;
            try {
                FoundModules = new SmallPtrSet((DenseMapInfo)new DenseMapInfoObject((Object)new ModuleFile(), (Object)new ModuleFile()), 4);
                if (GlobalIndex.lookupIdentifier(new StringRef(Name), FoundModules)) {
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                if (FoundModules != null) {
                    FoundModules.$destroy();
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalModuleIndex loadGlobalModuleIndex(SourceLocation TriggerLoc) {
        if (!this.ModuleManager.$boolean()) {
            this.createModuleManager();
        }
        if (!this.ModuleManager.$boolean()) {
            return null;
        }
        ((ASTReader)this.ModuleManager.$arrow()).loadGlobalIndex();
        GlobalModuleIndex GlobalIndex = ((ASTReader)this.ModuleManager.$arrow()).getGlobalIndex();
        if (GlobalIndex == null && this.shouldBuildGlobalModuleIndex() && this.hasFileManager() && this.hasPreprocessor()) {
            fs.create_directories((Twine)new Twine(this.getPreprocessor().getHeaderSearchInfo().getModuleCachePath()));
            GlobalModuleIndex.writeIndex((FileManager)this.getFileManager(), (StringRef)this.getPreprocessor().getHeaderSearchInfo().getModuleCachePath());
            ((ASTReader)this.ModuleManager.$arrow()).resetForReload();
            ((ASTReader)this.ModuleManager.$arrow()).loadGlobalIndex();
            GlobalIndex = ((ASTReader)this.ModuleManager.$arrow()).getGlobalIndex();
        }
        if (!this.HaveFullGlobalModuleIndex && GlobalIndex != null && !this.buildingModule()) {
            ModuleMap MMap = this.getPreprocessor().getHeaderSearchInfo().getModuleMap();
            boolean RecreateIndex = false;
            StringMapIterator I = MMap.module_begin();
            StringMapIterator E = MMap.module_end();
            while (I.$noteq((StringMapConstIterator)E)) {
                Module TheModule = (Module)I.$arrow().second;
                FileEntry Entry2 = TheModule.getASTFile();
                if (Entry2 == null) {
                    SmallVector Path = null;
                    try {
                        Path = new SmallVector(2, (Object)new std.pair(null, (Object)new SourceLocation()));
                        Path.push_back((Object)std.make_pair((Object)this.getPreprocessor().getIdentifierInfo(new StringRef(TheModule.Name)), (Object)TriggerLoc));
                        std.reverse((Object)Path.begin(), (Object)Path.end());
                        this.loadModule(new SourceLocation(TheModule.DefinitionLoc), new ModuleIdPath((SmallVectorImpl)Path), Module.NameVisibilityKind.Hidden, false);
                        RecreateIndex = true;
                    }
                    finally {
                        if (Path != null) {
                            Path.$destroy();
                        }
                    }
                }
                I.$preInc();
            }
            if (RecreateIndex) {
                GlobalModuleIndex.writeIndex((FileManager)this.getFileManager(), (StringRef)this.getPreprocessor().getHeaderSearchInfo().getModuleCachePath());
                ((ASTReader)this.ModuleManager.$arrow()).resetForReload();
                ((ASTReader)this.ModuleManager.$arrow()).loadGlobalIndex();
                GlobalIndex = ((ASTReader)this.ModuleManager.$arrow()).getGlobalIndex();
            }
            this.HaveFullGlobalModuleIndex = true;
        }
        return GlobalIndex;
    }

    public void addDependencyCollector(std_ptr.shared_ptr<DependencyCollector> Listener) {
        this.DependencyCollectors.push_back(std.move(Listener));
    }

    public String toString() {
        return "Invocation=" + this.Invocation + ", Diagnostics=" + this.Diagnostics + ", Target=" + this.Target + ", VirtualFileSystem=" + this.VirtualFileSystem + ", FileMgr=" + this.FileMgr + ", SourceMgr=" + this.SourceMgr + ", PP=" + this.PP + ", Context=" + this.Context + ", Consumer=" + this.Consumer + ", CompletionConsumer=" + this.CompletionConsumer + ", TheSema=" + this.TheSema + ", FrontendTimer=" + this.FrontendTimer + ", ModuleManager=" + this.ModuleManager + ", ModuleDepCollector=" + this.ModuleDepCollector + ", TheDependencyFileGenerator=" + this.TheDependencyFileGenerator + ", DependencyCollectors=" + this.DependencyCollectors + ", KnownModules=" + this.KnownModules + ", ModuleFileOverrides=" + this.ModuleFileOverrides + ", LastModuleImportLoc=" + this.LastModuleImportLoc + ", LastModuleImportResult=" + this.LastModuleImportResult + ", BuildGlobalModuleIndex=" + this.BuildGlobalModuleIndex + ", HaveFullGlobalModuleIndex=" + this.HaveFullGlobalModuleIndex + ", ModuleBuildFailed=" + this.ModuleBuildFailed + ", OutputFiles=" + this.OutputFiles + super.toString();
    }

    private final class ReadModuleNames
    extends ASTReaderListener
    implements Destructors.ClassWithDestructor {
        public CompilerInstance CI;
        public std.vector<StringRef> ModuleFileStack;
        public boolean Failed;
        public boolean TopFileIsModule;

        public ReadModuleNames(CompilerInstance CI) {
            this.CI = CI;
            this.ModuleFileStack = new std.vector((Object)new StringRef());
            this.Failed = false;
            this.TopFileIsModule = false;
        }

        public boolean needsImportVisitation() {
            return true;
        }

        public void visitImport(StringRef FileName) {
            this.ModuleFileStack.push_back((Object)FileName);
            if (ASTReader.readASTFileControlBlock((StringRef)new StringRef(FileName), (FileManager)this.CI.getFileManager(), (Object)((Object)this))) {
                org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.CI.getDiagnostics().Report(new SourceLocation(), 432L), (StringRef)new StringRef(FileName)).$destroy();
                this.Failed = true;
            }
            this.ModuleFileStack.pop_back();
        }

        public void ReadModuleName(StringRef ModuleName) {
            std.string ModuleFile;
            if (this.ModuleFileStack.size() == 1) {
                this.TopFileIsModule = true;
            }
            if (!(ModuleFile = (std.string)this.CI.ModuleFileOverrides.$at(new StringRef(ModuleName))).empty() && this.CI.getFileManager().getFile(new StringRef(ModuleFile)) != this.CI.getFileManager().getFile(new StringRef((StringRef)this.ModuleFileStack.back()))) {
                org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.CI.getDiagnostics().Report(new SourceLocation(), 401L), (StringRef)new StringRef(ModuleName)), (StringRef)new StringRef(ModuleFile)), (StringRef)new StringRef((StringRef)this.ModuleFileStack.back())).$destroy();
            }
            ModuleFile.$assign(((StringRef)this.ModuleFileStack.back()).$basic_string());
        }

        public void $destroy() {
            this.ModuleFileStack.$destroy();
            super.$destroy();
        }

        public String toString() {
            return "CI=" + (Object)((Object)this.CI) + ", ModuleFileStack=" + this.ModuleFileStack + ", Failed=" + this.Failed + ", TopFileIsModule=" + this.TopFileIsModule + super.toString();
        }
    }

    private static class OutputFile
    implements Destructors.ClassWithDestructor {
        public std.string Filename;
        public std.string TempFilename;
        public raw_ostream OS;

        public OutputFile(std.string filename, std.string tempFilename, raw_ostream os) {
            this.Filename = new std.string(filename);
            this.TempFilename = new std.string(tempFilename);
            this.OS = os;
        }

        public OutputFile(OutputFile $Prm0) {
            this.Filename = new std.string($Prm0.Filename);
            this.TempFilename = new std.string($Prm0.TempFilename);
            this.OS = $Prm0.OS;
        }

        public void $destroy() {
            this.TempFilename.$destroy();
            this.Filename.$destroy();
        }

        public String toString() {
            return "Filename=" + this.Filename + ", TempFilename=" + this.TempFilename + ", OS=" + this.OS;
        }
    }
}

