/*
 * Decompiled with CFR 0.152.
 */
package org.clang.frontend;

import org.clang.basic.Diagnostic;
import org.clang.basic.DiagnosticConsumer;
import org.clang.basic.DiagnosticIDs;
import org.clang.basic.DiagnosticOptions;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.FileEntry;
import org.clang.basic.FileID;
import org.clang.basic.FullSourceLoc;
import org.clang.basic.LangOptions;
import org.clang.basic.PresumedLoc;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.basic.markup.MarkupGlobals;
import org.clang.basic.spi.PreprocessorImplementation;
import org.clang.frontend.impl.LogDiagnosticPrinterStatics;
import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.llvm.adt.IntrusiveRefCntPtr;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.support.raw_ostream;
import org.llvm.support.raw_svector_ostream;

public class LogDiagnosticPrinter
extends DiagnosticConsumer
implements Destructors.ClassWithDestructor {
    private raw_ostream OS;
    private std_ptr.unique_ptr<raw_ostream> StreamOwner;
    private LangOptions LangOpts;
    private IntrusiveRefCntPtr<DiagnosticOptions> DiagOpts;
    private SourceLocation LastWarningLoc;
    private FullSourceLoc LastLoc;
    private SmallVector<DiagEntry> Entries;
    private std.string MainFilename;
    private std.string DwarfDebugFlags;

    private void EmitDiagEntry(raw_ostream OS, DiagEntry DE) {
        OS.$out(NativePointer.$((String)"    <dict>\n"));
        OS.$out(NativePointer.$((String)"      <key>level</key>\n")).$out(NativePointer.$((String)"      "));
        MarkupGlobals.EmitString((raw_ostream)OS, (StringRef)new StringRef(LogDiagnosticPrinterStatics.getLevelName(DE.DiagnosticLevel))).$out_char(NativePointer.$((char)'\n'));
        if (!DE.Filename.empty()) {
            OS.$out(NativePointer.$((String)"      <key>filename</key>\n")).$out(NativePointer.$((String)"      "));
            MarkupGlobals.EmitString((raw_ostream)OS, (StringRef)new StringRef(DE.Filename)).$out_char(NativePointer.$((char)'\n'));
        }
        if (DE.Line != 0L) {
            OS.$out(NativePointer.$((String)"      <key>line</key>\n")).$out(NativePointer.$((String)"      "));
            MarkupGlobals.EmitInteger((raw_ostream)OS, (int)((int)DE.Line)).$out_char(NativePointer.$((char)'\n'));
        }
        if (DE.Column != 0L) {
            OS.$out(NativePointer.$((String)"      <key>column</key>\n")).$out(NativePointer.$((String)"      "));
            MarkupGlobals.EmitInteger((raw_ostream)OS, (int)((int)DE.Column)).$out_char(NativePointer.$((char)'\n'));
        }
        if (!DE.Message.empty()) {
            OS.$out(NativePointer.$((String)"      <key>message</key>\n")).$out(NativePointer.$((String)"      "));
            MarkupGlobals.EmitString((raw_ostream)OS, (StringRef)new StringRef(DE.Message)).$out_char(NativePointer.$((char)'\n'));
        }
        OS.$out(NativePointer.$((String)"      <key>ID</key>\n")).$out(NativePointer.$((String)"      "));
        MarkupGlobals.EmitInteger((raw_ostream)OS, (int)((int)DE.DiagnosticID)).$out_char(NativePointer.$((char)'\n'));
        if (!DE.WarningOption.empty()) {
            OS.$out(NativePointer.$((String)"      <key>WarningOption</key>\n")).$out(NativePointer.$((String)"      "));
            MarkupGlobals.EmitString((raw_ostream)OS, (StringRef)new StringRef(DE.WarningOption)).$out_char(NativePointer.$((char)'\n'));
        }
        OS.$out(NativePointer.$((String)"    </dict>\n"));
    }

    public LogDiagnosticPrinter(raw_ostream os, DiagnosticOptions diags, std_ptr.unique_ptr<raw_ostream> StreamOwner) {
        this.OS = os;
        this.StreamOwner = new std_ptr.unique_ptr(JavaDifferentiators.Move.INSTANCE, std.move(StreamOwner));
        this.LangOpts = null;
        this.DiagOpts = new IntrusiveRefCntPtr((Object)diags);
        this.LastWarningLoc = new SourceLocation();
        this.LastLoc = new FullSourceLoc();
        this.Entries = new SmallVector(8, (Object)new DiagEntry());
        this.MainFilename = new std.string();
        this.DwarfDebugFlags = new std.string();
    }

    public void setDwarfDebugFlags(StringRef Value) {
        JavaCleaner $c = Native.$createJavaCleaner();
        try {
            $c.clean((Object)this.DwarfDebugFlags.$assignMove((std.string)$c.track((Object)Value.$basic_string())));
        }
        finally {
            $c.$destroy();
        }
    }

    public void BeginSourceFile(LangOptions LO, PreprocessorImplementation PP) {
        this.LangOpts = LO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void EndSourceFile() {
        SmallString Msg = null;
        raw_svector_ostream OS = null;
        try {
            if (this.Entries.empty()) {
                return;
            }
            Msg = new SmallString(512);
            OS = new raw_svector_ostream(Msg);
            OS.$out(NativePointer.$((String)"<dict>\n"));
            if (!this.MainFilename.empty()) {
                OS.$out(NativePointer.$((String)"  <key>main-file</key>\n")).$out(NativePointer.$((String)"  "));
                MarkupGlobals.EmitString((raw_ostream)OS, (StringRef)new StringRef(this.MainFilename)).$out_char(NativePointer.$((char)'\n'));
            }
            if (!this.DwarfDebugFlags.empty()) {
                OS.$out(NativePointer.$((String)"  <key>dwarf-debug-flags</key>\n")).$out(NativePointer.$((String)"  "));
                MarkupGlobals.EmitString((raw_ostream)OS, (StringRef)new StringRef(this.DwarfDebugFlags)).$out_char(NativePointer.$((char)'\n'));
            }
            OS.$out(NativePointer.$((String)"  <key>diagnostics</key>\n"));
            OS.$out(NativePointer.$((String)"  <array>\n"));
            for (DiagEntry DE : this.Entries) {
                this.EmitDiagEntry((raw_ostream)OS, DE);
            }
            OS.$out(NativePointer.$((String)"  </array>\n"));
            OS.$out(NativePointer.$((String)"</dict>\n"));
            this.OS.$out(OS.str());
        }
        finally {
            if (OS != null) {
                OS.$destroy();
            }
            if (Msg != null) {
                Msg.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void HandleDiagnostic(DiagnosticsEngine.Level Level2, Diagnostic Info) {
        DiagEntry DE = null;
        SmallString MessageStr = null;
        JavaCleaner $c = Native.$createJavaCleaner();
        try {
            FileEntry FE;
            SourceManager SM;
            FileID FID;
            super.HandleDiagnostic(Level2, Info);
            if (this.MainFilename.empty() && Info.hasSourceManager() && !(FID = (SM = Info.getSourceManager()).getMainFileID()).isInvalid() && (FE = SM.getFileEntryForID(new FileID(FID))) != null && FE.isValid()) {
                this.MainFilename.$assign(FE.getName());
            }
            DE = new DiagEntry();
            DE.DiagnosticID = Info.getID();
            DE.DiagnosticLevel = Level2;
            $c.clean((Object)DE.WarningOption.$assignMove((std.string)$c.track((Object)DiagnosticIDs.getWarningOptionForDiag((long)DE.DiagnosticID).$basic_string())));
            MessageStr = new SmallString(100);
            Info.FormatDiagnostic(MessageStr);
            $c.clean((Object)DE.Message.$assignMove((std.string)$c.track((Object)MessageStr.str().$basic_string())));
            DE.Filename.$assign(NativePointer.$((String)""));
            DE.Column = 0L;
            DE.Line = 0L;
            if (Info.getLocation().isValid() && Info.hasSourceManager()) {
                SM = Info.getSourceManager();
                PresumedLoc PLoc = SM.getPresumedLoc(new SourceLocation(Info.getLocation()));
                if (PLoc.isInvalid()) {
                    FileEntry FE2;
                    FileID FID2 = SM.getFileID(new SourceLocation(Info.getLocation()));
                    if (!FID2.isInvalid() && (FE2 = SM.getFileEntryForID(new FileID(FID2))) != null && FE2.isValid()) {
                        DE.Filename.$assign(FE2.getName());
                    }
                } else {
                    DE.Filename.$assign(PLoc.getFilename());
                    DE.Line = PLoc.getLine();
                    DE.Column = PLoc.getColumn();
                }
            }
            this.Entries.push_back((Object)DE);
        }
        finally {
            if (MessageStr != null) {
                MessageStr.$destroy();
            }
            if (DE != null) {
                DE.$destroy();
            }
            $c.$destroy();
        }
    }

    public void $destroy() {
        this.DwarfDebugFlags.$destroy();
        this.MainFilename.$destroy();
        this.Entries.$destroy();
        this.DiagOpts.$destroy();
        this.StreamOwner.$destroy();
        super.$destroy();
    }

    public String toString() {
        return "OS=" + this.OS + ", StreamOwner=" + this.StreamOwner + ", LangOpts=" + this.LangOpts + ", DiagOpts=" + this.DiagOpts + ", LastWarningLoc=" + this.LastWarningLoc + ", LastLoc=" + this.LastLoc + ", Entries=" + this.Entries + ", MainFilename=" + this.MainFilename + ", DwarfDebugFlags=" + this.DwarfDebugFlags + super.toString();
    }

    private static class DiagEntry
    implements Destructors.ClassWithDestructor {
        public std.string Message;
        public std.string Filename;
        public long Line;
        public long Column;
        public long DiagnosticID;
        public std.string WarningOption;
        public DiagnosticsEngine.Level DiagnosticLevel;

        public DiagEntry(DiagEntry $Prm0) {
            this.Message = new std.string($Prm0.Message);
            this.Filename = new std.string($Prm0.Filename);
            this.Line = $Prm0.Line;
            this.Column = $Prm0.Column;
            this.DiagnosticID = $Prm0.DiagnosticID;
            this.WarningOption = new std.string($Prm0.WarningOption);
            this.DiagnosticLevel = $Prm0.DiagnosticLevel;
        }

        public void $destroy() {
            this.WarningOption.$destroy();
            this.Filename.$destroy();
            this.Message.$destroy();
        }

        public DiagEntry() {
            this.Message = new std.string();
            this.Filename = new std.string();
            this.WarningOption = new std.string();
        }

        public String toString() {
            return "Message=" + this.Message + ", Filename=" + this.Filename + ", Line=" + this.Line + ", Column=" + this.Column + ", DiagnosticID=" + this.DiagnosticID + ", WarningOption=" + this.WarningOption + ", DiagnosticLevel=" + this.DiagnosticLevel;
        }
    }
}

